package com.ejianc.business.fill.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.fill.bean.ContractLightEntity;
import com.ejianc.business.fill.bean.MonthLightEntity;
import com.ejianc.business.fill.bean.ProjectLightEntity;
import com.ejianc.business.fill.cons.FillConstant;
import com.ejianc.business.fill.consumer.TransferVO;
import com.ejianc.business.fill.emum.LightRuleLevelEnum;
import com.ejianc.business.fill.service.*;
import com.ejianc.business.fill.util.WarnFeignUtil;
import com.ejianc.business.fill.vo.LevelReceiveVO;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.mapper.ExecPlanMapper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.bean.PushSetEntity;
import com.ejianc.business.progress.bean.PushSetReceiveEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.service.ILightRuleService;
import com.ejianc.business.progress.service.IPushSetReceiveService;
import com.ejianc.business.progress.service.IPushSetService;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.DetailListUtil;
import com.ejianc.business.progress.utils.WarnDateUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工期预警
 *
 * @author generator
 */
@Service("warnService")
public class WarnServiceImpl extends BaseServiceImpl<ExecPlanMapper, ExecPlanEntity> implements IWarnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IExecPlanDetailService detailService;
    @Autowired
    private IMonthPlanDetailService monthPlanDeteilService;
    @Autowired
    private IDelnyTrendService delnyTrendService;
    @Autowired
    private IProjectTrendService projectTrendService;
    @Autowired
    private IProjectLightService projectLightService;
    @Autowired
    private IMonthLightService monthLightService;
    @Autowired
    private IContractLightService contractLightService;
    @Autowired
    private IPushSetService pushSetService;
    @Autowired
    private IPushSetReceiveService receiveService;
    @Autowired
    private ILightRuleService lightRuleService;
    @Autowired
    private ITotalPlanService totalPlanService;

    @Autowired
    private WarnFeignUtil feignUtil;
    @Autowired
    private DetailListUtil detailListUtil;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IProjectPoolApi projectApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public CommonResponse light(HttpServletRequest request) {

        /** 查询执行计划 */
        List<ExecPlanEntity> execList = this.getExecPlanList();
        // 提前查询项目Map和组织Map
        List<Long> projectIds = execList.stream().map(ExecPlanEntity::getProjectId).collect(Collectors.toList());
        /** 查询月计划 */
        List<MonthPlanEntity> monthList = this.getMonthPlanList(projectIds);

        if(CollectionUtils.isEmpty(execList) && CollectionUtils.isEmpty(monthList)){
            logger.info("没有计划可执行！");
            return CommonResponse.success("没有计划可执行！");
        }

        TransferVO transferVO = feignUtil.getTransferVO(projectIds);

        transferVO.setExecList(execList);
        transferVO.setMonthList(monthList);

        /** 批量执行 */
        this.process(transferVO);

        return CommonResponse.success("执行成功！");
    }

    /**
     * 查询执行计划信息
     */
    private List<ExecPlanEntity> getExecPlanList() {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效

        List<ExecPlanEntity> list = execPlanService.queryList(queryParam);
        for (ExecPlanEntity entity : list){
            QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
            ew.eq("progress_id", entity.getId());
            ew.orderByAsc("tid");
            List<ExecPlanDetailEntity> detailList = detailService.list(ew);
            entity.setAllList(detailList);
        }

        return list;
    }

    /**
     * 查询所有月计划信息
     */
    private List<MonthPlanEntity> getMonthPlanList(List<Long> projectIds) {
        if(CollectionUtils.isEmpty(projectIds)){
            return new ArrayList<>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
        queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));// 生效

        List<MonthPlanEntity> list = monthPlanService.queryList(queryParam);
        for (MonthPlanEntity entity : list){
            QueryWrapper<MonthPlanDetailEntity> ew = new QueryWrapper<>();
            ew.eq("progress_id", entity.getId());
            ew.orderByAsc("tid");
            List<MonthPlanDetailEntity> detailList = monthPlanDeteilService.list(ew);
            entity.setAllList(detailList);
        }

        return list;
    }

    /**
     * 批量执行
     * @param transferVO
     */
    @Override
    public CommonResponse process(TransferVO transferVO) {

        List<ExecPlanEntity> execList = transferVO.getExecList();
        List<MonthPlanEntity> monthList = transferVO.getMonthList();

        logger.info("--> 同步年计划亮灯状态开始");

        // 获取项目主键对应亮灯规则模板Map
        Map<Long, LightRuleEntity> projectLightRuleMap = this.getProjectLightRuleMap(transferVO.getProjectMap(),transferVO.getOrgMap());

        // 更新执行计划的偏差值和里程碑节点的亮灯状态
        this.updateExecPlanDiffValue(execList, projectLightRuleMap);

        // 里程碑节点预警亮灯
        Map<Long, Integer> projectWarnMap = this.recordContractLight(execList,projectLightRuleMap);

        // 项目完成时间预警亮灯
        this.recordProjectLight(execList, projectLightRuleMap,projectWarnMap,transferVO.getProjectMap());

        if (CollectionUtils.isNotEmpty(monthList)){
            // 月计划完成的亮灯
            this.recordMonthLight(execList,monthList, projectLightRuleMap);
        }

        /** 3.执行计划列表延误趋势 */
        delnyTrendService.execPlanDetailTrend(execList,projectLightRuleMap);

        /** 4.项目延误趋势 */
        projectTrendService.projectTrendTrend(execList,projectLightRuleMap);

        logger.info("--> 同步年计划亮灯状态结束");
        return CommonResponse.success("执行成功！");
    }

    /**
     * 更新执行计划的偏差值和里程碑节点的亮灯状态
     * @param projectLightRuleMap
     */
    public void updateExecPlanDiffValue(List<ExecPlanEntity> execPlanList, Map<Long, LightRuleEntity> projectLightRuleMap){

        List<ExecPlanDetailEntity> updateData = new ArrayList<>();
        for (ExecPlanEntity execPlan : execPlanList){

            //获取亮灯规则模板
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, execPlan.getProjectId(), LightRuleLevelEnum.里程碑节点预警.getCode());

            List<ExecPlanDetailEntity> execPlanDetailList = execPlan.getAllList();
            for (ExecPlanDetailEntity execPlanDetail : execPlanDetailList){

                //偏差日期
                Date predictFinish = execPlanDetail.getPredictFinish();
                // 任务未完成，预测完成时间和系统时间取最大值
                if(!new Integer(1).equals(execPlanDetail.getFinishState())){
                    predictFinish = DateUtil.compareDay(new Date(), execPlanDetail.getPredictFinish()) > 0 ? new Date() : execPlanDetail.getPredictFinish();
                } else {// 任务已完成，预测完成时间取实际完成时间
                    predictFinish = execPlanDetail.getActualFinish();
                }
                Integer diffValueInt = DateUtil.getBetweenDays(predictFinish, execPlanDetail.getPlanFinish());
                BigDecimal diffValue = new BigDecimal(diffValueInt);
                execPlanDetail.setDiffValue(diffValue);
                execPlanDetail.setLightType(null);// 初始化不亮灯

                //获取里程碑节点亮灯状态
//                if (PlanConstant.LEVEL_CONTRACT == execPlanDetail.getNodeLevel() || PlanConstant.LEVEL_FIRST == execPlanDetail.getNodeLevel()){
                if (PlanConstant.LEVEL_CONTRACT == execPlanDetail.getNodeLevel()){
                    Integer status = null;
                    if (null == execPlanDetail.getActualStart() && null == execPlanDetail.getActualFinish()){
                        status = FillConstant.NOT_STAR;
                    }
                    if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getPredictFinish() && null == execPlanDetail.getActualFinish()){
                        status = FillConstant.UNDERWAY;
                    }
                    if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getActualFinish()){
                        status = FillConstant.FINISHED;
                    }

                    if (null != lightRuleLevel){
                        //节点剩余工期
                        Integer residueValue = DateUtil.getBetweenDays(execPlanDetail.getPredictFinish(),new Date());
                        // 偏差日期/节点剩余工期
                        BigDecimal finalValue = ComputeUtil.safeDiv(diffValue,new BigDecimal(residueValue));
                        //获取亮灯状态
                        Integer lightType = this.getLightType(lightRuleLevel, diffValue, finalValue,true,status);

                        execPlanDetail.setLightType(lightType);
                    }
                }

                updateData.add(execPlanDetail);

            }

        }

        //更新执行计划偏差值和亮灯状态
        if(updateData.size() > 0) {
            execPlanDetailService.saveOrUpdateBatch(updateData, updateData.size(), false);
        }

    }

    /**
     * 获取里程碑节点亮灯状态
     * @param lightRuleLevelEntity
     * @param diffValue
     * @param finalValue
     * @return
     */
    @Override
    public Integer getLightType(LightRuleLevelEntity lightRuleLevelEntity,BigDecimal diffValue,BigDecimal finalValue,Boolean isContractLevel,Integer state){

        if (finalValue.toString().equals("0E-8")){
            finalValue = BigDecimal.ZERO;
        }
        finalValue = ComputeUtil.safeMultiply(finalValue,new BigDecimal(100));

        Integer lightType = LightTypeEnum.绿灯.getCode();// 亮灯状态

        if (null != lightRuleLevelEntity){
            //蓝灯判断
            if (lightRuleLevelEntity.getBlueDiffSelect() == PlanConstant.INTEGER_YES){
                if (finalValue.compareTo(new BigDecimal(lightRuleLevelEntity.getBlueDiffMin())) > 0){
                    lightType = LightTypeEnum.蓝灯.getCode();
                }
            }
            if (lightRuleLevelEntity.getBlueLightSelect() == PlanConstant.INTEGER_YES){
                if (new BigDecimal(lightRuleLevelEntity.getBlueSumMin()).compareTo(diffValue) <= 0 && diffValue.compareTo(new BigDecimal(lightRuleLevelEntity.getBlueLightMin())) < 0){
                    lightType = LightTypeEnum.蓝灯.getCode();
                }
            }
            //黄灯判断
            if (lightRuleLevelEntity.getYellowDiffSelect() == PlanConstant.INTEGER_YES){
                if (finalValue.compareTo(new BigDecimal(lightRuleLevelEntity.getYellowDiffMin())) > 0){
                    lightType = LightTypeEnum.黄灯.getCode();
                }
            }
            if (lightRuleLevelEntity.getYellowLightSelect() == PlanConstant.INTEGER_YES){
                if (new BigDecimal(lightRuleLevelEntity.getYellowSumMin()).compareTo(diffValue) <= 0 && diffValue.compareTo(new BigDecimal(lightRuleLevelEntity.getYellowLightMin())) < 0){
                    lightType = LightTypeEnum.黄灯.getCode();
                }
            }
            //红灯判断
            if (lightRuleLevelEntity.getRedDiffSelect() == PlanConstant.INTEGER_YES){
                if (finalValue.compareTo(new BigDecimal(lightRuleLevelEntity.getRedDiffMin())) > 0){
                    lightType = LightTypeEnum.红灯.getCode();
                }
            }
            if (lightRuleLevelEntity.getRedLightSelect() == PlanConstant.INTEGER_YES){
                if (new BigDecimal(lightRuleLevelEntity.getRedLightMin()).compareTo(diffValue) <= 0 ){
                    lightType = LightTypeEnum.红灯.getCode();
                }
            }
            //紫灯判断(只有是里程碑节点并且是已完成的才判断是否亮紫灯)
            if (isContractLevel && FillConstant.FINISHED == state){
                if (lightRuleLevelEntity.getVioletDiffSelect() == PlanConstant.INTEGER_YES){
                    if (diffValue.compareTo(new BigDecimal(lightRuleLevelEntity.getVioletDiffMin())) > 0){
                        lightType = LightTypeEnum.紫灯.getCode();
                    }
                }
            }
        }

        return lightType;

    }

    /**
     * 获取项目亮灯规则
     * @param projectLightRuleMap
     * @param projectId
     * @param level
     * @return
     */
    @Override
    public LightRuleLevelEntity getLightRuleLevel(Map<Long,LightRuleEntity> projectLightRuleMap,Long projectId,Integer level){

        LightRuleLevelEntity lightRuleLevel = null;

        //如果没有亮灯规则模板则返回null
        if (!projectLightRuleMap.containsKey(projectId)){
            return lightRuleLevel;
        }

        // 亮灯规则
        LightRuleEntity lightRuleEntity = projectLightRuleMap.get(projectId);
        if (null != lightRuleEntity){
            List<LightRuleLevelEntity> detailList = lightRuleEntity.getDetailList();
            Map<Integer, LightRuleLevelEntity> LevelMap = detailList.stream().collect(Collectors.toMap(LightRuleLevelEntity::getLevel, Function.identity()));
            lightRuleLevel = LevelMap.get(level);
            // 如果是里程碑节点亮灯规则就把亮紫灯的信息放进去
            if (LightRuleLevelEnum.里程碑节点预警.getCode() == level){
                LightRuleLevelEntity violetRuleLevel = LevelMap.get(LightRuleLevelEnum.里程碑节点报警.getCode());
                lightRuleLevel.setVioletDiffSelect(violetRuleLevel.getVioletDiffSelect());
                lightRuleLevel.setVioletDiffMin(violetRuleLevel.getVioletDiffMin());
            }
        }

        return lightRuleLevel;

    }


    /**
     * 处理里程碑节点亮灯
     * @param projectLightRuleMap
     * @return
     */
    public Map<Long,Integer> recordContractLight(List<ExecPlanEntity> execPlanList, Map<Long, LightRuleEntity> projectLightRuleMap){

        Map<Long,Integer> projectWarnMap = new HashMap<>(); //项目报警map (key:项目主键,value:报警次数)；

        // 获取历史关系表
        List<ExecPlanDetailEntity> execPlanAllDetailList = new ArrayList<>();
        for (ExecPlanEntity execPlan : execPlanList){
            execPlanAllDetailList.addAll(execPlan.getAllList());
        }
        List<ExecPlanDetailEntity> levelContractList = execPlanAllDetailList.stream().filter(e -> PlanConstant.LEVEL_CONTRACT == e.getNodeLevel()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(levelContractList)){
            return projectWarnMap;
        }
        List<Long> levelContractIds = levelContractList.stream().map(ExecPlanDetailEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("execPlanBid", new Parameter(QueryParam.IN, levelContractIds));
        List<ContractLightEntity> list = contractLightService.queryList(queryParam);
        Map<Long, ContractLightEntity> map = list.stream().collect(Collectors.toMap(ContractLightEntity::getExecPlanBid, Function.identity()));


        // 获取插入更新集合
        List<ContractLightEntity> saveList = new ArrayList<>();
        for (ExecPlanEntity execPlan : execPlanList){

            //获取项目亮灯规则模板
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, execPlan.getProjectId(), LightRuleLevelEnum.里程碑节点预警.getCode());

            Integer sumWarn = 0; //一个项目下报警次数(即为里程碑节点亮紫灯的个数)
            List<ExecPlanDetailEntity> execPlanDetailList = execPlan.getAllList().stream().filter(e -> PlanConstant.LEVEL_CONTRACT == e.getNodeLevel()).collect(Collectors.toList());
            for (ExecPlanDetailEntity execPlanDetail : execPlanDetailList){
                if (PlanConstant.LEVEL_CONTRACT == execPlanDetail.getNodeLevel()){

                    ContractLightEntity lightEntity = new ContractLightEntity();

                    if(map.containsKey(execPlanDetail.getId())){
                        lightEntity = map.get(execPlanDetail.getId());
                    }

                    lightEntity.setProjectId(execPlan.getProjectId());
                    lightEntity.setProjectName(execPlan.getProjectName());
                    lightEntity.setOrgId(execPlan.getOrgId());
                    lightEntity.setOrgName(execPlan.getOrgName());
                    lightEntity.setCorpId(execPlan.getCorpId());
                    lightEntity.setCorpName(execPlan.getCorpName());
                    lightEntity.setExecPlanId(execPlan.getId());
                    lightEntity.setExecPlanCode(execPlan.getBillCode());
                    lightEntity.setExecPlanBid(execPlanDetail.getId());
                    lightEntity.setPlanName(execPlanDetail.getName());

                    Integer status = null;
                    if (null == execPlanDetail.getActualStart() && null == execPlanDetail.getActualFinish()){
                        status = FillConstant.NOT_STAR;
                    }
                    if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getPredictFinish() && null == execPlanDetail.getActualFinish()){
                        status = FillConstant.UNDERWAY;
                    }
                    if (null != execPlanDetail.getActualStart() && null != execPlanDetail.getActualFinish()){
                        status = FillConstant.FINISHED;
                    }
                    lightEntity.setStatus(status);

                    //偏差值
                    Integer diffValueInt = DateUtil.getBetweenDays(execPlanDetail.getPredictFinish(), execPlanDetail.getPlanFinish());
                    BigDecimal diffValue = new BigDecimal(diffValueInt);

                    //如果没有获取到项目亮灯规则模板就不显示亮灯状态了
                    if (null != lightRuleLevel){
                        //节点剩余工期
                        Integer residueValue = DateUtil.getBetweenDays(execPlanDetail.getPredictFinish(), new Date());
                        // 偏差日期/节点剩余工期
                        BigDecimal finalValue = ComputeUtil.safeDiv(diffValue,new BigDecimal(residueValue));
                        //获取亮灯状态
                        Integer lightType = this.getLightType(lightRuleLevel, diffValue, finalValue,true,status);

                        //如果亮紫则通统计亮灯次数
                        if (LightTypeEnum.紫灯.getCode() == lightType){
                            lightEntity.setWarnState(PlanConstant.INTEGER_YES);
                            sumWarn ++;
                        }

                        lightEntity.setLightType(lightType);
                    }

                    lightEntity.setDiffValue(diffValue);

                    // 实时更新修改时间，而且必须有默认初始值
                    lightEntity.setUpdateTime(lightEntity.getUpdateTime() != null ? lightEntity.getUpdateTime() : new Date());
                    lightEntity.setTenantId(lightEntity.getTenantId() != null ? lightEntity.getTenantId() : execPlan.getTenantId());

                    saveList.add(lightEntity);

                }
            }

            projectWarnMap.put(execPlan.getProjectId(),sumWarn);

        }

        if(CollectionUtils.isNotEmpty(saveList)){
            contractLightService.saveOrUpdateBatch(saveList);
        }

        return projectWarnMap;
    }

    /**
     * 项目亮灯关系统计
     * @param execList
     */
    private void recordProjectLight(List<ExecPlanEntity> execList, Map<Long, LightRuleEntity> projectLightRuleMap,Map<Long, Integer> projectWarnMap,Map<Long, ProjectVO> projectMap) {

        // 获取历史关系表
        List<Long> execIds = execList.stream().map(ExecPlanEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("execPlanId", new Parameter(QueryParam.IN, execIds));
        List<ProjectLightEntity> list = projectLightService.queryList(queryParam);
        Map<Long, ProjectLightEntity> map = list.stream().collect(Collectors.toMap(ProjectLightEntity::getExecPlanId, Function.identity()));

        // 获取插入更新集合
        List<ProjectLightEntity> saveList = new ArrayList<>();
        for(ExecPlanEntity execPlan : execList){
            //获取项目亮灯规则模板
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, execPlan.getProjectId(), LightRuleLevelEnum.项目完成时间.getCode());

            ProjectLightEntity lightEntity = new ProjectLightEntity();

            if(map.containsKey(execPlan.getId())){
                lightEntity = map.get(execPlan.getId());
            }

            lightEntity.setProjectId(execPlan.getProjectId());
            lightEntity.setProjectName(execPlan.getProjectName());
            lightEntity.setOrgId(execPlan.getOrgId());
            lightEntity.setOrgName(execPlan.getOrgName());
            lightEntity.setCorpId(execPlan.getCorpId());
            lightEntity.setCorpName(execPlan.getCorpName());
            lightEntity.setExecPlanId(execPlan.getId());
            lightEntity.setExecPlanCode(execPlan.getBillCode());
            if(projectMap.containsKey(execPlan.getProjectId())){
                ProjectVO projectVO = projectMap.get(execPlan.getProjectId());
                lightEntity.setProjectManager(projectVO.getLeader());
                lightEntity.setProjectType(projectVO.getProjectControlLevel());
                lightEntity.setStartDate(projectVO.getStartDate());
            }
            Integer sumWarn = projectWarnMap.get(execPlan.getProjectId());
            lightEntity.setSumWarn(null != sumWarn ? new BigDecimal(sumWarn) : BigDecimal.ZERO);

            //取执行计划中的总计划明细
            List<ExecPlanDetailEntity> detailList = execPlan.getAllList().stream().filter(e -> PlanConstant.TOTAL_PLAN == e.getPlanState()).collect(Collectors.toList());

            logger.info("执行计划项目id-{},字表数量-{},过滤后字表数量-{}",execPlan.getProjectId(),execPlan.getAllList().size(),detailList.size());

            if (CollectionUtils.isEmpty(detailList)){
                continue;
            }

            // 最大预测完成日期
            Date maxPredictFinish = detailList.stream().map(ExecPlanDetailEntity::getPredictFinish).max(Comparator.comparing(e -> e)).get();
            // 最大计划完成日期
            Date maxPlanFinish = detailList.stream().map(ExecPlanDetailEntity::getPlanFinish).max(Comparator.comparing(e -> e)).get();
            // 最大偏差值
            BigDecimal maxDiffValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, maxPlanFinish));

            Integer lightType = LightTypeEnum.绿灯.getCode();
            if (null != lightRuleLevel){
                // 最大预测完成日期
                //Date maxPredictFinish = detailList.stream().max(Comparator.comparing(ExecPlanDetailEntity::getPredictFinish)).get().getPredictFinish();
                // 最大节点剩余工期
                BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, new Date()));
                // 偏差日期/节点剩余工期
                BigDecimal finalValue = ComputeUtil.safeDiv(maxDiffValue, residueValue);
                //获取亮灯状态
                lightType = getLightType(lightRuleLevel, maxDiffValue, finalValue, false,null);
                lightEntity.setLightType(lightType);
            }

            if (null != lightType && lightType >= LightTypeEnum.蓝灯.getCode()){
                lightEntity.setCriticalPath(PlanConstant.INTEGER_YES);
            }else{
                lightEntity.setCriticalPath(PlanConstant.INTEGER_NO);
            }

            lightEntity.setDiffValue(maxDiffValue);

            // 实时更新修改时间，而且必须有默认初始值
            lightEntity.setUpdateTime(lightEntity.getUpdateTime() != null ? lightEntity.getUpdateTime() : new Date());
            lightEntity.setTenantId(lightEntity.getTenantId() != null ? lightEntity.getTenantId() : execPlan.getTenantId());

            saveList.add(lightEntity);

        }

        if(CollectionUtils.isNotEmpty(saveList)){
            projectLightService.saveOrUpdateBatch(saveList);
        }

    }

    /**
     * 月计划亮灯关系统计
     * @param monthList
     */
    private void recordMonthLight(List<ExecPlanEntity> execList, List<MonthPlanEntity> monthList, Map<Long, LightRuleEntity> projectLightRuleMap) {

        Map<Long, ExecPlanEntity> execMap = execList.stream().collect(Collectors.toMap(ExecPlanEntity::getProjectId, Function.identity()));

        // 获取历史关系表
        List<Long> monthIds = monthList.stream().map(MonthPlanEntity::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("monthPlanId", new Parameter(QueryParam.IN, monthIds));
        List<MonthLightEntity> list = monthLightService.queryList(queryParam);
        Map<Long, MonthLightEntity> map = list.stream().collect(Collectors.toMap(MonthLightEntity::getMonthPlanId, Function.identity()));

        // 获取插入更新集合
        List<MonthLightEntity> saveList = new ArrayList<>();
        for(MonthPlanEntity month : monthList){

            //获取项目亮灯规则模板
            LightRuleLevelEntity lightRuleLevel = this.getLightRuleLevel(projectLightRuleMap, month.getProjectId(), LightRuleLevelEnum.月计划完成.getCode());

            MonthLightEntity lightEntity = new MonthLightEntity();

            if(map.containsKey(month.getId())){
                lightEntity = map.get(month.getId());
            }

            lightEntity.setProjectId(month.getProjectId());
            lightEntity.setProjectName(month.getProjectName());
            lightEntity.setOrgId(month.getOrgId());
            lightEntity.setOrgName(month.getOrgName());
            lightEntity.setCorpId(month.getCorpId());
            lightEntity.setCorpName(month.getCorpName());
            lightEntity.setMonthPlanId(month.getId());
            lightEntity.setMonthPlanCode(month.getBillCode());
            lightEntity.setPlanMonth(month.getPlanMonth());

            // 将月计划与执行计划做对比取出来与月计划相同的执行计划明细
            List<MonthPlanDetailEntity> monthDetailList = month.getAllList();
            ExecPlanEntity execPlanEntity = execMap.get(month.getProjectId());
            List<ExecPlanDetailEntity> execDetailList = execPlanEntity.getAllList();
            Map<String, MonthPlanDetailEntity> structCodeMap = monthDetailList.stream().collect(Collectors.toMap(MonthPlanDetailEntity::getStructCode, Function.identity()));
            List<ExecPlanDetailEntity> detailList = execDetailList.stream().filter(e -> null != structCodeMap.get(e.getStructCode())).collect(Collectors.toList());

            if (CollectionUtils.isEmpty(detailList)){
                continue;
            }

            List<Date> leftDateList = new ArrayList<>();
            List<Date> rightDateList = new ArrayList<>();
            Map<String, ExecPlanDetailEntity> execPlanDetailMap = detailList.stream().collect(Collectors.toMap(ExecPlanDetailEntity::getStructCode, Function.identity()));
            for (MonthPlanDetailEntity monthDetail : monthDetailList){
                ExecPlanDetailEntity execDetail = execPlanDetailMap.get(monthDetail.getStructCode());
                if (null != execDetail && StringUtils.isNotEmpty(monthDetail.getName()) && StringUtils.isNotEmpty(execDetail.getName())){
                    // 偏差时间=max执行计划中当月计划的任务项{y%*(预测完成时间-预测开始时间+1）+预测开始时间-1}-min当月月计划中{本月最后1天，max{计划完成时间}}
                    Integer value = DateUtil.getBetweenDays(execDetail.getPredictFinish(),execDetail.getPredictStart());
                    Date leftDate = DateUtil.addDays(execDetail.getPredictStart(), value);
                    if (monthDetail.getName().length() > execDetail.getName().length()){
                        // 偏差时间=max执行计划中当月计划的任务项{y%*(预测完成时间-预测开始时间+1）+预测开始时间}-min当月月计划中{本月最后1天，max{计划完成时间}}
                        String percentTask = monthDetail.getName().substring(execDetail.getName().length());
                        String regex = percentTask.contains("--") ? "--" : "-";
                        if(!percentTask.contains(regex)) continue;
                        String split1 = percentTask.split(regex)[1];
                        String str = split1.substring(0, split1.length() - 2);
                        if (StringUtils.isEmpty(str)) continue;
                        Float y = new Float(str);
                        value = DateUtil.getBetweenDays(execDetail.getPredictFinish(),execDetail.getPredictStart());
                        int round = Math.round(y / 100 * (value + 1));
                        leftDate = DateUtil.addDays(execDetail.getPredictStart(), round);
                    }
                    leftDateList.add(leftDate);
                    rightDateList.add(monthDetail.getFinish());
                }
            }

            Date rightDate = null;
            Date date = rightDateList.stream().max(Comparator.comparing(e -> e)).get();
            Date monthLastDate = DateUtil.getMonthLastDate(new Date());
            if (date.getTime() <= monthLastDate.getTime()){
                rightDate = date;
            }else{
                rightDate = monthLastDate;
            }
            Date leftDate = leftDateList.stream().max(Comparator.comparing(e -> e)).get();
            BigDecimal maxDiffValue = new BigDecimal(DateUtil.getBetweenDays(leftDate, rightDate));

            // 最大偏差值
            //detailList.forEach(e -> e.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(e.getPredictFinish(), e.getPlanFinish()))));
            //BigDecimal maxDiffValue = detailList.stream().map(ExecPlanDetailEntity::getDiffValue).max(BigDecimal::compareTo).get();

            if (null != lightRuleLevel){
                // 最大预测完成日期
                Date maxPredictFinish = detailList.stream().max(Comparator.comparing(ExecPlanDetailEntity::getPredictFinish)).get().getPredictFinish();
                // 最大节点剩余工期
                BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, new Date()));
                // 偏差日期/节点剩余工期
                BigDecimal finalValue = ComputeUtil.safeDiv(maxDiffValue, residueValue);
                //获取亮灯状态
                Integer lightType = getLightType(lightRuleLevel, maxDiffValue, finalValue, false,null);
                lightEntity.setLightType(lightType);
            }

            lightEntity.setDiffValue(maxDiffValue);


            // 实时更新修改时间，而且必须有默认初始值
            lightEntity.setUpdateTime(lightEntity.getUpdateTime() != null ? lightEntity.getUpdateTime() : new Date());
            lightEntity.setTenantId(lightEntity.getTenantId() != null ? lightEntity.getTenantId() : month.getTenantId());

            saveList.add(lightEntity);

        }

        if(CollectionUtils.isNotEmpty(saveList)){
            monthLightService.saveOrUpdateBatch(saveList);
        }

    }


    /**
     * 获取项目主键对应亮灯规则模板Map
     * @return
     */
    private Map<Long, LightRuleEntity> getProjectLightRuleMap(Map<Long, ProjectVO> projectMap,Map<Long, OrgVO> orgMap) {

        //查询出所有的亮灯规则模板
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
        queryParam.getOrderMap().put("create_time", QueryParam.ASC);
        List<LightRuleEntity> lightRuleList = lightRuleService.queryList(queryParam);
        detailListUtil.setDetailList(lightRuleList);

        Map<Long, LightRuleEntity> orgRuleMap = new HashMap<>();
        for (LightRuleEntity entity : lightRuleList){
            orgRuleMap.put(entity.getOrgId(),entity);
        }
        Map<Long, LightRuleEntity> deptOrgIdRuleMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(orgRuleMap.keySet())){
            for (Long orgRuleId : orgRuleMap.keySet()){
                LightRuleEntity lightRuleEntity = orgRuleMap.get(orgRuleId);
                for (OrgVO orgVO : orgMap.values()){
                    String innerCode = orgVO.getInnerCode();
                    String orgId = orgRuleId.toString();
                    if (innerCode.contains(orgId)){
                        // 取最近组织亮灯规则模板
                        if(orgMap.containsKey(orgId) && orgMap.get(orgId).getInnerCode().length() > innerCode.length()){
                            continue;
                        }
                        deptOrgIdRuleMap.put(orgVO.getId(),lightRuleEntity);
                    }
                }
            }
        }

        Map<Long, LightRuleEntity> projectLightRuleMap = new HashMap<>();// 项目主键对应亮灯规则模板Map
        for(ProjectVO project : projectMap.values()){
            if (deptOrgIdRuleMap.containsKey(project.getProjectDepartmentId())){
                projectLightRuleMap.put(project.getId(),deptOrgIdRuleMap.get(project.getProjectDepartmentId()));
            }
        }
        return projectLightRuleMap;
    }

    @Override
    public CommonResponse pushNotice(HttpServletRequest request) {

        logger.info("--> 消息推送开始");

        // 推送设置
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));// 生效
        List<PushSetEntity> setList = pushSetService.queryList(queryParam2);
        if(CollectionUtils.isEmpty(setList)){
            logger.info("未查到推送设置！");
            return CommonResponse.success("未查到推送设置！");
        }
        Map<Long, PushSetEntity> setMap = setList.stream().collect(Collectors.toMap(PushSetEntity::getId, Function.identity()));
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("setId", new Parameter(QueryParam.IN, setList.stream().map(PushSetEntity::getId).collect(Collectors.toList())));
        List<PushSetReceiveEntity> receiveList = receiveService.queryList(queryParam3);

        // 查询推送设置所属组织本下
        List<Long> orgIds = setList.stream().map(PushSetEntity::getOrgId).collect(Collectors.toList());
        Map<Long, List<Long>> orgMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(orgIds)){
            orgIds.forEach(i->{
                if(!orgMap.containsKey(i)){
                    List<Long> childIds = orgApi.findChildrenByParentId(i).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                    orgMap.put(i, childIds);
                }
            });
        }

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(new Date()).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month = Integer.valueOf(split[1]);
        //获取某月的第一天
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(Calendar.YEAR,year);
        c1.set(Calendar.MONTH,Month-1);
        int firstDay = c1.getActualMinimum(Calendar.DAY_OF_MONTH);
        c1.set(Calendar.DAY_OF_MONTH,firstDay);
        Date monthFirstDate = c1.getTime();

        List<ProjectLightEntity> projectLightList = projectLightService.list();

        List<Long> projectIds = projectLightList.stream().map(ProjectLightEntity::getProjectId).collect(Collectors.toList());
        Map<Long, ProjectVO> projectMap = feignUtil.getProjectMapByIds(projectIds);

        List<MonthLightEntity> monthLightList = monthLightService.list(new LambdaQueryWrapper<MonthLightEntity>()
                .eq(MonthLightEntity::getPlanMonth,monthFirstDate));

        List<ContractLightEntity> contractLightList = contractLightService.list();
        List<ContractLightEntity> oldContractLightList = contractLightList;
        List<ContractLightEntity> newContractLightList = new ArrayList<>();
        contractLightList = contractLightList.stream().filter(e -> !LightTypeEnum.紫灯.getCode().equals(e.getLightType())).collect(Collectors.toList());
        contractLightList.stream().filter(x->x.getLightType() != null).collect(Collectors.groupingBy(ContractLightEntity::getProjectId, Collectors.maxBy(Comparator.comparing(ContractLightEntity::getLightType)))).forEach((k, v) -> {
            newContractLightList.add(v.get());
        });

        Map<String, Map<Long, LevelReceiveVO>> levelMap = new HashMap<>();// key-设置主键+层级，value(key-接收人主键，vlue-统计)
        if (CollectionUtils.isNotEmpty(receiveList)){
            for (PushSetReceiveEntity receive : receiveList){
                // 获取接收vo
                LevelReceiveVO vo = this.getReceiveVO(levelMap, receive, setMap.get(receive.getSetId()));
                if(LevelEnum.一级.getCode().equals(receive.getLevel())){
                    // 统计项目完成时间
                    this.calculateProject(projectLightList, receive, vo, orgMap);
                }
                if(LevelEnum.二级.getCode().equals(receive.getLevel())){
                    // 里程碑节点
                    this.calculateContract(newContractLightList, receive, vo, orgMap);
                }
                if(LevelEnum.三级.getCode().equals(receive.getLevel())){
                    // 月计划完成
                    this.calculateMonth(monthLightList, receive, vo, orgMap);
                }
                if(LevelEnum.四级.getCode().equals(receive.getLevel())){
                    // 里程碑节点报警
                    this.calculateContractWarn(oldContractLightList, receive, vo, orgMap);
                }
            }
        }

        if (CollectionUtils.isNotEmpty(levelMap)){
            for (Map<Long, LevelReceiveVO> level : levelMap.values()){
                if (CollectionUtils.isNotEmpty(level)){
                    for (LevelReceiveVO vo : level.values()){
                        // 根据发送频率判断是否发送消息
                        Boolean fillFlag = this.getFillFlag(vo.getFillType(), vo.getFillTime());
                        if(!fillFlag){
                            continue;
                        }
                        if(LevelEnum.一级.getCode().equals(vo.getLevel())){
                            // 解析项目完成时间推送设置
                            this.analysisProject(vo, projectMap);
                        }
                        if(LevelEnum.二级.getCode().equals(vo.getLevel())){
                            // 解析里程碑节点推送设置
                            this.analysisContract(vo, projectMap);
                        }
                        if(LevelEnum.三级.getCode().equals(vo.getLevel())){
                            // 解析月计划完成推送设置
                            this.analysisMonth(vo, projectMap);
                        }
                        if(LevelEnum.四级.getCode().equals(vo.getLevel())){
                            // 解析里程碑节点报警推送设置
                            this.analysisContractWarn(vo);
                        }
                    }
                }
            }
        }

        logger.info("执行成功！");
        return CommonResponse.success("执行成功！");
    }


    /**
     * 获取接收VO
     * @param levelMap
     * @param receive
     * @param set
     * @return
     */
    private LevelReceiveVO getReceiveVO(Map<String, Map<Long, LevelReceiveVO>> levelMap, PushSetReceiveEntity receive, PushSetEntity set) {
        // 接收人map
        Map<Long, LevelReceiveVO> map = new HashMap<>();
        String key = receive.getSetId() + "|" + receive.getLevel();
        if(!levelMap.containsKey(key)){
            levelMap.put(key, map);
        }
        map = levelMap.get(key);
        // 统计VO
        LevelReceiveVO vo = new LevelReceiveVO();
        if(!map.containsKey(receive.getReceiveId())){
            vo.setOrgId(set.getOrgId());
            vo.setOrgName(set.getOrgName());
            vo.setOrgType(receive.getOrgType());
            vo.setReceiveId(receive.getReceiveId());
            vo.setReceiveName(receive.getReceiveName());
            vo.setReceiveType(receive.getReceiveType());
            vo.setLevel(receive.getLevel());
            vo.setFillType(set.getFillType());
            vo.setFillTime(set.getFillTime());
            vo.setProjectBlueIds(new HashSet<>());
            vo.setProjectYellowIds(new HashSet<>());
            vo.setProjectRedIds(new HashSet<>());
            vo.setMonthBlueIds(new HashSet<>());
            vo.setMonthYellowIds(new HashSet<>());
            vo.setMonthRedIds(new HashSet<>());
            vo.setContractBlueIds(new HashSet<>());
            vo.setContractYellowIds(new HashSet<>());
            vo.setContractRedIds(new HashSet<>());
            vo.setContractVioletIds(new HashSet<>());
            map.put(receive.getReceiveId(), vo);
        }
        vo = map.get(receive.getReceiveId());
        return vo;
    }


    /**
     * 统计项目完成时间汇总
     * @param receive
     * @param vo
     */
    private void calculateProject(List<ProjectLightEntity> projectLightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set<Long> blueIds = vo.getProjectBlueIds();
        Set<Long> yellowIds = vo.getProjectYellowIds();
        Set<Long> redIds = vo.getProjectRedIds();
        for(ProjectLightEntity data : projectLightList){
            if(!orgMap.get(vo.getOrgId()).contains(data.getOrgId())){
                continue;
            }
            if(LightTypeEnum.蓝灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.蓝灯.getCode().equals(data.getLightType())){
                blueIds.add(data.getProjectId());
            }
            if(LightTypeEnum.黄灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.黄灯.getCode().equals(data.getLightType())){
                yellowIds.add(data.getProjectId());
            }
            if(LightTypeEnum.红灯.getCode().equals(receive.getLightType() -1) && LightTypeEnum.红灯.getCode().equals(data.getLightType())){
                redIds.add(data.getProjectId());
            }
        }
        vo.setProjectBlueIds(blueIds);
        vo.setProjectYellowIds(yellowIds);
        vo.setProjectRedIds(redIds);
    }

    /**
     * 统计月计划完成汇总
     * @param receive
     * @param vo
     */
    private void calculateMonth(List<MonthLightEntity> lightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set<Long> blueIds = vo.getMonthBlueIds();
        Set<Long> yellowIds = vo.getMonthYellowIds();
        Set<Long> redIds = vo.getMonthRedIds();
        for(MonthLightEntity data : lightList){
            if(!orgMap.get(vo.getOrgId()).contains(data.getOrgId())){
                continue;
            }
            if(LightTypeEnum.蓝灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.蓝灯.getCode().equals(data.getLightType())){
                blueIds.add(data.getProjectId());
            }
            if(LightTypeEnum.黄灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.黄灯.getCode().equals(data.getLightType())){
                yellowIds.add(data.getProjectId());
            }
            if(LightTypeEnum.红灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.红灯.getCode().equals(data.getLightType())){
                redIds.add(data.getProjectId());
            }
        }
        vo.setMonthBlueIds(blueIds);
        vo.setMonthYellowIds(yellowIds);
        vo.setMonthRedIds(redIds);
    }

    /**
     * 里程碑节点汇总
     * @param receive
     * @param vo
     */
    private void calculateContract(List<ContractLightEntity> lightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set<Long> blueIds = vo.getContractBlueIds();
        Set<Long> yellowIds = vo.getContractYellowIds();
        Set<Long> redIds = vo.getContractRedIds();
        for(ContractLightEntity data : lightList){
            if(!orgMap.get(vo.getOrgId()).contains(data.getOrgId())){
                continue;
            }
            if(LightTypeEnum.蓝灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.蓝灯.getCode().equals(data.getLightType())){
                blueIds.add(data.getProjectId());
            }
            if(LightTypeEnum.黄灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.黄灯.getCode().equals(data.getLightType())){
                yellowIds.add(data.getProjectId());
            }
            if(LightTypeEnum.红灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.红灯.getCode().equals(data.getLightType())){
                redIds.add(data.getProjectId());
            }
        }
        vo.setContractBlueIds(blueIds);
        vo.setContractYellowIds(yellowIds);
        vo.setContractRedIds(redIds);
    }

    /**
     * 里程碑节点报警汇总
     * @param receive
     * @param vo
     */
    private void calculateContractWarn(List<ContractLightEntity> lightList, PushSetReceiveEntity receive, LevelReceiveVO vo, Map<Long, List<Long>> orgMap) {
        Set<Long> violetIds = vo.getContractVioletIds();
        for(ContractLightEntity data : lightList){
            if(!orgMap.get(vo.getOrgId()).contains(data.getOrgId())){
                continue;
            }
            if(LightTypeEnum.紫灯.getCode().equals(receive.getLightType() - 1) && LightTypeEnum.紫灯.getCode().equals(data.getLightType())){
                violetIds.add(data.getProjectId());
            }
        }
        vo.setContractVioletIds(violetIds);
    }


    /**
     * 根据发送频率判断是否发送消息
     * @param fillType
     * @param fillTime
     * @return
     */
    private Boolean getFillFlag(String fillType, String fillTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Boolean fillFlag = false;// 填报是否发送
        if("1".equals(fillType)){// 每天
            fillFlag = true;
        } else if ("2".equals(fillType)){// 每周
            int  DAY_OF_WEEK = cal.get(Calendar.DAY_OF_WEEK);// 当前星期的第几天(星期天表示第一天，星期六表示第七天)
            Integer day = Integer.valueOf(fillTime);// 亮灯规则模板填报日期(从星期一开始)
            if(DAY_OF_WEEK == WarnDateUtil.turnZnDayOfWeek(day)){// 转换为对应星期几
                fillFlag = true;
            }
        } else if ("3".equals(fillType)){// 每月
            int  DAY_OF_MONTH = cal.get(Calendar.DAY_OF_MONTH );// 当前月中的第几天
            Integer day = Integer.valueOf(fillTime);// 亮灯规则模板填报日期(从1-28及最后一天)
            if(DAY_OF_MONTH  == WarnDateUtil.turnZnDayOfMonth(day)){// 转换为对应当月天数
                fillFlag = true;
            }
        }
        return fillFlag;
    }


    /**
     * 解析项目推送设置
     * @param vo
     * @return
     */
    private boolean analysisProject(LevelReceiveVO vo, Map<Long, ProjectVO> projectMap) {
        // 信息发送类型
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("dingding");

        int sum = vo.getProjectRedIds().size() + vo.getProjectYellowIds().size() + vo.getProjectBlueIds().size();
        if(sum < 1) {
            return true;
        }

        StringBuffer str = new StringBuffer();
        StringBuffer url = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
        str.append("截止至" + sdf.format(new Date()) + "，共有"+sum+"个项目状态异常：");
        url.append("截止至" + sdf.format(new Date()) + "，共有"+sum+"个项目状态异常：");
        List<Integer> lightType = new ArrayList<>();
        if(vo.getProjectRedIds().size() > 0){
            str.append("项目完成时间红灯项目：" + vo.getProjectRedIds().size() + "个；");
            url.append("项目完成时间红灯项目：" + vo.getProjectRedIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getProjectRedIds());
            lightType.add(LightTypeEnum.红灯.getCode());
        }
        if(vo.getProjectYellowIds().size() > 0){
            str.append("项目完成时间黄灯项目：" + vo.getProjectYellowIds().size() + "个；");
            url.append("项目完成时间黄灯项目：" + vo.getProjectYellowIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getProjectYellowIds());
            lightType.add(LightTypeEnum.黄灯.getCode());
        }
        if(vo.getProjectBlueIds().size() > 0){
            str.append("项目完成时间蓝灯项目：" + vo.getProjectBlueIds().size() + "个；");
            url.append("项目完成时间蓝灯项目：" + vo.getProjectBlueIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getProjectBlueIds());
            lightType.add(LightTypeEnum.蓝灯.getCode());
        }

        List<String> sender = new ArrayList<>();
        if(vo.getReceiveType().equals("user")){
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if(vo.getReceiveType().equals("role")){
            CommonResponse<List<RoleUserRelationVO>> response = roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()),Arrays.asList(vo.getOrgId()));
            if(!response.isSuccess()){
                return false;
            }
            sender = response.getData().stream().map(RoleUserRelationVO:: getUserId).map(String::valueOf).collect(Collectors.toList());
        }

        if(CollectionUtils.isNotEmpty(sender)){
            String formurl = baseHost+"ejc-zjkjprogress-frontend/#/projectLight";
            if(CollectionUtils.isNotEmpty(lightType)){
                Collections.reverse(lightType);
                formurl = formurl + "?lightType=" + StringUtils.join(lightType, ",");
            }
            String mobileUrl = baseHost+"ejc-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = url.toString() + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            feignUtil.sendMsg(messageType, sender, "notice", subject, content, mobileUrl, formurl);
        }
        return true;
    }

    /**
     * 拼接项目名称连接
     * @param str
     * @param url
     * @param projectMap
     * @param projectIds
     */
    private void projectNameLink(StringBuffer str, StringBuffer url, Map<Long, ProjectVO> projectMap, Set<Long> projectIds){
        String pcurl = baseHost+"ejc-zjkjprogress-frontend/#/queryProgress";
        for(Long projectId : projectIds){
            ProjectVO project = projectMap.get(projectId);
            str.append("【" + project.getProjectName() + "】");
            url.append("【<a href=" + '"' + pcurl + "?orgId=" + project.getProjectDepartmentId() + '"' + ">");
            url.append(project.getProjectName());
            url.append("</a>】");
        }
    }

    /**
     * 解析里程碑节点推送设置
     * @param vo
     * @return
     */
    private boolean analysisContract(LevelReceiveVO vo, Map<Long, ProjectVO> projectMap) {
        // 信息发送类型
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("dingding");

        int sum = vo.getContractRedIds().size() + vo.getContractYellowIds().size() + vo.getContractBlueIds().size();
        if(sum < 1) {
            return true;
        }

        StringBuffer str = new StringBuffer();
        StringBuffer url = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
        str.append("截止至" + sdf.format(new Date()) + "，共有"+sum+"个项目状态异常：");
        url.append("截止至" + sdf.format(new Date()) + "，共有"+sum+"个项目状态异常：");
        List<Integer> lightType = new ArrayList<>();
        if(vo.getContractRedIds().size() > 0){
            str.append("里程碑节点红灯项目：" + vo.getContractRedIds().size() + "个；");
            url.append("里程碑节点红灯项目：" + vo.getContractRedIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getContractRedIds());
            lightType.add(LightTypeEnum.红灯.getCode());
        }
        if(vo.getContractYellowIds().size() > 0){
            str.append("里程碑节点黄灯项目：" + vo.getContractYellowIds().size() + "个；");
            url.append("里程碑节点黄灯项目：" + vo.getContractYellowIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getContractYellowIds());
            lightType.add(LightTypeEnum.黄灯.getCode());
        }
        if(vo.getContractBlueIds().size() > 0){
            str.append("里程碑节点蓝灯项目：" + vo.getContractBlueIds().size() + "个；");
            url.append("里程碑节点蓝灯项目：" + vo.getContractBlueIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getContractBlueIds());
            lightType.add(LightTypeEnum.蓝灯.getCode());
        }

        List<String> sender = new ArrayList<>();
        if(vo.getReceiveType().equals("user")){
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if(vo.getReceiveType().equals("role")){
            CommonResponse<List<RoleUserRelationVO>> response = roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()),Arrays.asList(vo.getOrgId()));
            if(!response.isSuccess()){
                return false;
            }
            sender = response.getData().stream().map(RoleUserRelationVO:: getUserId).map(String::valueOf).collect(Collectors.toList());
        }

        if(CollectionUtils.isNotEmpty(sender)){
            String formurl = baseHost+"ejc-zjkjprogress-frontend/#/projectLight";
            if(CollectionUtils.isNotEmpty(lightType)){
                Collections.reverse(lightType);
                formurl = formurl + "?lightType=" + StringUtils.join(lightType, ",");
            }
            String mobileUrl = baseHost+"ejc-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = url.toString() + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            feignUtil.sendMsg(messageType, sender, "notice", subject, content, mobileUrl, formurl);
        }
        return true;
    }

    /**
     * 解析月计划推送设置
     * @param vo
     * @return
     */
    private boolean analysisMonth(LevelReceiveVO vo, Map<Long, ProjectVO> projectMap) {
        // 信息发送类型
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("dingding");

        int sum = vo.getMonthRedIds().size() + vo.getMonthYellowIds().size() + vo.getMonthBlueIds().size();
        if(sum < 1) {
            return true;
        }

        StringBuffer str = new StringBuffer();
        StringBuffer url = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
        str.append("截止至" + sdf.format(new Date()) + "，共有"+sum+"个项目状态异常：");
        url.append("截止至" + sdf.format(new Date()) + "，共有"+sum+"个项目状态异常：");
        List<Integer> lightType = new ArrayList<>();
        if(vo.getMonthRedIds().size() > 0){
            str.append("当月月计划完成红灯项目：" + vo.getMonthRedIds().size() + "个；");
            url.append("当月月计划完成红灯项目：" + vo.getMonthRedIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getMonthRedIds());
            lightType.add(LightTypeEnum.红灯.getCode());
        }
        if(vo.getMonthYellowIds().size() > 0){
            str.append("当月月计划完成黄灯项目：" + vo.getMonthYellowIds().size() + "个；");
            url.append("当月月计划完成黄灯项目：" + vo.getMonthYellowIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getMonthYellowIds());
            lightType.add(LightTypeEnum.黄灯.getCode());
        }
        if(vo.getMonthBlueIds().size() > 0){
            str.append("当月月计划完成蓝灯项目：" + vo.getMonthBlueIds().size() + "个；");
            url.append("当月月计划完成蓝灯项目：" + vo.getMonthBlueIds().size() + "个；");
            // 拼接项目名称连接
            this.projectNameLink(str, url, projectMap, vo.getMonthBlueIds());
            lightType.add(LightTypeEnum.蓝灯.getCode());
        }

        List<String> sender = new ArrayList<>();
        if(vo.getReceiveType().equals("user")){
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if(vo.getReceiveType().equals("role")){
            CommonResponse<List<RoleUserRelationVO>> response = roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()),Arrays.asList(vo.getOrgId()));
            if(!response.isSuccess()){
                return false;
            }
            sender = response.getData().stream().map(RoleUserRelationVO:: getUserId).map(String::valueOf).collect(Collectors.toList());
        }

        if(CollectionUtils.isNotEmpty(sender)){
            String formurl = baseHost+"sdbj-zjkjprogress-frontend/#/projectLight";
            if(CollectionUtils.isNotEmpty(lightType)){
                Collections.reverse(lightType);
                formurl = formurl + "?lightType=" + StringUtils.join(lightType, ",");
            }
            String mobileUrl = baseHost+"sdbj-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = url.toString() + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            feignUtil.sendMsg(messageType, sender, "notice", subject, content, mobileUrl, formurl);
        }
        return true;
    }

    /**
     * 解析里程碑节点报警推送设置
     * @param vo
     * @return
     */
    private boolean analysisContractWarn(LevelReceiveVO vo) {
        // 信息发送类型
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("dingding");

        int sum = vo.getContractVioletIds().size();
        if(sum < 1) {
            return true;
        }

        StringBuffer str = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
        str.append("截止至" + sdf.format(new Date()) + "，共有"+sum+"个项目里程碑节点存在报警状态：");
        str.append("本周期新增里程碑节点报警状态的项目" + vo.getContractVioletIds().size() + "个；");

        List<String> sender = new ArrayList<>();
        if(vo.getReceiveType().equals("user")){
            sender = Arrays.asList(String.valueOf(vo.getReceiveId()));
        }
        if(vo.getReceiveType().equals("role")){
            CommonResponse<List<RoleUserRelationVO>> response = roleApi.getRoleUser(Arrays.asList(vo.getReceiveId()),Arrays.asList(vo.getOrgId()));
            if(!response.isSuccess()){
                return false;
            }
            sender = response.getData().stream().map(RoleUserRelationVO:: getUserId).map(String::valueOf).collect(Collectors.toList());
        }

        if(CollectionUtils.isNotEmpty(sender)){
            String formurl = baseHost+"ejc-zjkjprogress-frontend/#/projectLight";
            String mobileUrl = baseHost+"ejc-zjkjprogress-mobile/#/orgBillboard?userid={userid}";
            String subject = str.toString();
            String content = subject + "<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            feignUtil.sendMsg(messageType, sender, "notice", subject, null, mobileUrl, formurl);
        }
        return true;
    }

    @Override
    public CommonResponse<WarnProjectVO> queryProject(Long orgId) {

        WarnProjectVO warnVO = new WarnProjectVO();

        // 项目
        CommonResponse<ProjectVO> resp = projectApi.queryProjectByProjectDepartmentId(orgId);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        ProjectVO project = resp.getData();
        if(project == null){
            return CommonResponse.success("项目为空！", warnVO);
        }
        // 联系电话
        EmployeeVO employee = null;
        if(project != null && project.getLeader() != null) {
            Long userId = project.getLeader();
            //userId = userId.equals(1247777316689256450L) ? 303581417601122400L : userId;
            CommonResponse<EmployeeVO> userResp = employeeApi.queryEmployeByUserId(userId);
            if(!userResp.isSuccess()){
                throw new BusinessException(userResp.getMsg());
            }
            if(userResp.getData() != null){
                employee = userResp.getData();
            }
        }
        warnVO.setProjectId(project.getId());
        warnVO.setProjectName(project.getProjectName());
        warnVO.setOrgId(project.getProjectDepartmentId());
        warnVO.setProjectStatus(project.getStatus());

        warnVO.setProjectName(project.getProjectName());

        if (null != employee){
            warnVO.setProjectManagerName(employee.getUserName());
            warnVO.setMobilePhone(employee.getMobilePhone());
        }

        // 查询项目完成时间预警
        LambdaQueryWrapper<ProjectLightEntity> projectQueryWrapper = new LambdaQueryWrapper<>();
        projectQueryWrapper.eq(ProjectLightEntity::getProjectId,project.getId());
        ProjectLightEntity projectLightEntity = projectLightService.getOne(projectQueryWrapper);

        // 当月进度预警
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(new Date()).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month = Integer.valueOf(split[1]);

        //获取某月的第一天
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(Calendar.YEAR,year);
        c1.set(Calendar.MONTH,Month-1);
        int firstDay = c1.getActualMinimum(Calendar.DAY_OF_MONTH);
        c1.set(Calendar.DAY_OF_MONTH,firstDay);
        Date monthFirstDate = c1.getTime();

        LambdaQueryWrapper<MonthLightEntity> monthQueryWrapper = new LambdaQueryWrapper<>();
        monthQueryWrapper.eq(MonthLightEntity::getProjectId,project.getId());
        monthQueryWrapper.eq(MonthLightEntity::getPlanMonth,monthFirstDate);
        MonthLightEntity monthLightEntity = monthLightService.getOne(monthQueryWrapper);

        ExecPlanVO execPlan = new ExecPlanVO();
        List<ExecPlanDetailVO> execPlanDetailList = new ArrayList<>();
        QueryWrapper<ExecPlanEntity> ew = new QueryWrapper<>();
        ew.eq("project_id", project.getId());
        ExecPlanEntity entity = execPlanService.getOne(ew);

        // 里程碑节点预警
       if (null != entity){
           QueryWrapper<ExecPlanDetailEntity> contractLight = new QueryWrapper<>();
           contractLight.eq("progress_id", entity.getId());
           contractLight.eq("node_level", PlanConstant.LEVEL_CONTRACT);
           contractLight.orderByAsc("tid");
           List<ExecPlanDetailEntity> detailList = execPlanDetailService.list(contractLight);
           if (CollectionUtils.isNotEmpty(detailList)){
               for(ExecPlanDetailEntity detail : detailList) {
                   ExecPlanDetailVO execPlanDetailVO = ExecPlanDetailEntity.convertEntityToVo(detail);
                   Integer status = null;
                   if (null == execPlanDetailVO.getActualStart() && null == execPlanDetailVO.getActualFinish()){
                       status = FillConstant.NOT_STAR;
                   }
                   if (null != execPlanDetailVO.getActualStart() && null != execPlanDetailVO.getPredictFinish() && null == execPlanDetailVO.getActualFinish()){
                       status = FillConstant.UNDERWAY;
                   }
                   if (null != execPlanDetailVO.getActualStart() && null != execPlanDetailVO.getActualFinish()){
                       status = FillConstant.FINISHED;
                   }
                   execPlanDetailVO.setFinishState(status);
                   execPlanDetailVO.setChildren(null);
                   execPlanDetailList.add(execPlanDetailVO);
               }
           }
       }

        /*LambdaQueryWrapper<ContractLightEntity> contractQueryWrapper = new LambdaQueryWrapper<>();
        contractQueryWrapper.eq(ContractLightEntity::getProjectId,project.getId());
        List<ContractLightEntity> contractLightList = contractLightService.list(contractQueryWrapper);
        List<ContractLightVO> contractLightVOS = BeanMapper.mapList(contractLightList, ContractLightVO.class);*/

        // 获取执行计划中的总计划
        if (null != entity){
            execPlan = execPlanService.queryDetail(entity.getId());
        }

        if (null != projectLightEntity){
            warnVO.setProjectDays(projectLightEntity.getDiffValue());
            warnVO.setProjectLight(projectLightEntity.getLightType() != null ? projectLightEntity.getLightType() : LightTypeEnum.绿灯.getCode());
        }

        if (null != monthLightEntity){
            warnVO.setMonthDays(monthLightEntity.getDiffValue());
            warnVO.setMonthLight(monthLightEntity.getLightType());
        }

        LambdaQueryWrapper<MonthPlanEntity> monthPlanQueryWrapper = new LambdaQueryWrapper<>();
        monthPlanQueryWrapper.eq(MonthPlanEntity::getProjectId,project.getId());
        monthPlanQueryWrapper.eq(MonthPlanEntity::getPlanMonth,monthFirstDate);
        MonthPlanEntity one = monthPlanService.getOne(monthPlanQueryWrapper);
        if (null != one){
            warnVO.setIsMonthPlan(PlanConstant.INTEGER_YES);
        }


        warnVO.setPlanId(execPlan.getId());
        warnVO.setContractLightList(execPlanDetailList);
        warnVO.setExecPlan(execPlan);

        return CommonResponse.success("执行成功！", warnVO);
    }

}
