package com.ejianc.business.fill.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.fill.bean.WeekFillDetailEntity;
import com.ejianc.business.fill.bean.WeekFillEntity;
import com.ejianc.business.fill.service.IWeekFillDetailService;
import com.ejianc.business.fill.vo.WeekFillDetailVO;
import com.ejianc.business.fill.vo.WeekFillVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.fill.mapper.WeekFillMapper;
import com.ejianc.business.fill.service.IWeekFillService;

import java.util.ArrayList;
import java.util.List;

/**
 * 周进度计划填报
 * 
 * @author generator
 * 
 */
@Service("weekFillService")
public class WeekFillServiceImpl extends BaseServiceImpl<WeekFillMapper, WeekFillEntity> implements IWeekFillService{
    @Autowired
    private IWeekFillDetailService detailService;
    
    @Override
    public WeekFillVO queryDetail(Long id) {
        WeekFillEntity entity = baseMapper.selectById(id);
        //查询子表
        QueryWrapper<WeekFillDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", id);
        ew.orderByAsc("tid");
        List<WeekFillDetailEntity> detailList = detailService.list(ew);
        WeekFillVO vo = BeanMapper.map(entity, WeekFillVO.class);
        if(CollectionUtils.isNotEmpty(detailList)) {
            List<WeekFillDetailVO> detailVOList = new ArrayList<>();
            for(WeekFillDetailEntity detail : detailList) {
                detailVOList.add(WeekFillDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return vo;
    }
}
