package com.ejianc.business.plan.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.business.plan.vo.*;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.dozer.DozerBeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.plan.bean.YearPlanEntity;
import redis.clients.jedis.Jedis;

/**
 * 年计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("yearPlan")
public class YearPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IYearPlanService service;
    @Autowired
    private IYearPlanDetailService detailService;

    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private ITotalPlanService totalPlanService;



    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YearPlanVO> saveOrUpdate(@RequestBody YearPlanVO saveOrUpdateVO) {
        // 日历的例外日期普加加载后有问题
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getCalendars())){
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        YearPlanVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YearPlanVO> queryDetail(Long id) {
        YearPlanVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YearPlanVO> vos) {
        // todo 判断下级引用
        List<Long> ids = vos.stream().map(YearPlanVO::getId).collect(Collectors.toList());
        service.removeByIds(ids,true);
        detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<YearPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<YearPlanEntity> page = service.queryPage(param,false);
        IPage<YearPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<YearPlanVO> yearPlanVOS = BeanMapper.mapList(page.getRecords(), YearPlanVO.class);
        yearPlanVOS.stream().forEach(vo -> {
            vo.setChangeStatusName(PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
            vo.setChangeVersionName("第" + NumberUtil.int2chineseNum(vo.getChangeVersion()) + "版");
        });
        pageData.setRecords(yearPlanVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<YearPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("YearPlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refYearPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<YearPlanVO>> refYearPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<YearPlanEntity> page = service.queryPage(param,false);
        IPage<YearPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), YearPlanVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @RequestMapping(value = "/getxml", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return service.getxml(request);
    }

    @RequestMapping(value = "/exportxml", method = RequestMethod.POST)
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        service.exportxml(response, vo);
    }

    @RequestMapping(value = "/generateYearPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YearPlanVO> generateYearPlan(@RequestParam("projectId") Long projectId,@RequestParam("planYear") Integer planYear,
            @RequestParam(value = "id",required = false) Long id, @RequestParam(value = "changeFlag",required = false) Boolean changeFlag,
            @RequestParam(value = "sourceId",required = false) Long sourceId){

        if(BooleanUtils.isNotTrue(changeFlag)){
            YearPlanVO yearPlanVO = new YearPlanVO();
            yearPlanVO.setProjectId(projectId);
            yearPlanVO.setPlanYear(planYear);
            yearPlanVO.setId(id);
            service.validateYearPlan(yearPlanVO);
        }


        //获取某年的第一天
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(Calendar.YEAR,planYear);
        Date yearFirstDate = c1.getTime();

        //获取某年的最后一天
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(Calendar.YEAR,planYear);
        c2.roll(Calendar.DAY_OF_YEAR,-1);
        Date yearLastDate = c2.getTime();

        Integer planState = BooleanUtils.isTrue(changeFlag) ? PlanConstant.YEAR_PLAN : PlanConstant.TOTAL_PLAN;
        ExecPlanVO execPlanVO = execPlanService.queryRefDetail(projectId, planState, yearFirstDate, yearLastDate, changeFlag, true);
        List<ExecPlanDetailVO> execlDetailList = execPlanVO.getProgressDetailList();
        List<ExecPlanDetailVO> allExeclDetailList = execPlanVO.getAllList();

        if (CollectionUtils.isEmpty(execlDetailList)){
            throw new BusinessException("该项目的总计划在"+planYear+"年没有计划详情！");
        }

        execPlanVO.setProgressDetailList(null);
        YearPlanVO planVO = new YearPlanVO();
        BeanUtils.copyProperties(execPlanVO, planVO);

        List<ExecPlanDetailVO> progressDetailList = TreeHelper2.tree2List(execlDetailList);
        List<YearPlanDetailVO> list = new ArrayList<>();
        for (ExecPlanDetailVO vo : progressDetailList){
            if(PlanConstant.YEAR_PLAN.equals(vo.getPlanState())){// 原计划新增
                if(vo.getSourceId().equals(sourceId)){
                    vo.setPlanState(null);
                }
            }
            if (StringUtils.isNotBlank(vo.getPercentTask())){
                vo.setName(vo.getName()+vo.getPercentTask());
            }
            YearPlanDetailVO monthPlanDetailVO = new YearPlanDetailVO();
            BeanUtils.copyProperties(vo, monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            list.add(monthPlanDetailVO);
        }
        List<ExecPlanDetailVO> allProgressDetailList = TreeHelper2.tree2List(allExeclDetailList);
        List<YearPlanDetailVO> allList = new ArrayList<>();
        for (ExecPlanDetailVO vo : allProgressDetailList){
            if(PlanConstant.YEAR_PLAN.equals(vo.getPlanState())){// 原计划新增
                if(vo.getSourceId().equals(sourceId)){
                    vo.setPlanState(null);
                }
            }
            if (StringUtils.isNotBlank(vo.getPercentTask())){
                vo.setName(vo.getName()+vo.getPercentTask());
            }
            YearPlanDetailVO monthPlanDetailVO = new YearPlanDetailVO();
            BeanUtils.copyProperties(vo, monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            allList.add(monthPlanDetailVO);
        }
        List<YearPlanDetailVO> yearPlanTree = TreeHelper2.list2Tree(list);
        List<YearPlanDetailVO> allYearPlanTree = TreeHelper2.list2Tree(allList);

        planVO.setProgressDetailList(yearPlanTree);
        planVO.setAllList(allYearPlanTree);

        planVO.setSourceId(execPlanVO.getId());
        return CommonResponse.success(planVO);

    }


}
