package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fill.bean.MonthLightEntity;
import com.ejianc.business.fill.service.IMonthLightService;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service("monthPlan") 
public class MonthPlanBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IMonthPlanService monthPlanService;
	@Autowired
	private IMonthPlanDetailService monthPlanDetailService;
	@Autowired
	private IExecPlanService execPlanService;
	@Autowired
	private IWeekPlanService weekPlanService;
	@Autowired
	private IMonthLightService monthLightService;
	@Autowired
	private CommonHelper commonHelper;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//校验关联负责人
		List<MonthPlanDetailEntity> detailList = monthPlanDetailService.list(new QueryWrapper<MonthPlanDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);

		LambdaUpdateWrapper<MonthPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(MonthPlanEntity::getCommitTime, new Date());
		lambd.eq(MonthPlanEntity::getId, billId);
		monthPlanService.update(lambd);
		return CommonResponse.success();
	}

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//校验关联负责人
		List<MonthPlanDetailEntity> detailList = monthPlanDetailService.list(new QueryWrapper<MonthPlanDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);
		if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state){
			LambdaUpdateWrapper<MonthPlanEntity> lambd = new LambdaUpdateWrapper<>();
			lambd.set(MonthPlanEntity::getCommitTime, new Date());
			lambd.eq(MonthPlanEntity::getId, billId);
			monthPlanService.update(lambd);
		}

		MonthPlanEntity planEntity = monthPlanService.selectById(billId);
		LambdaUpdateWrapper<MonthPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(MonthPlanEntity::getApprovedTime, new Date());
		if (planEntity.getStartDate() != null) {
			Integer subDay = DateUtil.getSubDay(new Date(), planEntity.getPlanBeginDate());
//			Integer finishFlag = subDay - 9;
			lambd.set(MonthPlanEntity::getFinishFlag, subDay);
		}
		if (state == 1) {
			lambd.set(MonthPlanEntity::getCommitTime, new Date());
		}
		lambd.eq(MonthPlanEntity::getId, billId);
		monthPlanService.update(lambd);
		execPlanService.pushExecPlan(billId, PlanConstant.MONTH_PLAN);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// todo 校验，是否有下游单据
		MonthPlanEntity planEntity = monthPlanService.selectById(billId);
		if (planEntity.getChangeStatus() != PlanConstant.CHANGE_NO) {
			return CommonResponse.error("计划存在变更单，暂不支持回退功能!");
		}

		execPlanService.validateProject(planEntity.getProjectId(),planEntity.getId());

		LambdaQueryWrapper<WeekPlanEntity> weekQueryWrapper = new LambdaQueryWrapper<>();
		weekQueryWrapper.eq(WeekPlanEntity::getProjectId,planEntity.getProjectId());
		weekQueryWrapper.eq(WeekPlanEntity::getPlanMonth,planEntity.getPlanMonth());
		weekQueryWrapper.eq(WeekPlanEntity::getDr,0);
		List<WeekPlanEntity> monthList = weekPlanService.list(weekQueryWrapper);
		if (CollectionUtils.isNotEmpty(monthList)){
			return CommonResponse.error("此月计划存在周计划，暂不支持回退功能!");
		}

		// 删除月计划完成时间亮灯状态中的数据
		monthLightService.remove(new QueryWrapper<MonthLightEntity>().eq("month_plan_id",billId));

		LambdaUpdateWrapper<MonthPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(MonthPlanEntity::getCommitTime, null);
		lambd.set(MonthPlanEntity::getApprovedTime, null);
		lambd.set(MonthPlanEntity::getFinishFlag, null);
		lambd.eq(MonthPlanEntity::getId, billId);
		monthPlanService.update(lambd);
		execPlanService.pushExecPlanRollBack(billId, PlanConstant.MONTH_PLAN);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
