package com.ejianc.business.progress.bean;

import java.util.Date;

import com.ejianc.business.progress.vo.ProgressDetailVO;
import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

@TableName("ejc_mdm_progress_detail")
public class ProgressDetailEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField(value = "progress_id")
	private Long progressId;

	@TableField(value = "parent_id")
	private Long parentId; // 父任务UID（体现树形结构）

	@TableField(value = "tid")
	private Integer tid;// 序号

	@TableField(value = "code")
	private String code;// 编码

	@TableField(value = "struct_code")
	private String structCode;// 编码

	@TableField(value = "name")
	private String name;// 任务名称

	@TableField(value = "start")
	private Date start;// 开始日期

	@TableField(value = "finish")
	private Date finish;// 完成日期

	@TableField(value = "duration")
	private Integer duration;// 工期

	@TableField(value = "work")
	private Integer work;// 工时

	@TableField(value = "percent_complete")
	private Integer percentComplete; // 完成百分比

	@TableField(value = "manual")
	private Integer manual; // 任务模式， 0：自动 ， 1： 手动

	@TableField(value = "weight")
	private Integer weight; // 权重

	@TableField(value = "constraint_type")
	private Integer constraintType; // 任务限制类型。

	@TableField(value = "constraint_date")
	private Date constraintDate; // 任务限制日期

	@TableField(value = "milestone")
	private Integer milestone;// 里程碑

	@TableField(value = "summary")
	private Integer summary; // 摘要任务

	@TableField(value = "critical")
	private Integer critical; // 关键任务

	@TableField(value = "priority")
	private Integer priority; // 重要级别

	@TableField(value = "notes")
	private String notes; // 备注

	@TableField(value = "department")
	private String department; // 所属部门。如"1"。

	@TableField(value = "principal")
	private String principal; // 任务负责人。如"101,220,201"。

	@TableField(value = "predecessor_link")
	private String predecessorLink; // 前置任务（JSON字符串）。如"[{PredecessorUID: 2,Type:
									// 1,LinkLag: 0}, ...]"

	@TableField(value = "fixed_date")
	private Integer fixedDate;// 限制日期（摘要任务专用）

	@TableField(value = "project_id")
	private Long projectId; // 项目ID

	@TableField(value = "actual_start")
	private Date actualStart; // 实际开始时间

	@TableField(value = "actual_finish")
	private Date actualFinish; // 实际完成时间

	@TableField(value = "actual_duration")
	private Integer actualDuration; // 实际工期

	@TableField(value = "assignments")
	private String assignments; //

	@TableField(value = "wbs")
	private String wbs; // wbs

	@TableField(value = "outline_level")
	private Integer outlineLevel;

	@TableField(value = "outline_number")
	private String outlineNumber;

	public Long getProgressId() {
		return progressId;
	}

	public void setProgressId(Long progressId) {
		this.progressId = progressId;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Integer getTid() {
		return tid;
	}

	public void setTid(Integer tid) {
		this.tid = tid;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getStructCode() {
		return structCode;
	}

	public void setStructCode(String structCode) {
		this.structCode = structCode;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getStart() {
		return start;
	}

	public void setStart(Date start) {
		this.start = start;
	}

	public Date getFinish() {
		return finish;
	}

	public void setFinish(Date finish) {
		this.finish = finish;
	}

	public Integer getDuration() {
		return duration;
	}

	public void setDuration(Integer duration) {
		this.duration = duration;
	}

	public Integer getWork() {
		return work;
	}

	public void setWork(Integer work) {
		this.work = work;
	}

	public Integer getPercentComplete() {
		return percentComplete;
	}

	public void setPercentComplete(Integer percentComplete) {
		this.percentComplete = percentComplete;
	}

	public Integer getManual() {
		return manual;
	}

	public void setManual(Integer manual) {
		this.manual = manual;
	}

	public Integer getWeight() {
		return weight;
	}

	public void setWeight(Integer weight) {
		this.weight = weight;
	}

	public Integer getConstraintType() {
		return constraintType;
	}

	public void setConstraintType(Integer constraintType) {
		this.constraintType = constraintType;
	}

	public Date getConstraintDate() {
		return constraintDate;
	}

	public void setConstraintDate(Date constraintDate) {
		this.constraintDate = constraintDate;
	}

	public Integer getMilestone() {
		return milestone;
	}

	public void setMilestone(Integer milestone) {
		this.milestone = milestone;
	}

	public Integer getSummary() {
		return summary;
	}

	public void setSummary(Integer summary) {
		this.summary = summary;
	}

	public Integer getCritical() {
		return critical;
	}

	public void setCritical(Integer critical) {
		this.critical = critical;
	}

	public Integer getPriority() {
		return priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public String getDepartment() {
		return department;
	}

	public void setDepartment(String department) {
		this.department = department;
	}

	public String getPrincipal() {
		return principal;
	}

	public void setPrincipal(String principal) {
		this.principal = principal;
	}

	public String getPredecessorLink() {
		return predecessorLink;
	}

	public void setPredecessorLink(String predecessorLink) {
		this.predecessorLink = predecessorLink;
	}

	public Integer getFixedDate() {
		return fixedDate;
	}

	public void setFixedDate(Integer fixedDate) {
		this.fixedDate = fixedDate;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public Date getActualStart() {
		return actualStart;
	}

	public void setActualStart(Date actualStart) {
		this.actualStart = actualStart;
	}

	public Date getActualFinish() {
		return actualFinish;
	}

	public void setActualFinish(Date actualFinish) {
		this.actualFinish = actualFinish;
	}

	public Integer getActualDuration() {
		return actualDuration;
	}

	public void setActualDuration(Integer actualDuration) {
		this.actualDuration = actualDuration;
	}

	public String getAssignments() {
		return assignments;
	}

	public void setAssignments(String assignments) {
		this.assignments = assignments;
	}

	public String getWbs() {
		return wbs;
	}

	public void setWbs(String wbs) {
		this.wbs = wbs;
	}

	public Integer getOutlineLevel() {
		return outlineLevel;
	}

	public void setOutlineLevel(Integer outlineLevel) {
		this.outlineLevel = outlineLevel;
	}

	public String getOutlineNumber() {
		return outlineNumber;
	}

	public void setOutlineNumber(String outlineNumber) {
		this.outlineNumber = outlineNumber;
	}

	/**
	 * entity to vo
	 */
	public static ProgressDetailVO convertEntityToVo(ProgressDetailEntity entity) {
		ProgressDetailVO progressDetailVo = new ProgressDetailVO();
		progressDetailVo.setUid(entity.getId().toString());
		progressDetailVo.setManual(entity.getManual());
		progressDetailVo.setActualDuration(entity.getActualDuration());
		progressDetailVo.setDuration(entity.getDuration());
		progressDetailVo.setPercentComplete(entity.getPercentComplete());
		progressDetailVo.setDepartment(entity.getDepartment());
		progressDetailVo.setProjectUID(entity.getProjectId());
		progressDetailVo.setMilestone(entity.getMilestone());
		progressDetailVo.setFinish(entity.getFinish());
		progressDetailVo.setConstraintType(entity.getConstraintType());
		progressDetailVo.setPrincipal(entity.getPrincipal());
		progressDetailVo.setParentTaskUID(entity.getParentId() + "");
		progressDetailVo.setWbs(entity.getWbs());
		if (StringUtils.isNotBlank(entity.getAssignments())) {
			progressDetailVo.setAssignments(JSON.parseArray(entity.getAssignments()));
		}
		progressDetailVo.setStart(entity.getStart());
		progressDetailVo.setOutlineLevel(entity.getOutlineLevel());
		progressDetailVo.setOutlineNumber(entity.getOutlineNumber());
		progressDetailVo.setCritical(entity.getCritical());
		progressDetailVo.setNote(entity.getNotes());
		progressDetailVo.setSummary(entity.getSummary());
		progressDetailVo.setActualFinish(entity.getActualFinish());
		progressDetailVo.setName(entity.getName());
		progressDetailVo.setId(entity.getTid());
		progressDetailVo.setCode(entity.getCode());
		progressDetailVo.setStructCode(entity.getStructCode());
		progressDetailVo.setWeight(entity.getWeight());
		progressDetailVo.setFixedDate(entity.getFixedDate());
		progressDetailVo.setWork(entity.getWork());
		progressDetailVo.setConstraintDate(entity.getConstraintDate());
		if(StringUtils.isNotBlank(entity.getPredecessorLink())) {
			progressDetailVo.setPredecessorLink(JSON.parseArray(entity.getPredecessorLink()));
		}
		progressDetailVo.setPriority(entity.getPriority());
		progressDetailVo.setActualStart(entity.getActualStart());
		
		return progressDetailVo;
	}

	/**
	 * vo to entity
	 */
	public static ProgressDetailEntity convertVoToEntity(ProgressDetailVO vo) {
		ProgressDetailEntity progressDetailEntity = new ProgressDetailEntity();
		if(StringUtils.isNotBlank(vo.getUid())) {
			progressDetailEntity.setId(Long.parseLong(vo.getUid()));
		}
		progressDetailEntity.setManual(vo.getManual());
		progressDetailEntity.setActualDuration(vo.getActualDuration());
		progressDetailEntity.setDuration(vo.getDuration());
		progressDetailEntity.setPercentComplete(vo.getPercentComplete());
		progressDetailEntity.setDepartment(vo.getDepartment());
		progressDetailEntity.setProjectId(vo.getProjectUID());
		progressDetailEntity.setMilestone(vo.getMilestone());
		progressDetailEntity.setFinish(vo.getFinish());
		progressDetailEntity.setConstraintType(vo.getConstraintType());
		progressDetailEntity.setPrincipal(vo.getPrincipal());
		if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
			progressDetailEntity.setParentId(Long.parseLong(vo.getParentTaskUID()));
		}
		progressDetailEntity.setWbs(vo.getWbs());
		if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
			progressDetailEntity.setAssignments(JSON.toJSONString(vo.getAssignments()));
		}
		progressDetailEntity.setStart(vo.getStart());
		progressDetailEntity.setOutlineLevel(vo.getOutlineLevel());
		progressDetailEntity.setOutlineNumber(vo.getOutlineNumber());
		progressDetailEntity.setCritical(vo.getCritical());
		progressDetailEntity.setNotes(vo.getNote());
		progressDetailEntity.setSummary(vo.getSummary());
		progressDetailEntity.setActualFinish(vo.getActualFinish());
		progressDetailEntity.setName(vo.getName());
		progressDetailEntity.setTid(vo.getId());
		progressDetailEntity.setCode(vo.getCode());
		progressDetailEntity.setStructCode(vo.getStructCode());
		progressDetailEntity.setWeight(vo.getWeight());
		progressDetailEntity.setFixedDate(vo.getFixedDate());
		progressDetailEntity.setWork(vo.getWork());
		progressDetailEntity.setConstraintDate(vo.getConstraintDate());
		if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
			progressDetailEntity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
		}
		progressDetailEntity.setPriority(vo.getPriority());
		progressDetailEntity.setActualStart(vo.getActualStart());
		
		return progressDetailEntity;
	}
}
