package com.ejianc.business.progress.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.progress.bean.DocEntity;
import com.ejianc.business.progress.service.IDocService;
import com.ejianc.business.progress.service.INodeArchivesService;
import com.ejianc.business.progress.utils.TreeNodeBUtil;
import com.ejianc.business.progress.vo.DocVO;
import com.ejianc.business.progress.vo.comparator.DocComparatorVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 节点档案
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("doc")
public class DocController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IDocService service; 

    @Autowired
    private INodeArchivesService archivesService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DocVO> saveOrUpdate(@RequestBody DocVO saveorUpdateVO) {
    	return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DocVO> queryDetail(Long id) {
    	DocEntity entity = service.selectById(id);
    	DocVO vo = BeanMapper.map(entity, DocVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isEmpty(ids)) {
            return CommonResponse.success("删除失败：主键为空！");
        } else {
            service.removeByIds(ids);
        }

        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DocVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        String nodeArchivesId = param.getParams().get("nodeArchivesId").getValue().toString();
        if (StringUtils.isBlank(nodeArchivesId)) {
            IPage<DocVO> pageData = new Page<>(1, 10, 0);
            pageData.setRecords(new ArrayList<>());
            return CommonResponse.success("查询列表数据成功！", pageData);
        } else {
            List<Long> ids = archivesService.getChildIds(Long.parseLong(nodeArchivesId));
            param.getParams().put("nodeArchivesId", new Parameter(QueryParam.IN, ids));
            IPage<DocEntity> page = service.queryPage(param, false);
            IPage<DocVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<DocVO> docVOList = BeanMapper.mapList(page.getRecords(), DocVO.class);

            Collections.sort(docVOList, new DocComparatorVo());
            pageData.setRecords(TreeNodeBUtil.buildTree(docVOList));
            return CommonResponse.success("查询列表数据成功！", pageData);
        }
    }

    /**
     * 表格导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelCategory(HttpServletRequest request, @RequestBody List<DocVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error("导入的数据为空！");
        }
        String nodeArchivesId = request.getParameter("nodeArchivesId");
        List<DocEntity> list = new ArrayList<>();
        importVOS.forEach(importVO -> {
            importVO.setNodeArchivesId(Long.valueOf(nodeArchivesId));
            String tPid = importVO.getTpid();
            if (StringUtils.isNotBlank(tPid)) {
                importVO.setParentId(Long.valueOf(tPid));
            }
            list.add(BeanMapper.map(importVO, DocEntity.class));
        });
        service.insertBatch(list);
        return CommonResponse.success("保存成功！");
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "node-doc-import.xlsx", "节点档案导入模板");
    }

    /**
     * 表格导出
     * @param param
     * @param response
     */
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        service.excelExport(param,response);
    }


}
