package com.ejianc.business.progress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.progress.bean.RiskCorrectionDetailEntity;
import com.ejianc.business.progress.bean.RiskCorrectionDrawHistoryEntity;
import com.ejianc.business.progress.bean.RiskCorrectionEntity;
import com.ejianc.business.progress.bean.RiskCorrectionHistoryEntity;
import com.ejianc.business.progress.enums.HandleStatusEnum;
import com.ejianc.business.progress.enums.RiskStateEnum;
import com.ejianc.business.progress.mapper.RiskCorrectionMapper;
import com.ejianc.business.progress.service.*;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.business.progress.vo.RiskCorrectionDetailVO;
import com.ejianc.business.progress.vo.RiskCorrectionDrawHistoryVO;
import com.ejianc.business.progress.vo.RiskCorrectionHistoryVO;
import com.ejianc.business.progress.vo.RiskCorrectionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 风险纠偏
 *
 * @author generator
 */
@Service("riskCorrectionService")
public class RiskCorrectionServiceImpl extends BaseServiceImpl<RiskCorrectionMapper, RiskCorrectionEntity> implements IRiskCorrectionService {
    private static final String RISK_CODE = "RISK_ZJKJ_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IRiskCorrectionHistoryService historyService;

    @Autowired
    private RiskCorrectionBpmServiceImpl bpmService;

    @Autowired
    private IRiskCorrectionDrawHistoryService drawHistoryService;

    @Autowired
    private IRiskMessageService messageService;

    @Autowired
    private IRiskCorrectionDetailService detailService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OrgUtil orgUtil;

    @Override
    public CommonResponse<RiskCorrectionVO> saveOrUpdate(RiskCorrectionVO saveorUpdateVO) {
        String operateType = null;
        RiskCorrectionEntity entity = new RiskCorrectionEntity();

        if (saveorUpdateVO.getId() == null || saveorUpdateVO.getId() <= 0) {
            // 新增
            LambdaQueryWrapper<RiskCorrectionEntity> lambda = Wrappers.<RiskCorrectionEntity>lambdaQuery();
            lambda.eq(RiskCorrectionEntity::getYearBid, saveorUpdateVO.getYearBid());
            lambda.eq(RiskCorrectionEntity::getDr, 0);
            lambda.notIn(RiskCorrectionEntity::getBillState, 1, 3);
            List<RiskCorrectionEntity> list = super.list(lambda);
            if (list.size() > 0) {
                throw new BusinessException("该节点存在其他未生效单据，不允许保存!");
            }
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RISK_CODE, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            // 查询区域公司
            OrgVO orgVO = orgUtil.findById(saveorUpdateVO.getOrgId());
            saveorUpdateVO.setCorpId(orgVO.getId());
            saveorUpdateVO.setCorpCode(orgVO.getCode());
            saveorUpdateVO.setCorpName(orgVO.getName());
            saveorUpdateVO.setTopOrgId(orgVO.getId());
            saveorUpdateVO.setTopOrgName(orgVO.getName());
            entity = BeanMapper.map(saveorUpdateVO, RiskCorrectionEntity.class);
            operateType = "add";

        } else {
            LambdaQueryWrapper<RiskCorrectionEntity> lambda = Wrappers.<RiskCorrectionEntity>lambdaQuery();
            lambda.eq(RiskCorrectionEntity::getYearBid, saveorUpdateVO.getYearBid());
            lambda.eq(RiskCorrectionEntity::getDr, 0);
            lambda.ne(RiskCorrectionEntity::getId, saveorUpdateVO.getId());
            lambda.notIn(RiskCorrectionEntity::getBillState, 1, 3);
            List<RiskCorrectionEntity> list = super.list(lambda);
            if (list.size() > 0) {
                throw new BusinessException("该节点存在其他未生效单据，不允许保存!");
            }

            RiskCorrectionEntity oldEntity = this.selectById(saveorUpdateVO.getId());
            String handleStatus = oldEntity.getHandleStatus();

            if (Objects.equals(HandleStatusEnum.已完成.getCode(), handleStatus)) {
                if (oldEntity.getFinishTime() == null) {
                    oldEntity.setFinishTime(new Date());
                }
            }else {
                if (!Objects.equals(HandleStatusEnum.纠偏中.getCode(), handleStatus)) {
                    List<RiskCorrectionDetailEntity> oldDetailList = oldEntity.getDetailList();
                    List<RiskCorrectionDetailVO> detailList = saveorUpdateVO.getDetailList();
                    if (CollectionUtil.isEmpty(oldDetailList) && CollectionUtil.isNotEmpty(detailList)) {
                        // 纠偏单处理状态为纠偏中
                        oldEntity.setHandleStatus(HandleStatusEnum.纠偏中.getCode());
                    }
                }
            }

            // 设置可能修改的值(纠偏单和纠偏待办)
            oldEntity.setCorrectionType(saveorUpdateVO.getCorrectionType());
            oldEntity.setCorrectionDate(saveorUpdateVO.getCorrectionDate());
            oldEntity.setYearBid(saveorUpdateVO.getYearBid());
            oldEntity.setYearBname(saveorUpdateVO.getYearBname());
            oldEntity.setNodeLevel(saveorUpdateVO.getNodeLevel());
            oldEntity.setEmployeeId(saveorUpdateVO.getEmployeeId());
            oldEntity.setEmployeeName(saveorUpdateVO.getEmployeeName());
            oldEntity.setDiffValue(saveorUpdateVO.getDiffValue());
            oldEntity.setLagReasons(saveorUpdateVO.getLagReasons());
            oldEntity.setSupplement(saveorUpdateVO.getSupplement());
            oldEntity.setLagReasonId(saveorUpdateVO.getLagReasonId());
            if (Objects.equals(HandleStatusEnum.已完成.getCode(), saveorUpdateVO.getHandleStatus())) {
                oldEntity.setHandleStatus(HandleStatusEnum.已完成.getCode());
                oldEntity.setFinishUserId(saveorUpdateVO.getFinishUserId());
                oldEntity.setFinishUserName(saveorUpdateVO.getFinishUserName());
                oldEntity.setFinishTime(saveorUpdateVO.getFinishTime());
            }

            entity = BeanMapper.map(oldEntity, RiskCorrectionEntity.class);
            operateType = "edit";
        }

        // 保存主表
        super.saveOrUpdate(entity);

        List<RiskCorrectionDetailVO> detailList = saveorUpdateVO.getDetailList();
        List<RiskCorrectionDetailVO> newDetailList = new ArrayList<>();
        List<Long> deleteIds = new ArrayList<>();
        for (RiskCorrectionDetailVO vo : detailList) {
            if (Objects.equals("del", vo.getRowState())) {
                deleteIds.add(vo.getId());
            }
            if (Objects.equals("add", vo.getRowState())) {
                vo.setId(null);
                vo.setRiskId(entity.getId());
                vo.setCreateUserId(InvocationInfoProxy.getUserid());
                newDetailList.add(vo);
            }
            if (Objects.equals("edit", vo.getRowState())) {
                newDetailList.add(vo);
            }
        }

        List<RiskCorrectionDetailVO> minList = newDetailList.stream().filter(list -> !list.getHandleStatus().equals("2")).sorted(Comparator.comparing(RiskCorrectionDetailVO::getFinishTime)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(minList)) {
            RiskCorrectionDetailVO detailVO = minList.get(0);
            // 纠偏措施未完成最小时间
            entity.setMinTime(detailVO.getFinishTime());
        }

        if (CollectionUtil.isNotEmpty(newDetailList)) {
            detailService.saveOrUpdateBatch(BeanMapper.mapList(newDetailList, RiskCorrectionDetailEntity.class), newDetailList.size(), false);
        }
        if (CollectionUtil.isNotEmpty(deleteIds)) {
            detailService.removeByIds(deleteIds, false);
        }

        // 历史记录
        RiskCorrectionHistoryEntity historyEntity = new RiskCorrectionHistoryEntity();
        historyEntity.setRiskId(entity.getId());
        historyEntity.setUserId(InvocationInfoProxy.getUserid());
        historyEntity.setUserName(sessionManager.getUserContext().getUserName());
        if (operateType.equals("add")) {
            // 增加 创建 历史记录
            historyEntity.setRiskState(RiskStateEnum.CREATE.getCode());
        }
        if (operateType.equals("edit")) {
            if (CollectionUtil.isNotEmpty(newDetailList) || CollectionUtil.isNotEmpty(deleteIds)) {
                // 增加 保存 历史记录
                historyEntity.setRiskState(RiskStateEnum.SAVE.getCode());
            }
        }

        if (!Objects.equals(null, historyEntity.getRiskState())) {
            historyService.saveOrUpdate(historyEntity);
        }
        // 回写最近更新时间
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        this.saveOrUpdate(entity);

        RiskCorrectionVO vo = BeanMapper.map(entity, RiskCorrectionVO.class);
        return CommonResponse.success("保存或修改单据成功！", queryDetail(entity.getId()));
    }

    @Override
    public RiskCorrectionVO queryDetail(Long id) {
        RiskCorrectionEntity entity = this.selectById(id);
        List<RiskCorrectionDetailEntity> detailList = entity.getDetailList();

        if (ListUtil.isNotEmpty(detailList)) {
            int size = detailList.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < size; i++) {
                RiskCorrectionDetailEntity detailEntity = detailList.get(i);
                detailEntity.setRowState("edit");
                stringBuffer.append(i + 1).append("、").append(detailEntity.getRiskSetp()).append("；");
            }
            entity.setCorrectionMeasures(stringBuffer.toString());
        }

        RiskCorrectionVO vo = BeanMapper.map(entity, RiskCorrectionVO.class);
        // 纠偏历时
        if (!Objects.equals(vo.getStartTime(), null)) {
            if (vo.getHandleStatus().equals(HandleStatusEnum.已完成.getCode())) {
                vo.setTake(DateUtil.daysBetween(vo.getStartTime(),vo.getFinishTime()));
            }else {
                vo.setTake(DateUtil.daysBetween(vo.getStartTime(),new Date()));
            }
        }
        // 历史记录
        List<RiskCorrectionHistoryVO> historyList = historyService.queryList(id);
        vo.setHistoryList(historyList);

        return vo;
    }

    @Override
    public Map<Long, RiskCorrectionVO> getRisk(Long yearId) {
        List<RiskCorrectionVO> list = baseMapper.getRisk(yearId);
        Map<Long, RiskCorrectionVO> map = new HashMap<>();
        for (RiskCorrectionVO vo : list) {
            if (map.containsKey(vo.getYearBid())) {
                RiskCorrectionVO oldvo = map.get(vo.getYearBid());
                if (vo.getCorrectionDate().getTime() > oldvo.getCorrectionDate().getTime()) {
                    map.put(vo.getYearBid(), vo);
                }
            } else {
                map.put(vo.getYearBid(), vo);
            }

        }
        return map;
    }
    // 根据节点主键查纠偏
    @Override
    public Map<Long, RiskCorrectionVO> getRiskByYearBid(List<Long> yearBidList) {
        Map<Long, RiskCorrectionVO> map = new HashMap<>();
        if(yearBidList.size()>0){
            List<RiskCorrectionVO> list = baseMapper.getRiskByYearBid(yearBidList);
            for (RiskCorrectionVO vo : list) {
                if (map.containsKey(vo.getYearBid())) {
                    RiskCorrectionVO oldvo = map.get(vo.getYearBid());
                    if (vo.getCorrectionDate().getTime() > oldvo.getCorrectionDate().getTime()) {
                        map.put(vo.getYearBid(), vo);
                    }
                } else {
                    map.put(vo.getYearBid(), vo);
                }
            }
        }
        return map;
    }

    @Override
    public CommonResponse<JSONObject> queryRiskList(QueryParam param) {
        JSONObject resp = new JSONObject();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planYear");
        fuzzyFields.add("yearBname");
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getOrderMap().put("createTime", QueryParam.DESC);

        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<OrgVO> response = orgApi.getOneById(orgId);
        OrgVO orgVO = response.getData();
        Integer orgType = orgVO.getOrgType();
        if (orgType.equals(1)) {
            // 当上下文组织为工程局时，查询处置单位为【工程局处理】的纠偏
            param.getParams().put("correctionType", new Parameter(QueryParam.EQ, "2"));
        }else if (orgType.equals(2)) {
            // 当上下文组织为分子公司时，查询上下文组织本下的纠偏（用二级单位对比）、且处置单位为【二级单位处理】的纠偏
            param.getParams().put("topOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            param.getParams().put("correctionType", new Parameter(QueryParam.EQ, "1"));
        }else if (orgType.equals(3) || orgType.equals(5)) {
            // 当上下文组织为经理部或项目部时，查询上下文组织本下（用所属项目对比）、且处置单位为【项目自行处理】的纠偏
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            param.getParams().put("correctionType", new Parameter(QueryParam.EQ, "0"));
        }

        IPage<RiskCorrectionEntity> page = this.queryPage(param,false);
        IPage<RiskCorrectionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RiskCorrectionVO.class));

        List<RiskCorrectionVO> records = pageData.getRecords();
        for (RiskCorrectionVO vo : records) {
            if (vo.getMinTime() != null) {
                // 纠偏剩余时间/天
                vo.setSurplusDay(DateUtil2.getSubDay2(new Date(), vo.getMinTime()));
            }
        }

        resp.put("pages", pageData.getPages());
        resp.put("size", pageData.getSize());
        resp.put("current", pageData.getCurrent());
        resp.put("total", pageData.getTotal());
        resp.put("records", records);

        return CommonResponse.success(resp);
    }

    @Override
    public CommonResponse<String> drawTask(RiskCorrectionHistoryVO historyVO) {
        // 保存历史记录
        historyVO.setRiskState(RiskStateEnum.DRAW.getCode());
        RiskCorrectionHistoryEntity historyEntity = BeanMapper.map(historyVO, RiskCorrectionHistoryEntity.class);
        historyService.saveOrUpdate(historyEntity,false);
        CommonResponse<OrgVO> response = orgApi.getOneById(InvocationInfoProxy.getOrgId());
        OrgVO orgVO = response.getData();
        // 回写纠偏单
        RiskCorrectionEntity entity = this.getById(historyVO.getRiskId());
        entity.setCorrectionType(historyVO.getCorrectionType());
        entity.setLagReasons(historyVO.getLagReasons());
        entity.setDrawExplain(historyVO.getOperateDescribe());
        entity.setDrawUserId(historyVO.getUserId());
        entity.setDrawUserName(historyVO.getUserName());
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        entity.setDrawOrgId(orgVO.getId());
        entity.setDrawOrgName(orgVO.getName());
        this.saveOrUpdate(entity, false);
        // 回写提请记录
        RiskCorrectionDrawHistoryEntity drawHistoryEntity = BeanMapper.map(entity, RiskCorrectionDrawHistoryEntity.class);
        drawHistoryEntity.setId(null);
        drawHistoryEntity.setRiskId(entity.getId());
        drawHistoryService.saveOrUpdate(drawHistoryEntity);
        OrgVO orgVO1 = null;
        // 发送消息
        orgVO1 = orgUtil.findById(entity.getDrawOrgId());
        if (Objects.equals(orgVO1.getId(), null)) {
            messageService.riskByPushSet(entity, InvocationInfoProxy.getOrgId());
        }else {
            messageService.riskByPushSet(entity, orgVO1.getId());
        }
        return CommonResponse.success("提请成功");
    }

    @Override
    public CommonResponse<String> returnTask(RiskCorrectionHistoryVO historyVO) {
        // 保存历史记录
        historyVO.setRiskState(RiskStateEnum.RETURN.getCode());
        RiskCorrectionHistoryEntity historyEntity = BeanMapper.map(historyVO, RiskCorrectionHistoryEntity.class);
        historyService.saveOrUpdate(historyEntity,false);

        // 回写纠偏单
        RiskCorrectionEntity entity = this.getById(historyVO.getRiskId());
        entity.setCorrectionType(historyVO.getCorrectionType());
        entity.setLagReasons(historyVO.getLagReasons());
        entity.setReturnExplain(historyVO.getOperateDescribe());
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        this.saveOrUpdate(entity, false);

        return CommonResponse.success("退回成功");
    }

    @Override
    public CommonResponse<String> acceptTask(List<RiskCorrectionHistoryVO> historyVOs) {
        RiskCorrectionHistoryVO historyVO = historyVOs.get(0);

        // 保存历史记录
        historyVO.setRiskState(RiskStateEnum.ACCEPT.getCode());
        RiskCorrectionHistoryEntity historyEntity = BeanMapper.map(historyVO, RiskCorrectionHistoryEntity.class);
        historyService.saveOrUpdate(historyEntity,false);

        // 回写纠偏单
        RiskCorrectionEntity entity = this.getById(historyVO.getRiskId());
        entity.setAcceptUserId(historyVO.getUserId());
        entity.setAcceptUserName(historyVO.getUserName());
        entity.setMemo(historyVO.getOperateDescribe());
        // 修改处理状态为待纠偏
        entity.setHandleStatus(HandleStatusEnum.待纠偏.getCode());
        entity.setLastUpdateTime(historyEntity.getCreateTime());
        entity.setAcceptTime(historyEntity.getCreateTime());
        this.saveOrUpdate(entity, false);

        return CommonResponse.success("受理成功");
    }

    @Override
    public CommonResponse<String> progressTask(RiskCorrectionVO vo) {
        RiskCorrectionHistoryEntity historyEntity = new RiskCorrectionHistoryEntity();
        historyEntity.setRiskId(vo.getId());
        historyEntity.setUserId(vo.getFinishUserId());
        historyEntity.setUserName(vo.getFinishUserName());

        if (Objects.equals(HandleStatusEnum.已完成.getCode(), vo.getHandleStatus())) {
            List<RiskCorrectionDetailVO> detailList = vo.getDetailList();
            for (RiskCorrectionDetailVO detailVO : detailList) {
                detailVO.setHandleStatus("2");
            }
            // 增加 纠偏进度 已完成 历史记录
            historyEntity.setRiskState(RiskStateEnum.FINISH.getCode());
            vo.setFinishTime(new Date());
            // 发送消息
            messageService.riskFinish(vo.getId());
        }else {
            // 增加 纠偏进度 纠偏中 历史记录
            historyEntity.setRiskState(RiskStateEnum.RUNNING.getCode());
        }

        // 回写纠偏单
        this.saveOrUpdate(vo);
        // 保存历史记录
        historyService.saveOrUpdate(historyEntity, false);

        return CommonResponse.success("修改纠偏进度成功");
    }

    @Override
    public CommonResponse<JSONObject> queryDrawRisk(QueryParam param) {
        JSONObject resp = new JSONObject();

        long pageIndex = param.getPageIndex();
        long pageSize = param.getPageSize();
        param.setPageSize(-1);

        param.getParams().put("drawOrgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        param.getParams().remove("handleStatus");

        List<RiskCorrectionDrawHistoryEntity> list = drawHistoryService.queryList(param);
        Map<Long, List<RiskCorrectionDrawHistoryEntity>> map = list.stream().collect(Collectors.groupingBy(RiskCorrectionDrawHistoryEntity::getRiskId));
        List<RiskCorrectionDrawHistoryEntity> resultList = new ArrayList<>();
        for (Map.Entry<Long, List<RiskCorrectionDrawHistoryEntity>> entry : map.entrySet()) {
            List<RiskCorrectionDrawHistoryEntity> entityList = entry.getValue();
            List<RiskCorrectionDrawHistoryEntity> maxList = entityList.stream().sorted(Comparator.comparing(RiskCorrectionDrawHistoryEntity::getCreateTime)).collect(Collectors.toList());
            resultList.add(maxList.get(0));
        }

        List<RiskCorrectionDrawHistoryEntity> records = resultList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        long total = resultList.size();
        long pages = total / pageSize;
        if (total % pageSize != 0) {
            ++pages;
        }

        resp.put("pages", pages);
        resp.put("size", pageSize);
        resp.put("current", pageIndex);
        resp.put("total", total);
        resp.put("records", BeanMapper.mapList(records, RiskCorrectionDrawHistoryVO.class));

        return CommonResponse.success(resp);
    }

    @Override
    public CommonResponse<JSONObject> dataCount(Boolean dataCountFlag) {
        JSONObject resp = new JSONObject();
        JSONObject dataCount = new JSONObject();

        if (dataCountFlag) {
            // 查询 待受理 已受理 已完成 数量
            QueryParam param = new QueryParam();
            param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse<OrgVO> response = orgApi.getOneById(orgId);
            OrgVO orgVO = response.getData();
            Integer orgType = orgVO.getOrgType();
            if (orgType.equals(1)) {
                // 当上下文组织为工程局时，查询处置单位为【工程局处理】的纠偏
                param.getParams().put("correctionType", new Parameter(QueryParam.EQ, "2"));
            }else if (orgType.equals(2)) {
                // 当上下文组织为分子公司时，查询上下文组织本下的纠偏（用二级单位对比）、且处置单位为【二级单位处理】的纠偏
                param.getParams().put("topOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                param.getParams().put("correctionType", new Parameter(QueryParam.EQ, "1"));
            }else if (orgType.equals(3) || orgType.equals(5)) {
                // 当上下文组织为经理部或项目部时，查询上下文组织本下（用所属项目对比）、且处置单位为【项目自行处理】的纠偏
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
                param.getParams().put("correctionType", new Parameter(QueryParam.EQ, "0"));
            }

            QueryWrapper<RiskCorrectionEntity> taskCountQuery = BaseServiceImpl.changeToQueryWrapper(param);
            taskCountQuery.select("sum(if(handle_status = '" + HandleStatusEnum.待受理.getCode() + "', 1, 0)) as pendAcceptNumber, sum(if(handle_status = '" + HandleStatusEnum.待纠偏.getCode() + "'|| handle_status ='" + HandleStatusEnum.纠偏中.getCode() + "', 1, 0)) as acceptNumber,sum(if(handle_status = '" + HandleStatusEnum.已完成.getCode() + "', 1, 0)) as finishNum");
            List<Map<String, Object>> countResult = this.listMaps(taskCountQuery);
            if(CollectionUtils.isEmpty(countResult) || (null == countResult.get(0))) {
                dataCount.put("pendAcceptNumber", 0);
                dataCount.put("acceptNumber", 0);
                dataCount.put("finishNum", 0);
            }else {
                dataCount.put("pendAcceptNumber", countResult.get(0).get("pendAcceptNumber"));
                dataCount.put("acceptNumber", countResult.get(0).get("acceptNumber"));
                dataCount.put("finishNum", countResult.get(0).get("finishNum"));
            }

            // 查询已提请数量
            CommonResponse<JSONObject> drawResponse = this.queryDrawRisk(new QueryParam());
            JSONObject data = drawResponse.getData();
            long drawNumber = Long.parseLong(data.get("total").toString());
            dataCount.put("drawNumber", drawNumber);

            resp.put("dataCount", dataCount);
        }else {
            resp.put("dataCount", 0);
        }

        return CommonResponse.success(resp);
    }

    @Override
    public CommonResponse<JSONObject> queryRiskReport(QueryParam param) {
        JSONObject resp = new JSONObject();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planYear");
        fuzzyFields.add("yearBname");

        // 查询全部传的空串，查询不到
        if(param.getParams().containsKey("handleStatus") && StringUtils.isEmpty(String.valueOf(param.getParams().get("handleStatus").getValue()))){
            param.getParams().remove("handleStatus");
        }
        if(param.getParams().containsKey("correctionType") && StringUtils.isEmpty(String.valueOf(param.getParams().get("correctionType").getValue()))){
            param.getParams().remove("correctionType");
        }

        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<RiskCorrectionEntity> page = this.queryPage(param,false);
        IPage<RiskCorrectionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RiskCorrectionVO.class));

        List<RiskCorrectionVO> records = pageData.getRecords();
        for (RiskCorrectionVO vo : records) {
            if (vo.getMinTime() != null) {
                // 纠偏剩余时间/天
                vo.setSurplusDay(DateUtil.daysBetween(vo.getMinTime(), new Date()));
            }
            // 纠偏历时
            if (!Objects.equals(vo.getStartTime(), null)) {
                if (vo.getHandleStatus().equals(HandleStatusEnum.已完成.getCode())) {
                    vo.setTake(DateUtil.daysBetween(vo.getStartTime(), vo.getFinishTime()));
                }else {
                    vo.setTake(DateUtil.daysBetween(vo.getStartTime(), new Date()));
                }
            }
        }

        resp.put("pages", pageData.getPages());
        resp.put("size", pageData.getSize());
        resp.put("current", pageData.getCurrent());
        resp.put("total", pageData.getTotal());
        resp.put("records", records);

        return CommonResponse.success(resp);
    }

    @Override
    public Map<Long, RiskCorrectionEntity> queryRiskByYearId(Long yearId) {
        LambdaQueryWrapper<RiskCorrectionEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RiskCorrectionEntity::getYearId, yearId).eq(BaseEntity::getDr, 0).orderByDesc(BaseEntity::getCreateTime);
        List<RiskCorrectionEntity> list = this.list(wrapper);

        Map<Long, RiskCorrectionEntity> map = list.stream().collect(Collectors.toMap(RiskCorrectionEntity::getYearBid, Function.identity(), (x1, x2) -> x1));

        return map;
    }

    @Override
    public void handleTopData() {
        // 查询全部数据
        List<RiskCorrectionEntity> list = this.list();

        if (ListUtil.isNotEmpty(list)) {
//            CommonResponse<OrgVO> response = orgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
            CommonResponse<List<OrgVO>> response = orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(1), null);
            if (!response.isSuccess()) {
                throw new BusinessException("查询租户顶级组织失败！");
            }
            List<OrgVO> data = new ArrayList<>();
            for(OrgVO vo : response.getData()){
                CommonResponse<List<OrgVO>> parentsByOrgId = orgApi.findChildrenByParentId(vo.getId());
                if (!parentsByOrgId.isSuccess()) {
                    throw new BusinessException("网络异常，查询非项目部组织失败，请稍后再试");
                }
                data.addAll(parentsByOrgId.getData());
            }

            Map<Long, OrgVO> map = data.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));

            for (RiskCorrectionEntity entity : list) {
                if (!Objects.equals(null, entity.getOrgId())) {
                    OrgVO orgVO = map.get(entity.getOrgId());
                    if (!Objects.equals(null, orgVO)) {
                        OrgVO parentOrgVo = getCorp(map, orgVO.getParentId());
                        entity.setTopOrgId(parentOrgVo.getId());
                        entity.setTopOrgName(parentOrgVo.getName());
                    }
                }
            }

            this.saveOrUpdateBatch(list);
        }

    }


    private OrgVO getCorp(Map<Long, OrgVO> orgMap, Long parentId) {
        OrgVO vo = new OrgVO();
        if (parentId == null) {
            return vo;
        }else {
            vo = orgMap.get(parentId);
        }

        if (vo.getOrgType() == 2) {
            return vo;
        }

        return getCorp(orgMap, vo.getParentId());
    }
}
