package com.ejianc.business.progress.utils;

import PluSoft.Utils.PlusProject;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.cons.CustomizeCloumVO;
import com.ejianc.business.plan.utils.PlusProjectUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class PlusUtil {
    public static HashMap read(MultipartFile file, List<String> cloums) {
        HashMap read = null;
        try {
            read = PlusProjectUtil.Read(file, cloums);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("解析异常，请检查导入文件！");
        }
        return read;
    }

    public static void write(HttpServletResponse response, String fileName, Map dataProject, List<String> cloums) {
        String write = null;
        try {
            write = PlusProjectUtil.Write(dataProject, cloums);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (write != null) {
            OutputStreamWriter out = null;
            try {
                OutputStream os = response.getOutputStream();
                out = new OutputStreamWriter(os, "UTF-8");
//                response.reset();
                response.setContentType("application/octet-stream; charset=utf-8");
                response.addHeader("Content-Disposition", "attachment;filename="
                        + URLEncoder.encode(fileName, "UTF-8")
                );
//                response.addHeader("Access-Control-Allow-Origin", "*");
                response.setCharacterEncoding("UTF-8");
                out.write(write);
                out.flush();
                out.close();
            } catch (IOException e) {
                e.printStackTrace();
                throw new BusinessException("下载失败");
            } finally {
                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException var11) {
                        var11.printStackTrace();
                    }
                }
            }
        }

    }

    public static HashMap readMain(HashMap map, Map<String, Map> value) {
        if (map != null) {
            map = read2Date(map, "CreationDate", "FinishDate", "StartDate");
            map = readCalendar(map);
            List<HashMap> tasks = (List<HashMap>) map.get("Tasks");
            readTask(tasks, value, "Start", "Finish", "EarlyFinish", "LateStart", "EarlyStart", "LateFinish", "ConstraintDate", "CreateDate");
        }
        return map;
    }

    public static HashMap readMain(HashMap map) {
        if (map != null) {
            map = read2Date(map, "CreationDate", "FinishDate", "StartDate");
            map = readCalendar(map);
            List<HashMap> tasks = (List<HashMap>) map.get("Tasks");
            Map<String, Map> value = new HashMap<>();
            readTask(tasks, value, "Start", "Finish", "EarlyFinish", "LateStart", "EarlyStart", "LateFinish", "ConstraintDate", "CreateDate");
        }
        return map;
    }

    public static HashMap read2Date(HashMap map, String... key) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        for (String k : key) {
            if (map.get(k) != null) {
                map.put(k, sd.format(map.get(k)));
            } else {
                map.put(k, null);
            }
        }

        return map;
    }

//    public static HashMap value2Key(HashMap hm, Map<String, Map> value) {
//        for (String field : value.keySet()) {
//            Map map = value.get(field);
//            if (hm.get(field) != null) {
//                hm.put(field, getKey(map, hm.get(field).toString()));
//            }
//        }
//        return hm;
//    }

    public static HashMap value2Key(HashMap hm, Map<String, Map> value) {
        if(!hm.containsKey("ExtendedAttribute")){
            return hm;
        }
        ArrayList ExtendedAttributes = (ArrayList) hm.get("ExtendedAttribute");
        for(Object obj : ExtendedAttributes){
            HashMap vo = (HashMap) obj;
            for(Map cloum : value.values()){
                if(vo.get("FieldID").toString().equals(cloum.get("fieldID").toString())){
                    Object key = vo.get("Value");
                    if(cloum.get("value") != null){
                        key = getKey((HashMap) cloum.get("value"), vo.get("Value").toString());
                    }
                    hm.put(cloum.get("field"), key);
                }
            }
        }
        return hm;
    }

    public static List<HashMap> readTask(List<HashMap> tasks, Map<String, Map> value, String... key) {
        for (HashMap hm : tasks) {
            read2Date(hm, key);
            if (value.size() > 0) {
                value2Key(hm, value);
            }
            hm.remove("employeeName");
            hm.remove("PercentComplete");
            hm.remove("diffValue");
            hm.remove("planNum");
            if (hm.get("children") != null) {
                List<HashMap> child = (List<HashMap>) hm.get("children");
                readTask(child, value, key);
            }
        }
        return tasks;
    }

    // 别再改我的代码了，已经报错了，查了很久才改回来
    public static List<Map> dealCalendars(String calendars) {
        List<Map> list = ArrayListUtil.toArrayList(calendars);
        for (Map m : list) {
            List<Map> weekDays = ArrayListUtil.toArrayList(m.get("WeekDays"));
            m.put("WeekDays", weekDays);
            for (Map workingTimes : weekDays) {
                List<Map> times = ArrayListUtil.toArrayList(workingTimes.get("WorkingTimes"));
                workingTimes.put("WorkingTimes", times);
            }
            List<Map> exceptions = ArrayListUtil.toArrayList(m.get("Exceptions"));
            m.put("Exceptions", exceptions);
            for (Map n : exceptions) {
                if(n.containsKey("WorkingTimes")){
                    List<Map> times = ArrayListUtil.toArrayList(n.get("WorkingTimes"));
                    n.put("WorkingTimes", times);
                }
                Map timePeriod = JSONObject.parseObject(JSONObject.toJSONString(n.get("TimePeriod")), Map.class);
                // 导出带".000Z"，project打开失败
                String FromDate = (String) timePeriod.get("FromDate");
                String ToDate = (String) timePeriod.get("ToDate");
                if(FromDate.contains(".000Z")){
                    timePeriod.put("FromDate", FromDate.substring(0, FromDate.lastIndexOf(".000Z")));
                }
                if(ToDate.contains(".000Z")){
                    timePeriod.put("ToDate", ToDate.substring(0, ToDate.lastIndexOf(".000Z")));
                }
                n.put("TimePeriod", timePeriod);
            }
        }
        return list;
    }

    public static <K, V> K getKey(Map<K, V> map, V value) {
        return map
                .entrySet()
                .stream()
                .filter(entry -> value.equals(entry.getValue()))
                .map(Map.Entry::getKey)
                .findFirst()
                .orElse(null);
    }

    public static Map<String, Map> getFieldMap(ArrayList list, Map<String, CustomizeCloumVO> cloumMap) {
        String fieldName = null;
        Map<String, Map> fieldMap = new HashMap<>();
        if(list == null){
            return fieldMap;
        }
        for(Object obj : list){
            HashMap o = (HashMap) obj;
            if(o.get("Alias") == null){
                continue;
            }
            fieldName = o.get("Alias").toString();
            for(CustomizeCloumVO cloum : cloumMap.values()){
                if(cloum.getFieldName().equals(fieldName)){
                    Map field = BeanMapper.map(cloum, Map.class);
                    field.put("fieldID", o.get("FieldID"));
                    field.put("value", cloum.getValue());
                    fieldMap.put(cloum.getField(), field);
                }
            }
        }
        return fieldMap;
    }

    public static String utc2Local(String time) {
        String res = "";
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf1.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            Date date = sdf1.parse(time);
            res = sdf2.format(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static HashMap readCalendar(HashMap map) {
        ArrayList lst = new ArrayList();
        if(map.get("Calendars") != null){
            ArrayList Calendars = (ArrayList) map.get("Calendars");
            for(Object obj : Calendars){
                HashMap calendar = (HashMap) obj;
                calendar = readExceptions(calendar);
                lst.add(calendar);
            }
            map.put("Calendars", lst);
        }
        return map;
    }

    private static HashMap readExceptions(HashMap map) {
        ArrayList lst = new ArrayList();
        if(map.get("Exceptions") != null){
            ArrayList Exceptions = (ArrayList) map.get("Exceptions");
            for(Object obj : Exceptions){
                HashMap exception = (HashMap) obj;
                exception = readTimePeriod(exception);
                lst.add(exception);
            }
            map.put("Exceptions", lst);
        }
        return map;
    }

    private static HashMap readTimePeriod(HashMap map) {
        if(map.get("TimePeriod") != null){
            HashMap TimePeriod = (HashMap) map.get("TimePeriod");
            TimePeriod = read2Date(TimePeriod, "FromDate", "ToDate");
            map.put("TimePeriod", TimePeriod);
        }
        return map;
    }
}
