package com.ejianc.business.progress.utils;

import java.util.*;

public class TreeUtil {
    // 树转list
    public static List<Map<String, Object>> treeToList(List<Map<String, Object>> list){
        List<Map<String, Object>> reList=new ArrayList<>();
        for(Map<String, Object> stringObjectMap:list){
            List<Map<String, Object>> child =(List)stringObjectMap.get("children");
            if(null!=child){// 有下级
                List<Map<String, Object>> childrenList=treeToList(child);
                stringObjectMap.put("children",null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
            }else{
                reList.add(stringObjectMap);
            }
        }
        return reList;
    }
    // 根据逻辑结构构造树形
    public static List<Map<String, Object>> logicTreeData(List<Map> list) {
        List<Map<String, Object>> resp = new ArrayList();
        List<String> rootItems = new ArrayList();
        Map<String, Map<String, Object>> listMap = new HashMap();
        Iterator var4 = list.iterator();

        Map item;
        while(var4.hasNext()) {
            item = (Map)var4.next();
            listMap.put(item.get("tid").toString(), item);
        }

        for(int i = 0; i < list.size(); ++i) {
            item = (Map)list.get(i);
            String parentId = item.get("logicParentId") != null ? item.get("logicParentId").toString() : "";
            Map<String, Object> parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List<Map<String, Object>> child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                } else {
                    List<Map<String, Object>> children = new ArrayList();
                    children.add(item);
                    parent.put("children", children);
                }
            } else {
                rootItems.add(item.get("tid").toString());
            }
        }

        var4 = rootItems.iterator();

        while(var4.hasNext()) {
            String rootId = (String)var4.next();
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
