/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bim.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.vo.BimConnectVO;
import com.ejianc.business.bim.vo.BimDetailVO;
import com.ejianc.business.bim.vo.BimQureyVO;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bim"})
public class BimController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZJKJ_BIM_CODE";
    @Autowired
    private IBimService service;
    @Autowired
    private IBimDetailService detailService;
    @Autowired
    private IBimDetailExecService bimExecService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BimVO> saveOrUpdate(@RequestBody BimVO saveOrUpdateVO) {
        BimVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BimVO> queryDetail(Long id) {
        BimVO vo = this.service.syncDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BimVO> queryByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        BimEntity entity = this.service.queryList(queryParam).stream().findAny().orElse(null);
        if (entity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0bBIM\u6a21\u578b\uff01");
        }
        entity = (BimEntity)((Object)this.service.selectById(entity.getId()));
        BimVO vo = (BimVO)BeanMapper.map((Object)((Object)entity), BimVO.class);
        for (BimDetailVO detail : vo.getDetailList()) {
            if (detail.getStatus() != 1) continue;
            detail.setViewerToken(this.service.getViewerToken(detail.getModleId(), detail.getPath()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BimVO> vos) {
        Long orgId = InvocationInfoProxy.getOrgId();
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        Collection list = this.service.listByIds(ids);
        for (BimEntity entity : list) {
            if (orgId.equals(entity.getOrgId())) continue;
            return CommonResponse.error((String)"\u6ca1\u6709\u5220\u9664\u6743\u9650\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bimId", new Parameter("in", ids));
        List detaiList = this.detailService.queryList(queryParam);
        this.service.removeByIds(ids, true);
        List<String> delPaths = detaiList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getModleId())).map(BimDetailEntity::getModleId).collect(Collectors.toList());
        TokenHelper.delFileBatch(delPaths.toArray(new String[0]));
        List delIds = detaiList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delIds)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"bim_detail_id", delIds);
            this.bimExecService.remove((Wrapper)wrapper);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BimVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BimVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Bim-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBimData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BimVO>> refBimData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BimVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getToken"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getToken() {
        Object token = CacheHelper.get("TOKEN");
        if (token == null) {
            TokenHelper.getTokenData();
            token = CacheHelper.get("TOKEN");
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)String.valueOf(token));
        }
        JSONObject json = TokenHelper.getTokenExpiry(String.valueOf(token));
        if (json != null && json.containsKey((Object)"code") && json.getInteger("code") != 0) {
            TokenHelper.getTokenData();
            token = CacheHelper.get("TOKEN");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)String.valueOf(token));
    }

    @RequestMapping(value={"/getViewerToken"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getViewerToken(@RequestParam(value="fileId") String fileId, @RequestParam(value="path") String path) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getViewerToken(fileId, path));
    }

    @RequestMapping(value={"/getViewerModel"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONArray> getViewerModel(@RequestParam(value="fileId") String fileId, @RequestParam(value="path") String path) {
        JSONObject json = TokenHelper.getFile(fileId, path);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)json.getJSONArray("refs"));
    }

    @RequestMapping(value={"/getFileCheck"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getFileCheck(@RequestParam(value="fileName") String fileName, @RequestParam(value="parentId") String parentId) {
        JSONObject json = TokenHelper.getFileCheck(fileName, parentId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)json.getJSONObject("data"));
    }

    @RequestMapping(value={"/getHiddenItems"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getHiddenItems(@RequestBody BimQureyVO queryVO) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getHiddenItems(queryVO));
    }

    @RequestMapping(value={"/connect"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> connect(@RequestBody BimConnectVO vo) {
        return CommonResponse.success((String)(vo.getState() != false ? "\u5173\u8054\u6210\u529f\uff01" : "\u53d6\u6d88\u5173\u8054\u6210\u529f\uff01"), (Object)this.service.connect(vo));
    }

    @RequestMapping(value={"/oneUnConnect"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> oneUnConnect(@RequestParam Long bimDetailId) {
        return CommonResponse.success((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f\uff01", (Object)this.service.oneUnConnect(bimDetailId));
    }

    @RequestMapping(value={"/batchDownload"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> batchDownload(@RequestBody List<BimDetailVO> vos, HttpServletResponse response) {
        return CommonResponse.success((String)"\u6279\u91cf\u4e0b\u8f09\u6587\u4ef6\u6210\u529f\uff01", (Object)this.service.batchDownload(vos, response));
    }

    @RequestMapping(value={"/setCamera"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> setCamera(@RequestBody JSONObject json) {
        Long projectId = json.getLong("projectId");
        String path = json.getString("path");
        String camera = json.getString("camera");
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List bimList = this.service.queryList(param);
        if (CollectionUtils.isEmpty((Collection)bimList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0bBIM\uff01");
        }
        BimEntity bim = (BimEntity)((Object)this.service.selectById(((BimEntity)((Object)bimList.get(0))).getId()));
        BimDetailEntity detail = bim.getDetailList().stream().filter(x -> x.getPath().equals(path)).findAny().orElse(null);
        if (detail == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6a21\u578b\u6587\u4ef6\uff01");
        }
        detail.setCamera(camera);
        this.detailService.saveOrUpdate((Object)detail);
        return CommonResponse.success((String)"\u8bbe\u7f6e\u6210\u529f\uff01", (Object)true);
    }

    @RequestMapping(value={"/getCamera"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getCamera(@RequestParam(value="projectId") Long projectId, @RequestParam(value="path") String path) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List bimList = this.service.queryList(param);
        if (CollectionUtils.isEmpty((Collection)bimList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0bBIM\uff01");
        }
        BimEntity bim = (BimEntity)((Object)this.service.selectById(((BimEntity)((Object)bimList.get(0))).getId()));
        BimDetailEntity detail = bim.getDetailList().stream().filter(x -> x.getPath().equals(path)).findAny().orElse(null);
        if (detail == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6a21\u578b\u6587\u4ef6\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)(StringUtils.isNotEmpty((CharSequence)detail.getCamera()) ? detail.getCamera() : ""));
    }
}

