/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bim.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimDetailExecEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.mapper.BimMapper;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.util.ParamUtil;
import com.ejianc.business.bim.util.ZipCompress;
import com.ejianc.business.bim.vo.BimConnectVO;
import com.ejianc.business.bim.vo.BimDetailVO;
import com.ejianc.business.bim.vo.BimQureyVO;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.business.bim.vo.ItemVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bimService")
public class BimServiceImpl
extends BaseServiceImpl<BimMapper, BimEntity>
implements IBimService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZJKJ_BIM_CODE";
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IBimDetailService detailService;
    @Autowired
    private IExecPlanService execService;
    @Autowired
    private IExecPlanDetailService execDetailService;
    @Autowired
    private IBimDetailExecService bimExecService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PROJECT_TYPE_PARAM = "P-l00WYH0188";
    private static final String LONG_PROJECT_VALUE_PARAM = "P-g2Jo4i0190";
    private static final String SHORT_PROJECT_VALUE_PARAM = "P-92i8590189";

    @Override
    public BimVO saveOrUpdate(BimVO saveOrUpdateVO) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(BaseEntity::getDr, (Object)0);
        ew.eq(BimEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        ew.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        List list = super.list((Wrapper)ew);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728BIM\u6a21\u578b");
        }
        BimEntity entity = (BimEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BimEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String date = sdf.format(new Date());
            entity.setBillCode("MX" + date);
        } else {
            List detailIds = entity.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && x.getId() != null).map(BaseEntity::getId).collect(Collectors.toList());
            BimEntity data = (BimEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
            List<String> delPaths = data.getDetailList().stream().filter(x -> !detailIds.contains(x.getId()) && StringUtils.isNotEmpty((CharSequence)x.getModleId())).map(BimDetailEntity::getModleId).collect(Collectors.toList());
            TokenHelper.delFileBatch(delPaths.toArray(new String[0]));
            List delIds = data.getDetailList().stream().filter(x -> !detailIds.contains(x.getId())).map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(delIds)) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.in((Object)"bim_detail_id", delIds);
                this.bimExecService.remove((Wrapper)wrapper);
            }
        }
        OrgVO orgVO = this.orgUtil.findById(entity.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
        entity.setState(0);
        for (BimDetailEntity detail : entity.getDetailList()) {
            if ("del".equals(detail.getRowState()) || detail.getModle() == null || detail.getModle() != 1 || detail.getState() == null || detail.getState() != 1) continue;
            entity.setState(1);
        }
        BimDetailEntity oldModel = null;
        if (entity.getId() != null) {
            BimEntity data = (BimEntity)((Object)super.selectById((Serializable)entity.getId()));
            oldModel = data.getDetailList().stream().filter(x -> x.getModle() == 1).findAny().orElse(null);
        }
        super.saveOrUpdate((Object)entity, false);
        this.syncBimExecList(entity, oldModel);
        List<String> modelIds = entity.getDetailList().stream().map(BimDetailEntity::getModleId).filter(Objects::nonNull).collect(Collectors.toList());
        this.syncDxyModelList(entity.getProjectId(), modelIds);
        BimVO vo = (BimVO)BeanMapper.map((Object)((Object)entity), BimVO.class);
        for (BimDetailVO detail : vo.getDetailList()) {
            if (detail.getModleId() == null) continue;
            detail.setViewerToken(this.getViewerToken(detail.getModleId(), detail.getPath()));
        }
        return vo;
    }

    private void syncBimExecList(BimEntity entity, BimDetailEntity oldModel) {
        BimDetailEntity newModel = entity.getDetailList().stream().filter(x -> x.getModle() == 1).findAny().orElse(null);
        if (oldModel == null || newModel == null || oldModel.getId().equals(newModel.getId()) || newModel.getState() != 0) {
            return;
        }
        if (oldModel.getFormat().equals("asm") && !newModel.getFormat().equals("asm")) {
            return;
        }
        ArrayList<String> pathList = new ArrayList<String>();
        if (!oldModel.getFormat().equals("asm") && !newModel.getFormat().equals("asm")) {
            String str2;
            String str1 = oldModel.getName().split("\\s+")[0];
            if (!str1.equals(str2 = newModel.getName().split("\\s+")[0])) {
                return;
            }
            pathList.add(oldModel.getPath());
        }
        JSONArray paths = new JSONArray();
        JSONArray oldPaths = new JSONArray();
        if (newModel.getFormat().equals("asm")) {
            JSONObject json = TokenHelper.getFile(newModel.getModleId(), newModel.getPath());
            paths = json.getJSONArray("refs");
            if (oldModel.getFormat().equals("asm")) {
                JSONObject oldJson = TokenHelper.getFile(oldModel.getModleId(), oldModel.getPath());
                oldPaths = oldJson.getJSONArray("refs");
            }
            pathList.addAll(paths.stream().map(x -> ((JSONObject)x).getString("ref")).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(pathList)) {
            return;
        }
        QueryParam param = new QueryParam();
        ComplexParam c4 = ParamUtil.getOrParam("bim_detail_id", new Parameter("eq", (Object)oldModel.getId()), "path", new Parameter("in", pathList));
        param.getComplexParams().add(c4);
        List oldList = this.bimExecService.queryList(param);
        Map<Long, BimDetailExecEntity> oldMap = oldList.stream().collect(Collectors.toMap(BimDetailExecEntity::getExecDetailId, x -> x, (v1, v2) -> {
            if (v1.getPath().equals(oldModel.getPath())) {
                return v1;
            }
            return v2;
        }));
        if (MapUtil.isNotEmpty(oldMap)) {
            for (BimDetailExecEntity old : oldMap.values()) {
                if (!newModel.getFormat().equals(oldModel.getFormat())) {
                    this.replaceRvtGuid(paths, old);
                }
                if (CollectionUtils.isNotEmpty((Collection)oldPaths)) {
                    this.replaceAsmGuid(paths, oldPaths, old);
                }
                old.setId(null);
                old.setVersion(null);
                old.setBimDetailId(newModel.getId());
                old.setName(newModel.getName());
                old.setPath(newModel.getPath());
                old.setCreateUserCode(null);
                old.setCreateTime(null);
                old.setUpdateUserCode(null);
                old.setUpdateTime(null);
            }
            this.bimExecService.saveOrUpdateBatch(oldMap.values());
            newModel.setState(1);
            this.detailService.saveOrUpdate((Object)newModel);
            entity.setState(1);
            super.saveOrUpdate((Object)entity);
        }
    }

    private void replaceRvtGuid(JSONArray paths, BimDetailExecEntity old) {
        String[] oldIds = old.getBimIds().split(",");
        Map<String, String> bimIds = Arrays.asList(oldIds).stream().collect(Collectors.toMap(x -> x, x -> x, (v1, v2) -> v1));
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.getJSONObject(i).getString("ref");
            if (!old.getPath().equals(path)) continue;
            String name = paths.getJSONObject(i).getString("name");
            for (String bimId : bimIds.keySet()) {
                String id = new String(decoder.decode(bimId));
                id = id.contains("Root") ? name + " Root " + i : i + "." + id;
                id = encoder.encodeToString(id.getBytes());
                bimIds.put(bimId, id);
            }
        }
        old.setBimIds(StringUtils.join(bimIds.values(), (String)","));
    }

    private void replaceAsmGuid(JSONArray paths, JSONArray oldPaths, BimDetailExecEntity old) {
        String[] oldIds = old.getBimIds().split(",");
        Map<String, String> bimIds = Arrays.asList(oldIds).stream().collect(Collectors.toMap(x -> x, x -> x, (v1, v2) -> v1));
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.getJSONObject(i).getString("ref");
            String name = paths.getJSONObject(i).getString("name");
            Integer j = null;
            for (int k = 0; k < oldPaths.size(); ++k) {
                String str2;
                String kpath = oldPaths.getJSONObject(k).getString("ref");
                String kname = oldPaths.getJSONObject(k).getString("name");
                if (kpath.equals(path)) {
                    j = k;
                    continue;
                }
                String str1 = name.split("\\s+")[0];
                if (!str1.equals(str2 = kname.split("\\s+")[0])) continue;
                j = k;
            }
            for (String bimId : bimIds.keySet()) {
                String id = new String(decoder.decode(bimId));
                if (j != null && id.startsWith(j + ".")) {
                    id = i + "." + id.split("\\.")[1];
                    id = encoder.encodeToString(id.getBytes());
                    bimIds.put(bimId, id);
                }
                if (j != null && id.endsWith("Root " + j)) {
                    id = name + " Root " + i;
                    id = encoder.encodeToString(id.getBytes());
                    bimIds.put(bimId, id);
                }
                if (j != null || id.contains(".")) continue;
                id = i + "." + id;
                id = encoder.encodeToString(id.getBytes());
                bimIds.put(bimId, id);
            }
        }
        old.setBimIds(StringUtils.join(bimIds.values(), (String)","));
    }

    @Override
    public BimVO syncDetail(Long id) {
        BimEntity entity = (BimEntity)((Object)super.selectById((Serializable)id));
        List<BimDetailEntity> detailList = entity.getDetailList();
        ArrayList<BimDetailEntity> saveList = new ArrayList<BimDetailEntity>();
        for (BimDetailEntity detail : detailList) {
            JSONObject fileStatus;
            if (detail.getStatus() == 1 || (fileStatus = TokenHelper.getFileStatus(detail.getPath())) == null || !"Ready".equals(fileStatus.getString("status"))) continue;
            detail.setStatus(1);
            saveList.add(detail);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.detailService.updateBatchById(saveList);
        }
        BimVO vo = (BimVO)BeanMapper.map((Object)((Object)entity), BimVO.class);
        for (BimDetailVO detail : vo.getDetailList()) {
            if (detail.getModleId() == null) continue;
            detail.setViewerToken(this.getViewerToken(detail.getModleId(), detail.getPath()));
        }
        return vo;
    }

    private void syncDxyModelList(Long projectId, List<String> modelIds) {
        String parentId = "";
        if (String.valueOf(projectId).length() <= 15) {
            return;
        }
        parentId = ("" + projectId + projectId).substring(0, 32);
        JSONObject json = TokenHelper.getFileList(parentId);
        JSONArray array = json.getJSONArray("model_list");
        List fileIds = array.stream().map(x -> ((JSONObject)x).getString("id")).collect(Collectors.toList());
        fileIds.removeAll(modelIds);
        if (CollectionUtils.isNotEmpty(fileIds)) {
            for (String fileId : fileIds) {
                TokenHelper.delFileBatch(new String[]{fileId});
            }
            this.logger.info("\u540c\u6b65\u5220\u9664\u5927\u8c61\u4e91\u672a\u4fdd\u5b58\u6a21\u578b\u6587\u4ef6\uff1a{}", (Object)JSONObject.toJSONString(fileIds));
        }
    }

    @Override
    public JSONObject getHiddenItems(BimQureyVO queryVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)queryVO.getProjectId()));
        BimEntity entity = super.queryList(queryParam).stream().findAny().orElse(null);
        if (entity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0bBIM\u6a21\u578b\uff01");
        }
        entity = (BimEntity)((Object)super.selectById((Serializable)entity.getId()));
        BimDetailEntity model = entity.getDetailList().stream().filter(x -> x.getModle() != null && x.getModle() == 1).findAny().orElse(new BimDetailEntity());
        JSONArray array = new JSONArray();
        if (StringUtils.isNotEmpty((CharSequence)model.getFormat()) && model.getFormat().equals("asm")) {
            JSONObject json = TokenHelper.getFile(model.getModleId(), model.getPath());
            array = json.getJSONArray("refs");
        }
        if (CollectionUtils.isEmpty((Collection)queryVO.getAsmPaths())) {
            if (StringUtils.isNotEmpty((CharSequence)model.getFormat()) && model.getFormat().equals("asm")) {
                queryVO.setAsmPaths(array.stream().map(x -> ((JSONObject)x).getString("ref")).collect(Collectors.toList()));
            } else {
                queryVO.setAsmPaths(new ArrayList<String>(Arrays.asList(model.getPath())));
            }
        }
        if (CollectionUtils.isEmpty((Collection)queryVO.getAsmPaths()) || model.getId() == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230BIM\u4e0b\u4e3b\u6a21\u578b\u8def\u5f84\uff01");
        }
        ExecPlanEntity exec = this.execService.queryList(queryParam).stream().findAny().orElse(null);
        if (exec == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0b\u7684\u6267\u884c\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)exec.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.execDetailService.list((Wrapper)ew);
        QueryParam param = new QueryParam();
        param.getParams().put("bim_detail_id", new Parameter("eq", (Object)model.getId()));
        List execList = this.bimExecService.queryList(param);
        Map<Long, List<BimDetailExecEntity>> execMap = execList.stream().collect(Collectors.groupingBy(BimDetailExecEntity::getExecDetailId));
        HashMap<String, String> items = new HashMap<String, String>();
        ArrayList<ItemVO> parents = new ArrayList<ItemVO>();
        if (queryVO.getAsmPaths().size() == 1) {
            JSONObject json = TokenHelper.getFileTree((String)queryVO.getAsmPaths().get(0));
            ItemVO parent = BimServiceImpl.getItems(json, items, null);
            parents.add(parent);
        }
        if (queryVO.getAsmPaths().size() > 1) {
            Map<String, String> pathNameMap = entity.getDetailList().stream().collect(Collectors.toMap(x -> x.getPath(), x -> x.getName()));
            Map<String, JSONObject> itemMap = this.getItemJSONMap(queryVO.getAsmPaths());
            for (int i = 0; i < array.size(); ++i) {
                String path = array.getJSONObject(i).getString("ref");
                if (!itemMap.containsKey(path)) continue;
                JSONObject json = itemMap.get(path);
                ItemVO parent = BimServiceImpl.getItems(json, items, i);
                if (pathNameMap.containsKey(json.getString("Path"))) {
                    String root = pathNameMap.get(json.getString("Path")) + " " + json.getString("Guid") + " " + i;
                    root = encoder.encodeToString(root.getBytes());
                    items.remove(parent.getUid());
                    items.put(root, root);
                    parent.setUid(root);
                    List children = parent.getChildren();
                    Iterator iterator = children.iterator();
                    while (iterator.hasNext()) {
                        ItemVO child = (ItemVO)iterator.next();
                        child.setParentId(root);
                    }
                    parent.setChildren(children);
                }
                parents.add(parent);
            }
        }
        Integer value = this.getParamValue(exec.getPlanBeginDate(), exec.getPlanEndDate());
        JSONObject colors = this.getColors();
        JSONArray hiddenItems = new JSONArray();
        JSONArray acturalItems = new JSONArray();
        JSONArray states = new JSONArray();
        JSONArray translucentBim = new JSONArray();
        HashMap<String, String> connectIitems = new HashMap<String, String>();
        for (ExecPlanDetailEntity detail : detailList) {
            if (!execMap.containsKey(detail.getId())) continue;
            List bimIds = execMap.get(detail.getId()).stream().map(BimDetailExecEntity::getBimIds).flatMap(x -> Stream.of(x.split(","))).collect(Collectors.toList());
            for (String bimId : bimIds) {
                if (!items.containsKey(bimId)) continue;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)bimId);
                obj.put("time", (Object)detail.getStart());
                obj.put("duration", (Object)detail.getDuration());
                obj.put("uid", (Object)detail.getId());
                obj.put("name", (Object)detail.getName());
                hiddenItems.add((Object)obj);
                if (detail.getActualStart() != null) {
                    JSONObject obj2 = new JSONObject();
                    obj2.put("id", (Object)bimId);
                    obj2.put("time", (Object)detail.getActualStart());
                    obj2.put("duration", (Object)detail.getDuration());
                    obj2.put("uid", (Object)detail.getId());
                    obj2.put("name", (Object)detail.getName());
                    acturalItems.add((Object)obj2);
                }
                JSONArray state = new JSONArray();
                state.add((Object)bimId);
                if (new Integer(1).equals(detail.getFinishState())) {
                    state.add((Object)colors.getJSONArray("blue"));
                } else if (new Integer(2).equals(detail.getFinishState())) {
                    if (DateUtil.compareDate(detail.getActualStart(), detail.getPlanStart()) > 0) {
                        if (ComputeUtil.isLessOrEqual((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) {
                            state.add((Object)colors.getJSONArray("green"));
                        } else {
                            state.add((Object)colors.getJSONArray("red"));
                        }
                    } else if (ComputeUtil.isGreaterThan((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) {
                        state.add((Object)colors.getJSONArray("yellow"));
                    } else if (ComputeUtil.isLessOrEqual((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) {
                        state.add((Object)colors.getJSONArray("green"));
                    }
                } else {
                    if (value != 0 && DateUtil.compareDate(detail.getPlanStart(), DateUtil.addDays(new Date(), value)) <= 0 && ComputeUtil.isGreaterThan((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) {
                        state.add((Object)colors.getJSONArray("red"));
                    } else {
                        state.add((Object)colors.getJSONArray("white"));
                    }
                    translucentBim.add((Object)bimId);
                }
                states.add((Object)state);
                connectIitems.put(bimId, bimId);
            }
        }
        JSONArray newStates = new JSONArray();
        Map<String, JSONArray> colorMap = states.stream().collect(Collectors.toMap(x -> ((JSONArray)x).getString(0), x -> ((JSONArray)x).getJSONArray(1), (v1, v2) -> v1));
        BimServiceImpl.getNewStates(newStates, parents, colorMap);
        newStates = newStates.stream().map(x -> {
            JSONArray vo = (JSONArray)x;
            String uid = vo.getString(0);
            if (colorMap.containsKey(uid)) {
                vo.remove(1);
                vo.add(colorMap.get(uid));
            }
            return vo;
        }).collect(Collectors.toCollection(JSONArray::new));
        HashMap<String, String> unItems = new HashMap<String, String>();
        BimServiceImpl.getUnItems(unItems, parents, connectIitems);
        hiddenItems = hiddenItems.stream().sorted(Comparator.comparing(x -> ((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        acturalItems = acturalItems.stream().sorted(Comparator.comparing(x -> ((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        JSONObject json = new JSONObject();
        json.put("hiddenItems", (Object)hiddenItems);
        json.put("acturalItems", (Object)acturalItems);
        json.put("states", (Object)newStates);
        json.put("translucentBim", (Object)translucentBim);
        if (StringUtils.isNotEmpty((CharSequence)queryVO.getRange()) && queryVO.getRange().equals("tree")) {
            json.put("unItems", new ArrayList(unItems.keySet()));
        }
        return json;
    }

    private String getContentByState(BigDecimal diffValue, Integer state) {
        JSONObject content = new JSONObject();
        StringBuilder str = new StringBuilder();
        if (state == 0) {
            str.append("\u8fdb\u884c\u4e2d\u9884\u8ba1\u5ef6\u671f");
        } else if (state == 1) {
            str.append("\u8fdb\u884c\u4e2d\u5df2\u903e\u671f");
        } else if (state == 2) {
            str.append("\u672a\u5f00\u59cb\u5c06\u903e\u671f");
        }
        Integer day = diffValue != null ? diffValue.intValue() : 0;
        str.append(day + "\u5929");
        return str.toString();
    }

    private Integer getParamValue(Date startDate, Date endDate) {
        Integer year = DateUtil.getSubYear(startDate, endDate);
        if (year == null) {
            return 0;
        }
        CommonResponse typeResponse = this.paramConfigApi.getByCode(PROJECT_TYPE_PARAM);
        CommonResponse longResponse = this.paramConfigApi.getByCode(LONG_PROJECT_VALUE_PARAM);
        CommonResponse shortResponse = this.paramConfigApi.getByCode(SHORT_PROJECT_VALUE_PARAM);
        if (!typeResponse.isSuccess() || typeResponse.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u5206\u7c7b\u9608\u503c\u8bbe\u7f6e(\u5e74)\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + typeResponse.getMsg());
        }
        if (!longResponse.isSuccess() || longResponse.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u957f\u65f6\u9879\u76ee\u9608\u503c\u8bbe\u7f6e(\u5929)\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + longResponse.getMsg());
        }
        if (!shortResponse.isSuccess() || shortResponse.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u4e00\u822c\u9879\u76ee\u9608\u503c\u8bbe\u7f6e(\u5929)\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + shortResponse.getMsg());
        }
        Integer typeValue = Integer.valueOf(((ParamRegisterSetVO)typeResponse.getData()).getValueData());
        Integer longValue = Integer.valueOf(((ParamRegisterSetVO)longResponse.getData()).getValueData());
        Integer shortValue = Integer.valueOf(((ParamRegisterSetVO)shortResponse.getData()).getValueData());
        return year >= typeValue ? longValue : shortValue;
    }

    private static void getNewStates(JSONArray newStates, List<ItemVO> parents, Map<String, JSONArray> colorMap) {
        for (ItemVO parent : parents) {
            String parentId = parent.getUid();
            List children = parent.getChildren();
            if (colorMap.containsKey(parentId)) {
                for (ItemVO item : children) {
                    colorMap.put(item.getUid(), colorMap.get(parentId));
                }
                JSONArray vo = new JSONArray();
                vo.add((Object)parentId);
                vo.add((Object)colorMap.get(parentId));
                newStates.add((Object)vo);
            }
            BimServiceImpl.getNewStates(newStates, children, colorMap);
        }
    }

    private static void getUnItems(Map<String, String> unItems, List<ItemVO> parents, Map<String, String> connectItems) {
        for (ItemVO parent : parents) {
            String parentId = parent.getUid();
            List children = parent.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                BimServiceImpl.getUnItems(unItems, children, connectItems);
                continue;
            }
            if (unItems.containsKey(parentId) || connectItems.containsKey(parentId)) continue;
            unItems.put(parentId, parentId);
        }
    }

    private static List<ItemVO> getChildrens(String root, ItemVO parent) {
        List<ItemVO> children = new ArrayList();
        if (root.equals(parent.getUid())) {
            children = parent.getChildren();
            ArrayList<ItemVO> childs = new ArrayList<ItemVO>();
            for (ItemVO child : children) {
                childs.addAll(BimServiceImpl.getChildrens(child.getUid(), child));
            }
            children.addAll(childs);
        } else {
            for (ItemVO child : parent.getChildren()) {
                children.addAll(BimServiceImpl.getChildrens(root, child));
            }
        }
        parent.setChildren(new ArrayList());
        return children;
    }

    private static JSONObject getColors() {
        JSONObject colors = new JSONObject();
        JSONArray blue = new JSONArray();
        blue.add((Object)BimServiceImpl.safeDiv(120, 255));
        blue.add((Object)BimServiceImpl.safeDiv(177, 255));
        blue.add((Object)BimServiceImpl.safeDiv(255, 255));
        colors.put("blue", (Object)blue);
        JSONArray red = new JSONArray();
        red.add((Object)BimServiceImpl.safeDiv(255, 255));
        red.add((Object)BimServiceImpl.safeDiv(105, 255));
        red.add((Object)BimServiceImpl.safeDiv(105, 255));
        colors.put("red", (Object)red);
        JSONArray yellow = new JSONArray();
        yellow.add((Object)BimServiceImpl.safeDiv(255, 255));
        yellow.add((Object)BimServiceImpl.safeDiv(193, 255));
        yellow.add((Object)BimServiceImpl.safeDiv(57, 255));
        colors.put("yellow", (Object)yellow);
        JSONArray green = new JSONArray();
        green.add((Object)BimServiceImpl.safeDiv(51, 255));
        green.add((Object)BimServiceImpl.safeDiv(196, 255));
        green.add((Object)BimServiceImpl.safeDiv(90, 255));
        colors.put("green", (Object)green);
        JSONArray white = new JSONArray();
        white.add((Object)BimServiceImpl.safeDiv(242, 255));
        white.add((Object)BimServiceImpl.safeDiv(242, 255));
        white.add((Object)BimServiceImpl.safeDiv(242, 255));
        colors.put("white", (Object)white);
        return colors;
    }

    private static BigDecimal safeDiv(Integer num1, Integer num2) {
        return BimServiceImpl.safeDiv(new BigDecimal(num1.toString()), new BigDecimal(num2.toString()));
    }

    private static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal(0);
        }
        return decimal1.divide(decimal2, 18, 4);
    }

    private static ItemVO getItems(JSONObject json, Map<String, String> items, Integer index) {
        String Guid = null;
        if (StringUtils.isNotEmpty((CharSequence)json.getString("Guid"))) {
            Guid = index != null ? encoder.encodeToString((index + "." + json.getString("Guid")).getBytes()) : encoder.encodeToString(json.getString("Guid").getBytes());
            items.put(Guid, Guid);
        }
        ArrayList<ItemVO> children = new ArrayList<ItemVO>();
        if (json.containsKey((Object)"Children")) {
            for (Object o : json.getJSONArray("Children")) {
                ItemVO child = BimServiceImpl.getItems(JSONObject.parseObject((String)o.toString()), items, index);
                child.setParentId(Guid);
                children.add(child);
            }
        }
        ItemVO vo = new ItemVO();
        vo.setUid(Guid);
        vo.setChildren(children);
        return vo;
    }

    @Override
    public Boolean connect(BimConnectVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
        BimEntity bim = super.queryList(queryParam).stream().findAny().orElse(null);
        if (bim == null) {
            return true;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("bim_id", new Parameter("eq", (Object)bim.getId()));
        param.getParams().put("modle", new Parameter("eq", (Object)1));
        List detailList = this.detailService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return true;
        }
        QueryParam execParam = new QueryParam();
        execParam.getParams().put("id", new Parameter("eq", (Object)vo.getExecDetailId()));
        List execList = this.execDetailService.queryList(execParam);
        if (CollectionUtils.isEmpty((Collection)execList)) {
            return true;
        }
        ExecPlanDetailEntity exec = (ExecPlanDetailEntity)((Object)execList.get(0));
        BimDetailEntity model = (BimDetailEntity)((Object)detailList.get(0));
        QueryParam bimParam = new QueryParam();
        bimParam.getParams().put("execDetailId", new Parameter("eq", (Object)vo.getExecDetailId()));
        bimParam.getParams().put("bimDetailId", new Parameter("eq", (Object)model.getId()));
        List list = this.bimExecService.queryList(bimParam);
        BimDetailExecEntity entity = new BimDetailExecEntity();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity = (BimDetailExecEntity)((Object)list.get(0));
        }
        if (vo.getState().booleanValue()) {
            entity.setBimId(model.getBimId());
            entity.setBimDetailId(model.getId());
            entity.setName(model.getName());
            entity.setPath(model.getPath());
            entity.setExecId(exec.getProgressId());
            entity.setExecDetailId(vo.getExecDetailId());
            entity.setBimIds(vo.getBimIds());
            this.bimExecService.saveOrUpdate((Object)entity);
        } else if (entity.getId() != null) {
            this.bimExecService.removeById(entity.getId());
        }
        QueryParam bimParam2 = new QueryParam();
        bimParam2.getParams().put("bimId", new Parameter("eq", (Object)bim.getId()));
        List list2 = this.bimExecService.queryList(bimParam2);
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            bim.setState(1);
            model.setState(1);
        } else {
            bim.setState(0);
            model.setState(0);
        }
        this.detailService.saveOrUpdate((Object)model);
        super.saveOrUpdate((Object)bim);
        return true;
    }

    @Override
    public Boolean oneUnConnect(Long bimDetailId) {
        QueryParam bimParam = new QueryParam();
        bimParam.getParams().put("bimDetailId", new Parameter("eq", (Object)bimDetailId));
        List list = this.bimExecService.queryList(bimParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.bimExecService.removeByIds(ids);
        }
        BimDetailEntity model = (BimDetailEntity)((Object)this.detailService.selectById(bimDetailId));
        model.setState(0);
        this.detailService.saveOrUpdate((Object)model);
        BimEntity bim = (BimEntity)((Object)super.selectById((Serializable)model.getBimId()));
        bim.setState(0);
        super.saveOrUpdate((Object)bim);
        return true;
    }

    @Override
    public Boolean batchDownload(List<BimDetailVO> vos, HttpServletResponse response) {
        String fileName = StringUtils.defaultString((String)"\u9644\u4ef6\u5305") + ".zip";
        try {
            TreeMap<String, byte[]> fileBytes = new TreeMap<String, byte[]>();
            BufferedInputStream inputStream = null;
            OutputStream out = null;
            HashMap<String, Integer> fileNames = new HashMap<String, Integer>();
            for (int i = 0; i < vos.size(); ++i) {
                BimDetailVO vo = vos.get(i);
                String filName = vo.getName() + "." + vo.getFormat();
                if (fileNames.get(filName) != null) {
                    Integer size = (Integer)fileNames.get(filName) + 1;
                    filName = filName.replace(".", "(" + fileNames.get(filName) + ").");
                    fileNames.put(filName, size);
                } else {
                    fileNames.put(filName, 1);
                }
                try {
                    String path = "/data/dxystorage" + File.separator + vo.getPath();
                    this.logger.info("\u6587\u4ef6\u5730\u5740\uff1a{}", (Object)path);
                    File file = new File(System.getProperty("user.dir") + path);
                    byte[] bytes = null;
                    if (!file.exists()) {
                        String content = TokenHelper.download(vo.getModleId());
                        bytes = content.getBytes();
                    } else {
                        FileInputStream in = new FileInputStream(System.getProperty("user.dir") + path);
                        inputStream = new BufferedInputStream(in);
                        out = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)inputStream, (OutputStream)out);
                        bytes = ((ByteArrayOutputStream)out).toByteArray();
                    }
                    fileBytes.put(filName, bytes);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                    throw new BusinessException(filName + "\u4e0b\u8f7d\u5931\u8d25");
                }
                finally {
                    if (out != null) {
                        try {
                            out.flush();
                            ((ByteArrayOutputStream)out).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            response.reset();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            ZipCompress zipCompress = new ZipCompress((OutputStream)outputStream);
            zipCompress.compress(fileBytes);
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u6279\u91cf\u6587\u4ef6\u4e0b\u8f09\u5931\u8d25\uff0cMsg\uff1a" + e.getMessage());
        }
        return true;
    }

    @Override
    public String getViewerToken(String fileId, String path) {
        String key = "VIEWER_TOKEN:" + fileId;
        Object viewerToken = CacheHelper.get(key);
        if (viewerToken == null) {
            TokenHelper.getViewerToken(fileId);
            viewerToken = CacheHelper.get(key);
            return String.valueOf(viewerToken);
        }
        JSONObject json = TokenHelper.getViewerStatus(path, String.valueOf(viewerToken));
        if (json != null && json.containsKey((Object)"code") && json.getInteger("code") != 0) {
            TokenHelper.getViewerToken(fileId);
            viewerToken = CacheHelper.get(key);
        }
        return String.valueOf(viewerToken);
    }

    @Override
    public Map<Long, String> getBimIdsMap(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List bimList = super.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)bimList)) {
            return new HashMap<Long, String>();
        }
        BimEntity entity = (BimEntity)((Object)super.selectById((Serializable)((BimEntity)((Object)bimList.get(0))).getId()));
        List modelList = entity.getDetailList().stream().filter(x -> x.getModle() != null && x.getModle() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(modelList)) {
            return new HashMap<Long, String>();
        }
        List execList = this.execService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)projectId));
        if (CollectionUtils.isEmpty((Collection)execList)) {
            return new HashMap<Long, String>();
        }
        QueryParam bimParam = new QueryParam();
        bimParam.getParams().put("exec_id", new Parameter("eq", (Object)((ExecPlanEntity)((Object)execList.get(0))).getId()));
        bimParam.getParams().put("bimDetailId", new Parameter("eq", (Object)((BimDetailEntity)((Object)modelList.get(0))).getId()));
        List list = this.bimExecService.queryList(bimParam);
        Map<Long, String> bimIdsMap = list.stream().collect(Collectors.toMap(BimDetailExecEntity::getExecDetailId, BimDetailExecEntity::getBimIds));
        return bimIdsMap;
    }

    @Override
    public Map<Long, String> getContentMap(Long id) {
        ExecPlanEntity exec = (ExecPlanEntity)((Object)this.execService.getById(id));
        if (exec == null) {
            return new HashMap<Long, String>();
        }
        Integer value = this.getParamValue(exec.getPlanBeginDate(), exec.getPlanEndDate());
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)exec.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.execDetailService.list((Wrapper)ew);
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (ExecPlanDetailEntity detail : detailList) {
            String content;
            if (new Integer(2).equals(detail.getFinishState())) {
                if (DateUtil.compareDate(detail.getActualStart(), detail.getPlanStart()) > 0) {
                    if (!ComputeUtil.isGreaterThan((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) continue;
                    content = this.getContentByState(detail.getDiffValue(), 1);
                    map.put(detail.getId(), content);
                    continue;
                }
                if (!ComputeUtil.isGreaterThan((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) continue;
                content = this.getContentByState(detail.getDiffValue(), 0);
                map.put(detail.getId(), content);
                continue;
            }
            if (value == 0 || DateUtil.compareDate(detail.getPlanStart(), DateUtil.addDays(new Date(), value)) > 0 || !ComputeUtil.isGreaterThan((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) continue;
            content = this.getContentByState(detail.getDiffValue(), 2);
            map.put(detail.getId(), content);
        }
        return map;
    }

    private Map<String, JSONObject> getItemJSONMap(List<String> paths) {
        Future future;
        if (CollectionUtils.isEmpty(paths)) {
            return new HashMap<String, JSONObject>();
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(paths.size() > 30 ? 30 : paths.size());
        HashMap<String, Future> futureMap = new HashMap<String, Future>();
        for (String string : paths) {
            BimCallable callable = new BimCallable(string);
            future = threadPool.submit(callable);
            futureMap.put(string, future);
        }
        HashMap<String, JSONObject> itemMap = new HashMap<String, JSONObject>();
        try {
            for (String path : futureMap.keySet()) {
                future = (Future)futureMap.get(path);
                JSONObject json = (JSONObject)future.get(30L, TimeUnit.SECONDS);
                itemMap.put(path, json);
            }
        }
        catch (Exception exception) {
            throw new BusinessException(exception.getMessage());
        }
        finally {
            threadPool.shutdown();
        }
        return itemMap;
    }

    public static void main(String[] args) {
        String id = "\u5468\u8fb9\u573a\u5730 \u73b0\u573a\u5de5\u51b5 Root 11";
        if (id.endsWith("Root 11")) {
            id = id.replace("Root 11", "Root 9");
        }
        System.out.println(id);
    }

    static class BimCallable
    implements Callable<JSONObject> {
        private String path;

        public BimCallable(String path) {
            this.path = path;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject json = TokenHelper.getFileTree(this.path);
            return json;
        }
    }
}

