/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fill.bean.DelnyTrendEntity;
import com.ejianc.business.fill.cons.FillConstant;
import com.ejianc.business.fill.emum.LightRuleLevelEnum;
import com.ejianc.business.fill.mapper.DelnyTrendMapper;
import com.ejianc.business.fill.service.IDelnyTrendService;
import com.ejianc.business.fill.service.IWarnService;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="delnyTrendService")
public class DelnyTrendServiceImpl
extends BaseServiceImpl<DelnyTrendMapper, DelnyTrendEntity>
implements IDelnyTrendService {
    @Autowired
    private IWarnService warnService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;

    @Override
    public Boolean execPlanDetailTrend(List<ExecPlanEntity> execList, Map<Long, LightRuleEntity> projectLightRuleMap) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ExecPlanEntity execPlanEntity : execList) {
            List<ExecPlanDetailEntity> details = execPlanEntity.getAllList();
            for (ExecPlanDetailEntity detailEntity : details) {
                ids.add(detailEntity.getId());
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());
        ArrayList list = ids.size() > 0 ? ((DelnyTrendMapper)this.baseMapper).getNearTorday(ids, today) : new ArrayList();
        ArrayList todayList = ids.size() > 0 ? ((DelnyTrendMapper)this.baseMapper).getTodayTorday(ids, today) : new ArrayList();
        HashMap<Long, DelnyTrendEntity> nearMap = new HashMap<Long, DelnyTrendEntity>();
        for (Object entity : list) {
            nearMap.put(((DelnyTrendEntity)((Object)entity)).getExecBid(), (DelnyTrendEntity)((Object)entity));
        }
        HashMap<Long, DelnyTrendEntity> todayMap = new HashMap<Long, DelnyTrendEntity>();
        if (todayList != null && todayList.size() > 0) {
            for (DelnyTrendEntity entity : todayList) {
                todayMap.put(entity.getExecBid(), entity);
            }
        }
        ArrayList<DelnyTrendEntity> saveOrUpdate = new ArrayList<DelnyTrendEntity>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (ExecPlanEntity execPlanEntity : execList) {
            LightRuleLevelEntity lightRuleLevel = this.warnService.getLightRuleLevel(projectLightRuleMap, execPlanEntity.getProjectId(), LightRuleLevelEnum.\u91cc\u7a0b\u7891\u8282\u70b9\u9884\u8b66.getCode());
            List execPlanDetails = execPlanEntity.getAllList().stream().filter(e -> PlanConstant.LEVEL_CONTRACT == e.getNodeLevel()).collect(Collectors.toList());
            for (ExecPlanDetailEntity ypd : execPlanDetails) {
                Integer status = null;
                if (null == ypd.getActualStart() && null == ypd.getActualFinish()) {
                    status = FillConstant.NOT_STAR;
                }
                if (null != ypd.getActualStart() && null != ypd.getPredictFinish() && null == ypd.getActualFinish()) {
                    status = FillConstant.UNDERWAY;
                }
                if (null != ypd.getActualStart() && null != ypd.getActualFinish()) {
                    status = FillConstant.FINISHED;
                }
                Integer diffValueInt = DateUtil.getBetweenDays(ypd.getPredictFinish(), ypd.getPlanFinish());
                BigDecimal diffValue = new BigDecimal(diffValueInt);
                BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(ypd.getPredictFinish(), new Date()));
                BigDecimal finalValue = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)diffValue, (BigDecimal)residueValue), (BigDecimal)new BigDecimal(100));
                Integer lightType = null;
                if (null != lightRuleLevel) {
                    lightType = this.warnService.getLightType(lightRuleLevel, diffValue, finalValue, true, status);
                }
                if (todayMap.containsKey(ypd.getId())) {
                    DelnyTrendEntity todayEntity = (DelnyTrendEntity)((Object)todayMap.get(ypd.getId()));
                    if (nearMap.containsKey(ypd.getId())) {
                        DelnyTrendEntity nearEntity = (DelnyTrendEntity)((Object)nearMap.get(ypd.getId()));
                        if (nearEntity.getDiffValue().compareTo(diffValue) == 0 && nearEntity.getCorpLightType() == lightType) {
                            delIds.add(todayEntity.getId());
                            continue;
                        }
                        todayEntity.setDiffValue(diffValue);
                        todayEntity.setCorpLightType(lightType);
                        saveOrUpdate.add(todayEntity);
                        continue;
                    }
                    todayEntity.setDiffValue(diffValue);
                    todayEntity.setCorpLightType(lightType);
                    saveOrUpdate.add(todayEntity);
                    continue;
                }
                if (nearMap.containsKey(ypd.getId())) {
                    DelnyTrendEntity nearEntity = (DelnyTrendEntity)((Object)nearMap.get(ypd.getId()));
                    if (nearEntity.getDiffValue().compareTo(diffValue) == 0 && nearEntity.getCorpLightType() == lightType) continue;
                    DelnyTrendEntity entity = new DelnyTrendEntity();
                    entity.setExecId(ypd.getProgressId());
                    entity.setExecBid(ypd.getId());
                    entity.setUpdateDate(today);
                    entity.setDiffValue(diffValue);
                    entity.setCorpLightType(lightType);
                    saveOrUpdate.add(entity);
                    continue;
                }
                DelnyTrendEntity entity = new DelnyTrendEntity();
                entity.setExecId(ypd.getProgressId());
                entity.setExecBid(ypd.getId());
                entity.setUpdateDate(today);
                entity.setDiffValue(diffValue);
                entity.setCorpLightType(lightType);
                saveOrUpdate.add(entity);
            }
        }
        if (saveOrUpdate.size() > 0) {
            super.saveOrUpdateBatch(saveOrUpdate, saveOrUpdate.size(), false);
        }
        if (delIds.size() > 0) {
            super.removeByIds(delIds, false);
        }
        return true;
    }

    @Override
    public JSONObject monthDelnyTrend(Long id) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        String thisMonth = df.format(new Date());
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<BigDecimal> valueList = new ArrayList<BigDecimal>();
        List<DelnyTrendEntity> entityList = ((DelnyTrendMapper)this.baseMapper).monthTrend(id, thisMonth);
        for (DelnyTrendEntity dte : entityList) {
            keyList.add(dte.getUpdateDate());
            valueList.add(dte.getDiffValue());
        }
        keyList.add(thisMonth);
        valueList.add(this.getTodayDiffValue(id));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }

    @Override
    public JSONObject weekDelnyTrend(Long id) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(DelnyTrendEntity::getExecBid, (Object)id);
        lambda.orderByAsc(DelnyTrendEntity::getUpdateDate);
        List entityList = super.list((Wrapper)lambda);
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<BigDecimal> valueList = new ArrayList<BigDecimal>();
        if (entityList == null || entityList.size() <= 0) {
            keyList.add(today);
            valueList.add(this.getTodayDiffValue(id));
            jsonObject.put("key", keyList);
            jsonObject.put("value", valueList);
            return jsonObject;
        }
        String startDate = ((DelnyTrendEntity)((Object)entityList.get(0))).getUpdateDate();
        BigDecimal diffValue = ((DelnyTrendEntity)((Object)entityList.get(0))).getDiffValue();
        LinkedHashMap<String, BigDecimal> entityMap = new LinkedHashMap<String, BigDecimal>();
        LinkedHashMap<String, BigDecimal> fullMap = new LinkedHashMap<String, BigDecimal>();
        for (DelnyTrendEntity pte : entityList) {
            entityMap.put(pte.getUpdateDate(), pte.getDiffValue());
        }
        while (DateUtil2.compareTime(startDate, today) <= 0) {
            if (entityMap.containsKey(startDate)) {
                diffValue = (BigDecimal)entityMap.get(startDate);
            }
            fullMap.put(startDate, diffValue);
            startDate = DateUtil2.dateAdd(df, startDate, 1);
        }
        String start = DateUtil2.getWeekOfMonthStartDate(df, 24);
        LinkedHashMap<String, BigDecimal> weekMap = new LinkedHashMap<String, BigDecimal>();
        Map<String, BigDecimal> resMap = new LinkedHashMap<String, BigDecimal>();
        int i = 1;
        while (DateUtil2.compareTime(start, today) <= 0) {
            if (fullMap.containsKey(start)) {
                BigDecimal bvalue = (BigDecimal)fullMap.get(start);
                weekMap.put(start, bvalue);
            }
            if (DateUtil2.compareTime(start = DateUtil2.dateAdd(df, start, 1), today) == 0) {
                resMap.put(today, this.getTodayDiffValue(id));
            } else if (i == 7) {
                i = 0;
                if (weekMap.size() > 0) {
                    resMap = this.maxWeekMap(weekMap, resMap);
                    weekMap = new LinkedHashMap();
                }
            }
            ++i;
        }
        for (String date : resMap.keySet()) {
            BigDecimal b = (BigDecimal)resMap.get(date);
            keyList.add(date);
            valueList.add(b);
        }
        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }

    private Map<String, BigDecimal> maxWeekMap(Map<String, BigDecimal> weekMap, Map<String, BigDecimal> resMap) {
        String d = weekMap.keySet().iterator().next();
        BigDecimal a = weekMap.get(d);
        for (String date : weekMap.keySet()) {
            BigDecimal b = weekMap.get(date);
            if (b.compareTo(a) <= 0) continue;
            a = b;
            d = date;
        }
        resMap.put(d, a);
        return resMap;
    }

    private BigDecimal getTodayDiffValue(Long id) {
        ExecPlanDetailEntity execPlanDetailEntity = (ExecPlanDetailEntity)((Object)this.execPlanDetailService.selectById(id));
        BigDecimal diffValue = new BigDecimal(DateUtil.getBetweenDays(execPlanDetailEntity.getPredictFinish(), execPlanDetailEntity.getPlanFinish()));
        return diffValue;
    }
}

