/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bim.bean.BimDetailExecEntity;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.fill.util.PageUtil;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.TotalPlanEntity;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.utils.SeparatorUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.DetailListUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"execPlan"})
public class ExecPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectApi;
    @Autowired
    private IExecPlanService service;
    @Autowired
    private IExecPlanDetailService detailService;
    @Autowired
    private IBimDetailExecService bimExecService;
    @Autowired
    private ITotalPlanService totalService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExecPlanVO> saveOrUpdate(@RequestBody ExecPlanVO saveOrUpdateVO) {
        ExecPlanVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> queryDetail(Long id) {
        ExecPlanVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExecPlanVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        this.detailService.remove((Wrapper)new QueryWrapper().in((Object)"progress_id", ids));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExecPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExecPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refExecPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExecPlanVO>> refExecPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExecPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refExecPlanDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> refExecPlanDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="planState", required=false) Integer planState, @RequestParam(value="startDate", required=false) Date startDate, @RequestParam(value="endDate", required=false) Date endDate) {
        ExecPlanVO vo = this.service.queryRefDetail(projectId, planState, startDate, endDate);
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/refExecPlanBimDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> refExecPlanBimDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="planState", required=false) Integer planState, @RequestParam(value="startDate", required=false) Date startDate, @RequestParam(value="endDate", required=false) Date endDate, @RequestParam(value="bimDetailId") Long bimDetailId) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"project_id", (Object)projectId);
        ExecPlanEntity entity = (ExecPlanEntity)((Object)this.service.getOne((Wrapper)ew));
        ExecPlanVO vo = new ExecPlanVO();
        if (entity != null) {
            vo = this.service.queryDetail(entity.getId());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("exec_id", new Parameter("eq", (Object)vo.getId()));
        param.getParams().put("bimDetailId", new Parameter("eq", (Object)bimDetailId));
        List execList = this.bimExecService.queryList(param);
        Map<Long, BimDetailExecEntity> execMap = execList.stream().collect(Collectors.toMap(BimDetailExecEntity::getExecDetailId, x -> x));
        List<ExecPlanDetailVO> detailList = TreeHelper2.tree2List(vo.getProgressDetailList());
        if (CollectionUtils.isNotEmpty(detailList)) {
            ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
            for (ExecPlanDetailVO detail : detailList) {
                detail.setState(Integer.valueOf(0));
                if (execMap.containsKey(Long.valueOf(detail.getUid()))) {
                    detail.setBimIds(execMap.get(Long.valueOf(detail.getUid())).getBimIds());
                    detail.setState(Integer.valueOf(1));
                }
                detailVOList.add(detail);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6e05\u5355\u53c2\u7167\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getxml"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return this.service.getxml(request);
    }

    @RequestMapping(value={"/exportxml"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        this.service.exportxml(response, vo);
    }

    @RequestMapping(value={"/pushExecPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlan(@RequestParam(value="id") Long id, @RequestParam(value="planState") Integer planState) {
        ExecPlanEntity vo = this.service.pushExecPlan(id, planState);
        return CommonResponse.success((String)"\u63a8\u9001\u6267\u884c\u8ba1\u5212\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/pushExecPlanRollBack"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanEntity> pushExecPlanRollBack(@RequestParam(value="id") Long id, @RequestParam(value="planState") Integer planState) {
        ExecPlanEntity vo = this.service.pushExecPlanRollBack(id, planState);
        return CommonResponse.success((String)"\u63a8\u9001\u6267\u884c\u8ba1\u5212\u56de\u9000\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/validateProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateProject(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateProject(projectId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/initTable"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initTable() {
        String msg = this.service.initTable();
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/referExecPlanDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExecPlanVO> referExecPlanDetail(@RequestParam(value="projectId") Long projectId, @RequestParam(value="fillUserId") Long fillUserId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        ExecPlanEntity entity = this.service.queryList(param).stream().findFirst().orElse(new ExecPlanEntity());
        if (entity.getId() == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6267\u884c\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.detailService.list((Wrapper)ew);
        List actualList = detailList.stream().filter(x -> x.getActualStart() != null).collect(Collectors.toList());
        HashMap<Long, ExecPlanDetailEntity> preMap = new HashMap<Long, ExecPlanDetailEntity>();
        for (ExecPlanDetailEntity actual : actualList) {
            List preList = TreeUtils.getPreLinkList(detailList, actual.getStructCode());
            if (CollectionUtils.isEmpty(preList)) continue;
            preMap.putAll(preList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x)));
        }
        List leafList = DetailListUtil.getLeafList(detailList);
        leafList = leafList.stream().filter(x -> new Integer(1).equals(x.getFinishState()) && fillUserId.equals(x.getEmployeeId())).collect(Collectors.toList());
        leafList = leafList.stream().filter(x -> !preMap.containsKey(x.getId())).collect(Collectors.toList());
        Set structCodes = leafList.stream().flatMap(x -> SeparatorUtil.substringPre(x.getStructCode()).stream()).collect(Collectors.toSet());
        List result = detailList.stream().filter(x -> structCodes.contains(x.getStructCode())).collect(Collectors.toList());
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)entity), ExecPlanVO.class);
        if (CollectionUtils.isNotEmpty(result)) {
            ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
            for (ExecPlanDetailEntity detail : result) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryContractList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExecPlanDetailVO>> queryContractList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("orgId")) {
            orgId = Long.valueOf(String.valueOf(((Parameter)param.getParams().get("orgId")).getValue()));
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param, false);
        Map<Long, ExecPlanEntity> map = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        ArrayList<ExecPlanDetailVO> array = new ArrayList<ExecPlanDetailVO>();
        if (CollectionUtils.isNotEmpty(map.keySet())) {
            QueryWrapper ew = new QueryWrapper();
            ew.in((Object)"progress_id", new ArrayList<Long>(map.keySet()));
            ew.eq((Object)"node_level", (Object)4);
            List detailList = this.detailService.list((Wrapper)ew);
            for (ExecPlanDetailEntity detail : detailList) {
                ExecPlanDetailVO vo = ExecPlanDetailEntity.convertEntityToVo(detail);
                vo.setProjectName(map.get(detail.getProgressId()).getProjectName());
                array.add(vo);
            }
        }
        List projectIds = list.stream().map(ExecPlanEntity::getProjectId).distinct().collect(Collectors.toList());
        Map<Object, Object> totalMap = new HashMap();
        if (CollectionUtils.isNotEmpty(projectIds)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("in", projectIds));
            List totalList = this.totalService.queryList(queryParam, false);
            totalMap = totalList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x));
        }
        int current = param.getPageIndex();
        int size = param.getPageSize();
        int total = array.size();
        Page pageData = new Page((long)current, (long)size, (long)total);
        List<ExecPlanDetailVO> records = PageUtil.listToPage(array, current, size);
        for (ExecPlanDetailVO vo : records) {
            if (!totalMap.containsKey(vo.getProjectUID())) continue;
            vo.setTotalPlanId(((TotalPlanEntity)((Object)totalMap.get(vo.getProjectUID()))).getId());
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

