/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.utils.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class DurationUtil {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static JSONObject getCalender(String calendars, String calenderUid) {
        JSONArray json = JSONArray.parseArray((String)calendars);
        JSONObject calender = (JSONObject)json.stream().filter(x -> calenderUid.equals(((JSONObject)x).getString("UID"))).findAny().orElse(new Object());
        return calender;
    }

    public static Integer calculateDuration(Date start, Date finish, JSONObject calender) {
        Integer period = DateUtil.getBetweenDays(finish, start);
        JSONArray WeekDays = new JSONArray();
        if (calender.containsKey((Object)"WeekDays")) {
            WeekDays = calender.getJSONArray("WeekDays");
        }
        JSONArray Exceptions = new JSONArray();
        if (calender.containsKey((Object)"Exceptions")) {
            Exceptions = calender.getJSONArray("Exceptions");
        }
        Integer duration = 1;
        Calendar cal = Calendar.getInstance();
        Date date = start;
        for (int i = 0; i < period; ++i) {
            date = DateUtil.addDays(start, i);
            cal.setTime(date);
            Integer DAY_OF_WEEK = DateUtil.turnZnDayOfWeek(cal.get(7));
            for (Object obj : WeekDays) {
                Integer DayType = ((JSONObject)obj).getInteger("DayType");
                if (!DayType.equals(DAY_OF_WEEK)) continue;
                Integer DayWorking = ((JSONObject)obj).getInteger("DayWorking");
                if (DayWorking == 1) {
                    duration = duration + 1;
                }
                for (Object exception : Exceptions) {
                    JSONObject TimePeriod = ((JSONObject)exception).getJSONObject("TimePeriod");
                    Date FromDate = DurationUtil.utc2Local(TimePeriod.getString("FromDate"));
                    Date ToDate = DurationUtil.utc2Local(TimePeriod.getString("ToDate"));
                    Integer ExcWorking = ((JSONObject)exception).getInteger("DayWorking");
                    if (FromDate.getHours() == 8) {
                        FromDate = DurationUtil.utc2Local(TimePeriod.getString("FromDate"));
                        ToDate = DurationUtil.utc2Local(TimePeriod.getString("ToDate"));
                    }
                    if (DateUtil.compareDate(date, FromDate) < 0 || DateUtil.compareDate(date, ToDate) > 0) continue;
                    if (DayWorking == 1 && ExcWorking == 0) {
                        duration = duration - 1;
                        continue;
                    }
                    if (DayWorking != 0 || ExcWorking != 1) continue;
                    duration = duration + 1;
                }
            }
        }
        return duration;
    }

    public static Date calculateFinish(Date start, Integer period, JSONObject calender) {
        JSONArray WeekDays = new JSONArray();
        if (calender.containsKey((Object)"WeekDays")) {
            WeekDays = calender.getJSONArray("WeekDays");
        }
        JSONArray Exceptions = new JSONArray();
        if (calender.containsKey((Object)"Exceptions")) {
            Exceptions = calender.getJSONArray("Exceptions");
        }
        Integer duration = 1;
        Calendar cal = Calendar.getInstance();
        Date date = start;
        int i = 0;
        while (duration <= period) {
            date = DateUtil.addDays(start, i);
            cal.setTime(date);
            Integer DAY_OF_WEEK = DateUtil.turnZnDayOfWeek(cal.get(7));
            for (Object obj : WeekDays) {
                Integer DayType = ((JSONObject)obj).getInteger("DayType");
                if (!DayType.equals(DAY_OF_WEEK)) continue;
                Integer DayWorking = ((JSONObject)obj).getInteger("DayWorking");
                if (DayWorking == 1) {
                    duration = duration + 1;
                }
                for (Object exception : Exceptions) {
                    JSONObject TimePeriod = ((JSONObject)exception).getJSONObject("TimePeriod");
                    Date FromDate = DurationUtil.utc2Local(TimePeriod.getString("FromDate"));
                    Date ToDate = DurationUtil.utc2Local(TimePeriod.getString("ToDate"));
                    Integer ExcWorking = ((JSONObject)exception).getInteger("DayWorking");
                    if (FromDate.getHours() == 8) {
                        FromDate = DurationUtil.utc2Local(TimePeriod.getString("FromDate"));
                        ToDate = DurationUtil.utc2Local(TimePeriod.getString("ToDate"));
                    }
                    if (DateUtil.compareDate(date, FromDate) < 0 || DateUtil.compareDate(date, ToDate) > 0) continue;
                    if (DayWorking == 1 && ExcWorking == 0) {
                        duration = duration - 1;
                        continue;
                    }
                    if (DayWorking != 0 || ExcWorking != 1) continue;
                    duration = duration + 1;
                }
            }
            ++i;
        }
        Date finish = DateUtil.setHours(date, 17);
        return finish;
    }

    public static Date getConstraintDate(Date start, Date finish, Integer constraintType) {
        if (constraintType == 2 || constraintType == 4 || constraintType == 5) {
            return start;
        }
        if (constraintType == 3 || constraintType == 6 || constraintType == 7) {
            return finish;
        }
        return start;
    }

    public static String resetCalender(String calendars) {
        JSONArray json = JSONArray.parseArray((String)calendars);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        for (Object obj : json) {
            JSONObject calender = (JSONObject)obj;
            JSONArray Exceptions = new JSONArray();
            if (calender.containsKey((Object)"Exceptions")) {
                Exceptions = calender.getJSONArray("Exceptions");
            }
            for (Object obj2 : Exceptions) {
                JSONObject TimePeriod = ((JSONObject)obj2).getJSONObject("TimePeriod");
                Date FromDate = TimePeriod.getDate("FromDate");
                Date ToDate = TimePeriod.getDate("ToDate");
                if (FromDate.getHours() != 0) continue;
                TimePeriod.put("FromDate", (Object)(sdf.format(FromDate) + ".000Z"));
                TimePeriod.put("ToDate", (Object)(sdf.format(ToDate) + ".000Z"));
            }
        }
        return json.toJSONString();
    }

    public static Date utc2Local(String time) {
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static void main(String[] args) {
        String calendars = "[{\"UID\":\"1\",\"WeekDays\":[{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":1,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":2,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":3,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":4,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":5,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":6,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":7,\"DayWorking\":1}],\"Exceptions\":[{\"TimePeriod\":{\"FromDate\":\"2024-02-05T00:00:00.000Z\",\"ToDate\":\"2024-02-25T23:59:00.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2023\u5e74\u6625\u8282\"}],\"IsBaseCalendar\":1,\"BaseCalendarUID\":\"-1\",\"Name\":\"\u6807\u51c6\"}]";
        String calenderUid = "1";
        JSONObject calender = DurationUtil.getCalender(calendars, calenderUid);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date start = null;
        Date finish = null;
        try {
            start = sdf.parse("2024-01-01");
            finish = sdf.parse("2024-03-21");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Integer duration = DurationUtil.calculateDuration(start, finish, calender);
        System.out.println(duration);
        Date date = DurationUtil.calculateFinish(start, 1, calender);
        System.out.println(DateUtil.formatSeconds(date));
    }
}

