/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.WeekPlanDetailEntity;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.cons.PlanCloumCons;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.mapper.WeekPlanDetailMapper;
import com.ejianc.business.plan.mapper.WeekPlanMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.Export;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.WeekPlanDetailVO;
import com.ejianc.business.plan.vo.WeekPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="weekPlanService")
public class WeekPlanServiceImpl
extends BaseServiceImpl<WeekPlanMapper, WeekPlanEntity>
implements IWeekPlanService {
    @Autowired
    private IWeekPlanDetailService detailService;
    @Autowired
    private WeekPlanMapper progressMapper;
    @Autowired
    private WeekPlanDetailMapper progressDetailMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private CommonHelper commonHelper;
    private static final String BILL_CODE = "ZJKJ_WEEK_PLAN";

    @Override
    public CommonResponse<WeekPlanVO> saveOrUpdate(WeekPlanVO saveOrUpdateVO) {
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
        this.commonHelper.validatePredecessorLink(saveOrUpdateVO.getTasks(), saveOrUpdateVO.getProjectId());
        this.queryMonthPlan(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getPlanMonth());
        OrgVO orgVO = this.orgUtil.findById(saveOrUpdateVO.getOrgId());
        saveOrUpdateVO.setCorpId(orgVO.getId());
        saveOrUpdateVO.setCorpCode(orgVO.getCode());
        saveOrUpdateVO.setCorpName(orgVO.getName());
        Long tenantId = InvocationInfoProxy.getTenantid();
        WeekPlanEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            progressEntity = (WeekPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WeekPlanEntity.class));
            this.progressMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.detailService.deleteByProgressId(progressEntity.getId());
                }
                Iterator iterator = saveVOList.iterator();
                while (iterator.hasNext()) {
                    WeekPlanDetailEntity progressDetailEntity;
                    WeekPlanDetailVO progressDetailVo = (WeekPlanDetailVO)iterator.next();
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = WeekPlanDetailEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        this.progressDetailMapper.insert((Object)progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = WeekPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    this.progressDetailMapper.updateById((Object)progressDetailEntity);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (WeekPlanDetailVO progressDetailVo : delDetailList) {
                    this.progressDetailMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            Long masterPkId = IdWorker.getId();
            if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveOrUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            progressEntity = (WeekPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WeekPlanEntity.class));
            progressEntity.setId(masterPkId);
            progressEntity.setChangeVersion(1);
            progressEntity.setChangeStatus(PlanConstant.CHANGE_NO);
            this.progressMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, true);
                for (WeekPlanDetailVO progressDetailVo : saveVOList) {
                    WeekPlanDetailEntity progressDetailEntity = WeekPlanDetailEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    this.progressDetailMapper.insert((Object)progressDetailEntity);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(saveOrUpdateVO.getBillState())) {
            this.execPlanService.updateExecPlan(saveOrUpdateVO.getId(), PlanConstant.WEEK_PLAN);
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public WeekPlanVO queryDetail(Long id) {
        WeekPlanEntity entity = (WeekPlanEntity)((Object)((WeekPlanMapper)this.baseMapper).selectById(id));
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)id);
        ew.orderByAsc((Object)"tid");
        List detailList = this.detailService.list((Wrapper)ew);
        WeekPlanVO vo = (WeekPlanVO)BeanMapper.map((Object)((Object)entity), WeekPlanVO.class);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList<WeekPlanDetailVO> detailVOList = new ArrayList<WeekPlanDetailVO>();
            for (WeekPlanDetailEntity detail : detailList) {
                detailVOList.add(WeekPlanDetailEntity.convertEntityToVo(detail));
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return vo;
    }

    @Override
    public Map getDetail(Long id) {
        WeekPlanVO vo = this.queryDetail(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List detailList = vo.getProgressDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            HashMap<String, Long> pkMap = new HashMap<String, Long>();
            ArrayList saveVOList = new ArrayList();
            TreeHelper2.tree2List(pkMap, saveVOList, detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List list = JSONObject.parseArray((String)jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") == null) continue;
                List link = JSONObject.parseArray((String)JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                m.put("PredecessorLink", link);
            }
            this.key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", null);
        }
        map.put("MinutesPerWeek", null);
        String calendars = vo.getCalendars();
        if (StringUtils.isNotBlank((CharSequence)calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", vo.getPlanEndDate());
        map.put("Name", vo.getProjectName());
        map.put("StartDate", vo.getPlanBeginDate());
        map.put("CalendarUID", vo.getCalendarUid());
        map.put("UID", vo.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public String validateProject(Long projectId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u5468\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            file = (MultipartFile)entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            extName = FileUtils.getFileExt((String)(originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_")), (Boolean)false);
            if ("xml".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        HashMap read = PlusUtil.read(file, PlanCloumCons.WEEK_PLAN_CLOUM);
        Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList)read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
        HashMap hashMap = PlusUtil.readMain(read, filed);
        Long projectId = Long.valueOf(request.getParameter("project"));
        String planBeginDate = request.getParameter("planBeginDate");
        String planEndDate = request.getParameter("planEndDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date start = null;
        Date end = null;
        try {
            start = sdf.parse(planBeginDate);
            end = sdf.parse(planEndDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Object tasks = hashMap.get("Tasks");
        Date startDate = DateUtil.beginOfDate(start);
        Date endDate = DateUtil.endOfDate(end);
        this.commonHelper.getExecClandars(hashMap, projectId);
        Object o = this.execPlanService.converMap(tasks, startDate, endDate, projectId);
        hashMap.put("Tasks", o);
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01", (Object)hashMap);
    }

    @Override
    public String queryMonthPlan(Long projectId, Date planMonth) {
        LocalDate date = LocalDate.now();
        LocalDate firstDayThisMonth = date.withDayOfMonth(1);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        if (planMonth != null) {
            date = planMonth.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withDayOfMonth(1);
            wrapper.eq((Object)"plan_month", (Object)date);
        } else {
            date = firstDayThisMonth;
            wrapper.eq((Object)"plan_month", (Object)date);
        }
        List list = this.monthPlanService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u4e0b\u65e0\u5ba1\u6279\u901a\u8fc7\u7684" + date.getMonthValue() + "\u6708\u4efd\u7684\u6708\u8ba1\u5212\uff0c\u65e0\u6cd5\u65b0\u589e\u5468\u8ba1\u5212!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    private List<Map> key2ValueList(List<Map> list) {
        for (Map map : list) {
            this.key2Value(map, "taskLine", PlanConstant.TASK_LINE);
            this.key2Value(map, "nodeLevel", PlanConstant.NODE_LEVEL);
            this.key2Value(map, "unit", PlanConstant.UNIT);
            this.key2Value(map, "type", PlanConstant.RESOURCE_TYPE);
            this.key2Value(map, "typeUnit", PlanConstant.RESOURCE_UNIT);
        }
        return list;
    }

    private Map key2Value(Map map, String filed, Map<Integer, String> planMap) {
        if (map.get(filed) != null) {
            map.put(filed, planMap.get(Integer.parseInt(map.get(filed).toString())));
        }
        return map;
    }

    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map dataProject = this.getDetail(vo.getId());
        Export.exportExtendedAttributes((HashMap)dataProject);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.TOTAL_PLAN_CLOUM);
    }
}

