/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.YearPlanChangeEntity;
import com.ejianc.business.plan.bean.YearPlanDetailChangeEntity;
import com.ejianc.business.plan.bean.YearPlanDetailEntity;
import com.ejianc.business.plan.bean.YearPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.YearPlanChangeMapper;
import com.ejianc.business.plan.mapper.YearPlanDetailChangeMapper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IYearPlanChangeService;
import com.ejianc.business.plan.service.IYearPlanDetailChangeService;
import com.ejianc.business.plan.service.IYearPlanDetailService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.vo.YearPlanChangeVO;
import com.ejianc.business.plan.vo.YearPlanDetailChangeVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="yearPlanChangeService")
public class YearPlanChangeServiceImpl
extends BaseServiceImpl<YearPlanChangeMapper, YearPlanChangeEntity>
implements IYearPlanChangeService {
    @Autowired
    private YearPlanChangeMapper changeMapper;
    @Autowired
    private YearPlanDetailChangeMapper detailChangeMapper;
    @Autowired
    private IYearPlanDetailChangeService detailChangeService;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IYearPlanDetailService yearPlanDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;

    @Override
    public CommonResponse<YearPlanChangeVO> saveOrUpdate(YearPlanChangeVO saveOrUpdateVO) {
        this.execPlanService.validateProject(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
        Long tenantId = InvocationInfoProxy.getTenantid();
        YearPlanChangeEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            progressEntity = (YearPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, YearPlanChangeEntity.class));
            this.changeMapper.updateById((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());
                if (saveOrUpdateVO.getImportFlag().booleanValue()) {
                    this.detailChangeService.deleteDetailByProgressId(progressEntity.getId());
                }
                List<YearPlanDetailChangeEntity> planEntityList = new ArrayList();
                Iterator iterator = saveVOList.iterator();
                while (iterator.hasNext()) {
                    YearPlanDetailChangeEntity progressDetailEntity;
                    YearPlanDetailChangeVO progressDetailVo = (YearPlanDetailChangeVO)iterator.next();
                    if (saveOrUpdateVO.getImportFlag().booleanValue() || "added".equals(progressDetailVo.get_state())) {
                        progressDetailEntity = YearPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        planEntityList.add(progressDetailEntity);
                        continue;
                    }
                    if (!"modified".equals(progressDetailVo.get_state())) continue;
                    progressDetailEntity = YearPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(progressEntity.getId());
                    this.detailChangeMapper.updateById((Object)progressDetailEntity);
                }
                if (CollectionUtils.isNotEmpty(planEntityList)) {
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    this.detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (YearPlanDetailChangeVO progressDetailVo : delDetailList) {
                    this.detailChangeMapper.deleteById((Serializable)((Object)progressDetailVo.getUid()));
                }
            }
        } else {
            YearPlanEntity totalPlanEntity = (YearPlanEntity)((Object)this.yearPlanService.selectById(saveOrUpdateVO.getYearId()));
            if (totalPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING) {
                throw new BusinessException("\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            Long masterPkId = IdWorker.getId();
            progressEntity = (YearPlanChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, YearPlanChangeEntity.class));
            progressEntity.setId(masterPkId);
            this.changeMapper.insert((Object)progressEntity);
            List progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                HashMap<String, Long> pkMap = new HashMap<String, Long>();
                ArrayList saveVOList = new ArrayList();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, true);
                List<YearPlanDetailChangeEntity> planEntityList = new ArrayList();
                for (YearPlanDetailChangeVO progressDetailVo : saveVOList) {
                    YearPlanDetailChangeEntity progressDetailEntity = YearPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }
                if (CollectionUtils.isNotEmpty(planEntityList)) {
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    this.detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(YearPlanEntity::getChangeId, (Object)progressEntity.getId());
            updateWrapper.set(YearPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_ING);
            updateWrapper.set(YearPlanEntity::getChangeCode, (Object)progressEntity.getBillCode());
            updateWrapper.eq(BaseEntity::getId, (Object)progressEntity.getYearId());
            this.yearPlanService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((Object)this.queryDetail(progressEntity.getId()));
    }

    @Override
    public YearPlanChangeVO queryDetail(Long id) {
        YearPlanChangeEntity progressEntity = (YearPlanChangeEntity)((Object)((YearPlanChangeMapper)this.baseMapper).selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.detailChangeService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        YearPlanChangeVO progressVo = (YearPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), YearPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<YearPlanDetailChangeVO> progressDetailVoList = new ArrayList<YearPlanDetailChangeVO>();
            for (YearPlanDetailChangeEntity progressDetailEntity : progressDetailList) {
                YearPlanDetailChangeVO changeVO = YearPlanDetailChangeEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public YearPlanChangeVO queryDetailChange(Long id) {
        YearPlanEntity progressEntity = (YearPlanEntity)((Object)this.yearPlanService.selectById(id));
        YearPlanChangeVO vo = (YearPlanChangeVO)BeanMapper.map((Object)((Object)progressEntity), YearPlanChangeVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.yearPlanDetailService.list((Wrapper)queryWrapper);
        List<String> useTasks = this.commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<YearPlanDetailChangeVO> progressDetailVoList = new ArrayList<YearPlanDetailChangeVO>();
            for (YearPlanDetailEntity progressDetailEntity : progressDetailList) {
                YearPlanDetailChangeEntity changeDetailEntity = (YearPlanDetailChangeEntity)((Object)BeanMapper.map((Object)((Object)progressDetailEntity), YearPlanDetailChangeEntity.class));
                changeDetailEntity.setYearId(changeDetailEntity.getProgressId());
                changeDetailEntity.setYearBid(changeDetailEntity.getId());
                changeDetailEntity.setProgressId(null);
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                YearPlanDetailChangeVO changeVO = YearPlanDetailChangeEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(Boolean.valueOf(false));
                if (useTasks.contains(changeVO.getStructCode())) {
                    changeVO.setUseState(Boolean.valueOf(true));
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setYearId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() + 1));
        return vo;
    }

    @Override
    public void deleteYearPlan(List<YearPlanChangeVO> vos) {
        for (YearPlanChangeVO vo : vos) {
            YearPlanChangeEntity changeEntity = (YearPlanChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(YearPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(YearPlanEntity::getChangeStatus, (Object)PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getYearId());
            this.yearPlanService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
            this.detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<YearPlanChangeVO> queryChangeHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        List changeEntities = ((YearPlanChangeMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"year_id", (Object)id)).in((Object)"bill_state", billStatus)).orderByDesc((Object)"approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List changeVos = BeanMapper.mapList((Iterable)changeEntities, YearPlanChangeVO.class);
            for (YearPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(YearPlanChangeVO vo) {
        Long projectId = vo.getProjectId();
        List ids = vo.getIds();
        LambdaQueryWrapper ylambd = new LambdaQueryWrapper();
        ylambd.and(x -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.in(BaseEntity::getId, (Collection)ids)).or()).in(ProgressDetailEntity::getParentId, (Collection)ids));
        List list = this.yearPlanDetailService.list((Wrapper)ylambd);
        Boolean isDel = true;
        if ("addLower".equals(vo.getDelFlag())) {
            isDel = null;
        }
        return this.commonHelper.transferDelIds(list, projectId, PlanConstant.YEAR_PLAN, isDel);
    }
}

