package com.ejianc.business.bim.helper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @description JSON 处理辅助类
 * @author 宫清
 * @date 2019年7月20日 下午5:35:31
 * @since JDK1.7
 */
public class JSONHelper {

	private static Logger logger = null;

	private JSONHelper() {
	}

	/**
	 * @description 格式化json data数据
	 *
	 * @param json
	 * @return
	 * @throws BusinessException
	 * @author 宫清
	 * @date 2019年7月20日 下午5:34:38
	 */
	@SuppressWarnings("unchecked")
	public static <T> T castDataJson(JSONObject json, Class<T> clz) throws BusinessException {
		if(logger == null){
			logger = LoggerFactory.getLogger(JSONHelper.class);
		}
		logger.info("返回大象云查询结果：{}", json);
		Object obj = json.get("data");
		int code = json.getIntValue("code");
		if (code != 0 && obj == null) {
			throw new BusinessException(json.getString("message"));
		}
		JSONObject error = json.getJSONObject("error");
		if (error != null && error.getInteger("code") != 0){
			logger.error(error.getString("message"));
		}
		return (T)obj;
	}
}
