package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.TotalPlanDetailHistoryEntity;
import com.ejianc.business.plan.service.ITotalPlanDetailHistoryService;
import com.ejianc.business.plan.vo.TotalPlanDetailHistoryVO;
import com.ejianc.business.plan.vo.TotalPlanHistoryVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.TotalPlanHistoryMapper;
import com.ejianc.business.plan.bean.TotalPlanHistoryEntity;
import com.ejianc.business.plan.service.ITotalPlanHistoryService;

import java.util.ArrayList;
import java.util.List;

/**
 * 总计划历史
 *
 * @author generator
 */
@Service("totalPlanHistoryService")
public class TotalPlanHistoryServiceImpl extends BaseServiceImpl<TotalPlanHistoryMapper, TotalPlanHistoryEntity> implements ITotalPlanHistoryService {

    @Autowired
    private ITotalPlanDetailHistoryService detailHistoryService;

    @Override
    public TotalPlanHistoryVO queryDetailByChangeId(Long id) {
        TotalPlanHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<TotalPlanHistoryEntity>().eq("change_id", id));
        if (historyEntity != null) {
            TotalPlanHistoryVO historyVo = BeanMapper.map(historyEntity, TotalPlanHistoryVO.class);
            //查询子表
            QueryWrapper<TotalPlanDetailHistoryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("progress_id", historyVo.getId());
            queryWrapper.orderByAsc("tid");
            List<TotalPlanDetailHistoryEntity> progressDetailList = detailHistoryService.list(queryWrapper);

            if (progressDetailList != null && progressDetailList.size() > 0) {
                List<TotalPlanDetailHistoryVO> progressDetailVoList = new ArrayList<>();
                for (TotalPlanDetailHistoryEntity progressDetailEntity : progressDetailList) {
                    progressDetailVoList.add(TotalPlanDetailHistoryEntity.convertEntityToVo(progressDetailEntity));
                }
                historyVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
            }
            return historyVo;
        }
        return null;
    }
}
