package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.plan.bean.WeekPlanDetailEntity;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.bean.YearPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("weekPlan") 
public class WeekPlanBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private CommonHelper commonHelper;
	@Autowired
	private IWeekPlanService service;
	@Autowired
	private IWeekPlanDetailService detailService;
	@Autowired
	private IExecPlanService execPlanService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//校验关联负责人
		List<WeekPlanDetailEntity> detailList = detailService.list(new QueryWrapper<WeekPlanDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);

		//TODO
		//保存提交时间
		LambdaUpdateWrapper<WeekPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(WeekPlanEntity::getCommitTime, new Date());
		lambd.eq(WeekPlanEntity::getId, billId);
		service.update(lambd);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//校验关联负责人
		List<WeekPlanDetailEntity> detailList = detailService.list(new QueryWrapper<WeekPlanDetailEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);
		if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state){
			LambdaUpdateWrapper<WeekPlanEntity> lambd = new LambdaUpdateWrapper<>();
			lambd.set(WeekPlanEntity::getCommitTime, new Date());
			lambd.eq(WeekPlanEntity::getId, billId);
			service.update(lambd);
		}

		//TODO
		WeekPlanEntity weekPlanEntity = service.selectById(billId);
		LambdaUpdateWrapper<WeekPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(WeekPlanEntity::getApprovedTime, new Date());
		if (weekPlanEntity.getStartDate() != null) {
			Integer subDay = DateUtil.getSubDay(new Date(), weekPlanEntity.getPlanBeginDate());
//			Integer finishFlag = subDay - 9;
			lambd.set(WeekPlanEntity::getFinishFlag, subDay);
		}
		if (state == 1) {
			lambd.set(WeekPlanEntity::getCommitTime, new Date());
		}
		lambd.eq(WeekPlanEntity::getId, billId);
		service.update(lambd);
		execPlanService.pushExecPlan(billId, PlanConstant.WEEK_PLAN);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
		WeekPlanEntity entity = service.selectById(billId);
		//同一个项目只能存在一个自由态或审批中的单据
		execPlanService.validateProject(entity.getProjectId(),billId);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//弃审更新提交时间
		LambdaUpdateWrapper<WeekPlanEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(WeekPlanEntity::getCommitTime, null);
		lambd.set(WeekPlanEntity::getApprovedTime, null);
		lambd.set(WeekPlanEntity::getFinishFlag, null);
		lambd.eq(WeekPlanEntity::getId, billId);
		service.update(lambd);
		execPlanService.pushExecPlanRollBack(billId,PlanConstant.WEEK_PLAN);
		return CommonResponse.success();
	}

}
