package com.ejianc.business.progress.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 风险纠偏
 * 
 * @author generator
 * 
 */
 @TableName("ejc_progress_risk_correction")
public class RiskCorrectionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="year_id")
    private Long yearId; // 年计划主键
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="corp_id")
    private Long corpId; // 区域公司
    @TableField(value="corp_code")
    private String corpCode; // 区域公司编码
    @TableField(value="corp_name")
    private String corpName; // 区域公司名称
    @TableField(value="plan_year")
    private String planYear; // 计划年度
    @TableField(value="year_bid")
    private Long yearBid; // 节点主键
    @TableField(value="employee_id")
    private Long employeeId; // 负责人主键
    @TableField(value="employee_name")
    private String employeeName; // 负责人名称
    @TableField(value="diff_value")
    private java.math.BigDecimal diffValue; // 偏差值
    @TableField(value="year_bname")
    private String yearBname; // 节点名称
    @TableField(value="node_level")
    private Integer nodeLevel; // 节点次级
    @TableField(value="correction_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date correctionDate; // 纠偏日期
    @TableField(value="lag_reasons")
    private String lagReasons; // 滞后原因说明
    @TableField(value="correction_measures")
    private String correctionMeasures; // 纠偏措施
    @TableField(value="supplement")
    private String supplement; // 补充说明
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="correction_type")
    private Integer correctionType; // 纠偏方式(0-项目自行解决，1-二级单位处理，2-工程局处理)
    @TableField(value="handle_status")
    private String handleStatus; // 处理状态：0-待受理，1-待纠偏，2-纠偏中，3-已完成
    @TableField(value="top_org_id")
    private Long topOrgId; // 二级单位id
    @TableField(value="top_org_name")
    private String topOrgName; // 二级单位名称
    @TableField(value="last_update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastUpdateTime; // 最近更新时间
    @TableField(value="start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime; // 纠偏开始时间（审批通过时间）
    @TableField(value="finish_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date finishTime; // 完成时间
    @TableField(value="accept_user_id")
    private Long acceptUserId; // 受理人id
    @TableField(value="accept_user_name")
    private String acceptUserName; // 受理人名称
    @TableField(value="draw_user_id")
    private Long drawUserId; // 提请人id
    @TableField(value="draw_user_name")
    private String drawUserName; // 提请人名称
    @TableField(value="draw_explain")
    private String drawExplain; // 提请说明
    @TableField(value="return_explain")
    private String returnExplain; // 退回说明
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="min_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date minTime; // 未完成最小时间
    @TableField(value="accept_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date acceptTime; // 受理时间
    @TableField(value="finish_user_id")
    private Long finishUserId; // 完成人id
    @TableField(value="finish_user_name")
    private String finishUserName; // 完成人名称
    @TableField(value="draw_org_id")
    private Long drawOrgId; // 提请组织id
    @TableField(value="draw_org_name")
    private String drawOrgName; // 提请组织名称
    @TableField(value="lag_reason_id")
    private String lagReasonId; // 滞后原因,自定义档案
    @TableField(value="project_control_level")
    private Long projectControlLevel; // 项目类别,自定义档案

    @TableField(exist=false)
    @SubEntity(serviceName="riskCorrectionDetailService", pidName = "riskId")
    private List<RiskCorrectionDetailEntity> detailList = new ArrayList<>(); // 风险纠偏清单实体

    public String getLagReasonId() {
        return lagReasonId;
    }

    public void setLagReasonId(String lagReasonId) {
        this.lagReasonId = lagReasonId;
    }

    /**
     * 年计划主键
     */
    public Long getYearId() {
        return yearId;
    }

    /**
     * 年计划主键
     */
    public void setYearId(Long yearId) {
        this.yearId = yearId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 计划年度
     */
    public String getPlanYear() {
        return planYear;
    }

    /**
     * 计划年度
     */
    public void setPlanYear(String planYear) {
        this.planYear = planYear;
    }
    /**
     * 节点主键
     */
    public Long getYearBid() {
        return yearBid;
    }

    /**
     * 节点主键
     */
    public void setYearBid(Long yearBid) {
        this.yearBid = yearBid;
    }
    /**
     * 负责人主键
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 负责人主键
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 负责人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 负责人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 偏差值
     */
    public java.math.BigDecimal getDiffValue() {
        return diffValue;
    }

    /**
     * 偏差值
     */
    public void setDiffValue(java.math.BigDecimal diffValue) {
        this.diffValue = diffValue;
    }
    /**
     * 节点名称
     */
    public String getYearBname() {
        return yearBname;
    }

    /**
     * 节点名称
     */
    public void setYearBname(String yearBname) {
        this.yearBname = yearBname;
    }

    /**
     * 节点次级
     */
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    /**
     * 节点次级
     */
    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    /**
     * 纠偏日期
     */
    public Date getCorrectionDate() {
        return correctionDate;
    }

    /**
     * 纠偏日期
     */
    public void setCorrectionDate(Date correctionDate) {
        this.correctionDate = correctionDate;
    }
    /**
     * 滞后原因说明
     */
    public String getLagReasons() {
        return lagReasons;
    }

    /**
     * 滞后原因说明
     */
    public void setLagReasons(String lagReasons) {
        this.lagReasons = lagReasons;
    }
    /**
     * 纠偏措施
     */
    public String getCorrectionMeasures() {
        return correctionMeasures;
    }

    /**
     * 纠偏措施
     */
    public void setCorrectionMeasures(String correctionMeasures) {
        this.correctionMeasures = correctionMeasures;
    }
    /**
     * 补充说明
     */
    public String getSupplement() {
        return supplement;
    }

    /**
     * 补充说明
     */
    public void setSupplement(String supplement) {
        this.supplement = supplement;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 纠偏方式(0-项目自行解决，1-二级单位处理，2-工程局处理)
     */
    public Integer getCorrectionType() {
        return correctionType;
    }

    /**
     * 纠偏方式(0-项目自行解决，1-二级单位处理，2-工程局处理)
     */
    public void setCorrectionType(Integer correctionType) {
        this.correctionType = correctionType;
    }
    /**
     * 处理状态：0-待受理，1-待纠偏，2-纠偏中，3-已完成
     */
    public String getHandleStatus() {
        return handleStatus;
    }

    /**
     * 处理状态：0-待受理，1-待纠偏，2-纠偏中，3-已完成
     */
    public void setHandleStatus(String handleStatus) {
        this.handleStatus = handleStatus;
    }
    /**
     * 二级单位id
     */
    public Long getTopOrgId() {
        return topOrgId;
    }

    /**
     * 二级单位id
     */
    public void setTopOrgId(Long topOrgId) {
        this.topOrgId = topOrgId;
    }
    /**
     * 二级单位名称
     */
    public String getTopOrgName() {
        return topOrgName;
    }

    /**
     * 二级单位名称
     */
    public void setTopOrgName(String topOrgName) {
        this.topOrgName = topOrgName;
    }
    /**
     * 最近更新时间
     */
    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * 最近更新时间
     */
    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    /**
     * 纠偏开始时间（审批通过时间）
     */
    public Date getStartTime() {
        return startTime;
    }

    /**
     * 纠偏开始时间（审批通过时间）
     */
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 完成时间
     */
    public Date getFinishTime() {
        return finishTime;
    }

    /**
     * 完成时间
     */
    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    /**
     * 受理人id
     */
    public Long getAcceptUserId() {
        return acceptUserId;
    }

    /**
     * 受理人id
     */
    public void setAcceptUserId(Long acceptUserId) {
        this.acceptUserId = acceptUserId;
    }

    /**
     * 受理人名称
     */
    public String getAcceptUserName() {
        return acceptUserName;
    }

    /**
     * 受理人名称
     */
    public void setAcceptUserName(String acceptUserName) {
        this.acceptUserName = acceptUserName;
    }

    /**
     * 提请人id
     */
    public Long getDrawUserId() {
        return drawUserId;
    }

    /**
     * 提请人id
     */
    public void setDrawUserId(Long drawUserId) {
        this.drawUserId = drawUserId;
    }

    /**
     * 提请人名称
     */
    public String getDrawUserName() {
        return drawUserName;
    }

    /**
     * 提请人名称
     */
    public void setDrawUserName(String drawUserName) {
        this.drawUserName = drawUserName;
    }

    /**
     * 提请说明
     */
    public String getDrawExplain() {
        return drawExplain;
    }

    /**
     * 提请说明
     */
    public void setDrawExplain(String drawExplain) {
        this.drawExplain = drawExplain;
    }

    /**
     * 退回说明
     */
    public String getReturnExplain() {
        return returnExplain;
    }

    /**
     * 退回说明
     */
    public void setReturnExplain(String returnExplain) {
        this.returnExplain = returnExplain;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 未完成最小时间
     */
    public Date getMinTime() {
        return minTime;
    }

    /**
     * 未完成最小时间
     */
    public void setMinTime(Date minTime) {
        this.minTime = minTime;
    }

    /**
     * 受理时间
     */
    public Date getAcceptTime() {
        return acceptTime;
    }

    /**
     * 受理时间
     */
    public void setAcceptTime(Date acceptTime) {
        this.acceptTime = acceptTime;
    }

    /**
     * 完成人id
     */
    public Long getFinishUserId() {
        return finishUserId;
    }

    /**
     * 完成人id
     */
    public void setFinishUserId(Long finishUserId) {
        this.finishUserId = finishUserId;
    }

    /**
     * 完成人名称
     */
    public String getFinishUserName() {
        return finishUserName;
    }

    /**
     * 完成人名称
     */
    public void setFinishUserName(String finishUserName) {
        this.finishUserName = finishUserName;
    }

    /**
     * 提请组织id
     */
    public Long getDrawOrgId() {
        return drawOrgId;
    }

    /**
     * 提请组织id
     */
    public void setDrawOrgId(Long drawOrgId) {
        this.drawOrgId = drawOrgId;
    }

    /**
     * 提请组织名称
     */
    public String getDrawOrgName() {
        return drawOrgName;
    }

    /**
     * 提请组织名称
     */
    public void setDrawOrgName(String drawOrgName) {
        this.drawOrgName = drawOrgName;
    }

    public Long getProjectControlLevel() {
        return projectControlLevel;
    }

    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }

    /**
     * 风险纠偏清单实体
     */
    public List<RiskCorrectionDetailEntity> getDetailList() {
        return detailList;
    }

    /**
     * 风险纠偏清单实体
     */
    public void setDetailList(List<RiskCorrectionDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
}
