package com.ejianc.business.progress.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.progress.service.IProgressDetailService;
import com.ejianc.business.progress.vo.ProgressFilterVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2023/10/26 16:30
 */
@RestController
@RequestMapping(value = "/api/progress")
public class ProgressApi {

    @Autowired
    private IProgressDetailService progressDetailService;

    /**
     * 查询项目
     *
     * @param progressFilterVO
     * @return
     */
    @PostMapping(value = "/getProjectProgress")
    CommonResponse<List<JSONObject>> getProjectProgress(@RequestBody ProgressFilterVO progressFilterVO) {
        List<JSONObject> dataList = progressDetailService.getProjectProgress(progressFilterVO);
        return CommonResponse.success(dataList);
    }

}
