package com.ejianc.business.progress.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.bean.ProgressEntity;
import com.ejianc.business.progress.mapper.ProgressDetailMapper;
import com.ejianc.business.progress.mapper.ProgressMapper;
import com.ejianc.business.progress.service.IProgressService;
import com.ejianc.business.progress.utils.TreeHelper;
import com.ejianc.business.progress.vo.ProgressDetailVO;
import com.ejianc.business.progress.vo.ProgressVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class ProgressServiceImpl extends BaseServiceImpl<ProgressMapper, ProgressEntity> implements IProgressService {

	@Autowired
	private ProgressMapper progressMapper;
	@Autowired
	private ProgressDetailMapper progressDetailMapper;
	
	@Override
	public void saveOrUpdate(ProgressVO progressVo) {
		if(progressVo.getId() != null && progressVo.getId() > 0) { //修改
			ProgressEntity progressEntity = progressMapper.selectById(progressVo.getId());
			progressEntity.setProgressCode(progressVo.getProgressCode());
			progressEntity.setProgressName(progressVo.getProgressName());
			progressEntity.setDescription(progressVo.getDescription());
			progressMapper.updateById(progressEntity);
			
			//子表
			List<ProgressDetailVO> progressDetailList = progressVo.getTasks();
			if(progressDetailList.size() > 0) {
				Map<String, Long> pkMap = new HashMap<>();
				List<ProgressDetailVO> saveVOList = new ArrayList<ProgressDetailVO>();
				TreeHelper.tree2List(pkMap, saveVOList, progressDetailList);
				
				for(ProgressDetailVO progressDetailVo : saveVOList) {
					if("added".equals(progressDetailVo.get_state())) {
						ProgressDetailEntity progressDetailEntity = ProgressDetailEntity.convertVoToEntity(progressDetailVo);
						progressDetailEntity.setProgressId(progressEntity.getId());
						progressDetailMapper.insert(progressDetailEntity);
					}else if("modified".equals(progressDetailVo.get_state())){
						ProgressDetailEntity progressDetailEntity = ProgressDetailEntity.convertVoToEntity(progressDetailVo);
						progressDetailEntity.setProgressId(progressEntity.getId());
						progressDetailMapper.updateById(progressDetailEntity);
					}
				}
			}
			
			//子表删除
			List<ProgressDetailVO> delDetailList = progressVo.getRemovedTasks();
			if(delDetailList != null && delDetailList.size() > 0) {
				for(ProgressDetailVO progressDetailVo:delDetailList) {
					progressDetailMapper.deleteById(progressDetailVo.getUid());
				}
			}
		}else { //新增
			Long masterPkId = IdWorker.getId();
			ProgressEntity progressEntity = BeanMapper.map(progressVo, ProgressEntity.class);
			progressEntity.setId(masterPkId);
			progressMapper.insert(progressEntity);
			
			//子表
			List<ProgressDetailVO> progressDetailList = progressVo.getTasks();
			
			if(progressDetailList.size() > 0) {
				Map<String, Long> pkMap = new HashMap<>();
				List<ProgressDetailVO> saveVOList = new ArrayList<ProgressDetailVO>();
				TreeHelper.tree2List(pkMap, saveVOList, progressDetailList);
				
				for(ProgressDetailVO progressDetailVo : saveVOList) {
					ProgressDetailEntity progressDetailEntity = ProgressDetailEntity.convertVoToEntity(progressDetailVo);
					progressDetailEntity.setProgressId(masterPkId);
					progressDetailMapper.insert(progressDetailEntity);
				}
			}
			
		}
	}
	
	public static void main(String[] args) {
		String time = "2007-01-01T15:59:59.000Z";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
		try {
			System.out.println(sdf.parse(time));
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
			DateTimeFormatter parser = ISODateTimeFormat.dateTime();
			DateTime dt = parser.parseDateTime(time);

			DateTimeFormatter formatter = DateTimeFormat.mediumDateTime();

			System.out.println(formatter.print(dt));
	}

}
