/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.NumberUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.plan.vo.MonthPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"monthPlan"})
public class MonthPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMonthPlanService service;
    @Autowired
    private IMonthPlanDetailService detailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IYearPlanService yearPlanService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MonthPlanVO> saveOrUpdate(@RequestBody MonthPlanVO saveOrUpdateVO) {
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getCalendars())) {
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        CommonResponse<MonthPlanVO> response = this.service.saveOrUpdate(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthPlanVO> queryDetail(Long id) {
        MonthPlanVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthPlanVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(ids, true);
        this.detailService.deleteDetailByProgressIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List MonthPlanVOS = BeanMapper.mapList((Iterable)page.getRecords(), MonthPlanVO.class);
        MonthPlanVOS.forEach(vo -> {
            vo.setChangeStatusName((String)PlanConstant.CHANGE_STATUS.get(vo.getChangeStatus()));
            vo.setChangeVersionName("\u7b2c" + NumberUtil.int2chineseNum(vo.getChangeVersion()) + "\u7248");
        });
        pageData.setRecords(MonthPlanVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MonthPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMonthPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MonthPlanVO>> refMonthPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("changeStatus", new Parameter("ne", (Object)2));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getxml"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<HashMap> getxml(HttpServletRequest request, HttpServletResponse response) {
        return this.service.getxml(request);
    }

    @RequestMapping(value={"/exportxml"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportxml(HttpServletResponse response, @RequestBody XmlVO vo) {
        this.service.exportxml(response, vo);
    }

    @RequestMapping(value={"/generateMonthPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthPlanVO> generateMonthPlan(@RequestParam(value="projectId") Long projectId, @RequestParam(value="planMonth") Date planMonth, @RequestParam(value="id", required=false) Long id, @RequestParam(value="changeFlag", required=false) Boolean changeFlag) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String[] split = sdf.format(planMonth).split("-");
        Integer year = Integer.valueOf(split[0]);
        Integer Month2 = Integer.valueOf(split[1]);
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(1, year);
        c1.set(2, Month2 - 1);
        int firstDay = c1.getActualMinimum(5);
        c1.set(5, firstDay);
        Date monthFirstDate = c1.getTime();
        Calendar c2 = Calendar.getInstance();
        c2.clear();
        c2.set(1, year);
        c2.set(2, Month2 - 1);
        int lastDay = c2.getActualMaximum(5);
        c2.set(5, lastDay);
        Date monthLastDate = c2.getTime();
        if (BooleanUtils.isNotTrue((Boolean)changeFlag)) {
            MonthPlanVO monthPlanVO = new MonthPlanVO();
            monthPlanVO.setProjectId(projectId);
            monthPlanVO.setPlanMonth(monthFirstDate);
            monthPlanVO.setId(id);
            this.service.validateMonthPlan(monthPlanVO);
        }
        Integer planState = BooleanUtils.isTrue((Boolean)changeFlag) ? PlanConstant.MONTH_PLAN : PlanConstant.YEAR_PLAN;
        ExecPlanVO execPlanVO = this.execPlanService.queryRefDetail(projectId, planState, monthFirstDate, monthLastDate, changeFlag);
        List execlDetailList = execPlanVO.getProgressDetailList();
        List allExeclDetailList = execPlanVO.getAllList();
        if (CollectionUtils.isEmpty((Collection)execlDetailList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u7684\u5e74\u8ba1\u5212\u5728" + year + "\u5e74" + Month2 + "\u6708\u6ca1\u6709\u8ba1\u5212\u8be6\u60c5\uff01");
        }
        execPlanVO.setProgressDetailList(null);
        MonthPlanVO planVO = new MonthPlanVO();
        BeanUtils.copyProperties((Object)execPlanVO, (Object)planVO);
        List<ExecPlanDetailVO> progressDetailList = TreeHelper2.tree2List(execlDetailList);
        ArrayList<MonthPlanDetailVO> list = new ArrayList<MonthPlanDetailVO>();
        for (ExecPlanDetailVO vo : progressDetailList) {
            if (PlanConstant.MONTH_PLAN.equals(vo.getPlanState())) {
                vo.setPlanState(null);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPercentTask())) {
                vo.setName(vo.getName() + vo.getPercentTask());
            }
            MonthPlanDetailVO monthPlanDetailVO = new MonthPlanDetailVO();
            BeanUtils.copyProperties((Object)vo, (Object)monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            list.add(monthPlanDetailVO);
        }
        List<ExecPlanDetailVO> allProgressDetailList = TreeHelper2.tree2List(allExeclDetailList);
        ArrayList<MonthPlanDetailVO> allList = new ArrayList<MonthPlanDetailVO>();
        for (ExecPlanDetailVO vo : allProgressDetailList) {
            if (PlanConstant.MONTH_PLAN.equals(vo.getPlanState())) {
                vo.setPlanState(null);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPercentTask())) {
                vo.setName(vo.getName() + vo.getPercentTask());
            }
            MonthPlanDetailVO monthPlanDetailVO = new MonthPlanDetailVO();
            BeanUtils.copyProperties((Object)vo, (Object)monthPlanDetailVO);
            monthPlanDetailVO.setSourceId(execPlanVO.getId());
            monthPlanDetailVO.setSourceBid(Long.valueOf(vo.getUid()));
            allList.add(monthPlanDetailVO);
        }
        List monthPlanTree = TreeHelper2.list2Tree(list);
        List allMonthPlanTree = TreeHelper2.list2Tree(allList);
        planVO.setProgressDetailList(monthPlanTree);
        planVO.setAllList(allMonthPlanTree);
        planVO.setSourceId(execPlanVO.getId());
        return CommonResponse.success((Object)planVO);
    }

    @RequestMapping(value={"/dateMonthPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthPlanVO> dateMonthPlan(@RequestParam(value="projectId") Long projectId, @RequestParam(value="date") String date) {
        return CommonResponse.success((Object)this.service.dateMonthPlan(projectId, DateUtil.parseDate(date)));
    }
}

