/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.handler;

import com.ejianc.framework.cache.utils.RedisTool;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class PlanLockUtil {
    @Autowired
    private JedisPool jedisPool2;
    private static JedisPool jedisPool;
    private static final String REQUEST_ID = "ExecPlanUpdate";
    private static final String LOCK_KEY = "PLANKEY";
    private static PlanLockUtil util;

    @PostConstruct
    public void init() {
        util = this;
        jedisPool = this.jedisPool2;
    }

    public static Boolean getLock(Long id) {
        boolean locked = false;
        if (id != null) {
            Jedis jedis = jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)(LOCK_KEY + id), (String)REQUEST_ID, (int)1000);
            return locked;
        }
        return false;
    }

    public static void releaseLock(Long id) {
        if (id != null) {
            Jedis jedis = jedisPool.getResource();
            RedisTool.releaseLock((Jedis)jedis, (String)(LOCK_KEY + id), (String)REQUEST_ID);
            jedis.close();
        }
    }
}

