package com.ejianc.business.bim.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.mapper.BimMapper;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * BIM模型
 * 
 * @author generator
 * 
 */
@Service("bimService")
public class BimServiceImpl extends BaseServiceImpl<BimMapper, BimEntity> implements IBimService{

    private static final String BILL_CODE = "ZJKJ_BIM_CODE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private IBimDetailService detailService;

    @Autowired
    private IExecPlanService execService;

    @Autowired
    private IExecPlanDetailService execDetailService;

    @Override
    public BimVO saveOrUpdate(BimVO saveOrUpdateVO) {
        LambdaQueryWrapper<BimEntity> ew = new LambdaQueryWrapper<>();
        ew.eq(BimEntity::getDr, 0);
        ew.eq(BimEntity::getProjectId, saveOrUpdateVO.getProjectId());
        ew.ne(null != saveOrUpdateVO.getId(), BimEntity::getId, saveOrUpdateVO.getId());
        List<BimEntity> list = super.list(ew);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("该项目已存在BIM模型");
        }
        BimEntity entity = BeanMapper.map(saveOrUpdateVO, BimEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
//            Long tenantId = InvocationInfoProxy.getTenantid();
//            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String date = sdf.format(new Date());
            entity.setBillCode("MX" + date);
        } else {
            // 同步删除大象云模型列表
            List<Long> detailIds = entity.getDetailList().stream().filter(x->!"del".equals(x.getRowState()) && x.getId() != null).
                    map(BimDetailEntity::getId).collect(Collectors.toList());
            BimEntity data = super.selectById(saveOrUpdateVO.getId());
            List<String> delPaths = data.getDetailList().stream().filter(x->!detailIds.contains(x.getId())).
                    map(BimDetailEntity::getPath).collect(Collectors.toList());
            for(String path : delPaths){
                TokenHelper.delFile(path);
            }
        }
        OrgVO orgVO = orgUtil.findById(entity.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
        if(entity.getState() == null){
            entity.setState(0);
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, BimVO.class);
    }

    @Override
    public BimVO syncDetail(Long id) {
        BimEntity entity = super.selectById(id);
        List<BimDetailEntity> detailList = entity.getDetailList();
        List<BimDetailEntity> saveList = new ArrayList<>();
        for(BimDetailEntity detail : detailList){
            if(detail.getStatus() == 1){
                continue;
            }
            JSONObject fileStatus = TokenHelper.getFileStatus(detail.getPath());
            if(fileStatus != null && "Ready".equals(fileStatus.getString("status"))){
                detail.setStatus(1);
                saveList.add(detail);
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            detailService.updateBatchById(saveList);
        }
        BimVO vo = BeanMapper.map(entity, BimVO.class);
        return vo;
    }

    @Override
    public Boolean syncState(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        BimEntity bim = super.queryList(queryParam).stream().findAny().orElse(null);
        ExecPlanEntity exec = execService.queryList(queryParam).stream().findAny().orElse(null);
        if(bim == null || exec == null) {
            return true;
        }
        Boolean oldFlag = new Integer(1).equals(bim.getState()) ? true : false;
        List<BimDetailEntity> detailList = detailService.list(new QueryWrapper<BimDetailEntity>().eq("bim_id", bim.getId()));
        List<ExecPlanDetailEntity> execDetailList = execDetailService.list(new QueryWrapper<ExecPlanDetailEntity>().eq("progress_id", exec.getId()));
        List<String> bimDetailIds = execDetailList.stream().map(x->x.getBimDetailIds()).filter(x->StringUtils.isNotEmpty(x)).
                flatMap(x->Stream.of(x.split(","))).collect(Collectors.toList());
        List<BimDetailEntity> saveList = new ArrayList<>();
        boolean flag = false;
        for(BimDetailEntity detail : detailList){
            if(bimDetailIds.contains(String.valueOf(detail.getId()))){
                if(!new Integer(1).equals(detail.getState())){
                    detail.setState(1);
                    saveList.add(detail);
                }
            } else {
                if(new Integer(1).equals(detail.getState())){
                    detail.setState(0);
                    saveList.add(detail);
                }
            }
            if(new Integer(1).equals(detail.getState())){
                flag = true;
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            detailService.updateBatchById(saveList);
        }
        if(oldFlag != flag){
            bim.setState(flag ? 1 : 0);
            super.saveOrUpdate(bim);
        }
        return true;
    }
}
