package com.ejianc.business.fill.controller;

import com.alibaba.fastjson.JSONObject;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.fill.bean.ProjectTrendEntity;
import com.ejianc.business.fill.service.IProjectTrendService;
import com.ejianc.business.fill.vo.ProjectTrendVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目趋势
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("projectTrend")
public class ProjectTrendController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IProjectTrendService service;

    /**
     * 项目月折线图
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/proMonthDelnyTrend", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> proMonthDelnyTrend(Long projectId) {
        return CommonResponse.success("查询数据成功！",service.proMonthDelnyTrend(projectId));
    }

    /**
     * 项目周折线图(3个月内)
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/proWeekDelnyTrend", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> proWeekDelnyTrend(Long projectId) {
        return CommonResponse.success("查询数据成功！",service.proWeekDelnyTrend(projectId));
    }


}
