package com.ejianc.business.fill.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.fill.service.IWarnService;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 *  工期预警
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("warn")
public class WarnController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWarnService service;

    /**
     * @Description 同步年计划亮灯状态
     */
    @RequestMapping(value = "/light", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse light(HttpServletRequest request) {
        return service.light(request);
    }


    /**
     * @Description 根据推送设置推送消息
     */
    @RequestMapping(value = "/pushNotice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushNotice(HttpServletRequest request) {
        return service.pushNotice(request);
    }

    /**
     * 项目进度查询表头
     * @Description queryProject 查询项目
     * @param orgId
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WarnProjectVO> queryProject(@RequestParam("orgId") Long orgId) {
        return service.queryProject(orgId);
    }

    /**
     * 项目进度达成率
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectFinishList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> projectFinishList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.projectFinishList(param));
    }

    /**
     * 项目进度达成率
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/projectFinishExport", method = RequestMethod.POST)
    @ResponseBody
    public void projectFinishExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.projectFinishList(param);
        JSONArray records = commonResponse.getData().getJSONArray("records");
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("projectFinish-export.xlsx", beans, response);
    }

    /**
     * 任务进度达成率
     * parentId默认-1，nodeLevel默认1
     * @return
     */
    @RequestMapping(value = "/taskFinishList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> taskFinishList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.taskFinishList(param));
    }

    /**
     * 任务进度达成率
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/taskFinishExport", method = RequestMethod.POST)
    @ResponseBody
    public void taskFinishExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.taskFinishList(param);
        JSONArray records = commonResponse.getData().getJSONArray("records");
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("taskFinish-export.xlsx", beans, response);
    }

}
