package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.mapper.MonthPlanChangeMapper;
import com.ejianc.business.plan.mapper.MonthPlanDetailChangeMapper;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.MonthPlanChangeVO;
import com.ejianc.business.plan.vo.MonthPlanDetailChangeVO;
import com.ejianc.business.plan.vo.TotalPlanChangeVO;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.MonthPlanChangeMapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月计划变更
 * 
 * @author generator
 * 
 */
@Service("monthPlanChangeService")
public class MonthPlanChangeServiceImpl extends BaseServiceImpl<MonthPlanChangeMapper, MonthPlanChangeEntity> implements IMonthPlanChangeService{

    @Autowired
    private MonthPlanChangeMapper changeMapper;
    @Autowired
    private MonthPlanDetailChangeMapper detailChangeMapper;
    @Autowired
    private IMonthPlanDetailChangeService detailChangeService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private CommonHelper commonHelper;


    @Override
    public CommonResponse<MonthPlanChangeVO> saveOrUpdate(MonthPlanChangeVO saveOrUpdateVO) {

        execPlanService.validateProject(saveOrUpdateVO.getProjectId(),saveOrUpdateVO.getId());

        // todo 是否有校验
        Long tenantId = InvocationInfoProxy.getTenantid();
        MonthPlanChangeEntity progressEntity = null;
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
            progressEntity = BeanMapper.map(saveOrUpdateVO, MonthPlanChangeEntity.class);
            changeMapper.updateById(progressEntity);

            //子表
            List<MonthPlanDetailChangeVO> progressDetailList = saveOrUpdateVO.getTasks();
            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<MonthPlanDetailChangeVO> saveVOList = new ArrayList<MonthPlanDetailChangeVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, saveOrUpdateVO.getImportFlag());

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                if(saveOrUpdateVO.getImportFlag()){
                    detailChangeService.deleteDetailByProgressId(progressEntity.getId());
                }

                List<MonthPlanDetailChangeEntity> planEntityList = new ArrayList<>();
                for (MonthPlanDetailChangeVO progressDetailVo : saveVOList) {
                    if (saveOrUpdateVO.getImportFlag() || "added".equals(progressDetailVo.get_state())) {
                        MonthPlanDetailChangeEntity progressDetailEntity = MonthPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        planEntityList.add(progressDetailEntity);
                    } else if ("modified".equals(progressDetailVo.get_state())) {
                        MonthPlanDetailChangeEntity progressDetailEntity = MonthPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                        progressDetailEntity.setProgressId(progressEntity.getId());
                        detailChangeMapper.updateById(progressDetailEntity);
                    }
                }

                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }

            //子表删除
            List<MonthPlanDetailChangeVO> delDetailList = saveOrUpdateVO.getRemovedTasks();
            if (delDetailList != null && delDetailList.size() > 0) {
                for (MonthPlanDetailChangeVO progressDetailVo : delDetailList) {
                    detailChangeMapper.deleteById(progressDetailVo.getUid());
                }
            }
        } else { //新增
            MonthPlanEntity totalPlanEntity = monthPlanService.selectById(saveOrUpdateVO.getMonthId());
            if(totalPlanEntity.getChangeStatus() == PlanConstant.CHANGE_ING){
                throw new BusinessException("存在变更中单据，不允许保存!");
            }

            Long masterPkId = IdWorker.getId();
            progressEntity = BeanMapper.map(saveOrUpdateVO, MonthPlanChangeEntity.class);
            progressEntity.setId(masterPkId);
            changeMapper.insert(progressEntity);

            //子表
            List<MonthPlanDetailChangeVO> progressDetailList = saveOrUpdateVO.getTasks();

            if (progressDetailList.size() > 0) {
                Map<String, Long> pkMap = new HashMap<>();
                List<MonthPlanDetailChangeVO> saveVOList = new ArrayList<MonthPlanDetailChangeVO>();
                TreeHelper2.tree2List(pkMap, saveVOList, progressDetailList, true);

                //校验末级负责人
                //commonHelper.validateEmployee(saveVOList);

                List<MonthPlanDetailChangeEntity> planEntityList = new ArrayList<>();
                for (MonthPlanDetailChangeVO progressDetailVo : saveVOList) {
                    MonthPlanDetailChangeEntity progressDetailEntity = MonthPlanDetailChangeEntity.convertVoToEntity(progressDetailVo);
                    progressDetailEntity.setProgressId(masterPkId);
                    planEntityList.add(progressDetailEntity);
                }

                if(CollectionUtils.isNotEmpty(planEntityList)){
                    planEntityList = TreeUtils.restParentId(planEntityList);
                    detailChangeService.saveOrUpdateBatch(planEntityList);
                }
            } else {
                throw new BusinessException("计划详情不能为空");
            }

            LambdaUpdateWrapper<MonthPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(MonthPlanEntity::getChangeId, progressEntity.getId());
            updateWrapper.set(MonthPlanEntity::getChangeStatus, PlanConstant.CHANGE_ING);
            updateWrapper.set(MonthPlanEntity::getChangeCode, progressEntity.getBillCode());
            updateWrapper.eq(MonthPlanEntity::getId, progressEntity.getMonthId());
            monthPlanService.update(updateWrapper);
        }
        return CommonResponse.success(queryDetail(progressEntity.getId()));
    }

    @Override
    public MonthPlanChangeVO queryDetail(Long id) {
        MonthPlanChangeEntity progressEntity = baseMapper.selectById(id);

        //查询子表
        QueryWrapper<MonthPlanDetailChangeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<MonthPlanDetailChangeEntity> progressDetailList = detailChangeService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        MonthPlanChangeVO progressVo = BeanMapper.map(progressEntity, MonthPlanChangeVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<MonthPlanDetailChangeVO> progressDetailVoList = new ArrayList<>();
            for (MonthPlanDetailChangeEntity progressDetailEntity : progressDetailList) {
                MonthPlanDetailChangeVO changeVO = MonthPlanDetailChangeEntity.convertEntityToVo(progressDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            progressVo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        return progressVo;
    }

    @Override
    public MonthPlanChangeVO queryDetailChange(Long id) {
        MonthPlanEntity progressEntity = monthPlanService.selectById(id);
        MonthPlanChangeVO vo = BeanMapper.map(progressEntity, MonthPlanChangeVO.class);
        //查询子表
        QueryWrapper<MonthPlanDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("progress_id", id);
        queryWrapper.orderByAsc("tid");
        List<MonthPlanDetailEntity> progressDetailList = monthPlanDetailService.list(queryWrapper);

        // 查询日反馈引用集合主键
        List<String> useTasks = commonHelper.transferUseIds(progressDetailList, progressEntity.getProjectId());

        if (progressDetailList != null && progressDetailList.size() > 0) {
            List<MonthPlanDetailChangeVO> progressDetailVoList = new ArrayList<>();
            for (MonthPlanDetailEntity progressDetailEntity : progressDetailList) {
                MonthPlanDetailChangeEntity changeDetailEntity = BeanMapper.map(progressDetailEntity, MonthPlanDetailChangeEntity.class);
                changeDetailEntity.setMonthId(changeDetailEntity.getProgressId());
                changeDetailEntity.setMonthBid(changeDetailEntity.getId());
                changeDetailEntity.setProgressId(null);
                changeDetailEntity.setChangeType(PlanConstant.CHANGE_TYPE_NO);
                MonthPlanDetailChangeVO changeVO = MonthPlanDetailChangeEntity.convertEntityToVo(changeDetailEntity);
                changeVO.setUseState(false);
                if(useTasks.contains(changeVO.getStructCode())){
                    changeVO.setUseState(true);
                }
                progressDetailVoList.add(changeVO);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(progressDetailVoList));
        }
        vo.setMonthId(vo.getId());
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setChangeDescription(null);
        vo.setChangeVersion(vo.getChangeVersion() + 1);
        return vo;
    }

    @Override
    public void deleteMonthPlan(List<MonthPlanChangeVO> vos) {
        for (MonthPlanChangeVO vo : vos) {
            MonthPlanChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<MonthPlanEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (changeEntity.getChangeVersion() == 2) {
                updateWrapper.set(MonthPlanEntity::getChangeStatus, PlanConstant.CHANGE_NO);
            } else {
                updateWrapper.set(MonthPlanEntity::getChangeStatus, PlanConstant.CHANGE_OVER);
            }
            updateWrapper.eq(MonthPlanEntity::getId, changeEntity.getMonthId());
            monthPlanService.update(updateWrapper);
            super.removeById(vo, false);
            detailChangeService.deleteDetailByProgressId(vo.getId());
        }
    }

    @Override
    public List<MonthPlanChangeVO> queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<MonthPlanChangeEntity> changeEntities = baseMapper.selectList(new QueryWrapper<MonthPlanChangeEntity>()
                .eq("month_id", id)
                .in("bill_state", billStatus).orderByDesc("approved_time"));
        if (null != changeEntities && changeEntities.size() > 0) {
            List<MonthPlanChangeVO> changeVos = BeanMapper.mapList(changeEntities, MonthPlanChangeVO.class);
            for (MonthPlanChangeVO cvo : changeVos) {
                String historyBillCode = cvo.getBillCode() + "-" + (cvo.getChangeVersion() - 1);
                cvo.setHistoryBillCode(historyBillCode);
            }
            return changeVos;
        }
        return null;
    }

    @Override
    public List<Long> queryDelIds(Long projectId, List<Long> ids) {
        LambdaQueryWrapper<MonthPlanDetailEntity> ylambd = new LambdaQueryWrapper<>();
        ylambd.in(MonthPlanDetailEntity::getId, ids);
        List<MonthPlanDetailEntity> list = monthPlanDetailService.list(ylambd);
        return commonHelper.transferDelIds(list, projectId, PlanConstant.MONTH_PLAN);
    }
    
}
