package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.TotalPlanDetailEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.mapper.YearPlanDetailMapper;
import com.ejianc.business.plan.bean.YearPlanDetailEntity;
import com.ejianc.business.plan.service.IYearPlanDetailService;

import java.util.List;

/**
 * 年计划详情
 * 
 * @author generator
 * 
 */
@Service("yearPlanDetailService")
public class YearPlanDetailServiceImpl extends BaseServiceImpl<YearPlanDetailMapper, YearPlanDetailEntity> implements IYearPlanDetailService{

    @Override
    public void deleteDetailByProgressIds(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<YearPlanDetailEntity>().in("progress_id", ids));
    }

    @Override
    public void deleteDetailByIds(List<Long> ids) {
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public void deleteByProgressId(Long id) {
        baseMapper.delete(new QueryWrapper<YearPlanDetailEntity>().eq("progress_id", id));
    }

}
