package com.ejianc.business.progress.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.progress.bean.DocEntity;
import com.ejianc.business.progress.bean.NodeArchivesEntity;
import com.ejianc.business.progress.service.IDocService;
import com.ejianc.business.progress.service.INodeArchivesService;
import com.ejianc.business.progress.vo.NodeArchivesVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * 节点档案分类实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("nodeArchives")
public class NodeArchivesController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private INodeArchivesService service;

    @Autowired
    private IDocService docService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NodeArchivesVO> saveOrUpdate(@RequestBody NodeArchivesVO saveorUpdateVO) {
    	return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NodeArchivesVO> queryDetail(Long id) {
        NodeArchivesEntity entity = service.selectById(id);
        NodeArchivesVO vo = BeanMapper.map(entity, NodeArchivesVO.class);
        if (entity.getParentId() != null && entity.getParentId() > 0) {
            NodeArchivesEntity parentEntity = service.selectById(entity.getParentId());
            vo.setParentName(parentEntity.getName());
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        // 有子节点不允许删除
        List<NodeArchivesEntity> children = service.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error("该分类下有子分类不允许删除");
        }
        // 分类下有方案了不允许删除
        List<DocEntity> docEntityList = docService.queryListByArchivesId(id);
        if (docEntityList != null && docEntityList.size() > 0) {
            return CommonResponse.error("该分类下有方案了，不允许删除");
        }
        service.removeById(id);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("id", "asc");

        List<NodeArchivesEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));

        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 查询树参照(上级分类)
     *
     * @return
     */
    @RequestMapping(value = "/treeRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> treeRef(@RequestParam(value = "id", required = false) Long id) {
        return CommonResponse.success("查询详情数据成功！", service.treeRef(id));
    }


}
