package com.ejianc.business.progress.controller;

import com.ejianc.business.progress.service.IRiskMessageService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;

/**
 * 风险纠偏消息发送
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("riskMsg")
public class RiskMesageController implements Serializable {
	private static final long serialVersionUID = 1L;
    @Autowired
    private IRiskMessageService service;

    /**
     * @Description 纠偏预警
     */
    @RequestMapping(value = "/riskWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse riskWarn(HttpServletRequest request) {
        return service.riskWarn(request);
    }

}
