/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bim.helper;

import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class CacheHelper {
    private static final Map<String, Object> localCache = Maps.newConcurrentMap();
    @Value(value="${spring.application.name}")
    private String ApplicationName;
    public static String APPLICATION_NAME;
    private static CacheHelper helper;

    private CacheHelper() {
    }

    @PostConstruct
    public void init() {
        helper = this;
        APPLICATION_NAME = this.ApplicationName;
    }

    public static void put(String k, Object v) {
        if (APPLICATION_NAME != null) {
            String cacheKey = APPLICATION_NAME + ":" + k;
            RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
            redisTemplate.opsForValue().set((Object)cacheKey, v, 5L, TimeUnit.DAYS);
        } else {
            localCache.put(k, v);
        }
    }

    public static Object get(String k) {
        if (APPLICATION_NAME != null) {
            String cacheKey = APPLICATION_NAME + ":" + k;
            RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
            Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
            return cacheValue;
        }
        return localCache.get(k);
    }

    public static void remove(String k) {
        if (APPLICATION_NAME != null) {
            String cacheKey = APPLICATION_NAME + ":" + k;
            RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
            redisTemplate.delete((Object)cacheKey);
        } else {
            localCache.remove(k);
        }
    }
}

