/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.fill.bean.ProjectTrendEntity;
import com.ejianc.business.fill.emum.LightRuleLevelEnum;
import com.ejianc.business.fill.mapper.ProjectTrendMapper;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.fill.service.IProjectTrendService;
import com.ejianc.business.fill.service.IWarnService;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectTrendService")
public class ProjectTrendServiceImpl
extends BaseServiceImpl<ProjectTrendMapper, ProjectTrendEntity>
implements IProjectTrendService {
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IProjectLightService projectLightService;
    @Autowired
    private IWarnService warnService;

    @Override
    public Boolean projectTrendTrend(List<ExecPlanEntity> execList, Map<Long, LightRuleEntity> projectLightRuleMap) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ExecPlanEntity execPlan : execList) {
            ids.add(execPlan.getProjectId());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());
        ArrayList list = ids.size() > 0 ? ((ProjectTrendMapper)this.baseMapper).proNearToday(ids, today) : new ArrayList();
        ArrayList todayList = ids.size() > 0 ? ((ProjectTrendMapper)this.baseMapper).proTodayToday(ids, today) : new ArrayList();
        HashMap<Long, ProjectTrendEntity> nearMap = new HashMap<Long, ProjectTrendEntity>();
        for (Object entity : list) {
            nearMap.put(((ProjectTrendEntity)((Object)entity)).getProjectId(), (ProjectTrendEntity)((Object)entity));
        }
        HashMap<Long, ProjectTrendEntity> todayMap = new HashMap<Long, ProjectTrendEntity>();
        if (todayList != null && todayList.size() > 0) {
            for (ProjectTrendEntity entity : todayList) {
                todayMap.put(entity.getProjectId(), entity);
            }
        }
        ArrayList<ProjectTrendEntity> saveOrUpdate = new ArrayList<ProjectTrendEntity>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (ExecPlanEntity execPlanEntity : execList) {
            Long projectId = execPlanEntity.getProjectId();
            LightRuleLevelEntity lightRuleLevel = this.warnService.getLightRuleLevel(projectLightRuleMap, projectId, LightRuleLevelEnum.\u9879\u76ee\u5b8c\u6210\u65f6\u95f4.getCode());
            List detailList = execPlanEntity.getAllList().stream().filter(e -> PlanConstant.TOTAL_PLAN == e.getPlanState()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(detailList)) continue;
            BigDecimal maxDiffValue = detailList.stream().map(ExecPlanDetailEntity::getDiffValue).max(BigDecimal::compareTo).get();
            Date maxPredictFinish = detailList.stream().max(Comparator.comparing(ExecPlanDetailEntity::getPredictFinish)).get().getPredictFinish();
            BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(maxPredictFinish, new Date()));
            BigDecimal finalValue = ComputeUtil.safeDiv(maxDiffValue, residueValue);
            Integer lightType = null;
            if (null != lightRuleLevel) {
                lightType = this.warnService.getLightType(lightRuleLevel, maxDiffValue, finalValue, false, null);
            }
            if (todayMap.containsKey(projectId)) {
                ProjectTrendEntity todayEntity = (ProjectTrendEntity)((Object)todayMap.get(projectId));
                if (nearMap.containsKey(projectId)) {
                    ProjectTrendEntity nearEntity = (ProjectTrendEntity)((Object)nearMap.get(projectId));
                    if (nearEntity.getDiffValue().compareTo(maxDiffValue) == 0 && nearEntity.getCorpLightType() == lightType) {
                        delIds.add(todayEntity.getId());
                        continue;
                    }
                    todayEntity.setDiffValue(maxDiffValue);
                    todayEntity.setCorpLightType(lightType);
                    saveOrUpdate.add(todayEntity);
                    continue;
                }
                todayEntity.setDiffValue(maxDiffValue);
                todayEntity.setCorpLightType(lightType);
                saveOrUpdate.add(todayEntity);
                continue;
            }
            if (nearMap.containsKey(projectId)) {
                ProjectTrendEntity nearEntity = (ProjectTrendEntity)((Object)nearMap.get(projectId));
                if (nearEntity.getDiffValue().compareTo(maxDiffValue) == 0 && nearEntity.getCorpLightType() == lightType) continue;
                ProjectTrendEntity entity = new ProjectTrendEntity();
                entity.setProjectId(projectId);
                entity.setUpdateDate(today);
                entity.setDiffValue(maxDiffValue);
                entity.setCorpLightType(lightType);
                saveOrUpdate.add(entity);
                continue;
            }
            ProjectTrendEntity entity = new ProjectTrendEntity();
            entity.setProjectId(projectId);
            entity.setUpdateDate(today);
            entity.setDiffValue(maxDiffValue);
            entity.setCorpLightType(lightType);
            saveOrUpdate.add(entity);
        }
        if (saveOrUpdate.size() > 0) {
            super.saveOrUpdateBatch(saveOrUpdate, saveOrUpdate.size(), false);
        }
        if (delIds.size() > 0) {
            super.removeByIds(delIds, false);
        }
        return true;
    }

    @Override
    public JSONObject proMonthDelnyTrend(Long projectId) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        String thisMonth = df.format(new Date());
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<BigDecimal> valueList = new ArrayList<BigDecimal>();
        List<ProjectTrendEntity> entityList = ((ProjectTrendMapper)this.baseMapper).monthTrend(projectId, thisMonth);
        for (ProjectTrendEntity dte : entityList) {
            keyList.add(dte.getUpdateDate());
            valueList.add(dte.getDiffValue());
        }
        keyList.add(thisMonth);
        valueList.add(this.getTodayDiffValue(projectId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }

    @Override
    public JSONObject proWeekDelnyTrend(Long projectId) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(ProjectTrendEntity::getProjectId, (Object)projectId);
        lambda.orderByAsc(ProjectTrendEntity::getUpdateDate);
        List entityList = super.list((Wrapper)lambda);
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<BigDecimal> valueList = new ArrayList<BigDecimal>();
        if (entityList == null || entityList.size() <= 0) {
            keyList.add(today);
            valueList.add(this.getTodayDiffValue(projectId));
            jsonObject.put("key", keyList);
            jsonObject.put("value", valueList);
            return jsonObject;
        }
        String startDate = ((ProjectTrendEntity)((Object)entityList.get(0))).getUpdateDate();
        BigDecimal diffValue = ((ProjectTrendEntity)((Object)entityList.get(0))).getDiffValue();
        LinkedHashMap<String, BigDecimal> entityMap = new LinkedHashMap<String, BigDecimal>();
        LinkedHashMap<String, BigDecimal> fullMap = new LinkedHashMap<String, BigDecimal>();
        for (ProjectTrendEntity pte : entityList) {
            entityMap.put(pte.getUpdateDate(), pte.getDiffValue());
        }
        while (DateUtil2.compareTime(startDate, today) <= 0) {
            if (entityMap.containsKey(startDate)) {
                diffValue = (BigDecimal)entityMap.get(startDate);
            }
            fullMap.put(startDate, diffValue);
            startDate = DateUtil2.dateAdd(df, startDate, 1);
        }
        String start = DateUtil2.getWeekOfMonthStartDate(df, 24);
        LinkedHashMap<String, BigDecimal> weekMap = new LinkedHashMap<String, BigDecimal>();
        Map<String, BigDecimal> resMap = new LinkedHashMap<String, BigDecimal>();
        int i = 1;
        while (DateUtil2.compareTime(start, today) <= 0) {
            if (fullMap.containsKey(start)) {
                BigDecimal bvalue = (BigDecimal)fullMap.get(start);
                weekMap.put(start, bvalue);
            }
            if (DateUtil2.compareTime(start = DateUtil2.dateAdd(df, start, 1), today) == 0) {
                resMap.put(today, this.getTodayDiffValue(projectId));
            } else if (i == 7) {
                i = 0;
                if (weekMap.size() > 0) {
                    resMap = this.maxWeekMap(weekMap, resMap);
                    weekMap = new LinkedHashMap();
                }
            }
            ++i;
        }
        for (String date : resMap.keySet()) {
            BigDecimal b = (BigDecimal)resMap.get(date);
            keyList.add(date);
            valueList.add(b);
        }
        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }

    private Map<String, BigDecimal> maxWeekMap(Map<String, BigDecimal> weekMap, Map<String, BigDecimal> resMap) {
        String d = weekMap.keySet().iterator().next();
        BigDecimal a = weekMap.get(d);
        for (String date : weekMap.keySet()) {
            BigDecimal b = weekMap.get(date);
            if (b.compareTo(a) <= 0) continue;
            a = b;
            d = date;
        }
        resMap.put(d, a);
        return resMap;
    }

    private BigDecimal getTodayDiffValue(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ExecPlanEntity::getProjectId, (Object)projectId);
        ExecPlanEntity entity = (ExecPlanEntity)((Object)this.execPlanService.getOne((Wrapper)queryWrapper));
        if (entity == null) {
            return BigDecimal.ZERO;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getId());
        ew.eq((Object)"plan_state", (Object)PlanConstant.TOTAL_PLAN);
        ew.orderByAsc((Object)"tid");
        List detailList = this.execPlanDetailService.list((Wrapper)ew);
        detailList.forEach(e -> e.setDiffValue(new BigDecimal(DateUtil.getBetweenDays(e.getPredictFinish(), e.getPlanFinish()))));
        BigDecimal maxDiffValue = detailList.stream().map(ExecPlanDetailEntity::getDiffValue).max(BigDecimal::compareTo).get();
        return maxDiffValue;
    }
}

