/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.utils.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class DurationUtil {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static JSONObject getCalender(String calendars, String calenderUid) {
        JSONArray json = JSONArray.parseArray((String)calendars);
        JSONObject calender = (JSONObject)json.stream().filter(x -> calenderUid.equals(((JSONObject)x).getString("UID"))).findAny().orElse(new Object());
        return calender;
    }

    public static Integer calculateDuration(Date start, Date finish, JSONObject calender) {
        Integer period = DateUtil.getBetweenDays(finish, start);
        JSONArray WeekDays = new JSONArray();
        if (calender.containsKey((Object)"WeekDays")) {
            WeekDays = calender.getJSONArray("WeekDays");
        }
        JSONArray Exceptions = new JSONArray();
        if (calender.containsKey((Object)"Exceptions")) {
            Exceptions = calender.getJSONArray("Exceptions");
        }
        Integer duration = 1;
        Calendar cal = Calendar.getInstance();
        Date date = start;
        for (int i = 0; i < period; ++i) {
            date = DateUtil.addDays(start, i);
            cal.setTime(date);
            Integer DAY_OF_WEEK = DateUtil.turnZnDayOfWeek(cal.get(7));
            for (Object obj : WeekDays) {
                Integer DayType = ((JSONObject)obj).getInteger("DayType");
                Integer DayWorking = ((JSONObject)obj).getInteger("DayWorking");
                if (!DayType.equals(DAY_OF_WEEK) || DayWorking != 1) continue;
                duration = duration + 1;
            }
            for (Object obj : Exceptions) {
                JSONObject TimePeriod = ((JSONObject)obj).getJSONObject("TimePeriod");
                Date FromDate = DurationUtil.utc2Local(TimePeriod.getString("FromDate"));
                Date ToDate = DurationUtil.utc2Local(TimePeriod.getString("ToDate"));
                Integer DayWorking = ((JSONObject)obj).getInteger("DayWorking");
                if (FromDate.getHours() == 8) {
                    FromDate = DurationUtil.utc2Local(TimePeriod.getString("FromDate"));
                    ToDate = DurationUtil.utc2Local(TimePeriod.getString("ToDate"));
                }
                if (DateUtil.compareDay(date, FromDate) < 0 || DateUtil.compareDay(date, ToDate) > 0) continue;
                if (DayWorking == 0) {
                    duration = duration - 1;
                    continue;
                }
                duration = duration + 1;
            }
        }
        return duration;
    }

    public static Date getConstraintDate(Date start, Date finish, Integer constraintType) {
        if (constraintType == 2 || constraintType == 4 || constraintType == 5) {
            return start;
        }
        if (constraintType == 3 || constraintType == 6 || constraintType == 7) {
            return finish;
        }
        return start;
    }

    public static String resetCalender(String calendars) {
        JSONArray json = JSONArray.parseArray((String)calendars);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        for (Object obj : json) {
            JSONObject calender = (JSONObject)obj;
            JSONArray Exceptions = new JSONArray();
            if (calender.containsKey((Object)"Exceptions")) {
                Exceptions = calender.getJSONArray("Exceptions");
            }
            for (Object obj2 : Exceptions) {
                JSONObject TimePeriod = ((JSONObject)obj2).getJSONObject("TimePeriod");
                Date FromDate = TimePeriod.getDate("FromDate");
                Date ToDate = TimePeriod.getDate("ToDate");
                if (FromDate.getHours() != 0) continue;
                TimePeriod.put("FromDate", (Object)(sdf.format(FromDate) + ".000Z"));
                TimePeriod.put("ToDate", (Object)(sdf.format(ToDate) + ".000Z"));
            }
        }
        return json.toJSONString();
    }

    public static Date utc2Local(String time) {
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static void main(String[] args) {
        String calendars = "[{\"UID\":\"1\",\"WeekDays\":[{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":1,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":2,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":3,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":4,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":5,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":6,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":7,\"DayWorking\":1}],\"Exceptions\":[{\"TimePeriod\":{\"FromDate\":\"2022-02-20T16:00:00.000Z\",\"ToDate\":\"2022-02-21T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"\"}],\"IsBaseCalendar\":1,\"BaseCalendarUID\":\"-1\",\"Name\":\"\u6807\u51c6\"},{\"UID\":\"42\",\"WeekDays\":[{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":1,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":2,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":3,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":4,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":5,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":6,\"DayWorking\":1},{\"WorkingTimes\":[{\"ToTime\":\"12:00:00\",\"FromTime\":\"08:00:00\"},{\"ToTime\":\"17:00:00\",\"FromTime\":\"13:00:00\"}],\"DayType\":7,\"DayWorking\":1}],\"Exceptions\":[{\"TimePeriod\":{\"FromDate\":\"2016-01-27T16:00:00.000Z\",\"ToDate\":\"2016-02-21T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2016\u5e74\u6625\u8282\"},{\"TimePeriod\":{\"FromDate\":\"2016-08-19T16:00:00.000Z\",\"ToDate\":\"2016-09-05T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"G20\u5cf0\u4f1a\"},{\"TimePeriod\":{\"FromDate\":\"2017-01-16T16:00:00.000Z\",\"ToDate\":\"2017-02-10T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2017\u5e74\u6625\u8282\"},{\"TimePeriod\":{\"FromDate\":\"2018-02-04T16:00:00.000Z\",\"ToDate\":\"2018-03-01T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2018\u5e74\u6625\u8282\"},{\"TimePeriod\":{\"FromDate\":\"2019-01-24T16:00:00.000Z\",\"ToDate\":\"2019-02-18T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2019\u5e74\u6625\u8282\"},{\"TimePeriod\":{\"FromDate\":\"2020-01-13T16:00:00.000Z\",\"ToDate\":\"2020-02-07T15:59:59.000Z\"},\"DayType\":0,\"DayWorking\":0,\"Name\":\"2020\u5e74\u6625\u8282\"}],\"IsBaseCalendar\":1,\"BaseCalendarUID\":\"-1\",\"Name\":\"\u201c\u6807\u51c6\u201d\u7684\u526f\u672c\"}]";
        String c2 = DurationUtil.resetCalender(calendars);
        System.out.println(calendars);
        System.out.println(c2);
    }
}

