/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.bean.ProgressEntity;
import com.ejianc.business.progress.service.IProgressDetailService;
import com.ejianc.business.progress.service.IProgressService;
import com.ejianc.business.progress.utils.TreeHelper;
import com.ejianc.business.progress.vo.ProgressDetailVO;
import com.ejianc.business.progress.vo.ProgressVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/progress/"})
public class ProgressController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IProgressService progressService;
    @Autowired
    private IProgressDetailService progressDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProgressVO> saveOrUpdate(@RequestBody ProgressVO progressVO) {
        this.progressService.saveOrUpdate(progressVO);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProgressVO> queryDetail(@RequestParam Long id) {
        ProgressEntity progressEntity = (ProgressEntity)((Object)this.progressService.selectById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"progress_id", (Object)id);
        queryWrapper.orderByAsc((Object)"tid");
        List progressDetailList = this.progressDetailService.list((Wrapper)queryWrapper);
        ProgressVO progressVo = (ProgressVO)BeanMapper.map((Object)((Object)progressEntity), ProgressVO.class);
        if (progressDetailList != null && progressDetailList.size() > 0) {
            ArrayList<ProgressDetailVO> progressDetailVoList = new ArrayList<ProgressDetailVO>();
            for (ProgressDetailEntity progressDetailEntity : progressDetailList) {
                progressDetailVoList.add(ProgressDetailEntity.convertEntityToVo(progressDetailEntity));
            }
            progressVo.setProgressDetailList(TreeHelper.list2Tree(progressDetailVoList));
        }
        return CommonResponse.success((Object)progressVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        this.progressService.removeById(id);
        this.progressDetailService.deleteDetailByProgressId(id);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProgressEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        IPage pageData = this.progressService.queryPage(queryParam);
        return CommonResponse.success((Object)pageData);
    }
}

