package com.ejianc.business.bim.helper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * @description 鉴权认证 辅助类
 * @author 宫清
 * @date 2019年7月19日 上午11:54:28
 * @since JDK1.7
 */
@Component
public class TokenHelper {

	private static Logger logger = null;

	public static final String BASE_HOST = "https://sales.dxbim.com:8443";

	private static final String APP_ID = "9204360f0a8a4bb8a5d523401f2872cb";

	private static final String SECURITY_KEY = "c3c48e5a92b74dbf862b77b348511978";

	/*
	 * token 缓存 key
	 */
	public static final String TOKEN = "TOKEN";

	/**
	 * 不允许外部创建实例
	 */
	private TokenHelper() {
	}

	//静态初始化当前类
	private static TokenHelper helper;

	//在方法上加上注解@PostConstruct,这样方法就会在bean初始化之后被spring容器执行
	@PostConstruct
	public void init(){
		//声明的静态类=this
		helper = this;
		if(logger == null){
			logger = LoggerFactory.getLogger(JSONHelper.class);
		}
	}

	// -------------------------------------------公有方法start-------------------------------------------------------

	/**
	 * @description 获取token
	 * 
	 *              实际使用中，可获取token后，放在redis缓存中，如果是非分布式架构，也可使用guava的LoadingCache或者自己构建本地缓存来存储该token，
	 *              缓存存储时，需要注意缓存失效截止时间expiresIn
	 * 
	 * @date 2019年7月19日 上午11:55:57
	 * @author 宫清
	 * @throws BusinessException
	 */
	public static JSONObject getTokenData() throws BusinessException {
		Map<String, String> params = new HashMap<>();
		params.put("appId", APP_ID);
		params.put("securityKey", SECURITY_KEY);
		JSONObject json = null;
		try {
			String response = HttpTookit.postParameters(BASE_HOST + "/api/v3/auth/apptokens", params);
			json = JSONObject.parseObject(response);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		json = JSONHelper.castDataJson(json,JSONObject.class);
		// 模拟存放本地缓存
		toLocalCache(json);
		return json;
	}

	// -------------------------------------------公有方法end---------------------------------------------------------

	// -------------------------------------------私有方法start-------------------------------------------------------

	/**
	 * @description 模拟存放本地缓存
	 *
	 * @param json
	 * @author 宫清
	 * @date 2019年7月20日 下午4:04:08
	 */
	private static void toLocalCache(JSONObject json) {
		CacheHelper.put(TOKEN, json.getString("token"));
	}

	public static JSONObject getFileStatus(String path) throws BusinessException {
		String url = BASE_HOST + "/api/v3/srv/fs/file/status";
		Map<String, String> params = new HashMap<>();
		params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
		params.put("path", path);
		JSONObject json = null;
		try {
			String response = HttpTookit.getAndHeader(url, params);
			json = JSONObject.parseObject(response);
			if(json.getIntValue("code") == 0 && json.get("data") == null){
				getTokenData();
				params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpTookit.getAndHeader(url, params);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return JSONHelper.castDataJson(json,JSONObject.class);
	}

	public static JSONObject delFile(String path) throws BusinessException {
		String url = BASE_HOST + "/api/v3/srv/fs/file";
		Map<String, String> params = new HashMap<>();
		params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
		params.put("path", path);
		JSONObject json = null;
		try {
			String response = HttpDelTookit.deleteByJson(url, params);
			json = JSONObject.parseObject(response);
			if(json.getIntValue("code") == 0 && json.get("data") == null){
				getTokenData();
				params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpDelTookit.deleteByJson(url, params);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return JSONHelper.castDataJson(json,JSONObject.class);
	}

	public static JSONObject getFileTree(String path) throws BusinessException{
		return getFileTree(path, "tree");
	}

	public static JSONObject getFileTree(String path, String format) throws BusinessException {
		String url = BASE_HOST + "/api/v3/srv/fs/file/tree";
		Map<String, String> params = new HashMap<>();
		params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
		params.put("path", path);
		params.put("format", format);
		JSONObject json = null;
		try {
			String response = HttpTookit.getAndHeader(url, params);
			json = JSONObject.parseObject(response);
			if(json.getIntValue("code") == 0 && json.get("data") == null){
				getTokenData();
				params.put("token", String.valueOf(CacheHelper.get(TOKEN)));
				response = HttpTookit.getAndHeader(url, params);
				json = JSONObject.parseObject(response);
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		return JSONHelper.castDataJson(json,JSONObject.class);
	}

	// -------------------------------------------私有方法end---------------------------------------------------------

	public static void main(String[] args) {
//		getTokenData();
//		System.out.println(LocalCacheHelper.get(TOKEN));
		String path = "opendx/9204360f0a8a4bb8a5d523401f2872cb/ef34af2b93e24b4ea6ea6f8cc63e6d17/ef34af2b93e24b4ea6ea6f8cc63e6d17.rvt";
		JSONObject json = getFileTree(path, "flat");
		System.out.println(json);
	}
}
