package com.ejianc.business.fill.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.bean.WeekFillDetailEntity;
import com.ejianc.business.fill.service.IWeekFillDetailService;
import com.ejianc.business.fill.vo.WeekFillDetailVO;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.WeekPlanDetailVO;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.fill.bean.WeekFillEntity;
import com.ejianc.business.fill.service.IWeekFillService;
import com.ejianc.business.fill.vo.WeekFillVO;

/**
 * 周进度计划填报
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("weekFill")
public class WeekFillController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_WEEK_FILL";//此处需要根据实际修改

    @Autowired
    private IWeekFillService service;

    @Autowired
    private IWeekFillDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IExecPlanService execPlanService;

    @Autowired
    private OrgUtil orgUtil;

    @Autowired
    private IWeekPlanService weekPlanService;

    @Autowired
    private IWeekPlanDetailService weekPlanDetailService;

    @Autowired
    private IExecPlanDetailService execPlanDetailService;

    @Autowired
    private IWeekFillDetailService weekFillDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeekFillVO> saveOrUpdate(@RequestBody WeekFillVO saveOrUpdateVO) {
        // 日历的例外日期普加加载后有问题
        if(StringUtils.isNotEmpty(saveOrUpdateVO.getCalendars())){
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
    	WeekFillEntity entity = BeanMapper.map(saveOrUpdateVO, WeekFillEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            detailService.deleteByProgressId(entity.getId());
        }

        Integer subDay = DateUtil.getSubDay(new Date(), entity.getFillDate());
    	entity.setFinishFlag(subDay);

        OrgVO orgVO = orgUtil.findById(saveOrUpdateVO.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
    	service.saveOrUpdate(entity, false);
        // 子表新增/修改
        List<WeekFillDetailVO> detailList = saveOrUpdateVO.getTasks();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<WeekFillDetailVO> voList = TreeHelper2.tree2List(detailList);
            List<WeekFillDetailEntity> saveList = new ArrayList<>();
            for (WeekFillDetailVO mvo : voList) {
                WeekFillDetailEntity detail = WeekFillDetailEntity.convertVoToEntity(mvo);
                detail.setProgressId(entity.getId());
                saveList.add(detail);
            }
            if(CollectionUtils.isNotEmpty(saveList)){
                detailService.saveOrUpdateBatch(saveList);
            }
        }
    	return queryDetail(entity.getId());
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeekFillVO> queryDetail(Long id) {
        WeekFillVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeekFillVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WeekFillVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WeekFillVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeekFillVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("updateUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<WeekFillEntity> page = service.queryPage(param,false);
        IPage<WeekFillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeekFillVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WeekFillEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WeekFill-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWeekFillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WeekFillVO>> refWeekFillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WeekFillEntity> page = service.queryPage(param,false);
        IPage<WeekFillVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeekFillVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    //获取周计划的计划详情
    @RequestMapping(value = "/getWeekFillData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeekFillVO> getWeekFillData(@RequestParam(value = "weekId") Long weekId,@RequestParam(required = false,value = "billId") Long billId) {
        //查询周计划
        WeekPlanEntity entity = weekPlanService.selectById(weekId);
        QueryWrapper<WeekPlanDetailEntity> qw = new QueryWrapper<>();
        qw.eq("progress_id", weekId);
        qw.orderByAsc("tid");
        List<WeekPlanDetailEntity> detailList = weekPlanDetailService.list(qw);
        List<WeekPlanDetailVO> weekDetailVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)) {
            for(WeekPlanDetailEntity detail : detailList) {
                weekDetailVOList.add(WeekPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        //查询执行计划
        ExecPlanEntity execEntity = execPlanService.selectById(entity.getSourceId());
        ExecPlanVO vo = BeanMapper.map(execEntity, ExecPlanVO.class);
        QueryWrapper<ExecPlanDetailEntity> ew = new QueryWrapper<>();
        ew.eq("progress_id", entity.getSourceId());
        ew.orderByAsc("tid");
        List<ExecPlanDetailEntity> execPlanDetail = execPlanDetailService.list(ew);
        List<ExecPlanDetailVO> detailVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(execPlanDetail)) {
            for(ExecPlanDetailEntity detail : execPlanDetail) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        //根据结构码匹配
        List<ExecPlanDetailVO> resultList = detailVOList.stream().filter(
                (ExecPlanDetailVO) -> weekDetailVOList.stream().map(WeekPlanDetailVO::getStructCode).collect(Collectors.toList()).contains(ExecPlanDetailVO.getStructCode())
        ).collect(Collectors.toList());
        //转换VO
        List<WeekFillDetailVO> wfList = new ArrayList<>();
        wfList = resultList.stream().map(ExecPlanDetailVO -> {
            WeekFillDetailVO wfvo = new WeekFillDetailVO();
            BeanUtils.copyProperties(ExecPlanDetailVO, wfvo);
            return wfvo;
        }).collect(Collectors.toList());
        wfList = TreeHelper2.list2Tree(wfList);
        wfList = TreeHelper2.tree2List(wfList,true);
        vo.setProgressDetailList(null);
        WeekFillVO fillVO = new WeekFillVO();
        BeanUtils.copyProperties(vo, fillVO);
        //查询周填报最新本期完成比例
        QueryWrapper<WeekFillEntity> queryWrapper  = new QueryWrapper<WeekFillEntity>();
        queryWrapper.eq("week_id", weekId);
        if (billId != null){
            queryWrapper.ne("id",billId);
        }
        queryWrapper.orderByDesc("fill_date");
        queryWrapper.last("LIMIT 1");
        WeekFillEntity wfEntity = service.getOne(queryWrapper);
        List<WeekFillDetailEntity> fList = new ArrayList<>();
        Map<String, WeekFillDetailEntity> fMap = new HashMap<>();
        if(wfEntity!=null){
           fList = weekFillDetailService.list(new QueryWrapper<WeekFillDetailEntity>()
                    .eq("progress_id", wfEntity.getId())
                    .orderByAsc("tid")
            );
            fMap = fList.stream().collect(Collectors.toMap(WeekFillDetailEntity::getStructCode,a -> a,(k1,k2)->k1));
        }
        //拼数据
        String name = "";
        String percentTask = "";
        String[] arr = new String[]{};
        BigDecimal complete = BigDecimal.ZERO;
        BigDecimal yx = BigDecimal.ZERO;
        BigDecimal cComplete = BigDecimal.ZERO;
        for(WeekFillDetailVO evo : wfList) {
            for (WeekPlanDetailEntity we : detailList) {
                if (evo.getStructCode().equals(we.getStructCode())){
                    evo.setPlanStart(we.getStart());
                    evo.setDuration(we.getDuration());
                    evo.setPlanFinish(we.getFinish());
                    evo.setNodeLevel(we.getNodeLevel());
                    //evo.setPredecessorLink(JSON.parseArray(we.getPredecessorLink()));
                    evo.setEmployeeId(we.getEmployeeId());
                    evo.setEmployeeName(we.getEmployeeName());
                    evo.setPlanNum(we.getPlanNum());
                    evo.setUnit(we.getUnit());
                    evo.setResourceName(we.getResourceName());
                    evo.setType(we.getType());
                    evo.setTypeUnit(we.getTypeUnit());
                    evo.setNeedNum(we.getNeedNum());
                    if (MapUtils.isNotEmpty(fMap)){
                        complete = ComputeUtil.safeSub(new BigDecimal(evo.getPercentComplete().toString()),fMap.get(we.getStructCode())!=null?fMap.get(we.getStructCode()).getCurrentComplete():BigDecimal.ZERO);
                    }else {
                        complete = new BigDecimal(evo.getPercentComplete().toString());
                    }
                    percentTask = we.getName().replace(evo.getName(),"");
                    if (StringUtils.isNotBlank(percentTask)){
                        arr = percentTask.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\-", ",").replaceAll("\\%","").split(",");
                        //处理yx为负数
                        if (arr.length > 2){
                            if (arr[0].equals("")){
                                arr[0] = "-"+arr[1];
                            }
                            if (arr[1].equals("")){
                                arr[1]= "-"+arr[2];
                            }
                            if (arr[2].equals("")){
                                arr[1] = "-"+arr[3];
                            }
                        }
                        yx = ComputeUtil.safeSub(new BigDecimal(arr[1]),new BigDecimal(arr[0]));
                    } else {
                        // 没有x、y的任务，默认取x=0%，y=100%
                        yx = new BigDecimal("100");
                    }
                    cComplete = ComputeUtil.bigDecimalPercent(complete,yx,0);
                    evo.setCurrentComplete(cComplete.compareTo(new BigDecimal("100"))==1?new BigDecimal("100"):cComplete.compareTo(BigDecimal.ZERO)==-1?BigDecimal.ZERO:cComplete);
                }
            }
            name = StringUtils.isNotBlank(percentTask)?evo.getName() + percentTask:evo.getName();
            evo.setName(name);
        }
        fillVO.setProgressDetailList(TreeHelper2.list2Tree(wfList));
        return CommonResponse.success("查询成功!",fillVO);
    }

    /**
     * @Description queryWeekFill 查询该项目下有没有的做填报
     * @param projectId 项目ID
     */
    @RequestMapping(value = "/queryWeekFill", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> queryWeekFill(@RequestParam("projectId") Long projectId,@RequestParam(required = false,value = "billId") Long billId) {
        QueryWrapper<WeekFillEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.eq("dr",0);
        wrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        if (billId != null){
            wrapper.ne("id",billId);
        }
        wrapper.orderByDesc("fill_date");
        List<WeekFillEntity> list = service.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.success("校验通过！",list.get(0).getFillDate());
        }
        return CommonResponse.success("校验通过！");
    }
}
