package com.ejianc.business.plan.bean;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.TotalPlanDetailVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 执行计划详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zjkjprogress_exec_plan_detail")
public class ExecPlanDetailEntity extends ProgressDetailEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="task_line")
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    @TableField(value="node_level")
    private Integer nodeLevel; // 节点级别
    @TableField(value="employee_id")
    private Long employeeId; // 负责人主键
    @TableField(value="employee_name")
    private String employeeName; // 负责人名称
    @TableField(value="plan_num")
    private BigDecimal planNum; // 工程量
    @TableField(value="unit")
    private Integer unit; // 单位(枚举格式012， 包含：㎡、m、m3、kg、t、个)
    @TableField(value="resource_name")
    private String resourceName; // 资源名称
    @TableField(value="type")
    private Integer type; // 资源类型(劳动力、材料、机械)
    @TableField(value="type_unit")
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    @TableField(value="need_num")
    private BigDecimal needNum; // 需求量
    @TableField(value="percent_task")
    private String percentTask; // 任务百分比
    @TableField(value="plan_state")
    private Integer planState; // 任务标识 1-总计划、2-年计划、3-月计划、4-周计划
    @TableField(value="source_id")
    private Long sourceId; // 来源单据主键
    @TableField(value="source_bid")
    private Long sourceBid; // 来源单据明细主键
    @TableField(value="plan_start")
    private Date planStart; // 计划开始日期
    @TableField(value="plan_finish")
    private Date planFinish; // 计划完成日期
    @TableField(value="estimate_finish")
    private Date estimateFinish; // 预计完成日期
    @TableField(value="predict_start")
    private Date predictStart; // 预测开始日期
    @TableField(value="predict_finish")
    private Date predictFinish; // 预测完成日期
    @TableField(value="finish_num")
    private BigDecimal finishNum; // 已完成量
    @TableField(value="finish_state")
    private Integer finishState; // 完成状态，0-未完成，1-已完成，2-进行中
    @TableField(value="light_type")
    private Integer lightType; // 亮灯，0-蓝，1-黄，2-红，3-紫灯
    @TableField(value="diff_value")
    private BigDecimal diffValue; // 偏差值
    @TableField(value="diff_type")
    private Long diffType; // 偏差原因类型 劳动力、材料、机械、内部原因、甲方原因、政府原因
    @TableField(value="diff_resson")
    private String diffResson; // 偏差原因
    @TableField(value="resource_num")
    private BigDecimal resourceNum; // 实际资源量
    @TableField(value="diff_num")
    private BigDecimal diffNum; // 资源偏差
    @TableField(value="bim_ids")
    private String bimIds; // 关联ID集合
    @TableField(value="bim_detail_ids")
    private String bimDetailIds; // 关联明细主键集合
    @TableField(value="state")
    private Integer state; // 是否关联进度 0-未关联，1-已关联
    @TableField(exist=false)
    private List<ExecPlanDetailEntity> children = new ArrayList<>();// 子任务
    @TableField(value = "predict_duration")
    private Integer predictDuration;// 预测工期
    @TableField(value="delay_finish")
    private Date delayFinish; // 延后完成日期
    @TableField(value = "this_percent_complete")
    private Integer thisPercentComplete; // 本期完成百分比
    @TableField(value = "this_plan_num")
    private BigDecimal thisPlanNum; // 本期计划工程量
    @TableField(value = "this_finish_num")
    private BigDecimal thisFinishNum; // 本期完成工程量
    @TableField(value = "next_plan_num")
    private BigDecimal nextPlanNum; // 下期计划工程量


    public Integer getPredictDuration() {
        return predictDuration;
    }

    public void setPredictDuration(Integer predictDuration) {
        this.predictDuration = predictDuration;
    }

    public List<ExecPlanDetailEntity> getChildren() {
        return children;
    }

    public void setChildren(List<ExecPlanDetailEntity> children) {
        this.children = children;
    }
    
    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }
    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }
    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }
    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }
    public String getPercentTask() {
        return percentTask;
    }

    public void setPercentTask(String percentTask) {
        this.percentTask = percentTask;
    }
    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }
    public Date getPlanStart() {
        return planStart;
    }

    public void setPlanStart(Date planStart) {
        this.planStart = planStart;
    }
    public Date getPlanFinish() {
        return planFinish;
    }

    public void setPlanFinish(Date planFinish) {
        this.planFinish = planFinish;
    }
    public Date getPredictStart() {
        return predictStart;
    }

    public void setPredictStart(Date predictStart) {
        this.predictStart = predictStart;
    }
    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }
    public Integer getFinishState() {
        return finishState;
    }

    public void setFinishState(Integer finishState) {
        this.finishState = finishState;
    }

    public Integer getLightType() {
        return lightType;
    }

    public void setLightType(Integer lightType) {
        this.lightType = lightType;
    }

    public Date getPredictFinish() {
        return predictFinish;
    }

    public void setPredictFinish(Date predictFinish) {
        this.predictFinish = predictFinish;
    }
    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }

    public Date getEstimateFinish() {
        return estimateFinish;
    }

    public void setEstimateFinish(Date estimateFinish) {
        this.estimateFinish = estimateFinish;
    }

    public Long getDiffType() {
        return diffType;
    }

    public void setDiffType(Long diffType) {
        this.diffType = diffType;
    }

    public String getDiffResson() {
        return diffResson;
    }

    public void setDiffResson(String diffResson) {
        this.diffResson = diffResson;
    }

    public BigDecimal getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(BigDecimal resourceNum) {
        this.resourceNum = resourceNum;
    }

    public BigDecimal getDiffNum() {
        return diffNum;
    }

    public void setDiffNum(BigDecimal diffNum) {
        this.diffNum = diffNum;
    }

    public String getBimIds() {
        return bimIds;
    }

    public void setBimIds(String bimIds) {
        this.bimIds = bimIds;
    }

    public String getBimDetailIds() {
        return bimDetailIds;
    }

    public void setBimDetailIds(String bimDetailIds) {
        this.bimDetailIds = bimDetailIds;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Date getDelayFinish() {
        return delayFinish;
    }

    public void setDelayFinish(Date delayFinish) {
        this.delayFinish = delayFinish;
    }

    public Integer getThisPercentComplete() {
        return thisPercentComplete;
    }

    public void setThisPercentComplete(Integer thisPercentComplete) {
        this.thisPercentComplete = thisPercentComplete;
    }

    public BigDecimal getThisPlanNum() {
        return thisPlanNum;
    }

    public void setThisPlanNum(BigDecimal thisPlanNum) {
        this.thisPlanNum = thisPlanNum;
    }

    public BigDecimal getThisFinishNum() {
        return thisFinishNum;
    }

    public void setThisFinishNum(BigDecimal thisFinishNum) {
        this.thisFinishNum = thisFinishNum;
    }

    public BigDecimal getNextPlanNum() {
        return nextPlanNum;
    }

    public void setNextPlanNum(BigDecimal nextPlanNum) {
        this.nextPlanNum = nextPlanNum;
    }

    /**
     * entity to vo
     */
    public static ExecPlanDetailVO convertEntityToVo(ExecPlanDetailEntity entity) {
        ExecPlanDetailEntity copy = BeanMapper.map(entity, ExecPlanDetailEntity.class);
        Long id = copy.getId();
        copy.setId(1L);
        String predecessorLink = copy.getPredecessorLink();
        copy.setPredecessorLink(null);
        String assignments = copy.getAssignments();
        copy.setAssignments(null);
        ExecPlanDetailVO vo = BeanMapper.map(copy, ExecPlanDetailVO.class);
        vo.setUid(id.toString());
        vo.setProjectUID(copy.getProjectId());
        vo.setParentTaskUID(copy.getParentId() + "");
        if (StringUtils.isNotBlank(assignments)) {
            vo.setAssignments(JSON.parseArray(assignments));
        }
        vo.setNote(copy.getNotes());
        vo.setId(copy.getTid());
        if(StringUtils.isNotBlank(predecessorLink)) {
            vo.setPredecessorLink(JSON.parseArray(predecessorLink));
        }
        return vo;
    }

    /**
     * vo to entity
     */
    public static ExecPlanDetailEntity convertVoToEntity(ExecPlanDetailVO vo) {
        ExecPlanDetailEntity entity = BeanMapper.map(vo, ExecPlanDetailEntity.class);
        if(StringUtils.isNotBlank(vo.getUid())) {
            entity.setId(Long.parseLong(vo.getUid()));
        }
        entity.setProjectId(vo.getProjectUID());
        if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
            entity.setParentId(Long.parseLong(vo.getParentTaskUID()));
        }
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            entity.setAssignments(JSON.toJSONString(vo.getAssignments()));
        }
        entity.setNotes(vo.getNote());
        entity.setTid(vo.getId());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            entity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
        }
        return entity;
    }
    
}
