package com.ejianc.business.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.plan.vo.MonthPlanDetailChangeVO;
import com.ejianc.business.plan.vo.TotalPlanDetailChangeVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.apache.commons.lang3.StringUtils;

/**
 * 月计划变更详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_zjkjprogress_month_plan_detail_change")
public class MonthPlanDetailChangeEntity extends ProgressDetailEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "month_id")
    private Long monthId; // 月计划主键
    @TableField(value = "month_bid")
    private Long monthBid; // 主表主键

    @TableField(value = "task_line")
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    @TableField(value = "node_level")
    private Integer nodeLevel; // 节点级别
    @TableField(value = "employee_id")
    private Long employeeId; // 负责人主键
    @TableField(value = "employee_name")
    private String employeeName; // 负责人名称
    @TableField(value = "plan_num")
    private BigDecimal planNum; // 工程量
    @TableField(value = "unit")
    private Integer unit; // 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
    @TableField(value = "resource_name")
    private String resourceName; // 资源名称
    @TableField(value = "type")
    private Integer type; // 资源类型(劳动力、材料、机械)
    @TableField(value = "type_unit")
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    @TableField(value = "need_num")
    private BigDecimal needNum; // 需求量
    @TableField(value="change_type")
    private Integer changeType; // 变更类型,0-未变更,1-变更项,2-新增项
    @TableField(value="plan_state")
    private Integer planState; // 任务标识
    @TableField(value="source_bid")
    private Long sourceBid; // 执行计划明细主键
    @TableField(value="source_id")
    private Long sourceId; // 执行计划单据主键

    @TableField(exist=false)
    private List<MonthPlanDetailChangeEntity> children = new ArrayList<>();// 子任务

    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }

    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMonthId() {
        return monthId;
    }

    public void setMonthId(Long monthId) {
        this.monthId = monthId;
    }

    public Long getMonthBid() {
        return monthBid;
    }

    public void setMonthBid(Long monthBid) {
        this.monthBid = monthBid;
    }

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }

    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }

    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public List<MonthPlanDetailChangeEntity> getChildren() {
        return children;
    }

    public void setChildren(List<MonthPlanDetailChangeEntity> children) {
        this.children = children;
    }

    /**
     * entity to vo
     */
    public static MonthPlanDetailChangeVO convertEntityToVo(MonthPlanDetailChangeEntity entity) {
        MonthPlanDetailChangeEntity copy = BeanMapper.map(entity, MonthPlanDetailChangeEntity.class);
        Long id = copy.getId();
        copy.setId(1L);
        String predecessorLink = copy.getPredecessorLink();
        copy.setPredecessorLink(null);
        String assignments = copy.getAssignments();
        copy.setAssignments(null);
        MonthPlanDetailChangeVO vo = BeanMapper.map(copy, MonthPlanDetailChangeVO.class);
        vo.setUid(id.toString());
        vo.setProjectUID(copy.getProjectId());
        vo.setParentTaskUID(copy.getParentId() + "");
        if (StringUtils.isNotBlank(assignments)) {
            vo.setAssignments(JSON.parseArray(assignments));
        }
        vo.setNote(copy.getNotes());
        vo.setId(copy.getTid());
        if(StringUtils.isNotBlank(predecessorLink)) {
            vo.setPredecessorLink(JSON.parseArray(predecessorLink));
        }
        return vo;
    }

    /**
     * vo to entity
     */
    public static MonthPlanDetailChangeEntity convertVoToEntity(MonthPlanDetailChangeVO vo) {
        MonthPlanDetailChangeEntity entity = BeanMapper.map(vo, MonthPlanDetailChangeEntity.class);
        if(StringUtils.isNotBlank(vo.getUid())) {
            entity.setId(Long.parseLong(vo.getUid()));
        }
        entity.setProjectId(vo.getProjectUID());
        if(StringUtils.isNotBlank(vo.getParentTaskUID())) {
            entity.setParentId(Long.parseLong(vo.getParentTaskUID()));
        }
        if(vo.getAssignments() != null && vo.getAssignments().size() > 0) {
            entity.setAssignments(JSON.toJSONString(vo.getAssignments()));
        }
        entity.setNotes(vo.getNote());
        entity.setTid(vo.getId());
        if(vo.getPredecessorLink() != null && vo.getPredecessorLink().size() > 0) {
            entity.setPredecessorLink(JSON.toJSONString(vo.getPredecessorLink()));
        }
        return entity;
    }
}
