package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.handler.TreeUtils;
import com.ejianc.business.plan.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.*;
import java.util.stream.Collectors;

@Service("yearPlanChange") 
public class YearPlanChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IYearPlanService service;
	@Autowired
	private IYearPlanDetailService detailService;
	@Autowired
	private IYearPlanChangeService changeService;
	@Autowired
	private IYearPlanDetailChangeService detailChangeService;
	@Autowired
	private IYearPlanHistoryService historyService;
	@Autowired
	private IYearPlanDetailHistoryService detailHistoryService;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IExecPlanService execPlanService;
	@Autowired
	private CommonHelper commonHelper;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {

		//校验关联负责人
		List<YearPlanDetailChangeEntity> detailList = detailChangeService.list(new QueryWrapper<YearPlanDetailChangeEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList);

		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//校验关联负责人
		List<YearPlanDetailChangeEntity> detailList1 = detailChangeService.list(new QueryWrapper<YearPlanDetailChangeEntity>().eq("progress_id", billId));
		commonHelper.validateEmployeeEntity(detailList1);

		logger.info("--------------变更审批通过，处理业务");
		YearPlanChangeEntity changeEntity = changeService.selectById(billId);
		QueryWrapper<YearPlanDetailChangeEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("progress_id", billId);
		queryWrapper.orderByAsc("tid");
		List<YearPlanDetailChangeEntity> detailChangeList = detailChangeService.list(queryWrapper);
		logger.info("--------------同步原始计划到记录表");
		YearPlanEntity entity = service.selectById(changeEntity.getYearId());
		QueryWrapper<YearPlanDetailEntity> queryWrapper1 = new QueryWrapper<>();
		queryWrapper1.eq("progress_id", entity.getId());
		queryWrapper1.orderByAsc("tid");
		List<YearPlanDetailEntity> detailList = detailService.list(queryWrapper1);
		Map<Long, YearPlanDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(YearPlanDetailEntity::getId, x->x));
		//List<Long> detailIds = detailList.stream().map(YearPlanDetailEntity::getId).collect(Collectors.toList());
		List<Long> detailIds = new ArrayList<>();
		for (YearPlanDetailEntity pde : detailList) {
			detailIds.add(pde.getId());
		}
		YearPlanHistoryEntity historyEntity = BeanMapper.map(entity, YearPlanHistoryEntity.class);
		Long historyId = IdWorker.getId();
		historyEntity.setYearId(historyEntity.getId());
		historyEntity.setId(historyId);
		historyService.save(historyEntity);
		List<YearPlanDetailHistoryEntity> historyDetailEntity = BeanMapper.mapList(detailList, YearPlanDetailHistoryEntity.class);
		Map<Long, Long> pmap = new HashMap<>();
		for (YearPlanDetailHistoryEntity pdh : historyDetailEntity) {
			Long historyDetailId = IdWorker.getId();
			pdh.setYearId(entity.getId());
			pdh.setYearBid(pdh.getId());
			pdh.setProgressId(historyId);
			pdh.setId(historyDetailId);
			pmap.put(pdh.getYearBid(), pdh.getId());
		}
		for (YearPlanDetailHistoryEntity pdh : historyDetailEntity) {
			pdh.setParentId(pmap.containsKey(pdh.getParentId()) ? pmap.get(pdh.getParentId()) : -1L);
			TreeUtils.resetProjectClomn(pdh, pmap);
		}
		detailHistoryService.saveBatch(historyDetailEntity);
		logger.info("--------------同步变更到原计划表");
		entity.setChangeStatus(PlanConstant.CHANGE_OVER);
		entity.setChangeVersion(changeEntity.getChangeVersion());
		entity.setChangeApprovedTime(new Date());
		entity.setChangeReason(changeEntity.getChangeReason());
		entity.setChangeDescription(changeEntity.getChangeDescription());
		service.updateById(entity);
		List<YearPlanDetailEntity> newDetail = new ArrayList<>();
		Map<Long, Long> idmap = new HashMap<>();
		for (YearPlanDetailChangeEntity pdc : detailChangeList) {
			Long detailId = IdWorker.getId();
			if (pdc.getYearBid() != null && pdc.getYearBid() > 0) {
				idmap.put(pdc.getId(), pdc.getYearBid());
				pdc.setId(pdc.getYearBid());
				detailIds.remove(pdc.getYearBid());
			} else {
				idmap.put(pdc.getId(), detailId);
				pdc.setId(detailId);
			}
			pdc.setProgressId(entity.getId());
			// version替换，否则更新不了
			if(detailMap.containsKey(pdc.getId())){
				pdc.setVersion(detailMap.get(pdc.getId()).getVersion());
			}
			newDetail.add(BeanMapper.map(pdc, YearPlanDetailEntity.class));
		}
		if (detailIds != null && detailIds.size() > 0) {
			detailService.deleteDetailByIds(detailIds);
		}
		for (YearPlanDetailEntity pde : newDetail) {
			pde.setParentId(idmap.containsKey(pde.getParentId()) ? idmap.get(pde.getParentId()) : -1L);
			TreeUtils.resetProjectClomn(pde, idmap);
		}
		detailService.saveOrUpdateBatch(newDetail, newDetail.size(), false);
		logger.info("--------------变更审批通过时间");
		LambdaUpdateWrapper<YearPlanChangeEntity> lambd = new LambdaUpdateWrapper<>();
		lambd.set(YearPlanChangeEntity::getApprovedTime, new Date());
		lambd.eq(YearPlanChangeEntity::getId, billId);
		changeService.update(lambd);
		logger.info("--------------处理变更附件");
		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(billId), PlanConstant.YEAR_PLAN_CHANGE_BILL_TYPE, PlanConstant.YEAR_PLAN_CHANGE_SOURCE_TYPE,
				String.valueOf(entity.getId()), PlanConstant.YEAR_PLAN_BILL_TYPE, PlanConstant.YEAR_PLAN_SOURCE_TYPE);
		execPlanService.pushExecPlan(entity.getId(), PlanConstant.YEAR_PLAN);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
