package com.ejianc.business.plan.utils;

import PluSoft.Data.Project;
import PluSoft.Utils.*;
import PluSoft.Utils.DateUtil;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class PlusProjectUtil {
    public static final List<String> customize_cloum = new ArrayList<>();

    public static HashMap Read(MultipartFile file, List<String> cloums) throws Exception {
        customize_cloum.clear();
        for (String cloum : cloums) {
            customize_cloum.add(cloum);
        }
        HashMap map = Read(file, false);
        customize_cloum.clear();
        return map;
    }

    public static String Write(Map dataProject, List<String> cloums) throws ParseException {
        customize_cloum.clear();
        for (String cloum : cloums) {
            customize_cloum.add(cloum);
        }
        String file = WriteXml(dataProject);
        customize_cloum.clear();
        return file;
    }


    public static String WriteXml(Map dataProject) throws ParseException {
        ArrayList tasks = (ArrayList) dataProject.get("Tasks");
        syncTreeNodes(tasks, 1, "", "children");
        tasks = Tree.ToTable(tasks, "-1", "children", "UID", "ParentTaskUID");
        dataProject.put("Tasks", tasks);
        ArrayList Assignments = new ArrayList();
        Iterator var5 = tasks.iterator();

        HashMap asi;
        while (var5.hasNext()) {
            Object task_o = var5.next();
            asi = (HashMap) task_o;
            int duration = Convert.toInt(asi.get("Duration"));
            asi.put("Duration", duration * 8);
            ArrayList PredecessorLink = (ArrayList) asi.get("PredecessorLink");
            if (PredecessorLink != null) {
                int j = 0;

                for (int k = PredecessorLink.size(); j < k; ++j) {
                    Map link = (Map) PredecessorLink.get(j);
                    int linkLag = Convert.toInt(link.get("LinkLag"));
                    if (linkLag != 0) {
                        link.put("LinkLag", Convert.toInt(linkLag * 4800));
                    }
                }
            }

            ArrayList ass = (ArrayList) asi.get("Assignments");
            if (ass != null) {
                Assignments.addAll(ass);
            }
        }

        ArrayList resources = (ArrayList) dataProject.get("Resources");
        int i;
        if (resources != null) {
            for (i = resources.size() - 1; i >= 0; --i) {
                asi = (HashMap) resources.get(i);
                asi.put("MaxUnits", Convert.toInt(asi.get("MaxUnits")));
            }
        }

        if (Assignments != null) {
            for (i = Assignments.size() - 1; i >= 0; --i) {
                asi = (HashMap) Assignments.get(i);
                asi.put("Units", Convert.toInt(asi.get("Units")));
            }
        }

        return MSProjectWrite(dataProject);
    }

    public static String MSProjectWrite(Map dataProject) throws ParseException {
        return ExportToXMLFile(dataProject);
    }

    public static String ExportToXMLFile(Map hs) throws ParseException {
        //File.write(filePath, ToXML(hs));
        return ToXML(hs);
    }

    public static String ToXML(Map hs) throws ParseException {
        ArrayList eaList = (ArrayList) hs.get("ExtendedAttributes");
        if (eaList == null) {
            eaList = new ArrayList();
            hs.put("ExtendedAttributes", eaList);
        }

        HashMap eaText = new HashMap();
        eaText.put("FieldID", 188743731);
        eaText.put("FieldName", "GUID");
        eaText.put("Alias", hs.get("UID"));
        eaList.add(eaText);
        ArrayList tasks = (ArrayList) hs.get("Tasks");
        Iterator var5 = tasks.iterator();

        ArrayList OutlineCodes;
        HashMap ca;
        while (var5.hasNext()) {
            Object task_o = var5.next();
            HashMap task = (HashMap) task_o;
            OutlineCodes = (ArrayList) task.get("ExtendedAttribute");
            if (OutlineCodes == null) {
                OutlineCodes = new ArrayList();
                task.put("ExtendedAttribute", OutlineCodes);
            }

            ca = new HashMap();
            ca.put("FieldID", 188743731);
            ca.put("Value", task.get("UID"));
            OutlineCodes.add(ca);
        }

        if (hs.get("CreationDate") == null) {
            hs.put("CreationDate", new Date());
        }

        if (hs.get("WeekStartDay") == null) {
            hs.put("WeekStartDay", 0);
        }

        if (hs.get("DefaultStartTime") == null) {
            hs.put("DefaultStartTime", "08:00:00");
        }

        if (hs.get("DefaultFinishTime") == null) {
            hs.put("DefaultFinishTime", "17:00:00");
        }

        if (hs.get("MinutesPerDay") == null) {
            hs.put("MinutesPerDay", 480);
        }

        if (hs.get("MinutesPerWeek") == null) {
            hs.put("MinutesPerWeek", 2400);
        }

        if (hs.get("DaysPerMonth") == null) {
            hs.put("DaysPerMonth", 20);
        }

        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" standalone=\"yes\"?><Project xmlns=\"http://schemas.microsoft.com/project\">");
        sb.append("<SaveVersion>1000</SaveVersion>");
        sb.append("<UID>" + hs.get("UID") + "</UID>");
        sb.append("<Author>" + hs.get("Author") + "</Author>");
        sb.append("<Name>" + ToCDATAString(hs.get("Name")) + "</Name>");
        sb.append("<StartDate>" + ToDateTimeString(hs.get("StartDate"), true) + "</StartDate>");
        sb.append("<FinishDate>" + ToDateTimeString(hs.get("FinishDate"), false) + "</FinishDate>");
        sb.append("<CreationDate>" + ToDateTimeString(hs.get("CreationDate")) + "</CreationDate>");
        sb.append("<CalendarUID>" + hs.get("CalendarUID") + "</CalendarUID>");
        sb.append("<WeekStartDay>" + hs.get("WeekStartDay") + "</WeekStartDay>");
        sb.append("<DefaultStartTime>" + hs.get("DefaultStartTime") + "</DefaultStartTime>");
        sb.append("<DefaultFinishTime>" + hs.get("DefaultFinishTime") + "</DefaultFinishTime>");
        sb.append("<MinutesPerDay>" + hs.get("MinutesPerDay") + "</MinutesPerDay>");
        sb.append("<MinutesPerWeek>" + hs.get("MinutesPerWeek") + "</MinutesPerWeek>");
        sb.append("<DaysPerMonth>" + hs.get("DaysPerMonth") + "</DaysPerMonth>");
        sb.append("<ProjectExternallyEdited>0</ProjectExternallyEdited>");
        sb.append("<Calendars>");
        ArrayList calendarList = (ArrayList) hs.get("Calendars");
        if (calendarList == null || calendarList.size() == 0) {
            calendarList = GetDefaultCalendars();
            hs.put("Calendars", calendarList);
            hs.put("CalendarUID", "1");
        }

        ArrayList marks;
        Object mark_o;
        Iterator var13;
        HashMap resourceMaps;
        HashMap a;
        HashMap value;
        ArrayList wktmList;
        Object wktm_o;
        Iterator var63;
        for (Iterator var40 = calendarList.iterator(); var40.hasNext(); sb.append("</Calendar>")) {
            Object ca_o = var40.next();
            ca = (HashMap) ca_o;
            String caName = ToCDATAString(ca.get("Name"));
            if (StringUtil.isNullOrEmpty(caName)) {
                caName = "Calendar" + ca.get("UID");
            }

            sb.append("<Calendar>");
            sb.append("<UID>" + ca.get("UID") + "</UID>");
            sb.append("<Name>" + caName + "</Name>");
            sb.append("<IsBaseCalendar>" + ca.get("IsBaseCalendar") + "</IsBaseCalendar>");
            sb.append("<BaseCalendarUID>" + ca.get("BaseCalendarUID") + "</BaseCalendarUID>");
            ArrayList weekdayList = (ArrayList) ca.get("WeekDays");
            marks = (ArrayList) ca.get("Exceptions");
            if (marks == null) {
                marks = new ArrayList();
            }

            if (weekdayList != null) {
                sb.append("<WeekDays>");
                var13 = weekdayList.iterator();

                while (true) {
                    while (var13.hasNext()) {
                        mark_o = var13.next();
                        resourceMaps = (HashMap) mark_o;
                        if (resourceMaps.get("DayType").toString().equals("0")) {
                            marks.add(resourceMaps);
                        } else {
                            sb.append("<WeekDay>");
                            sb.append("<DayType>" + resourceMaps.get("DayType") + "</DayType>");
                            sb.append("<DayWorking>" + resourceMaps.get("DayWorking") + "</DayWorking>");
                            wktmList = (ArrayList) resourceMaps.get("WorkingTimes");
                            if (wktmList != null) {
                                sb.append("<WorkingTimes>");
                                Iterator var17 = wktmList.iterator();

                                while (var17.hasNext()) {
                                    wktm_o = var17.next();
                                    HashMap wktm = (HashMap) wktm_o;
                                    sb.append("<WorkingTime>");
                                    sb.append("<FromTime>" + wktm.get("FromTime") + "</FromTime>");
                                    sb.append("<ToTime>" + wktm.get("ToTime") + "</ToTime>");
                                    sb.append("</WorkingTime>");
                                }

                                sb.append("</WorkingTimes>");
                            }

                            if (resourceMaps.get("DayWorking").toString().equals("1") && wktmList == null) {
                                sb.append("<WorkingTimes><WorkingTime><FromTime>08:00:00</FromTime><ToTime>12:00:00</ToTime></WorkingTime><WorkingTime><FromTime>13:00:00</FromTime><ToTime>17:00:00</ToTime></WorkingTime></WorkingTimes>");
                            }

                            sb.append("</WeekDay>");
                        }
                    }

                    sb.append("</WeekDays>");
                    break;
                }
            }

            if (marks != null) {
                sb.append("<Exceptions>");

                for (var13 = marks.iterator(); var13.hasNext(); sb.append("</Exception>")) {
                    mark_o = var13.next();
                    resourceMaps = (HashMap) mark_o;
                    sb.append("<Exception>");
                    sb.append("<EnteredByOccurrences>0</EnteredByOccurrences>");
                    sb.append("<Occurrences>1</Occurrences>");
                    sb.append("<Type>1</Type>");
                    sb.append("<DayWorking>" + resourceMaps.get("DayWorking") + "</DayWorking>");
                    sb.append("<Name>" + resourceMaps.get("Name") + "</Name>");
                    sb.append("<TimePeriod>");
                    value = (HashMap) resourceMaps.get("TimePeriod");
                    sb.append("<FromDate>" + ToDateTimeString(value.get("FromDate")) + "</FromDate>");
                    sb.append("<ToDate>" + ToDateTimeString(value.get("ToDate")) + "</ToDate>");
                    sb.append("</TimePeriod>");
                    wktmList = (ArrayList) resourceMaps.get("WorkingTimes");
                    if (wktmList == null) {
                        if ("1".equals(resourceMaps.get("DayWorking").toString())) {
                            sb.append("<WorkingTimes><WorkingTime><FromTime>08:00:00</FromTime><ToTime>12:00:00</ToTime></WorkingTime><WorkingTime><FromTime>13:00:00</FromTime><ToTime>17:00:00</ToTime></WorkingTime></WorkingTimes>");
                        }
                    } else {
                        sb.append("<WorkingTimes>");
                        var63 = wktmList.iterator();

                        while (var63.hasNext()) {
                            wktm_o = var63.next();
                            a = (HashMap) wktm_o;
                            sb.append("<WorkingTime>");
                            sb.append("<FromTime>" + a.get("FromTime") + "</FromTime>");
                            sb.append("<ToTime>" + a.get("ToTime") + "</ToTime>");
                            sb.append("</WorkingTime>");
                        }

                        sb.append("</WorkingTimes>");
                    }
                }

                sb.append("</Exceptions>");
            }
        }

        sb.append("</Calendars>");
        ArrayList ExtendedAttributes = (ArrayList) hs.get("ExtendedAttributes");
        if (ExtendedAttributes != null) {
            sb.append("<ExtendedAttributes>");

            for (Iterator var42 = ExtendedAttributes.iterator(); var42.hasNext(); sb.append("</ExtendedAttribute>")) {
                Object ea_o = var42.next();
                HashMap ea = (HashMap) ea_o;
                sb.append("<ExtendedAttribute>");
                sb.append("<FieldID>" + ea.get("FieldID") + "</FieldID>");
                sb.append("<FieldName>" + ea.get("FieldName") + "</FieldName>");
                if (ea.get("Ltuid") != null) {
                    sb.append("<Ltuid>" + ea.get("Ltuid") + "</Ltuid>");
                }

                if (ea.get("Alias") != null) {
                    sb.append("<Alias>" + ea.get("Alias") + "</Alias>");
                }

                if (ea.get("Guid") != null) {
                    sb.append("<Guid>" + ea.get("Guid") + "</Guid>");
                }
            }

            sb.append("</ExtendedAttributes>");
        }

        OutlineCodes = (ArrayList) hs.get("OutlineCodes");
        HashMap UIDTasks;
        Object v_o;
        Iterator var54;
        if (OutlineCodes != null) {
            sb.append("<OutlineCodes>");

            for (Iterator var46 = OutlineCodes.iterator(); var46.hasNext(); sb.append("</OutlineCode>")) {
                Object oc_o = var46.next();
                UIDTasks = (HashMap) oc_o;
                sb.append("<OutlineCode>");
                if (UIDTasks.get("Guid") != null) {
                    sb.append("<Guid>" + UIDTasks.get("Guid") + "</Guid>");
                }

                marks = (ArrayList) UIDTasks.get("Masks");
                if (marks != null) {
                    sb.append("<Masks>");
                    var13 = marks.iterator();

                    while (var13.hasNext()) {
                        mark_o = var13.next();
                        resourceMaps = (HashMap) mark_o;
                        sb.append("<Mask>");
                        sb.append("<Level>" + resourceMaps.get("Level") + "</Level>");
                        sb.append("<Type>" + resourceMaps.get("Type") + "</Type>");
                        sb.append("<Length>" + resourceMaps.get("Length") + "</Length>");
                        sb.append("<Separator>" + resourceMaps.get("Separator") + "</Separator>");
                        sb.append("</Mask>");
                    }

                    sb.append("</Masks>");
                }

                ArrayList Values = (ArrayList) UIDTasks.get("Values");
                if (Values != null) {
                    sb.append("<Values>");
                    var54 = Values.iterator();

                    while (var54.hasNext()) {
                        v_o = var54.next();
                        value = (HashMap) v_o;
                        sb.append("<Value>");
                        sb.append("<ValueID>" + value.get("ValueID") + "</ValueID>");
                        sb.append("<FieldGUID>" + value.get("FieldGUID") + "</FieldGUID>");
                        sb.append("<ParentValueID>" + value.get("ParentValueID") + "</ParentValueID>");
                        sb.append("<Type>" + value.get("Type") + "</Type>");
                        sb.append("<Value>" + value.get("Value") + "</Value>");
                        sb.append("</Value>");
                    }

                    sb.append("</Values>");
                }
            }

            sb.append("</OutlineCodes>");
        }

        ArrayList Assignments = new ArrayList();
        ArrayList taskList = (ArrayList) hs.get("Tasks");
        UIDTasks = new HashMap();
        Map NewUIDTasks = new HashMap();
        int maxTaskUID = 1;
        var54 = taskList.iterator();

        while (var54.hasNext()) {
            v_o = var54.next();
            value = (HashMap) v_o;
            if (value.get("UID") != null) {
                UIDTasks.put(value.get("UID").toString(), value);
                value.put("UID", maxTaskUID++);
                NewUIDTasks.put(value.get("UID"), value);
            }
        }

        int TaskID = 1;
        sb.append("<Tasks>");
        Iterator var57 = taskList.iterator();

        HashMap pl;
        Map pTask;
        ArrayList plList;
        Object pl_o;
        Iterator var66;
        Object ass_o;
        Iterator var69;
        HashMap ass_m;
        while (var57.hasNext()) {
            Object task_o = var57.next();
            HashMap task = (HashMap) task_o;
            sb.append("<Task>");
            sb.append("<IsNull>0</IsNull>");
            sb.append("<UID>" + task.get("UID") + "</UID>");
            sb.append("<ID>" + TaskID++ + "</ID>");
            sb.append("<Name>" + ToCDATAString(task.get("Name")) + "</Name>");
            sb.append("<Type>" + (task.get("Type") == null ? 1 : task.get("Type")) + "</Type>");
            sb.append("<OutlineNumber>" + task.get("OutlineNumber") + "</OutlineNumber>");
            sb.append("<OutlineLevel>" + task.get("OutlineLevel") + "</OutlineLevel>");
            sb.append("<CalendarUID>" + hs.get("CalendarUID") + "</CalendarUID>");

            if (task.get("Priority") != null) {
                sb.append("<Priority>" + task.get("Priority") + "</Priority>");
            }

            sb.append("<Start>" + ToDateTimeString(task.get("Start")) + "</Start>");
            sb.append("<Finish>" + ToDateTimeString(task.get("Finish")) + "</Finish>");
            sb.append("<Duration>PT" + Convert.toInt(task.get("Duration")) + "H0M0S</Duration>");
            if (task.get("Work") != null) {
                sb.append("<Work>PT" + Convert.toInt(task.get("Work")) + "H0M0S</Work>");
            }

            sb.append("<Estimated>" + (task.get("Estimated") == null ? 0 : task.get("Estimated")) + "</Estimated>");
            sb.append("<PercentComplete>" + task.get("PercentComplete") + "</PercentComplete>");
            sb.append("<Milestone>" + (task.get("Milestone") == null ? 0 : task.get("Milestone")) + "</Milestone>");

            for (String cloum : customize_cloum) {
                if (task.get(cloum) != null) {
                    sb.append("<" + cloum + ">" + task.get(cloum) + "</" + cloum + ">");
                }
            }


            if (task.get("Summary") != null) {
                sb.append("<Summary>" + task.get("Summary") + "</Summary>");
            }

            if (task.get("Critical") != null) {
                sb.append("<Critical>" + task.get("Critical") + "</Critical>");
            }

            if (task.get("HyperLink") != null) {
                sb.append("<HyperLink>" + ToCDATAString(task.get("HyperLink")) + "</HyperLink>");
            }

            if (task.get("HyperLinkAddress") != null) {
                sb.append("<HyperLinkAddress>" + ToCDATAString(task.get("HyperLinkAddress")) + "</HyperLinkAddress>");
            }

            if (task.get("Notes") != null) {
                sb.append("<Notes>" + task.get("Notes") + "</Notes>");
            }

            if (task.get("ConstraintType") != null) {
                sb.append("<ConstraintType>" + task.get("ConstraintType") + "</ConstraintType>");
            }

            if (task.get("ConstraintDate") != null) {
                sb.append("<ConstraintDate>" + ToDateTimeString(task.get("ConstraintDate")) + "</ConstraintDate>");
            }

            if (task.get("Manual") != null) {
                sb.append("<Manual>" + task.get("Manual") + "</Manual>");
                if (task.get("Manual").toString().equals("1")) {
                    if (task.get("ManualStart") == null) {
                        task.put("ManualStart", task.get("Start"));
                    }

                    if (task.get("ManualFinish") == null) {
                        task.put("ManualFinish", task.get("Finish"));
                    }

                    if (task.get("ManualDuration") == null) {
                        task.put("ManualDuration", task.get("Duration"));
                    }
                }
            }

            if (task.get("ManualStart") != null) {
                sb.append("<ManualStart>" + ToDateTimeString(task.get("ManualStart"), "08:00:00") + "</ManualStart>");
            }

            if (task.get("ManualFinish") != null) {
                sb.append("<ManualFinish>" + ToDateTimeString(task.get("ManualFinish"), "17:00:00") + "</ManualFinish>");
            }

            if (task.get("ManualDuration") != null) {
                sb.append("<ManualDuration>PT" + Convert.toInt(task.get("ManualDuration")) + "H0M0S</ManualDuration>");
            }

            sb.append("<FixedCostAccrual>3</FixedCostAccrual>");
            task.get("BaseLine");
            if (task.get("PredecessorLink") != null) {
                plList = new ArrayList();
                if (task.get("PredecessorLink").getClass().getName() != "java.util.ArrayList") {
                    plList.add(task.get("PredecessorLink"));
                } else {
                    plList = (ArrayList) task.get("PredecessorLink");
                }

                var66 = plList.iterator();

                while (var66.hasNext()) {
                    pl_o = var66.next();
                    pl = (HashMap) pl_o;
                    if (pl.get("PredecessorUID") != null) {
                        pTask = (Map) UIDTasks.get(pl.get("PredecessorUID").toString());
                        if (pTask != null) {
                            pl.put("PredecessorUID", pTask.get("UID"));
                            sb.append("<PredecessorLink>");
                            sb.append("<CrossProject>0</CrossProject>");
                            sb.append("<PredecessorUID>" + pl.get("PredecessorUID") + "</PredecessorUID>");
                            sb.append("<Type>" + pl.get("Type") + "</Type>");
                            sb.append("<LinkLag>" + pl.get("LinkLag") + "</LinkLag>");
                            sb.append("<LagFormat>" + pl.get("LagFormat") + "</LagFormat>");
                            sb.append("</PredecessorLink>");
                        }
                    }
                }
            }

            plList = (ArrayList) task.get("ExtendedAttribute");
            if (plList != null) {
                for (var66 = plList.iterator(); var66.hasNext(); sb.append("</ExtendedAttribute>")) {
                    pl_o = var66.next();
                    pl = (HashMap) pl_o;
                    sb.append("<ExtendedAttribute>");
                    sb.append("<FieldID>" + pl.get("FieldID") + "</FieldID>");
                    sb.append("<Value>" + pl.get("Value") + "</Value>");
                    if (pl.get("ValueGUID") != null) {
                        sb.append("<ValueGUID>" + pl.get("ValueGUID") + "</ValueGUID>");
                    }
                }
            }

            sb.append("</Task>");
            ArrayList ass = (ArrayList) task.get("Assignments");
            if (ass != null && ass.size() > 0) {
                var69 = ass.iterator();

                while (var69.hasNext()) {
                    ass_o = var69.next();
                    ass_m = (HashMap) ass_o;
                    ass_m.put("TaskUID", task.get("UID"));
                }

                Assignments.addAll(ass);
            } else {
                ass = new ArrayList();
                a = new HashMap();
                a.put("ResourceUID", -65535);
                a.put("TaskUID", task.get("UID"));
                a.put("Units", 100);
                ass.add(a);
                Assignments.addAll(ass);
            }
        }

        sb.append("</Tasks>");
        resourceMaps = new HashMap();
        int resourceUID = 1;
        wktmList = (ArrayList) hs.get("Resources");
        if (wktmList == null) {
            wktmList = new ArrayList();
        }

        sb.append("<Resources>");
        var63 = wktmList.iterator();

        while (var63.hasNext()) {
            wktm_o = var63.next();
            a = (HashMap) wktm_o;
            int reUID = resourceUID++;
            resourceMaps.put(a.get("UID"), reUID);
            sb.append("<Resource>");
            sb.append("<UID>" + reUID + "</UID>");
            sb.append("<Type>" + a.get("Type") + "</Type>");
            sb.append("<Name>" + ToCDATAString(a.get("Name")) + "</Name>");
            sb.append("</Resource>");
        }

        sb.append("</Resources>");
        plList = (ArrayList) hs.get("Assignments");
        if (plList != null) {
            var66 = plList.iterator();

            while (var66.hasNext()) {
                pl_o = var66.next();
                pl = (HashMap) pl_o;
                pTask = (Map) UIDTasks.get(pl.get("TaskUID"));
                pl.put("TaskUID", pTask.get("UID"));
            }

            Assignments.addAll(plList);
        }

        sb.append("<Assignments>");
        int assUID = 1;
        var69 = Assignments.iterator();

        while (var69.hasNext()) {
            ass_o = var69.next();
            ass_m = (HashMap) ass_o;
            Map task = (Map) NewUIDTasks.get(ass_m.get("TaskUID"));
            if (task != null) {
                int Summary = Convert.toInt(task.get("Summary"));
                if (Summary != 1) {
                    String reUID = ass_m.get("ResourceUID").toString();
                    String reUID2 = resourceMaps.get(reUID) != null ? resourceMaps.get(reUID).toString() : reUID;
                    sb.append("<Assignment>");
                    sb.append("<UID>" + assUID + "</UID>");
                    sb.append("<TaskUID>" + ass_m.get("TaskUID") + "</TaskUID>");
                    sb.append("<ResourceUID>" + reUID2 + "</ResourceUID>");
                    double percent = (double) Convert.toInt(task.get("PercentComplete"));
                    double work = (double) Convert.toInt(task.get("Duration"));
                    double actualWork = percent / 100.0D * work;
                    sb.append("<Work>PT" + Convert.toInt(work) + "H0M0S</Work>");
                    int hours = (int) actualWork;
                    int minutes = (int) ((actualWork - (double) hours) * 60.0D);
                    sb.append("<ActualWork>PT");
                    sb.append(hours + "H");
                    sb.append(minutes + "M");
                    sb.append("0S</ActualWork>");
                    double remainintWrok = work - actualWork;
                    hours = (int) remainintWrok;
                    minutes = (int) ((remainintWrok - (double) hours) * 60.0D);
                    sb.append("<RemainingWork>PT");
                    sb.append(hours + "H");
                    sb.append(minutes + "M");
                    sb.append("0S</RemainingWork>");
                    sb.append("<Units>1</Units>");
                    if (percent > 0.0D) {
                        sb.append("<ActualStart>" + ToDateTimeString(task.get("Start")) + "</ActualStart>");
                    }

                    sb.append("<Start>" + ToDateTimeString(task.get("Start"), "08:00:00") + "</Start>");
                    sb.append("<TimephasedData>");
                    sb.append("<Type>1</Type>");
                    sb.append("<UID>" + assUID + "</UID>");
                    sb.append("<Start>" + ToDateTimeString(task.get("Start")) + "</Start>");
                    sb.append("<Finish>" + ToDateTimeString(task.get("Finish")) + "</Finish>");
                    sb.append("<Unit>1</Unit>");
                    sb.append("<Value>PT" + task.get("Duration") + "H0M0S</Value>");
                    sb.append("</TimephasedData>");
                    sb.append("</Assignment>");
                    ++assUID;
                }
            }
        }

        sb.append("</Assignments>");
        sb.append("</Project>");
        return sb.toString();
    }

    protected static ArrayList GetDefaultCalendars() {
        return (ArrayList) JSON.Decode("[{UID: 1,IsBaseCalendar: 1,BaseCalendarUID:-1,Name: '',WeekDays: [{DayType: 1,DayWorking: 0},{DayType: 2,DayWorking: 1},{DayType: 3,DayWorking: 1},{DayType: 4,DayWorking: 1},{DayType: 5,DayWorking: 1},{DayType: 6,DayWorking: 1},{DayType: 7,DayWorking: 0}],Exceptions:[]}]");
    }

    private static String ToDateTimeString(Object o) throws ParseException {
        if (o == null) {
            return "";
        } else if (o.getClass().getName() == "java.lang.String") {
            return o.toString();
        } else {
            Date date = (Date) o;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd啊HH:mm:ss");
            String str = df.format(date);
            str = str.replace("啊", "T");
            return str;
        }
    }

    private static String ToDateTimeString(Object o, boolean clearTime) throws ParseException {
        if (o == null) {
            return "";
        } else if (o.getClass().getName() == "java.lang.String") {
            return o.toString();
        } else {
            Date date = (Date) o;
            if (clearTime) {
                date = DateUtil.clearTime(date);
            } else {
                date = DateUtil.createDate(DateUtil.getYear(date), DateUtil.getMonth(date), DateUtil.getDate(date), 23, 59, 59);
            }

            return ToDateTimeString(date);
        }
    }

    private static String ToDateTimeString(Object o, String time) throws ParseException {
        if (o == null) {
            return "";
        } else if (o.getClass().getName() == "java.lang.String") {
            return o.toString();
        } else {
            Date date = (Date) o;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd啊");
            String str = df.format(date);
            str = str.replace("啊", "T");
            str = str + time;
            return str;
        }
    }

    private static String ToCDATAString(Object o) {
        String s = Convert.toString(o);
        if (s.indexOf("<") != -1 || s.indexOf(">") != -1 || s.indexOf("&") != -1) {
            s = "<![CDATA[" + s + "]]>";
        }

        return s;
    }

    private static void syncTreeNodes(ArrayList nodes, int outlineLevel, String outlineNumber, String childrenField) {
        int i = 0;

        for (int l = nodes.size(); i < l; ++i) {
            HashMap node = (HashMap) nodes.get(i);
            node.put("OutlineLevel", outlineLevel);
            node.put("OutlineNumber", outlineNumber + (i + 1));
            ArrayList childNodes = (ArrayList) node.get(childrenField);
            if (childNodes != null && childNodes.size() > 0) {
                syncTreeNodes(childNodes, outlineLevel + 1, node.get("OutlineNumber").toString() + ".", childrenField);
            }
        }

    }

    private static int ConvertTime(String time) {
        String[] _time = time.split(":");
        return ConvertTime(Convert.toInt(_time[0]), Convert.toInt(_time[1]), Convert.toInt(_time[2]));
    }

    private static int ConvertTime(int hours, int minutes, int seconds) {
        int sec = hours * 3600;
        sec += minutes * 60;
        sec += seconds;
        return sec;
    }

    public static HashMap Read(MultipartFile file, boolean autoOrder) throws Exception {
        HashMap dataProject = MSProjectRead(file);
        int defaultStartTime = ConvertTime(dataProject.get("DefaultStartTime").toString());
        int defaultFinishTime = ConvertTime(dataProject.get("DefaultFinishTime").toString());
        int MinutesPerDay = dataProject.get("MinutesPerDay") != null ? Convert.toInt(dataProject.get("MinutesPerDay")) : 480;
        int HoursPerDay = MinutesPerDay / 60;
        HashMap hashedTasks = new HashMap();
        ArrayList tasks = (ArrayList) dataProject.get("Tasks");
        int i = 0;
        for (int j = 0; j < tasks.size(); j++) {
            HashMap task = (HashMap) tasks.get(j);
            hashedTasks.put(task.get("UID").toString(), task);
            i = Convert.toInt(task.get("Duration"));
            if (i > 0 && i < HoursPerDay) {
                i = 1;
            } else {
                i /= HoursPerDay;
            }

            task.put("Duration", i);
            Date constraint;
            if (i != 0) {
                Date start = (Date) task.get("Start");
                constraint = (Date) task.get("Finish");
                if (start != null) {
                    if (ConvertTime(start.getHours(), start.getMinutes(), start.getSeconds()) >= defaultFinishTime) {
                        start.setDate(start.getDate() + 1);
                    }

                    task.put("Start", PluSoft.Utils.DateUtil.clearTime(start));
                }

                if (constraint != null) {
                    if (ConvertTime(constraint.getHours(), constraint.getMinutes(), constraint.getSeconds()) <= defaultStartTime) {
                        constraint.setDate(constraint.getDate() - 1);
                    }

                    task.put("Finish", PluSoft.Utils.DateUtil.createDate(PluSoft.Utils.DateUtil.getYear(constraint), PluSoft.Utils.DateUtil.getMonth(constraint), PluSoft.Utils.DateUtil.getDate(constraint), 23, 59, 59));
                }
            }

            if (task.get("ConstraintType") != null && task.get("ConstraintDate") != null) {
                i = Convert.toInt(task.get("ConstraintType"));
                constraint = (Date) task.get("ConstraintDate");
                if (i != 3 && i != 6 && i != 7) {
                    if (ConvertTime(constraint.getHours(), constraint.getMinutes(), constraint.getSeconds()) >= defaultFinishTime) {
                        constraint.setDate(constraint.getDate() + 1);
                    }

                    task.put("ConstraintDate", PluSoft.Utils.DateUtil.clearTime(constraint));
                } else {
                    if (ConvertTime(constraint.getHours(), constraint.getMinutes(), constraint.getSeconds()) <= defaultStartTime) {
                        constraint.setDate(constraint.getDate() - 1);
                    }

                    task.put("ConstraintDate", PluSoft.Utils.DateUtil.createDate(PluSoft.Utils.DateUtil.getYear(constraint), PluSoft.Utils.DateUtil.getMonth(constraint), DateUtil.getDate(constraint), 23, 59, 59));
                }
            }

            ArrayList PredecessorLink = (ArrayList) task.get("PredecessorLink");
            int PercentComplete;
            int Summary;
            if (PredecessorLink != null) {
                Summary = 0;

                for (PercentComplete = PredecessorLink.size(); Summary < PercentComplete; ++Summary) {
                    Map link = (Map) PredecessorLink.get(Summary);
                    int linkLag = Convert.toInt(link.get("LinkLag"));
                    if (linkLag != 0) {
                        link.put("LinkLag", Convert.toInt(linkLag / 4800));
                    }
                }
            }

            Summary = Convert.toInt(task.get("Summary"));
            if (Summary == 0) {
                PercentComplete = Convert.toInt(task.get("PercentComplete"));
                if (PercentComplete > 0) {
                    task.put("ConstraintType", 4);
                    task.put("ConstraintDate", task.get("Start"));
                }
            }

            if (Summary == 0 && Convert.toInt(task.get("Manual")) == 1) {
                task.put("ConstraintType", 2);
                task.put("ConstraintDate", task.get("Start"));
            }
        }

        ArrayList calendars = (ArrayList) dataProject.get("Calendars");

        for (i = calendars.size() - 1; i >= 0; --i) {
            Map c = (Map) calendars.get(i);
            if (c.get("IsBaseCalendar").toString().equals("0")) {
                calendars.remove(i);
            }
        }

        HashMap hashedResource = new HashMap();
        ArrayList resources = (ArrayList) dataProject.get("Resources");
        if(resources != null){
            for (i = resources.size() - 1; i >= 0; --i) {
                HashMap re = (HashMap) resources.get(i);
                hashedResource.put(re.get("UID").toString(), re);
                re.put("MaxUnits", Convert.toInt(re.get("MaxUnits")));
            }
        }

        ArrayList Assignments = (ArrayList) dataProject.get("Assignments");

        if(Assignments != null){
            for (i = Assignments.size() - 1; i >= 0; --i) {
                HashMap align = (HashMap) Assignments.get(i);
                align.put("Units", Convert.toInt(align.get("Units")));
                String taskUID = align.get("TaskUID").toString();
                String resourceUID = align.get("ResourceUID").toString();
                HashMap re = (HashMap) hashedResource.get(resourceUID);
                if (re != null) {
                    HashMap task = (HashMap) hashedTasks.get(taskUID);
                    if (task != null) {
                        ArrayList ass = (ArrayList) task.get("Assignments");
                        if (ass == null) {
                            ass = new ArrayList();
                            task.put("Assignments", ass);
                        }

                        ass.add(align);
                    }
                }
            }
            dataProject.remove("Assignments");
        }

        tasks = ToTaskTree(tasks, "children");
        dataProject.put("Tasks", tasks);
        Project project = new Project();
        project.Logic = true;
        project.Load(dataProject);
        if (autoOrder) {
            project.OrderProjectByStart();
        }

        return dataProject;
    }

    public static HashMap MSProjectRead(MultipartFile file) throws Exception {
        HashMap dataProject = ImportFile(file);
        checkProject(dataProject);
        return dataProject;
    }

    private static ArrayList ToTaskTree(ArrayList tasks, String nodesField) {
        if (tasks.size() > 0 && ((Map) tasks.get(0)).containsKey("ID")) {
            IDCompare idCompare = new IDCompare();
            Collections.sort(tasks, idCompare);
        }

        HashMap TaskRoot = new HashMap();
        TaskRoot.put(nodesField, new ArrayList());
        int i = 0;

        for (i = tasks.size(); i < i; ++i) {
            Map task = (Map) tasks.get(i);
            task.remove(nodesField);
        }

        Map ONashedTasks = new HashMap();
        i = 0;

        for (int l = tasks.size(); i < l; ++i) {
            Map task = (Map) tasks.get(i);
            task.put("_state","added");
            String OutlineNumber = task.get("OutlineNumber").toString();
            String OutlineLevel = task.get("OutlineLevel").toString();
            int lastIndex = OutlineNumber.lastIndexOf(".");
            String parentOutlineNumber = lastIndex >= 0 ? OutlineNumber.substring(0, lastIndex) : "";
            Map parentTask = (Map) ONashedTasks.get(parentOutlineNumber);
            if (parentTask == null) {
                parentTask = TaskRoot;
            }

            ArrayList Nodes = (ArrayList) ((Map) parentTask).get(nodesField);
            if (Nodes == null) {
                Nodes = new ArrayList();
                ((Map) parentTask).put(nodesField, Nodes);
            }

            Nodes.add(task);
            ONashedTasks.put(OutlineNumber, task);
        }

        return (ArrayList) TaskRoot.get(nodesField);
    }

    private static void checkProject(HashMap project) {
        if (project.get("FinishDate") == null) {
            Date date = (Date) project.get("StartDate");
            date = new Date(date.getTime());
            date.setDate(date.getDate() + 30);
            project.put("FinishDate", date);
        }

        if (project.get("DefaultStartTime") == null) {
            project.put("DefaultStartTime", "08:00:00");
        }

        if (project.get("DefaultFinishTime") == null) {
            project.put("DefaultFinishTime", "17:00:00");
        }

        if (project.get("MinutesPerDay") == null) {
            project.put("MinutesPerDay", 480);
        }

        if (project.get("MinutesPerWeek") == null) {
            project.put("MinutesPerWeek", 2400);
        }

        if (project.get("DaysPerMonth") == null) {
            project.put("DaysPerMonth", 20);
        }

        if (project.get("WeekStartDay") == null) {
            project.put("WeekStartDay", 0);
        }

    }

    public static HashMap ImportFile(MultipartFile file) throws Exception {
        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();
        domfac.setExpandEntityReferences(false);
        DocumentBuilder dombuilder = domfac.newDocumentBuilder();
        InputStream is = null;
        Document doc = null;

        try {
            is = file.getInputStream();
            doc = dombuilder.parse(is);
        } catch (Exception var14) {
            var14.printStackTrace();
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException var13) {
                    var13.printStackTrace();
                }
            }

        }

        return (HashMap) XML2OBJ(doc);
    }

    private static Object XML2OBJ(Document doc) throws Exception {
        Element root = doc.getDocumentElement();
        HashMap project = getObjectFromXML(root);
        ArrayList list = (ArrayList) project.get("ExtendedAttributes");
        if(list == null){
            return project;
        }
        Iterator var5 = list.iterator();

        while (var5.hasNext()) {
            Object obj = var5.next();
            HashMap o = (HashMap) obj;
            if (o.get("FieldID").toString().equals("188743731")) {
                project.put("UID", o.get("Alias"));
                break;
            }
        }

        return project;
    }

    private static HashMap getObjectFromXML(Element root) throws Exception {
        NodeList lst = root.getChildNodes();
        HashMap hs = new HashMap();
        if (lst == null) {
            return null;
        } else {
            ArrayList list;
            for (int it = 0; it < lst.getLength(); ++it) {
                Node nd = lst.item(it);
                NodeList tmp = nd.getChildNodes();
                String name = nd.getNodeName();
                String value = null;
                if (tmp != null && tmp.item(0) != null) {
                    value = tmp.item(0).getNodeValue();
                }

                if (name.equals("UID") || name.equals("Author") || name.equals("Name") || name.equals("CalendarUID") || name.equals("DefaultStartTime") || name.equals("DefaultFinishTime")) {
                    hs.put(name, value);
                }

                if (name.equals("MinutesPerDay") || name.equals("MinutesPerWeek") || name.equals("DaysPerMonth") || name.equals("WeekStartDay")) {
                    hs.put(name, toInt(value));
                }

                if (name.equals("CreationDate") || name.equals("LastSaved") || name.equals("StartDate") || name.equals("FinishDate")) {
                    hs.put(name, parseDate(value));
                }

                if (name.equals("Calendars")) {
                    hs.put(name, getCalendars(nd));
                }

                if (name.equals("Assignments")) {
                    hs.put(name, getAssignments(nd));
                }

                if (name.equals("Resources")) {
                    hs.put(name, getResources(nd));
                }

                if (name.equals("Tasks")) {
                    hs.put(name, getTasks(nd));
                }

                if (name.equals("ExtendedAttributes")) {
                    hs.put("ExtendedAttributes", getNodesList(nd));
                }

                if (name.equals("OutlineCodes")) {
                    list = new ArrayList();
                    NodeList node_list = nd.getChildNodes();

                    for (int i = 0; i < node_list.getLength(); ++i) {
                        NodeList child = node_list.item(i).getChildNodes();
                        if (child.getLength() > 0) {
                            HashMap o = new HashMap();

                            for (int j = 0; j < child.getLength(); ++j) {
                                Node _node = child.item(j);
                                String nodeName = _node.getNodeName();
                                putNodeValue(o, _node);
                                if (nodeName.equals("Masks")) {
                                    o.put("Masks", getNodesList(_node));
                                }

                                if (nodeName.equals("Values")) {
                                    o.put("Values", getNodesList(_node));
                                }
                            }

                            list.add(o);
                        }
                    }

                    hs.put("OutlineCodes", list);
                }
            }

            ArrayList calendars = (ArrayList) hs.get("Calendars");
            int i = 0;

            for (int l = calendars.size(); i < l; ++i) {
                HashMap calendar = (HashMap) calendars.get(i);
                ArrayList WeekDays = (ArrayList) calendar.get("WeekDays");
                if (WeekDays != null) {
                    list = (ArrayList) calendar.get("Exceptions");
                    if (list == null) {
                        list = new ArrayList();
                        calendar.put("Exceptions", list);
                    }

                    for (int j = WeekDays.size() - 1; j >= 0; --j) {
                        HashMap weekday = (HashMap) WeekDays.get(j);
                        if (weekday.get("DayType") == null || weekday.get("DayType").toString().equals("0")) {
                            WeekDays.remove(weekday);
                        }
                    }
                }
            }

            if (calendars != null && calendars.size() > 0 && (hs.get("CalendarUID") == null || hs.get("CalendarUID").toString().equals("null"))) {
                hs.put("CalendarUID", ((Map) calendars.get(0)).get("UID"));
            }

            return hs;
        }
    }

    private static String putNodeValue(Map o, Node nd) {
        String name = nd.getNodeName();
        String text = null;
        NodeList tmp2 = nd.getChildNodes();
        if (tmp2 != null && tmp2.item(0) != null) {
            text = tmp2.item(0).getNodeValue();
        }

        if (name != null && !name.equals("#text")) {
            o.put(name, text);
        }

        return name;
    }

    private static ArrayList getNodesList(Node nd) {
        ArrayList list = new ArrayList();
        NodeList node_list = nd.getChildNodes();

        for (int i = 0; i < node_list.getLength(); ++i) {
            NodeList child = node_list.item(i).getChildNodes();
            if (child.getLength() > 0) {
                HashMap o = new HashMap();

                for (int j = 0; j < child.getLength(); ++j) {
                    putNodeValue(o, child.item(j));
                }

                list.add(o);
            }
        }

        return list;
    }

    private static Object getTasks(Node nd) throws Exception {
        ArrayList lst = new ArrayList();
        NodeList task_list = nd.getChildNodes();

        HashMap hs;
        int j;
        String name;
        ArrayList list;
        for (int i = 0; i < task_list.getLength(); ++i) {
            NodeList task_child = task_list.item(i).getChildNodes();
            hs = new HashMap();
            if (task_child.getLength() > 0) {
                for (j = 0; j < task_child.getLength(); ++j) {
                    Node taskNode = task_child.item(j);
                    name = taskNode.getNodeName();
                    String value = null;
                    NodeList tmp = taskNode.getChildNodes();
                    if (tmp != null && tmp.item(0) != null) {
                        value = tmp.item(0).getNodeValue();
                    }
                    for (String cloum : customize_cloum) {
                        if (name.equals(cloum)) {
                            hs.put(name, value);
                        }
                    }
                    if (name.equals("UID") || name.equals("Name") || name.equals("OutlineNumber") || name.equals("Hyperlink") || name.equals("HyperlinkAddress") || name.equals("Notes") || name.equals("WBS")) {
                        hs.put(name, value);
                    }

                    if (name.equals("ID") || name.equals("Manual") || name.equals("Type") || name.equals("OutlineLevel") || name.equals("DurationFormat") || name.equals("PercentComplete") || name.equals("ConstraintType") || name.equals("Milestone") || name.equals("Summary") || name.equals("Critical") || name.equals("Priority") || name.equals("Estimated") || name.equals("IsSubproject") || name.equals("IsSubprojectReadOnly") || name.equals("IsNull")) {
                        hs.put(name, toInt(value));
                    }

                    if (name.equals("Duration") || name.equals("Work") || name.equals("ActualDuration")) {
                        hs.put(name, getDuration(value));
                    }

                    if (name.equals("CreateDate") || name.equals("Start") || name.equals("Finish") || name.equals("ConstraintDate") || name.equals("ActualStart") || name.equals("ActualFinish")) {
                        hs.put(name, parseDate(value));
                    }

                    if (name.equals("PredecessorLink")) {
                        if (hs.containsKey(name)) {
                            ((ArrayList) hs.get(name)).add(getPredecessorLink(task_child.item(j)));
                        } else {
                            list = new ArrayList();
                            list.add(getPredecessorLink(task_child.item(j)));
                            hs.put(name, list);
                        }
                    }

                    if (name.equals("ExtendedAttribute")) {
                        list = (ArrayList) hs.get("ExtendedAttribute");
                        if (list == null) {
                            list = new ArrayList();
                            hs.put("ExtendedAttribute", list);
                        }

                        NodeList node_list = taskNode.getChildNodes();
                        HashMap o = new HashMap();

                        for (int jj = 0; jj < node_list.getLength(); ++jj) {
                            Node _node = node_list.item(jj);
                            String text = null;
                            NodeList tmp2 = _node.getChildNodes();
                            if (tmp != null && tmp2.item(0) != null) {
                                text = tmp2.item(0).getNodeValue();
                            }

                            String _name = _node.getNodeName();
                            if (_name != null && !_name.equals("#text")) {
                                o.put(_node.getNodeName(), text);
                            }
                        }

                        if (o.get("FieldID").toString().equals("188743731")) {
                            hs.put("GUID", o.get("Value").toString());
                        }

                        list.add(o);
                    }
                }

                if (!hs.get("UID").toString().equals("0") && hs.get("OutlineLevel") != null && !hs.get("IsNull").toString().equals("1")) {
                    lst.add(hs);
                }
            }
        }

        HashMap preTask = null;

        for (int i = 0; i < lst.size(); ++i) {
            hs = (HashMap) lst.get(i);
            if (preTask == null) {
                hs.put("OutlineNumber", "1");
            } else {
                j = (Integer) preTask.get("OutlineLevel");
                int outlineLevel = (Integer) hs.get("OutlineLevel");
                name = preTask.get("OutlineNumber").toString();
                String[] ss = name.split("\\.");
                List<String> ls = new ArrayList();

                int count;
                for (count = 0; count < ss.length; ++count) {
                    ls.add(ss[count]);
                }

                if (outlineLevel > j) {
                    hs.put("OutlineNumber", preTask.get("OutlineNumber").toString() + ".1");
                } else if (outlineLevel == j) {
                    count = Convert.toInt(ls.get(ls.size() - 1));
                    ls.set(ls.size() - 1, Convert.toString(count + 1));
                    String outlineNumber = StringUtil.join(ls, ".");
                    hs.put("OutlineNumber", outlineNumber);
                } else if (outlineLevel < j) {
                    list = new ArrayList();

                    for (count = 0; count < outlineLevel; ++count) {
                        list.add((String) ls.get(count));
                    }

                    count = Convert.toInt(list.get(list.size() - 1));
                    list.set(list.size() - 1, Convert.toString(count + 1));
                    String outlineNumber = StringUtil.join(list, ".");
                    hs.put("OutlineNumber", outlineNumber);
                }
            }

            preTask = hs;
        }

        return lst;
    }

    private static String getDuration(String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            return "0";
        } else if (value.equals("PTnullH0M0S")) {
            return "0";
        } else {
            String str = value.substring(2);
            String[] res = str.split("H");
            double h = Double.parseDouble(res[0]);
            String[] res2 = res[1].split("M");
            double m = Double.parseDouble(res2[0]);
            String[] res3 = res2[1].split("S");
            double s = Double.parseDouble(res3[0]);
            String v = String.valueOf(h + m / 60.0D + s / 60.0D / 60.0D);
            if (v.equals("0.0")) {
                v = "0";
            }

            int n = StringUtil.toInt(v);
            v = Convert.toString(n);
            return v;
        }
    }

    private static Date parseDate(Object value) throws Exception {
        if (value != null && !value.toString().equals("")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date date = df.parse(value.toString());
            return date;
        } else {
            return null;
        }
    }

    private static Object getPredecessorLink(Node nd) {
        HashMap hs = new HashMap();
        NodeList child = nd.getChildNodes();

        for (int i = 0; i < child.getLength(); ++i) {
            Node _node = child.item(i);
            String name = _node.getNodeName();
            String value = null;
            NodeList tmp = _node.getChildNodes();
            if (tmp != null && tmp.item(0) != null) {
                value = tmp.item(0).getNodeValue();
            }

            if (name.equals("PredecessorUID")) {
                hs.put(name, value);
            }

            if (name.equals("Type") || name.equals("LinkLag") || name.equals("LagFormat")) {
                hs.put(name, toInt(value));
            }
        }

        return hs;
    }

    private static Object getResources(Node nd) {
        ArrayList lst = new ArrayList();
        NodeList resource_list = nd.getChildNodes();

        for (int i = 0; i < resource_list.getLength(); ++i) {
            NodeList child = resource_list.item(i).getChildNodes();
            HashMap hs = new HashMap();
            if (child.getLength() > 0) {
                for (int j = 0; j < child.getLength(); ++j) {
                    Node _node = child.item(j);
                    String name = _node.getNodeName();
                    String value = null;
                    NodeList tmp = _node.getChildNodes();
                    if (tmp != null && tmp.item(0) != null) {
                        value = tmp.item(0).getNodeValue();
                    }

                    if (!StringUtil.isNullOrEmpty(value)) {
                        if (name.equals("UID") || name.equals("Name")) {
                            hs.put(name, value);
                        }

                        if (name.equals("Type") || name.equals("MaxUnits") || name.equals("Cost")) {
                            hs.put(name, StringUtil.toInt(value));
                        }
                    }
                }

                if (!hs.get("UID").toString().equals("0")) {
                    lst.add(hs);
                }
            }
        }

        return lst;
    }

    private static Object getAssignments(Node nd) {
        ArrayList lst = new ArrayList();
        if (nd == null) {
            return null;
        } else {
            NodeList assigment_list = nd.getChildNodes();

            for (int i = 0; i < assigment_list.getLength(); ++i) {
                NodeList child = assigment_list.item(i).getChildNodes();
                HashMap hs = new HashMap();
                if (child.getLength() > 0) {
                    for (int j = 0; j < child.getLength(); ++j) {
                        String name = child.item(j).getNodeName();
                        NodeList tmp;
                        if (name.equals("TaskUID")) {
                            tmp = child.item(j).getChildNodes();
                            hs.put(name, tmp.item(0).getNodeValue());
                        } else if (name.equals("ResourceUID")) {
                            tmp = child.item(j).getChildNodes();
                            hs.put(name, tmp.item(0).getNodeValue());
                        } else if (name.equals("Units") || name.equals("Cost")) {
                            tmp = child.item(j).getChildNodes();
                            hs.put(name, toInt(tmp.item(0).getNodeValue()));
                        }
                    }
                }

                if (hs.size() > 0 && !hs.get("ResourceUID").equals("-65535")) {
                    lst.add(hs);
                }
            }

            return lst;
        }
    }

    private static Object getCalendars(Node nd) throws Exception {
        ArrayList lst = new ArrayList();
        NodeList calendar_list = nd.getChildNodes();

        for (int i = 0; i < calendar_list.getLength(); ++i) {
            NodeList child = calendar_list.item(i).getChildNodes();
            HashMap hs = new HashMap();
            if (child.getLength() > 0) {
                for (int j = 0; j < child.getLength(); ++j) {
                    Node _node = child.item(j);
                    String name = _node.getNodeName();
                    String value = null;
                    NodeList tmp = _node.getChildNodes();
                    if (tmp != null && tmp.item(0) != null) {
                        value = tmp.item(0).getNodeValue();
                    }

                    if (name.equals("UID") || name.equals("Name") || name.equals("BaseCalendarUID")) {
                        hs.put(name, value);
                    }

                    if (name.equals("IsBaseCalendar")) {
                        hs.put(name, toInt(value));
                    }

                    if (name.equals("WeekDays")) {
                        hs.put(name, getWeekDays(_node));
                    }

                    if (name.equals("Exceptions")) {
                        hs.put(name, getExceptions(_node));
                    }
                }

                lst.add(hs);
            }
        }

        return lst;
    }

    private static ArrayList getExceptions(Node nd) throws Exception {
        ArrayList lst = new ArrayList();
        NodeList exception_list = nd.getChildNodes();

        for (int i = 0; i < exception_list.getLength(); ++i) {
            NodeList child = exception_list.item(i).getChildNodes();
            HashMap hs = new HashMap();
            if (child.getLength() > 0) {
                for (int j = 0; j < child.getLength(); ++j) {
                    Node _node = child.item(j);
                    String name = _node.getNodeName();
                    String value = null;
                    NodeList tmp = _node.getChildNodes();
                    if (tmp != null && tmp.item(0) != null) {
                        value = tmp.item(0).getNodeValue();
                    }

                    if (name.equals("Name")) {
                        hs.put(name, value);
                    }

                    if (name.equals("DayWorking") || name.equals("DayType")) {
                        hs.put(name, toInt(value));
                    }

                    if (name.equals("TimePeriod")) {
                        hs.put(name, getTimePeriod(_node));
                    }

                    if (name.equals("WorkingTimes")) {
                        hs.put(name, getWorkingTimes(_node));
                    }
                }

                hs.put("DayType", 0);
                lst.add(hs);
            }
        }

        return lst;
    }

    private static Object getTimePeriod(Node nd) throws Exception {
        HashMap hs = new HashMap();
        NodeList child_list = nd.getChildNodes();

        for (int i = 0; i < child_list.getLength(); ++i) {
            String name = child_list.item(i).getNodeName();
            NodeList tmp;
            String value;
            if (name.equals("FromDate")) {
                tmp = child_list.item(i).getChildNodes();
                value = tmp.item(0).getNodeValue();
                hs.put(name, parseDate(value));
            } else if (name.equals("ToDate")) {
                tmp = child_list.item(i).getChildNodes();
                value = tmp.item(0).getNodeValue();
                hs.put(name, parseDate(value));
            }
        }

        return hs;
    }

    private static Object getWeekDays(Node nd) throws Exception {
        String[] fid = new String[]{"DayType", "DayWorking"};
        ArrayList lst = new ArrayList();
        NodeList weekday_list = nd.getChildNodes();

        for (int i = 0; i < weekday_list.getLength(); ++i) {
            NodeList child = weekday_list.item(i).getChildNodes();
            HashMap hs = new HashMap();
            if (child.getLength() > 0) {
                for (int j = 0; j < child.getLength(); ++j) {
                    String name = child.item(j).getNodeName();

                    for (int k = 0; k < fid.length; ++k) {
                        if (name.equals(fid[k])) {
                            NodeList tmp = child.item(j).getChildNodes();
                            String value = tmp.item(0).getNodeValue();
                            hs.put(name, toInt(value));
                            break;
                        }
                    }

                    if (name.equals("WorkingTimes")) {
                        hs.put(name, getWorkingTimes(child.item(j)));
                    }

                    if (name.equals("TimePeriod")) {
                        hs.put(name, getTimePeriod(child.item(j)));
                    }
                }

                lst.add(hs);
            }
        }

        return lst;
    }

    private static Object getWorkingTimes(Node nd) {
        String[] fid = new String[]{"FromTime", "ToTime"};
        ArrayList lst = new ArrayList();
        NodeList workingtime_list = nd.getChildNodes();

        for (int i = 0; i < workingtime_list.getLength(); ++i) {
            NodeList child = workingtime_list.item(i).getChildNodes();
            HashMap hs = new HashMap();
            if (child.getLength() > 0) {
                for (int j = 0; j < child.getLength(); ++j) {
                    String name = child.item(j).getNodeName();

                    for (int k = 0; k < fid.length; ++k) {
                        if (name.equals(fid[k])) {
                            NodeList tmp = child.item(j).getChildNodes();
                            String value = tmp.item(0).getNodeValue();
                            hs.put(name, value);
                            break;
                        }
                    }
                }

                lst.add(hs);
            }
        }

        return lst;
    }

    private static int toInt(Object o) {
        if (o == null) {
            return 0;
        } else if (!o.toString().equals("null") && !o.toString().equals("")) {
            boolean var1 = false;

            int i;
            try {
                i = Convert.toInt(o.toString());
            } catch (Exception var3) {
                i = 0;
            }

            return i;
        } else {
            return 0;
        }
    }
}
