/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bim.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.vo.BimQureyVO;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.business.bim.vo.ItemVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bim"})
public class BimController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZJKJ_BIM_CODE";
    @Autowired
    private IBimService service;
    @Autowired
    private IBimDetailService detailService;
    @Autowired
    private IExecPlanService execService;
    @Autowired
    private IExecPlanDetailService execDetailService;
    @Autowired
    private SessionManager sessionManager;
    private static final Base64.Encoder encoder = Base64.getEncoder();

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BimVO> saveOrUpdate(@RequestBody BimVO saveOrUpdateVO) {
        BimVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BimVO> queryDetail(Long id) {
        BimVO vo = this.service.syncDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BimVO> queryByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        BimEntity entity = this.service.queryList(queryParam).stream().findAny().orElse(null);
        if (entity == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0bBIM\u6a21\u578b\uff01");
        }
        entity = (BimEntity)((Object)this.service.selectById(entity.getId()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), BimVO.class));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BimVO> vos) {
        Long orgId = InvocationInfoProxy.getOrgId();
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        Collection list = this.service.listByIds(ids);
        for (BimEntity entity : list) {
            if (orgId.equals(entity.getOrgId())) continue;
            return CommonResponse.error((String)"\u6ca1\u6709\u5220\u9664\u6743\u9650\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bimId", new Parameter("in", ids));
        List detaiList = this.detailService.queryList(queryParam);
        this.service.removeByIds(ids, true);
        List delPaths = detaiList.stream().map(BimDetailEntity::getPath).collect(Collectors.toList());
        for (String path : delPaths) {
            TokenHelper.delFile(path);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BimVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BimVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Bim-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBimData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BimVO>> refBimData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BimVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getToken"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getToken() {
        Object token = CacheHelper.get("TOKEN");
        if (token == null) {
            TokenHelper.getTokenData();
            token = CacheHelper.get("TOKEN");
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)String.valueOf(token));
        }
        String url = "https://sales.dxbim.com:8443/api/v3/srv/fs/file/status";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", String.valueOf(token));
        params.put("path", "opendx/9204360f0a8a4bb8a5d523401f2872cb/ef34af2b93e24b4ea6ea6f8cc63e6d17/ef34af2b93e24b4ea6ea6f8cc63e6d17.rvt");
        JSONObject json = null;
        try {
            String response = HttpTookit.getAndHeader((String)url, params);
            json = JSONObject.parseObject((String)response);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (json.containsKey((Object)"error") && json.getJSONObject("error").containsKey((Object)"code") && json.getJSONObject("error").getInteger("code") == 1004) {
            TokenHelper.getTokenData();
            token = CacheHelper.get("TOKEN");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)String.valueOf(token));
    }

    @RequestMapping(value={"/getHiddenItems"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getHiddenItems(@RequestBody BimQureyVO queryVO) {
        ExecPlanEntity exec;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)queryVO.getProjectId()));
        if (CollectionUtils.isEmpty((Collection)queryVO.getAsmPaths())) {
            BimEntity entity = this.service.queryList(queryParam).stream().findAny().orElse(null);
            if (entity == null) {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0bBIM\u6a21\u578b\uff01");
            }
            entity = (BimEntity)((Object)this.service.selectById(entity.getId()));
            String path = entity.getDetailList().stream().filter(x -> x.getModle() != null && x.getModle() == 1).findAny().map(x -> x.getPath()).get();
            queryVO.setAsmPaths(new ArrayList<String>(Arrays.asList(path)));
        }
        if (CollectionUtils.isEmpty((Collection)queryVO.getAsmPaths())) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230BIM\u4e0b\u4e3b\u6a21\u578b\u8def\u5f84\uff01");
        }
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<ItemVO> parents = new ArrayList<ItemVO>();
        if (queryVO.getAsmPaths().size() == 1) {
            JSONObject json = TokenHelper.getFileTree((String)queryVO.getAsmPaths().get(0));
            ItemVO parent = BimController.getItems(json, items, null);
            parents.add(parent);
        }
        if (queryVO.getAsmPaths().size() > 1) {
            for (int i = 0; i < queryVO.getAsmPaths().size(); ++i) {
                JSONObject json = TokenHelper.getFileTree((String)queryVO.getAsmPaths().get(i));
                ItemVO parent = BimController.getItems(json, items, i);
                parents.add(parent);
            }
        }
        if ((exec = (ExecPlanEntity)this.execService.queryList(queryParam).stream().findAny().orElse(null)) == null) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0b\u7684\u6267\u884c\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)exec.getId());
        ew.orderByAsc((Object)"tid");
        List detailList = this.execDetailService.list((Wrapper)ew);
        JSONObject colors = this.getColors();
        JSONArray hiddenItems = new JSONArray();
        JSONArray acturalItems = new JSONArray();
        JSONArray states = new JSONArray();
        JSONArray translucentBim = new JSONArray();
        for (ExecPlanDetailEntity detail : detailList) {
            if (!StringUtils.isNotEmpty((CharSequence)detail.getBimIds())) continue;
            ArrayList<String> bimIds = new ArrayList<String>(Arrays.asList(detail.getBimIds().split(",")));
            for (String bimId : bimIds) {
                if (!items.contains(bimId)) continue;
                JSONObject obj = new JSONObject();
                obj.put("id", (Object)bimId);
                obj.put("time", (Object)detail.getStart());
                obj.put("duration", (Object)detail.getDuration());
                obj.put("uid", (Object)detail.getId());
                obj.put("name", (Object)detail.getName());
                hiddenItems.add((Object)obj);
                if (detail.getActualStart() != null) {
                    JSONObject obj2 = new JSONObject();
                    obj2.put("id", (Object)bimId);
                    obj2.put("time", (Object)detail.getActualStart());
                    obj2.put("duration", (Object)detail.getDuration());
                    obj2.put("uid", (Object)detail.getId());
                    obj2.put("name", (Object)detail.getName());
                    acturalItems.add((Object)obj2);
                }
                JSONArray state = new JSONArray();
                state.add((Object)bimId);
                if (new Integer(1).equals(detail.getFinishState())) {
                    state.add((Object)colors.getJSONArray("blue"));
                } else if (new Integer(2).equals(detail.getFinishState()) && DateUtil.compareDate(detail.getActualStart(), detail.getPlanStart()) > 0) {
                    state.add((Object)colors.getJSONArray("red"));
                } else if (new Integer(2).equals(detail.getFinishState()) && ComputeUtil.isGreaterThan((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) {
                    state.add((Object)colors.getJSONArray("yellow"));
                } else if (new Integer(2).equals(detail.getFinishState()) && ComputeUtil.isLessOrEqual((BigDecimal)detail.getDiffValue(), (BigDecimal)BigDecimal.ZERO)) {
                    state.add((Object)colors.getJSONArray("green"));
                } else {
                    state.add((Object)colors.getJSONArray("white"));
                    translucentBim.add((Object)bimId);
                }
                states.add((Object)state);
            }
        }
        JSONArray newStates = new JSONArray();
        Map<String, JSONArray> colorMap = states.stream().collect(Collectors.toMap(x -> ((JSONArray)x).getString(0), x -> ((JSONArray)x).getJSONArray(1)));
        BimController.getNewStates(newStates, parents, colorMap);
        newStates = newStates.stream().map(x -> {
            JSONArray vo = (JSONArray)x;
            String uid = vo.getString(0);
            if (colorMap.containsKey(uid)) {
                vo.remove(1);
                vo.add(colorMap.get(uid));
            }
            return vo;
        }).collect(Collectors.toCollection(JSONArray::new));
        hiddenItems = hiddenItems.stream().sorted(Comparator.comparing(x -> ((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        acturalItems = acturalItems.stream().sorted(Comparator.comparing(x -> ((JSONObject)x).getDate("time"))).collect(Collectors.toCollection(JSONArray::new));
        JSONObject json = new JSONObject();
        json.put("hiddenItems", (Object)hiddenItems);
        json.put("acturalItems", (Object)acturalItems);
        json.put("states", (Object)newStates);
        json.put("translucentBim", (Object)translucentBim);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)json);
    }

    private static void getNewStates(JSONArray newStates, List<ItemVO> parents, Map<String, JSONArray> colorMap) {
        for (ItemVO parent : parents) {
            String parentId = parent.getUid();
            List children = parent.getChildren();
            if (colorMap.containsKey(parentId)) {
                for (ItemVO item : children) {
                    colorMap.put(item.getUid(), colorMap.get(parentId));
                }
                JSONArray vo = new JSONArray();
                vo.add((Object)parentId);
                vo.add((Object)colorMap.get(parentId));
                newStates.add((Object)vo);
            }
            BimController.getNewStates(newStates, children, colorMap);
        }
    }

    private static List<ItemVO> getChildrens(String root, ItemVO parent) {
        List<ItemVO> children = new ArrayList();
        if (root.equals(parent.getUid())) {
            children = parent.getChildren();
            ArrayList<ItemVO> childs = new ArrayList<ItemVO>();
            for (ItemVO child : children) {
                childs.addAll(BimController.getChildrens(child.getUid(), child));
            }
            children.addAll(childs);
        } else {
            for (ItemVO child : parent.getChildren()) {
                children.addAll(BimController.getChildrens(root, child));
            }
        }
        parent.setChildren(new ArrayList());
        return children;
    }

    private static JSONObject getColors() {
        JSONObject colors = new JSONObject();
        JSONArray blue = new JSONArray();
        blue.add((Object)BimController.safeDiv(69, 255));
        blue.add((Object)BimController.safeDiv(125, 255));
        blue.add((Object)BimController.safeDiv(230, 255));
        colors.put("blue", (Object)blue);
        JSONArray red = new JSONArray();
        red.add((Object)BimController.safeDiv(237, 255));
        red.add((Object)BimController.safeDiv(114, 255));
        red.add((Object)BimController.safeDiv(110, 255));
        colors.put("red", (Object)red);
        JSONArray yellow = new JSONArray();
        yellow.add((Object)BimController.safeDiv(245, 255));
        yellow.add((Object)BimController.safeDiv(195, 255));
        yellow.add((Object)BimController.safeDiv(86, 255));
        colors.put("yellow", (Object)yellow);
        JSONArray green = new JSONArray();
        green.add((Object)BimController.safeDiv(83, 255));
        green.add((Object)BimController.safeDiv(180, 255));
        green.add((Object)BimController.safeDiv(102, 255));
        colors.put("green", (Object)green);
        JSONArray white = new JSONArray();
        white.add((Object)BimController.safeDiv(242, 255));
        white.add((Object)BimController.safeDiv(242, 255));
        white.add((Object)BimController.safeDiv(242, 255));
        colors.put("white", (Object)white);
        return colors;
    }

    private static BigDecimal safeDiv(Integer num1, Integer num2) {
        return BimController.safeDiv(new BigDecimal(num1.toString()), new BigDecimal(num2.toString()));
    }

    private static BigDecimal safeDiv(BigDecimal decimal1, BigDecimal decimal2) {
        if (decimal1 == null || decimal2 == null || decimal2.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal(0);
        }
        return decimal1.divide(decimal2, 18, 4);
    }

    private static ItemVO getItems(JSONObject json, List<String> items, Integer index) {
        String Guid = null;
        if (StringUtils.isNotEmpty((CharSequence)json.getString("Guid"))) {
            Guid = index != null ? encoder.encodeToString((index + "." + json.getString("Guid")).getBytes()) : encoder.encodeToString(json.getString("Guid").getBytes());
            items.add(Guid);
        }
        ArrayList<ItemVO> children = new ArrayList<ItemVO>();
        if (json.containsKey((Object)"Children")) {
            for (Object o : json.getJSONArray("Children")) {
                ItemVO child = BimController.getItems(JSONObject.parseObject((String)o.toString()), items, index);
                child.setParentId(Guid);
                children.add(child);
            }
        }
        ItemVO vo = new ItemVO();
        vo.setUid(Guid);
        vo.setChildren(children);
        return vo;
    }

    public static void main(String[] args) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/7c6b1f21b7d349ef958301438497a4a1/7c6b1f21b7d349ef958301438497a4a1.rvt");
        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/b4df9578f4a949f89c1dfe21fcb3a7ae/b4df9578f4a949f89c1dfe21fcb3a7ae.rvt");
        paths.add("opendx/9204360f0a8a4bb8a5d523401f2872cb/5c872b5ec4de4f86875e7fb4aca79824/5c872b5ec4de4f86875e7fb4aca79824.rvt");
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<ItemVO> parents = new ArrayList<ItemVO>();
        for (int i = 0; i < paths.size(); ++i) {
            JSONObject json = TokenHelper.getFileTree((String)paths.get(i));
            ItemVO parent = BimController.getItems(json, items, i);
            parents.add(parent);
        }
        JSONObject colors = BimController.getColors();
        JSONArray states = new JSONArray();
        JSONArray state = new JSONArray();
        state.add((Object)"MS5mYjlkMmQ3Ni1lOTcxLTRmNjYtODhhMy0xMDAwMDAwMDAwMDA=");
        state.add((Object)colors.getJSONArray("blue"));
        states.add((Object)state);
        JSONArray newStates = new JSONArray();
        Map<String, JSONArray> colorMap = states.stream().collect(Collectors.toMap(x -> ((JSONArray)x).getString(0), x -> ((JSONArray)x).getJSONArray(1)));
        BimController.getNewStates(newStates, parents, colorMap);
        newStates = newStates.stream().map(x -> {
            JSONArray vo = (JSONArray)x;
            String uid = vo.getString(0);
            if (colorMap.containsKey(uid)) {
                vo.remove(1);
                vo.add(colorMap.get(uid));
            }
            return vo;
        }).collect(Collectors.toCollection(JSONArray::new));
        System.out.println(JSONObject.toJSONString((Object)newStates));
    }
}

