/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.fill.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fill.bean.WeekFillDetailEntity;
import com.ejianc.business.fill.bean.WeekFillEntity;
import com.ejianc.business.fill.service.IWeekFillDetailService;
import com.ejianc.business.fill.service.IWeekFillService;
import com.ejianc.business.fill.vo.WeekFillDetailVO;
import com.ejianc.business.fill.vo.WeekFillVO;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.bean.WeekPlanDetailEntity;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IWeekPlanDetailService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.BaseDetailVO;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.WeekPlanDetailVO;
import com.ejianc.business.progress.bean.ProgressDetailEntity;
import com.ejianc.business.progress.utils.ComputeUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"weekFill"})
public class WeekFillController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZJKJ_WEEK_FILL";
    @Autowired
    private IWeekFillService service;
    @Autowired
    private IWeekFillDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IWeekPlanService weekPlanService;
    @Autowired
    private IWeekPlanDetailService weekPlanDetailService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;
    @Autowired
    private IWeekFillDetailService weekFillDetailService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WeekFillVO> saveOrUpdate(@RequestBody WeekFillVO saveOrUpdateVO) {
        WeekFillEntity entity;
        if (StringUtils.isNotEmpty((CharSequence)saveOrUpdateVO.getCalendars())) {
            saveOrUpdateVO.setCalendars(DurationUtil.resetCalender(saveOrUpdateVO.getCalendars()));
        }
        if ((entity = (WeekFillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WeekFillEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            this.detailService.deleteByProgressId(entity.getId());
        }
        Integer subDay = DateUtil.getSubDay(new Date(), entity.getFillDate());
        entity.setFinishFlag(subDay);
        OrgVO orgVO = this.orgUtil.findById(saveOrUpdateVO.getOrgId());
        entity.setCorpId(orgVO.getId());
        entity.setCorpCode(orgVO.getCode());
        entity.setCorpName(orgVO.getName());
        this.service.saveOrUpdate((Object)entity, false);
        List detailList = saveOrUpdateVO.getTasks();
        if (!CollectionUtils.isNotEmpty((Collection)detailList)) return this.queryDetail(entity.getId());
        List<WeekFillDetailVO> voList = TreeHelper2.tree2List(detailList);
        ArrayList<WeekFillDetailEntity> saveList = new ArrayList<WeekFillDetailEntity>();
        for (WeekFillDetailVO mvo : voList) {
            WeekFillDetailEntity detail = WeekFillDetailEntity.convertVoToEntity(mvo);
            detail.setProgressId(entity.getId());
            saveList.add(detail);
        }
        if (!CollectionUtils.isNotEmpty(saveList)) return this.queryDetail(entity.getId());
        this.detailService.saveOrUpdateBatch(saveList);
        return this.queryDetail(entity.getId());
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeekFillVO> queryDetail(Long id) {
        WeekFillVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeekFillVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WeekFillVO weekFillVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WeekFillVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("updateUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WeekFillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WeekFill-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWeekFillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WeekFillVO>> refWeekFillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WeekFillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getWeekFillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeekFillVO> getWeekFillData(@RequestParam(value="weekId") Long weekId, @RequestParam(required=false, value="billId") Long billId) {
        WeekPlanEntity entity = (WeekPlanEntity)((Object)this.weekPlanService.selectById(weekId));
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"progress_id", (Object)weekId);
        qw.orderByAsc((Object)"tid");
        List detailList = this.weekPlanDetailService.list((Wrapper)qw);
        ArrayList<WeekPlanDetailVO> weekDetailVOList = new ArrayList<WeekPlanDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (WeekPlanDetailEntity detail : detailList) {
                weekDetailVOList.add(WeekPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        ExecPlanEntity execEntity = (ExecPlanEntity)((Object)this.execPlanService.selectById(entity.getSourceId()));
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)execEntity), ExecPlanVO.class);
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)entity.getSourceId());
        ew.orderByAsc((Object)"tid");
        List execPlanDetail = this.execPlanDetailService.list((Wrapper)ew);
        ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)execPlanDetail)) {
            for (ExecPlanDetailEntity detail : execPlanDetail) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
        }
        List resultList = detailVOList.stream().filter(ExecPlanDetailVO2 -> weekDetailVOList.stream().map(BaseDetailVO::getStructCode).collect(Collectors.toList()).contains(ExecPlanDetailVO2.getStructCode())).collect(Collectors.toList());
        List<Object> wfList = new ArrayList();
        wfList = resultList.stream().map(ExecPlanDetailVO2 -> {
            WeekFillDetailVO wfvo = new WeekFillDetailVO();
            BeanUtils.copyProperties((Object)ExecPlanDetailVO2, (Object)wfvo);
            return wfvo;
        }).collect(Collectors.toList());
        wfList = TreeHelper2.list2Tree(wfList);
        wfList = TreeHelper2.tree2List(wfList, true);
        vo.setProgressDetailList(null);
        WeekFillVO fillVO = new WeekFillVO();
        BeanUtils.copyProperties((Object)vo, (Object)fillVO);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"week_id", (Object)weekId);
        if (billId != null) {
            queryWrapper.ne((Object)"id", (Object)billId);
        }
        queryWrapper.orderByDesc((Object)"fill_date");
        queryWrapper.last("LIMIT 1");
        WeekFillEntity wfEntity = (WeekFillEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        List fList = new ArrayList();
        Map<Object, Object> fMap = new HashMap();
        if (wfEntity != null) {
            fList = this.weekFillDetailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"progress_id", (Object)wfEntity.getId())).orderByAsc((Object)"tid"));
            fMap = fList.stream().collect(Collectors.toMap(ProgressDetailEntity::getStructCode, a -> a, (k1, k2) -> k1));
        }
        String name = "";
        String percentTask = "";
        String[] arr = new String[]{};
        BigDecimal complete = BigDecimal.ZERO;
        BigDecimal yx = BigDecimal.ZERO;
        BigDecimal cComplete = BigDecimal.ZERO;
        for (WeekFillDetailVO weekFillDetailVO : wfList) {
            for (WeekPlanDetailEntity we : detailList) {
                if (!weekFillDetailVO.getStructCode().equals(we.getStructCode())) continue;
                weekFillDetailVO.setPlanStart(we.getStart());
                weekFillDetailVO.setDuration(we.getDuration());
                weekFillDetailVO.setPlanFinish(we.getFinish());
                weekFillDetailVO.setNodeLevel(we.getNodeLevel());
                weekFillDetailVO.setEmployeeId(we.getEmployeeId());
                weekFillDetailVO.setEmployeeName(we.getEmployeeName());
                weekFillDetailVO.setPlanNum(we.getPlanNum());
                weekFillDetailVO.setUnit(we.getUnit());
                weekFillDetailVO.setResourceName(we.getResourceName());
                weekFillDetailVO.setType(we.getType());
                weekFillDetailVO.setTypeUnit(we.getTypeUnit());
                weekFillDetailVO.setNeedNum(we.getNeedNum());
                complete = MapUtils.isNotEmpty(fMap) ? ComputeUtil.safeSub(new BigDecimal(weekFillDetailVO.getPercentComplete().toString()), fMap.get(we.getStructCode()) != null ? ((WeekFillDetailEntity)((Object)fMap.get(we.getStructCode()))).getCurrentComplete() : BigDecimal.ZERO) : new BigDecimal(weekFillDetailVO.getPercentComplete().toString());
                percentTask = we.getName().replace(weekFillDetailVO.getName(), "");
                if (StringUtils.isNotBlank((CharSequence)percentTask)) {
                    arr = percentTask.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\-", ",").replaceAll("\\%", "").split(",");
                    if (arr.length > 2) {
                        if (arr[0].equals("")) {
                            arr[0] = "-" + arr[1];
                        }
                        if (arr[1].equals("")) {
                            arr[1] = "-" + arr[2];
                        }
                        if (arr[2].equals("")) {
                            arr[1] = "-" + arr[3];
                        }
                    }
                    yx = ComputeUtil.safeSub(new BigDecimal(arr[1]), new BigDecimal(arr[0]));
                } else {
                    yx = new BigDecimal("100");
                }
                cComplete = ComputeUtil.bigDecimalPercent(complete, yx, 0);
                weekFillDetailVO.setCurrentComplete(cComplete.compareTo(new BigDecimal("100")) == 1 ? new BigDecimal("100") : (cComplete.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : cComplete));
            }
            name = StringUtils.isNotBlank((CharSequence)percentTask) ? weekFillDetailVO.getName() + percentTask : weekFillDetailVO.getName();
            weekFillDetailVO.setName(name);
        }
        fillVO.setProgressDetailList(TreeHelper2.list2Tree(wfList));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f!", (Object)fillVO);
    }

    @RequestMapping(value={"/queryWeekFill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Date> queryWeekFill(@RequestParam(value="projectId") Long projectId, @RequestParam(required=false, value="billId") Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (billId != null) {
            wrapper.ne((Object)"id", (Object)billId);
        }
        wrapper.orderByDesc((Object)"fill_date");
        List list = this.service.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01", (Object)((WeekFillEntity)((Object)list.get(0))).getFillDate());
        }
        return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01");
    }
}

