/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.fill.service.IDayFillService;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.cons.PlanCloumCons;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.DurationUtil;
import com.ejianc.business.plan.handler.IPlanHandler;
import com.ejianc.business.plan.handler.PlanFactory;
import com.ejianc.business.plan.mapper.ExecPlanMapper;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.ITotalPlanService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.service.IYearPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.plan.utils.Export;
import com.ejianc.business.plan.utils.OrgUtil;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.XmlVO;
import com.ejianc.business.progress.utils.PlusUtil;
import com.ejianc.business.progress.utils.TreeHelper2;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="execPlanService")
public class ExecPlanServiceImpl
extends BaseServiceImpl<ExecPlanMapper, ExecPlanEntity>
implements IExecPlanService {
    private static final String BILL_CODE = "ZJKJ_EXEC_PLAN";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @Autowired
    private OrgUtil orgUtil;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IExecPlanDetailService detailService;
    @Autowired
    private PlanFactory factory;
    @Autowired
    private ITotalPlanService totalPlanService;
    @Autowired
    private IYearPlanService yearPlanService;
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IWeekPlanService weekPlanService;
    @Autowired
    private IDayFillService dayService;

    @Override
    public ExecPlanVO saveOrUpdate(ExecPlanVO saveOrUpdateVO) {
        List delList;
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(ExecPlanEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        ew.ne(null != saveOrUpdateVO.getId(), BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        List list = super.list((Wrapper)ew);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u6267\u884c\u8ba1\u5212");
        }
        ExecPlanEntity entity = (ExecPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ExecPlanEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        OrgVO org = this.orgUtil.findById(entity.getOrgId());
        entity.setCorpId(org.getId());
        entity.setCorpCode(org.getCode());
        entity.setCorpName(org.getName());
        super.saveOrUpdate((Object)entity);
        List detailList = saveOrUpdateVO.getTasks();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List<ExecPlanDetailVO> voList = TreeHelper2.tree2List(detailList);
            ArrayList<ExecPlanDetailEntity> saveList = new ArrayList<ExecPlanDetailEntity>();
            for (ExecPlanDetailVO vo : voList) {
                if (!"added".equals(vo.get_state()) && !"modified".equals(vo.get_state())) continue;
                ExecPlanDetailEntity detail = ExecPlanDetailEntity.convertVoToEntity(vo);
                detail.setProgressId(entity.getId());
                saveList.add(detail);
            }
            if (CollectionUtils.isNotEmpty(saveList)) {
                this.detailService.saveOrUpdateBatch(saveList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(delList = saveOrUpdateVO.getRemovedTasks()))) {
            ArrayList<String> delIds = new ArrayList<String>();
            for (ExecPlanDetailVO vo : delList) {
                delIds.add(vo.getUid());
            }
            if (CollectionUtils.isNotEmpty(delIds)) {
                this.detailService.removeByIds(delIds);
            }
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public ExecPlanVO queryDetail(Long id) {
        ExecPlanEntity entity = (ExecPlanEntity)((Object)((ExecPlanMapper)this.baseMapper).selectById(id));
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)id);
        ew.orderByAsc((Object)"tid");
        List detailList = this.detailService.list((Wrapper)ew);
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)entity), ExecPlanVO.class);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            JSONObject calender = DurationUtil.getCalender(entity.getCalendars(), entity.getCalendarUid());
            ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
            for (ExecPlanDetailEntity detail : detailList) {
                ExecPlanDetailVO data = ExecPlanDetailEntity.convertEntityToVo(detail);
                data.setStart(data.getPredictStart());
                data.setFinish(data.getPredictFinish());
                if (data.getPredictDuration() != null) {
                    data.setDuration(data.getPredictDuration());
                } else if (!DateUtil.isSameDay(detail.getStart(), data.getStart()) || !DateUtil.isSameDay(detail.getFinish(), data.getFinish())) {
                    data.setDuration(DurationUtil.calculateDuration(data.getStart(), data.getFinish(), calender));
                }
                data.setConstraintType(Integer.valueOf(2));
                data.setConstraintDate(data.getStart());
                Date date = detail.getActualFinish() != null ? detail.getActualFinish() : new Date();
                Date planFinish = detail.getDelayFinish() != null ? detail.getDelayFinish() : detail.getPlanFinish();
                Integer days = DateUtil.getBetweenDays(date, planFinish);
                data.setPlanDiffValue(ComputeUtil.toBigDecimal((Integer)days));
                detailVOList.add(data);
            }
            vo.setProgressDetailList(TreeHelper2.list2Tree(detailVOList));
        }
        return vo;
    }

    @Override
    public ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc) {
        return this.queryDetail(id, planState, startDate, endDate, asc, false);
    }

    @Override
    public ExecPlanVO queryDetail(Long id, Integer planState, Date startDate, Date endDate, Boolean asc, Boolean changeFlag) {
        ExecPlanEntity entity = (ExecPlanEntity)((Object)((ExecPlanMapper)this.baseMapper).selectById(id));
        if (entity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6267\u884c\u8ba1\u5212\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"progress_id", (Object)id);
        ew.orderByAsc((Object)"tid");
        String states = null;
        if (PlanConstant.TOTAL_PLAN.equals(planState)) {
            states = asc == false ? "1,2,3,4" : "1";
        } else if (PlanConstant.YEAR_PLAN.equals(planState)) {
            states = "1,2";
        } else if (PlanConstant.MONTH_PLAN.equals(planState)) {
            states = "1,2,3";
        } else if (PlanConstant.WEEK_PLAN.equals(planState)) {
            states = "1,2,3,4";
        }
        if (StringUtils.isNotEmpty((CharSequence)states)) {
            ew.in((Object)"plan_state", Arrays.asList(states.split(",")));
        }
        List detailList = this.detailService.list((Wrapper)ew);
        ExecPlanVO vo = (ExecPlanVO)BeanMapper.map((Object)((Object)entity), ExecPlanVO.class);
        ArrayList<ExecPlanDetailVO> detailVOList = new ArrayList<ExecPlanDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (ExecPlanDetailEntity detail : detailList) {
                detailVOList.add(ExecPlanDetailEntity.convertEntityToVo(detail));
            }
            List list = (List)Utils.deepCopy(detailVOList);
            List allList = TreeHelper2.list2Tree(list);
            vo.setAllList((List)Utils.deepCopy(allList));
            vo.setProgressDetailList(allList);
        }
        if (startDate == null || endDate == null) {
            return vo;
        }
        startDate = DateUtil.addHours(DateUtil.beginOfDate(startDate), 8);
        endDate = DateUtil.endOfDate(endDate);
        JSONObject calender = DurationUtil.getCalender(entity.getCalendars(), entity.getCalendarUid());
        ArrayList<ExecPlanDetailVO> resultList = new ArrayList<ExecPlanDetailVO>();
        if (CollectionUtils.isNotEmpty(detailVOList)) {
            for (ExecPlanDetailVO detail : detailVOList) {
                Integer fs;
                BigDecimal y;
                if (DateUtil.compareDate(startDate, detail.getPredictFinish()) > 0 || DateUtil.compareDate(endDate, detail.getPredictStart()) < 0) continue;
                if (DateUtil.compareDate(detail.getPredictStart(), startDate) <= 0) {
                    detail.setStart(startDate);
                } else {
                    detail.setStart(detail.getPredictStart());
                }
                if (DateUtil.compareDate(detail.getPredictFinish(), endDate) >= 0) {
                    detail.setFinish(endDate);
                } else {
                    detail.setFinish(detail.getPredictFinish());
                }
                if (detail.getConstraintDate() != null) {
                    detail.setConstraintDate(DurationUtil.getConstraintDate(detail.getStart(), detail.getFinish(), detail.getConstraintType()));
                }
                if (detail.getConstraintType() == 0) {
                    detail.setConstraintType(Integer.valueOf(4));
                    detail.setConstraintDate(detail.getStart());
                }
                Integer duration = DurationUtil.calculateDuration(detail.getStart(), detail.getFinish(), calender);
                detail.setDuration(duration);
                Integer term = DateUtil.getBetweenDays(detail.getPredictFinish(), detail.getPlanStart());
                term = term != null ? Integer.valueOf(term + 1) : null;
                BigDecimal x = new BigDecimal(detail.getPercentComplete());
                if (ComputeUtil.isEmpty((BigDecimal)x).booleanValue() || BooleanUtils.isTrue((Boolean)changeFlag)) {
                    x = ComputeUtil.bigDecimalPercent((Integer)DateUtil.getBetweenDays(detail.getStart(), detail.getPredictStart()), (Integer)term, (int)0);
                }
                if (ComputeUtil.isGreaterThan((BigDecimal)(y = ComputeUtil.bigDecimalPercent((Integer)(fs = (fs = DateUtil.getBetweenDays(detail.getFinish(), detail.getPredictStart())) != null ? Integer.valueOf(fs + 1) : null), (Integer)term, (int)0)), (BigDecimal)new BigDecimal("100"))) {
                    y = new BigDecimal("100");
                }
                if (!ComputeUtil.equals((BigDecimal)x, (BigDecimal)BigDecimal.ZERO) || !ComputeUtil.equals((BigDecimal)y, (BigDecimal)new BigDecimal("100"))) {
                    detail.setPercentTask("(" + x + "%-" + y + "%)");
                }
                BigDecimal planNum = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeSub((BigDecimal)y, (BigDecimal)x), (BigDecimal)new BigDecimal("100")), (BigDecimal)detail.getPlanNum());
                detail.setPlanNum(planNum);
                resultList.add(detail);
            }
        }
        vo.setProgressDetailList(TreeHelper2.list2Tree(resultList));
        return vo;
    }

    @Override
    public ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate) {
        return this.queryRefDetail(projectId, planState, startDate, endDate, false);
    }

    @Override
    public ExecPlanVO queryRefDetail(Long projectId, Integer planState, Date startDate, Date endDate, Boolean changeFlag) {
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"project_id", (Object)projectId);
        ExecPlanEntity entity = (ExecPlanEntity)((Object)((ExecPlanMapper)this.baseMapper).selectOne((Wrapper)ew));
        if (entity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u7684\u603b\u8ba1\u5212\uff01");
        }
        ExecPlanVO vo = this.queryDetail(entity.getId(), planState, startDate, endDate, true, changeFlag);
        return vo;
    }

    @Override
    public Map<String, Object> getDetail(XmlVO xml) {
        Long id = xml.getId();
        if (xml.getId() == null && xml.getProjectId() != null) {
            QueryWrapper ew = new QueryWrapper();
            ew.eq((Object)"project_id", (Object)xml.getProjectId());
            ExecPlanEntity entity = (ExecPlanEntity)((Object)((ExecPlanMapper)this.baseMapper).selectOne((Wrapper)ew));
            if (entity == null) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4e0b\u7684\u603b\u8ba1\u5212\uff01");
            }
            id = entity.getId();
        }
        ExecPlanVO vo = this.queryDetail(id, xml.getPlanState(), xml.getStartDate(), xml.getEndDate(), false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultStartTime", null);
        map.put("CreationDate", null);
        map.put("DaysPerMonth", null);
        List detailList = vo.getProgressDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            List saveVOList = TreeHelper2.tree2List(detailList);
            String jsonString = "";
            try {
                jsonString = new ObjectMapper().writeValueAsString(saveVOList);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List list = JSONObject.parseArray((String)jsonString, Map.class);
            for (Map m : list) {
                if (m.get("PredecessorLink") == null) continue;
                List link = JSONObject.parseArray((String)JSONObject.toJSONString(m.get("PredecessorLink")), Map.class);
                m.put("PredecessorLink", link);
            }
            TreeHelper2.key2ValueList(list);
            map.put("Tasks", TreeHelper2.listMap2Tree(list));
        } else {
            map.put("Tasks", new ArrayList());
        }
        map.put("MinutesPerWeek", null);
        String calendars = vo.getCalendars();
        if (StringUtils.isNotBlank((CharSequence)calendars)) {
            map.put("Calendars", PlusUtil.dealCalendars(calendars));
        } else {
            map.put("Calendars", null);
        }
        map.put("WeekStartDay", null);
        map.put("DefaultFinishTime", null);
        map.put("FinishDate", vo.getPlanEndDate());
        map.put("Name", vo.getProjectName());
        map.put("StartDate", vo.getPlanBeginDate());
        map.put("CalendarUID", vo.getCalendarUid());
        map.put("UID", vo.getId());
        map.put("ExtendedAttributes", null);
        map.put("MinutesPerDay", null);
        map.put("Author", null);
        map.put("Resources", null);
        return map;
    }

    @Override
    public ExecPlanEntity pushExecPlan(Long id, Integer planState) {
        IPlanHandler handler = this.factory.getHandler(planState);
        ExecPlanEntity entity = handler.handle(id);
        return entity;
    }

    @Override
    public ExecPlanEntity pushExecPlanRollBack(Long id, Integer planState) {
        IPlanHandler handler = this.factory.getHandler(planState);
        ExecPlanEntity entity = handler.handleRollback(id);
        return entity;
    }

    @Override
    public ExecPlanEntity updateExecPlan(Long id, Integer planState) {
        IPlanHandler handler = this.factory.getHandler(planState);
        ExecPlanEntity entity = handler.handleUpdate(id);
        return entity;
    }

    @Override
    public CommonResponse<HashMap> getxml(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile file = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            file = (MultipartFile)entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            extName = FileUtils.getFileExt((String)(originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_")), (Boolean)false);
            if ("xml".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        HashMap read = PlusUtil.read(file, PlanCloumCons.EXEC_PLAN_CLOUM);
        Map<String, Map> filed = PlusUtil.getFieldMap((ArrayList)read.get("ExtendedAttributes"), PlanCloumCons.CUSTOMIZE_CLOMN_MAP);
        return CommonResponse.success((String)"\u89e3\u6790\u6570\u636e\u6210\u529f\uff01", (Object)PlusUtil.readMain(read, filed));
    }

    @Override
    public String validateProject(Long projectId, Long billId) {
        List dayList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(dayList = this.dayService.queryList(queryParam)))) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u65e5\u8fdb\u5ea6\u53cd\u9988\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c!");
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("or");
        c1.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        c1.getParams().put("change_status", new Parameter("eq", (Object)PlanConstant.CHANGE_ING));
        if (billId != null) {
            c1.getParams().put("change_id", new Parameter("ne", (Object)billId));
        }
        queryParam.getComplexParams().add(c1);
        List totalList = this.totalPlanService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)totalList)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u53d8\u66f4\u4e2d\u7684\u603b\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c!");
        }
        List yearList = this.yearPlanService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)yearList)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u53d8\u66f4\u4e2d\u7684\u5e74\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c!");
        }
        List monthList = this.monthPlanService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)monthList)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u53d8\u66f4\u4e2d\u7684\u6708\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c!");
        }
        List weekList = this.weekPlanService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)weekList)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u53d8\u66f4\u4e2d\u7684\u5468\u8ba1\u5212\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public void exportxml(HttpServletResponse response, XmlVO vo) {
        Map<String, Object> dataProject = this.getDetail(vo);
        Export.exportExtendedAttributes((HashMap)dataProject, PlanCloumCons.CUSTOMIZE_EXEC_CLOMN_MAP);
        PlusUtil.write(response, vo.getFileName(), dataProject, PlanCloumCons.EXEC_PLAN_CLOUM);
    }

    @Override
    public Object converMap(Object obj, Date startDate, Date endDate, Long projectId) {
        ExecPlanVO execPlan = this.queryRefDetail(projectId, null, null, null);
        execPlan.setProgressDetailList(TreeHelper2.tree2List(execPlan.getProgressDetailList()));
        Object tranList = this.converChildren(obj, startDate, endDate, execPlan);
        return tranList;
    }

    private Object converChildren(Object obj, Date startDate, Date endDate, ExecPlanVO execPlan) {
        List detailVOList = execPlan.getProgressDetailList();
        if (null != obj && obj instanceof List) {
            ArrayList<Map> list = new ArrayList<Map>();
            for (Object o : (List)obj) {
                Object tranList = null;
                if (!(o instanceof Map)) continue;
                Map vo = (Map)o;
                if (vo.get("ParentTaskUID") == null || "-1".equals(String.valueOf(vo.get("ParentTaskUID"))) && vo.get("structCode") == null) {
                    throw new BusinessException("\u8bf7\u9009\u62e9\u4e0a\u7ea7\u8ba1\u5212\u5bfc\u51fa\u7f16\u8f91\u540e\u5bfc\u5165!");
                }
                Object children = vo.get("children");
                if (null != children) {
                    tranList = this.converChildren(children, startDate, endDate, execPlan);
                }
                String structCode = String.valueOf(vo.get("structCode"));
                ExecPlanDetailVO collect = detailVOList.stream().filter(e -> e.getStructCode().equals(structCode)).findAny().orElse(null);
                if (collect == null) {
                    if (this.dealDate(startDate, endDate, execPlan, vo)) continue;
                    vo.put("children", tranList);
                    list.add(vo);
                    continue;
                }
                try {
                    Map map;
                    String jsonString = new ObjectMapper().writeValueAsString((Object)collect);
                    vo = map = (Map)JSONObject.parseObject((String)jsonString, Map.class);
                }
                catch (JsonProcessingException e2) {
                    e2.printStackTrace();
                }
                if (this.dealDate(startDate, endDate, execPlan, vo)) continue;
                this.dealRef(vo);
                vo.put("children", tranList);
                list.add(vo);
            }
            return list;
        }
        return new Object();
    }

    private void dealRef(Map vo) {
        Integer fs;
        BigDecimal y;
        Date start = null;
        Date finish = null;
        Date planStart = null;
        Date predictStart = null;
        Date predictFinish = null;
        try {
            start = sdf.parse(String.valueOf(vo.get("Start")));
            finish = sdf.parse(String.valueOf(vo.get("Finish")));
            planStart = sdf.parse(String.valueOf(vo.get("planStart")));
            predictStart = sdf.parse(String.valueOf(vo.get("predictStart")));
            predictFinish = sdf.parse(String.valueOf(vo.get("predictFinish")));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        BigDecimal planNumDecimal = vo.get("planNum") != null ? new BigDecimal(String.valueOf(vo.get("planNum"))) : null;
        String percentTask = null;
        Integer term = DateUtil.getBetweenDays(predictFinish, planStart);
        term = term != null ? Integer.valueOf(term + 1) : null;
        BigDecimal x = new BigDecimal(String.valueOf(vo.get("PercentComplete")));
        if (ComputeUtil.isEmpty((BigDecimal)x).booleanValue()) {
            x = ComputeUtil.bigDecimalPercent((Integer)DateUtil.getBetweenDays(start, predictStart), (Integer)term, (int)0);
        }
        if (ComputeUtil.isGreaterThan((BigDecimal)(y = ComputeUtil.bigDecimalPercent((Integer)(fs = (fs = DateUtil.getBetweenDays(finish, predictStart)) != null ? Integer.valueOf(fs + 1) : null), (Integer)term, (int)0)), (BigDecimal)new BigDecimal("100"))) {
            y = new BigDecimal("100");
        }
        if (!ComputeUtil.equals((BigDecimal)x, (BigDecimal)BigDecimal.ZERO) || !ComputeUtil.equals((BigDecimal)y, (BigDecimal)new BigDecimal("100"))) {
            percentTask = "(" + x + "%-" + y + "%)";
        }
        BigDecimal planNum = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeSub((BigDecimal)y, (BigDecimal)x), (BigDecimal)new BigDecimal("100")), (BigDecimal)planNumDecimal);
        vo.put("planNum", planNum);
        if (StringUtils.isNotBlank((CharSequence)percentTask)) {
            vo.put("percentTask", percentTask);
            vo.put("Name", String.valueOf(vo.get("Name")) + percentTask);
        }
    }

    private boolean dealDate(Date startDate, Date endDate, ExecPlanVO execPlan, Map vo) {
        JSONObject calender = DurationUtil.getCalender(execPlan.getCalendars(), execPlan.getCalendarUid());
        Date start = null;
        Date finish = null;
        try {
            start = sdf.parse(String.valueOf(vo.get("Start")));
            finish = sdf.parse(String.valueOf(vo.get("Finish")));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (DateUtil.compareDate(startDate, finish) > 0) {
            return true;
        }
        if (DateUtil.compareDate(endDate, start) < 0) {
            return true;
        }
        if (DateUtil.compareDate(start, startDate) <= 0) {
            start = startDate;
        }
        if (DateUtil.compareDate(finish, endDate) >= 0) {
            finish = endDate;
        }
        Integer duration = DurationUtil.calculateDuration(start, finish, calender);
        vo.put("sourceId", execPlan.getId());
        vo.put("sourceBid", vo.get("UID"));
        vo.put("Start", sdf.format(start));
        vo.put("Finish", sdf.format(finish));
        vo.put("Duration", duration);
        Integer constraintType = Integer.valueOf(String.valueOf(vo.get("ConstraintType")));
        if (vo.get("ConstraintDate") != null) {
            Date constraintDate = DurationUtil.getConstraintDate(start, finish, constraintType);
            vo.put("ConstraintDate", sdf.format(constraintDate));
        }
        if (constraintType == 0) {
            vo.put("ConstraintType", 4);
            vo.put("ConstraintDate", sdf.format(start));
        }
        vo.put("FixedDate", 1);
        return false;
    }

    public static void main(String[] args) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date start = sdf.parse("2023-01-01");
            Date finish = sdf.parse("2023-01-31");
            Date planStart = sdf.parse("2022-12-01");
            Date predictFinish = sdf.parse("2023-01-31");
            Integer term = DateUtil.getBetweenDays(predictFinish, planStart) + 1;
            BigDecimal x = new BigDecimal(3);
            BigDecimal y = ComputeUtil.bigDecimalPercent((Integer)(DateUtil.getBetweenDays(finish, planStart) + 1), (Integer)term, (int)0);
            System.out.println(x + "%-" + y + "%");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

