/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.fill.service.IMonthLightService;
import com.ejianc.business.plan.bean.MonthPlanEntity;
import com.ejianc.business.plan.bean.WeekPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.handler.CommonHelper;
import com.ejianc.business.plan.service.IExecPlanService;
import com.ejianc.business.plan.service.IMonthPlanDetailService;
import com.ejianc.business.plan.service.IMonthPlanService;
import com.ejianc.business.plan.service.IWeekPlanService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthPlan")
public class MonthPlanBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IMonthPlanService monthPlanService;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private IExecPlanService execPlanService;
    @Autowired
    private IWeekPlanService weekPlanService;
    @Autowired
    private IMonthLightService monthLightService;
    @Autowired
    private CommonHelper commonHelper;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        List detailList = this.monthPlanDetailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(MonthPlanEntity::getCommitTime, (Object)new Date());
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.monthPlanService.update((Wrapper)lambd);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List detailList = this.monthPlanDetailService.list((Wrapper)new QueryWrapper().eq((Object)"progress_id", (Object)billId));
        this.commonHelper.validateEmployeeEntity(detailList);
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state || BillStateEnum.UNAPPROVED.getBillStateCode() == state) {
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(MonthPlanEntity::getCommitTime, (Object)new Date());
            lambd.eq(BaseEntity::getId, (Object)billId);
            this.monthPlanService.update((Wrapper)lambd);
        }
        MonthPlanEntity planEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(billId));
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(MonthPlanEntity::getApprovedTime, (Object)new Date());
        if (planEntity.getStartDate() != null) {
            Integer subDay = DateUtil.getSubDay(new Date(), planEntity.getPlanBeginDate());
            lambd.set(MonthPlanEntity::getFinishFlag, (Object)subDay);
        }
        if (state == 1) {
            lambd.set(MonthPlanEntity::getCommitTime, (Object)new Date());
        }
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.monthPlanService.update((Wrapper)lambd);
        this.execPlanService.pushExecPlan(billId, PlanConstant.MONTH_PLAN);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        MonthPlanEntity planEntity = (MonthPlanEntity)((Object)this.monthPlanService.selectById(billId));
        if (planEntity.getChangeStatus() != PlanConstant.CHANGE_NO) {
            return CommonResponse.error((String)"\u8ba1\u5212\u5b58\u5728\u53d8\u66f4\u5355\uff0c\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
        }
        this.execPlanService.validateProject(planEntity.getProjectId(), planEntity.getId());
        LambdaQueryWrapper weekQueryWrapper = new LambdaQueryWrapper();
        weekQueryWrapper.eq(WeekPlanEntity::getProjectId, (Object)planEntity.getProjectId());
        weekQueryWrapper.eq(WeekPlanEntity::getPlanMonth, (Object)planEntity.getPlanMonth());
        weekQueryWrapper.eq(BaseEntity::getDr, (Object)0);
        List monthList = this.weekPlanService.list((Wrapper)weekQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)monthList)) {
            return CommonResponse.error((String)"\u6b64\u6708\u8ba1\u5212\u5b58\u5728\u5468\u8ba1\u5212\uff0c\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
        }
        this.monthLightService.remove((Wrapper)new QueryWrapper().eq((Object)"month_plan_id", (Object)billId));
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(MonthPlanEntity::getCommitTime, null);
        lambd.set(MonthPlanEntity::getApprovedTime, null);
        lambd.set(MonthPlanEntity::getFinishFlag, null);
        lambd.eq(BaseEntity::getId, (Object)billId);
        this.monthPlanService.update((Wrapper)lambd);
        this.execPlanService.pushExecPlanRollBack(billId, PlanConstant.MONTH_PLAN);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

