/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.mapper.LightRuleMapper;
import com.ejianc.business.progress.service.ILightRuleService;
import com.ejianc.business.progress.vo.LightRuleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="lightRuleService")
public class LightRuleServiceImpl
extends BaseServiceImpl<LightRuleMapper, LightRuleEntity>
implements ILightRuleService {
    private static final String RULE_CODE = "ZZKJ_LIGHT_RULE";
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public LightRuleVO saveOrUpdate(LightRuleVO saveorUpdateVO) {
        List dataList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("org_id", new Parameter("eq", (Object)saveorUpdateVO.getOrgId()));
        queryParam.getParams().put("industry_type_id", new Parameter("eq", (Object)saveorUpdateVO.getIndustryTypeId()));
        if (saveorUpdateVO.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveorUpdateVO.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(dataList = super.queryList(queryParam)))) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u4e0b\u8be5\u884c\u4e1a\u5df2\u7ecf\u5b58\u5728\u5bf9\u5e94\u4eae\u706f\u89c4\u5219\u6a21\u677f\uff01");
        }
        LightRuleEntity entity = (LightRuleEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, LightRuleEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(RULE_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (LightRuleVO)BeanMapper.map((Object)((Object)entity), LightRuleVO.class);
    }
}

