/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.progress.bean.RiskCorrectionEntity;
import com.ejianc.business.progress.bean.RiskCorrectionHistoryEntity;
import com.ejianc.business.progress.enums.RiskStateEnum;
import com.ejianc.business.progress.service.IRiskCorrectionHistoryService;
import com.ejianc.business.progress.service.IRiskCorrectionService;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="riskCorrection")
public class RiskCorrectionBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRiskCorrectionService correctionService;
    @Autowired
    private IRiskCorrectionHistoryService historyService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.correctionService.selectById(billId));
        entity.setHandleStatus("0");
        entity.setStartTime(new Date());
        this.correctionService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(RiskCorrectionHistoryEntity::getRiskId, (Object)billId)).eq(BaseEntity::getDr, (Object)0);
        List list = this.historyService.list((Wrapper)wrapper);
        list = list.stream().filter(entity -> !entity.getRiskState().equals(RiskStateEnum.CREATE.getCode())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            return CommonResponse.error((String)"\u64a4\u56de\u5931\u8d25\uff0c\u5f53\u524d\u7ea0\u504f\u5355\u5b58\u5728\u5904\u7406\u8bb0\u5f55\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.correctionService.selectById(billId));
        entity.setHandleStatus(null);
        entity.setStartTime(null);
        this.correctionService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.correctionService.selectById(billId));
        entity.setHandleStatus("0");
        entity.setStartTime(new Date());
        this.correctionService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(RiskCorrectionHistoryEntity::getRiskId, (Object)billId)).eq(BaseEntity::getDr, (Object)0);
        List list = this.historyService.list((Wrapper)wrapper);
        list = list.stream().filter(entity -> !entity.getRiskState().equals(RiskStateEnum.CREATE.getCode())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            return CommonResponse.error((String)"\u64a4\u56de\u5931\u8d25\uff0c\u5f53\u524d\u7ea0\u504f\u5355\u5b58\u5728\u5904\u7406\u8bb0\u5f55\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RiskCorrectionEntity entity = (RiskCorrectionEntity)((Object)this.correctionService.selectById(billId));
        entity.setHandleStatus(null);
        entity.setStartTime(null);
        this.correctionService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }
}

