package com.ejianc.poc.pub;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BusinessCodeEnum {
	/**
	 * 人员类别
	 * */
	zai_bian("101301", "在编"),
	pin_yong("101302", "聘用"),
	lao_wu_pai_qian("101303", "劳务派遣"),

	/**
	 * 岗位状态
	 * */
	zai_gang("101401", "在岗"),
	dai_gang("101402", "待岗"),
	nei_tui("101403", "内退"),
	nei_tui_fan_pin("101404", "内退返聘"),
	qi_ta_fei_zai_gang("101405", "其他非在岗"),
	tui_xiu("101406", "退休"),
	tui_xiu_fan_pin("101407", "退休返聘"),
	li_xiu("101408", "离休"),
	diao_li("101409", "调离"),
	si_wang("101410", "死亡"),
	zai_zhi_si_wang("10141001", "在职死亡"),
	li_xiu_si_wang("10141002", "离休死亡"),
	tui_xiu_si_wang("10141003", "退休死亡");

	
	private final String billStateCode;
	private final String description;

	private static Map<String, BusinessCodeEnum> enumMap = new HashMap<>();
	
	BusinessCodeEnum(String billStateCode, String description) {
        this.billStateCode = billStateCode;
        this.description = description;
    }
	
	public String getBillStateCode() {
		return billStateCode;
	}
	public String getDescription() {
		return description;
	}

	static {
		enumMap = EnumSet.allOf(BusinessCodeEnum.class).stream().collect(Collectors.toMap(BusinessCodeEnum::getBillStateCode, Function.identity(), (k1, k2) -> k2));
	}

	public static BusinessCodeEnum getEnumByStateCode(String businessCode) {
		return enumMap.get(businessCode);
	}
}
