/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.poc.bean.UserAuthParam;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.bean.ZtjAppEntity;
import com.ejianc.poc.mapper.ZtjAppMapper;
import com.ejianc.poc.service.IAuthChangeRecordService;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.vo.AuthChangeRecordVO;
import com.ejianc.poc.vo.ZtjAppVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report/"})
public class ReportController {
    @Autowired
    private IWorkAuthService workAuthService;
    @Autowired
    private IAuthChangeRecordService authChangeRecordService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ZtjAppMapper ztjAppMapper;
    @Autowired
    private IWorkAuthSubService workAuthSubService;

    @GetMapping(value={"refreshDelAuthOrgInfo"})
    public CommonResponse<JSONObject> refreshAuthedOrgInfo() {
        List<WorkAuthEntity> authOrgList = this.workAuthService.queryAllAuthOrgList(null, null);
        this.authChangeRecordService.checkOrgList(authOrgList);
        return CommonResponse.success((String)"\u5237\u65b0\u5f53\u524d\u6388\u6743\u7ec4\u7ec7\u3001\u5c97\u4f4d\u4fe1\u606f\u6210\u529f\uff01");
    }

    @GetMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestParam(value="orgId") String orgId, @RequestParam(value="providerId") String providerId, @RequestParam(value="pageSize") int pageSize, @RequestParam(value="pageNumber") int pageNumber, @RequestParam(value="recordType") int recordType) {
        JSONObject resp = new JSONObject();
        List<WorkAuthEntity> authOrgList = this.workAuthService.queryAllAuthOrgList(null, null);
        boolean result = this.authChangeRecordService.checkOrgList(authOrgList);
        if (!result) {
            resp.put("reloadPage", (Object)false);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            queryParam.getParams().put("providerId", new Parameter("eq", (Object)providerId));
            queryParam.getParams().put("type", new Parameter("eq", (Object)recordType));
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            queryParam.getOrderMap().put("createTime", "desc");
            IPage page = this.authChangeRecordService.queryPage(queryParam);
            resp.put("current", (Object)page.getCurrent());
            resp.put("size", (Object)page.getSize());
            resp.put("pages", (Object)page.getPages());
            resp.put("total", (Object)page.getTotal());
            resp.put("records", CollectionUtils.isNotEmpty((Collection)page.getRecords()) ? BeanMapper.mapList((Iterable)page.getRecords(), AuthChangeRecordVO.class) : new ArrayList());
        } else {
            resp.put("reloadPage", (Object)true);
        }
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"authOrgDelRecordsExport"})
    public void authOrgDelRecordsExport(@RequestBody JSONObject paramJson, HttpServletResponse response) {
        String orgId = paramJson.getString("orgId");
        String providerId = paramJson.getString("providerId");
        String recordType = paramJson.getString("recordType");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList list = new ArrayList();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        queryParam.getParams().put("providerId", new Parameter("eq", (Object)providerId));
        queryParam.getParams().put("type", new Parameter("eq", (Object)recordType));
        queryParam.getOrderMap().put("createTime", "desc");
        List records = this.authChangeRecordService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(r -> r.setType(sdf.format(r.getChangeTime())));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().export("auth-org-del-record-export.xlsx", beans, response);
    }

    @GetMapping(value={"queryReportMenuListByCurrentUser"})
    public CommonResponse<List<ZtjAppVO>> queryReportMenuListByCurrentUser() {
        ArrayList<ZtjAppVO> ztjAppVos = new ArrayList<ZtjAppVO>();
        UserContext userContext = this.sessionManager.getUserContext();
        List<UserAuthParam> userAuthParams = this.workAuthSubService.queryUserAuthList(userContext.getDeptCode());
        if (ListUtil.isEmpty(userAuthParams)) {
            return CommonResponse.error((String)"");
        }
        String appIds = "";
        for (UserAuthParam entry : userAuthParams) {
            String appId = entry.getAuthId();
            appIds = appIds + appId + ",";
        }
        if (StringUtils.isNotBlank((CharSequence)appIds)) {
            List<ZtjAppEntity> appEntities = this.ztjAppMapper.queryAppListByIds(appIds.substring(0, appIds.length() - 1));
            for (ZtjAppEntity appEntity : appEntities) {
                if (!"1225".equals(appEntity.getCode()) && !"1226".equals(appEntity.getCode()) && !"1227".equals(appEntity.getCode())) continue;
                ZtjAppVO appVo = (ZtjAppVO)BeanMapper.map((Object)((Object)appEntity), ZtjAppVO.class);
                ztjAppVos.add(appVo);
            }
        }
        return CommonResponse.success(ztjAppVos);
    }
}

