/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.bean.LogParam;
import com.ejianc.poc.bean.PositionChangeEntity;
import com.ejianc.poc.bean.UserPositionEntity;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.bean.WorkAuthSubEntity;
import com.ejianc.poc.service.ILogService;
import com.ejianc.poc.service.IPositionChangeService;
import com.ejianc.poc.service.IUserPositionService;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.service.IZtjAppService;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.PositionChangeVO;
import com.ejianc.poc.vo.WorkAuthVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workAuth"})
public class WorkAuthController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private IWorkAuthService service;
    @Autowired
    private IWorkAuthSubService subService;
    @Autowired
    private IZtjAppService appService;
    @Autowired
    private IPositionChangeService positionChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ILogService logService;
    @Autowired
    private IUserPositionService userPositionService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkAuthVO> saveOrUpdate(@RequestBody WorkAuthVO saveorUpdateVO) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WorkAuthEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<JSONObject> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            QueryParam param = new QueryParam();
            ArrayList<WorkAuthEntity> authEntities = new ArrayList<WorkAuthEntity>();
            JSONArray arrayLog = new JSONArray();
            for (JSONObject vo : vos) {
                JSONObject log = new JSONObject();
                String corpProviderId = vo.getString("corpProviderId");
                String corpPk = vo.getString("corpPk");
                String corpCode = vo.getString("corpCode");
                String targetType = vo.getString("targetType");
                String providerId = vo.getString("providerId");
                String targetId = vo.getString("id");
                param.getParams().put("corpProviderId", new Parameter("eq", (Object)corpProviderId));
                param.getParams().put("corpPk", new Parameter("eq", (Object)corpPk));
                param.getParams().put("targetId", new Parameter("eq", (Object)targetId));
                param.getParams().put("providerId", new Parameter("eq", (Object)providerId));
                param.getParams().put("targetType", new Parameter("eq", (Object)targetType));
                List exist = this.service.queryList(param, false);
                if (ListUtil.isNotEmpty((List)exist)) {
                    return CommonResponse.error((String)("\u6388\u6743\u5bf9\u8c61\u3010" + vo.getString("name") + "\u3011\u5df2\u5b58\u5728\u6388\u6743\u5217\u8868\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6388\u6743\u3002"));
                }
                WorkAuthEntity entity = new WorkAuthEntity();
                entity.setCorpPk(corpPk);
                if (!corpCode.startsWith("root_org_code")) {
                    corpCode = "root_org_code" + corpCode;
                }
                entity.setCorpCode(corpCode);
                entity.setCorpProviderId(corpProviderId);
                JSONArray array = this.ztjApisService.getOrgPath(corpProviderId, corpPk);
                if (array.size() > 0) {
                    log.put("code", (Object)array.getJSONObject(0).getString("code"));
                    StringBuffer paths = new StringBuffer("");
                    if (array != null) {
                        for (int i = array.size() - 1; i > -1; --i) {
                            JSONObject p = array.getJSONObject(i);
                            paths.append(p.getString("name")).append(" ");
                        }
                    }
                    entity.setCorpName(paths.toString());
                }
                if (!"root_org_code".equals(corpProviderId)) {
                    JSONObject corp = this.ztjApisService.getOrgParent(corpProviderId, corpPk);
                    entity.setCorpParentPk(corp.getString("id"));
                    entity.setCorpParentProviderId(corp.getString("providerId"));
                }
                entity.setOrgId(vo.getString("positionId"));
                entity.setProviderId(providerId);
                entity.setTargetType(Integer.valueOf(targetType));
                entity.setTargetId(targetId);
                log.put("entity", (Object)entity);
                arrayLog.add((Object)log);
                authEntities.add(entity);
                if (!"1".equals(targetType)) continue;
                this.userPositionService.saveUserPosition(entity.getTargetId(), providerId);
            }
            this.service.saveOrUpdateBatch(authEntities);
            arrayLog.forEach(en -> {
                JSONObject log = (JSONObject)en;
                LogParam logParam = new LogParam();
                logParam.setWhichNodeOrgCode(log.getString("code"));
                WorkAuthEntity entity = (WorkAuthEntity)((Object)((Object)log.get((Object)"entity")));
                logParam.setWhichNodeOrgId(entity.getCorpPk());
                logParam.setWhichNodeProviderId(entity.getCorpProviderId());
                logParam.setAuthObjectId(entity.getTargetId());
                logParam.setAuthObjectProviderId(entity.getProviderId());
                logParam.setAuthObjectType(entity.getTargetType() + "");
                logParam.setAuthOrgId(entity.getOrgId());
                logParam.setOptType(LogParam.OptTypeEnum.AUTH_OBJECT_ADD);
                this.logService.optLog(logParam);
            });
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdateSubBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateSubBatch(@RequestBody List<JSONObject> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            LogParam logParam = new LogParam();
            JSONObject param = vos.get(0);
            logParam.setWhichNodeOrgCode(param.getString("corpProviderCode"));
            logParam.setWhichNodeOrgId(param.getString("corpPk"));
            logParam.setWhichNodeProviderId(param.getString("corpProviderId"));
            logParam.setAuthObjectId(param.getString("targetId"));
            logParam.setAuthObjectProviderId(param.getString("providerId"));
            logParam.setAuthObjectType(param.getString("targetType"));
            logParam.setAuthOrgId(param.getString("orgId"));
            StringBuilder authNameAdd = new StringBuilder();
            StringBuilder authNameDel = new StringBuilder();
            for (JSONObject vo : vos) {
                WorkAuthSubEntity sub;
                if (vo.get((Object)"authSubId") == null && vo.getBoolean("auth").booleanValue()) {
                    sub = new WorkAuthSubEntity();
                    sub.setPid(vo.getLong("pid"));
                    sub.setAuthId(vo.getLong("id"));
                    sub.setAuthName(vo.getString("name"));
                    if (vo.getLong("id") == 436574189119602768L) {
                        if (vo.getBoolean("manage").booleanValue()) {
                            sub.setManage(1);
                        } else {
                            sub.setManage(0);
                        }
                    }
                    this.subService.saveOrUpdate((Object)sub, false);
                    authNameAdd.append(vo.getString("name"));
                    authNameAdd.append("\u3001");
                    continue;
                }
                if (vo.get((Object)"authSubId") != null && !vo.getBoolean("auth").booleanValue()) {
                    this.subService.removeById(vo.getLong("authSubId"), false);
                    authNameDel.append(vo.getString("name"));
                    authNameDel.append("\u3001");
                    continue;
                }
                if (vo.get((Object)"authSubId") == null || !vo.getBoolean("auth").booleanValue() || vo.getLong("id") != 436574189119602768L) continue;
                sub = (WorkAuthSubEntity)((Object)this.subService.selectById(vo.getLong("authSubId")));
                if (vo.getBoolean("manage").booleanValue()) {
                    sub.setManage(1);
                } else {
                    sub.setManage(0);
                }
                this.subService.saveOrUpdate((Object)sub, false);
            }
            if (authNameAdd.length() > 0) {
                logParam.setAuthAppName(authNameAdd.toString());
                logParam.setOptType(LogParam.OptTypeEnum.APP_AUTH_ADD);
                this.logService.optLog(logParam);
            }
            if (authNameDel.length() > 0) {
                logParam.setAuthAppName(authNameDel.toString());
                logParam.setOptType(LogParam.OptTypeEnum.APP_AUTH_DEL);
                this.logService.optLog(logParam);
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkAuthVO> queryDetail(Long id) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)this.service.selectById(id));
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkAuthVO> vos) {
        String deptCode = this.sessionManager.getUserContext().getDeptCode();
        for (int i = 0; i < vos.size(); ++i) {
            WorkAuthVO vo = vos.get(i);
            if (vo.getTargetId().equals(InvocationInfoProxy.getUserid() + "")) {
                return CommonResponse.error((String)"\u6388\u6743\u5bf9\u8c61\u5305\u542b\u81ea\u5df1\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            }
            if (!deptCode.contains(vo.getTargetId())) continue;
            return CommonResponse.error((String)"\u6388\u6743\u5bf9\u8c61\u5305\u542b\u81ea\u5df1\u7684\u5c97\u4f4d\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("in", vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        List subEntities = this.subService.queryList(param, false);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        if (ListUtil.isNotEmpty((List)subEntities)) {
            this.subService.removeByIds(subEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        JSONObject corp = this.ztjApisService.getSureOrg(vos.get(0).getCorpProviderId(), vos.get(0).getCorpPk());
        vos.forEach(entity -> {
            LogParam logParam = new LogParam();
            logParam.setWhichNodeOrgCode(corp.getString("code"));
            logParam.setWhichNodeOrgId(entity.getCorpPk());
            logParam.setWhichNodeProviderId(entity.getCorpProviderId());
            logParam.setAuthObjectId(entity.getTargetId());
            logParam.setAuthObjectProviderId(entity.getProviderId());
            logParam.setAuthObjectType(entity.getTargetType() + "");
            logParam.setAuthOrgId(entity.getOrgId());
            logParam.setOptType(LogParam.OptTypeEnum.AUTH_OBJECT_DEL);
            this.logService.optLog(logParam);
        });
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkAuthVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkAuthVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(auth -> {
                JSONObject user;
                JSONArray array = null;
                int ii = -1;
                if (auth.getTargetType() == 1) {
                    user = this.ztjApisService.getUser(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    array = this.ztjApisService.getOrgPath(auth.getProviderId(), auth.getOrgId());
                } else {
                    ii = 0;
                    user = this.ztjApisService.getPosition(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    array = this.ztjApisService.getOrgPath(auth.getProviderId(), auth.getTargetId());
                }
                StringBuffer paths = new StringBuffer("");
                if (array != null) {
                    for (int i = array.size() - 1; i > ii; --i) {
                        JSONObject p = array.getJSONObject(i);
                        if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                        paths.append(p.getString("name")).append(" ");
                    }
                }
                auth.setOrgName(paths.toString());
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryStatisticsList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryStatisticsList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getOrderMap().put("corpCode", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkAuthVO.class);
        ArrayList recordList = new ArrayList();
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(auth -> {
                JSONObject user;
                JSONArray array = null;
                int ii = -1;
                if (auth.getTargetType() == 1) {
                    JSONObject position;
                    user = this.ztjApisService.getUser(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    if ((position = this.ztjApisService.getUserMainPosition(auth.getProviderId(), auth.getTargetId())) != null) {
                        if (!Objects.equals(auth.getOrgId(), position.getString("id"))) {
                            auth.setOrgId(position.getString("id"));
                            this.service.saveOrUpdate(BeanMapper.map((Object)auth, WorkAuthEntity.class));
                        }
                        array = this.ztjApisService.getOrgPath(auth.getProviderId(), position.getString("id"));
                    }
                } else {
                    ii = 0;
                    user = this.ztjApisService.getPosition(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    array = this.ztjApisService.getOrgPath(auth.getProviderId(), auth.getTargetId());
                }
                StringBuffer paths = new StringBuffer("");
                if (array != null) {
                    for (int i = array.size() - 1; i > ii; --i) {
                        JSONObject p = array.getJSONObject(i);
                        if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                        paths.append(p.getString("name")).append(" ");
                    }
                }
                auth.setOrgName(paths.toString());
                QueryParam subParam = new QueryParam();
                subParam.getParams().put("pid", new Parameter("eq", (Object)auth.getId()));
                List subEntities = this.subService.queryList(subParam, false);
                JSONObject res = new JSONObject();
                res.put("targetName", (Object)auth.getTargetName());
                res.put("orgName", (Object)auth.getOrgName());
                JSONArray corpName = this.ztjApisService.getOrgPath(auth.getCorpProviderId(), auth.getCorpPk());
                StringBuffer path = new StringBuffer("");
                for (int j = corpName.size() - 1; j > -1; --j) {
                    JSONObject p = corpName.getJSONObject(j);
                    path.append(p.getString("name")).append(" ");
                }
                res.put("corpName", (Object)path);
                res.put("id", (Object)auth.getId());
                if (ListUtil.isNotEmpty((List)subEntities)) {
                    String scope = subEntities.stream().map(WorkAuthSubEntity::getAuthName).collect(Collectors.joining(","));
                    for (WorkAuthSubEntity subEntity : subEntities) {
                        if (subEntity.getManage() != 1 || subEntity.getAuthId() != 436574189119602768L) continue;
                        scope = scope + ",\u5de5\u4f5c\u6388\u6743\u7ba1\u7406\u6743\u9650";
                    }
                    res.put("scope", (Object)scope);
                } else {
                    res.put("scope", (Object)"");
                }
                recordList.add(res);
            });
        }
        pageData.setRecords(recordList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"exportStatisticsList"})
    public void exportExcel(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse<IPage<JSONObject>> commonResponse = this.queryStatisticsList(param);
        if (commonResponse.isSuccess()) {
            IPage page = (IPage)commonResponse.getData();
            List rec = page.getRecords();
            HashMap<String, Object> beans = new HashMap<String, Object>();
            beans.put("records", rec);
            beans.put("sdf", sdf);
            ExcelExport.getInstance().export("auth-statistics-export.xlsx", beans, response);
        } else {
            ArrayList rec = new ArrayList();
            HashMap<String, Cloneable> beans = new HashMap<String, Cloneable>();
            beans.put("records", rec);
            beans.put("sdf", sdf);
            ExcelExport.getInstance().export("auth-statistics-export.xlsx", beans, response);
        }
    }

    @PostMapping(value={"exportAuthPositionChangeList"})
    public void exportAuthPositionChangeList(@RequestBody QueryParam param, HttpServletResponse response) {
        CommonResponse<IPage<PositionChangeVO>> commonResponse = this.queryAuthPositionChangeList(param);
        if (commonResponse.isSuccess()) {
            IPage page = (IPage)commonResponse.getData();
            List rec = page.getRecords();
            HashMap<String, Object> beans = new HashMap<String, Object>();
            if (ListUtil.isNotEmpty((List)rec)) {
                for (PositionChangeVO c : rec) {
                    c.setTargetId(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)c.getCreateTime()));
                }
            }
            beans.put("records", rec);
            beans.put("sdf", sdf);
            ExcelExport.getInstance().export("auth-position-change-export.xlsx", beans, response);
        } else {
            ArrayList rec = new ArrayList();
            HashMap<String, Cloneable> beans = new HashMap<String, Cloneable>();
            beans.put("records", rec);
            beans.put("sdf", sdf);
            ExcelExport.getInstance().export("auth-position-change-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/queryAuthAppList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryAuthAppList(@RequestParam String pid, @RequestParam String corpPk, @RequestParam String corpProviderId) {
        QueryParam param = new QueryParam();
        List appEntities = new ArrayList();
        if (InvocationInfoProxy.getUserid() == 372127L) {
            appEntities = this.appService.queryList(param, false);
        } else {
            String userProviderId = this.sessionManager.getUserContext().getProviderId();
            JSONArray positionArrJson = this.ztjApisService.getUserAllPosition(userProviderId, String.valueOf(InvocationInfoProxy.getUserid()));
            JSONObject positionJson = null;
            StringBuffer authIdBuff = new StringBuffer(InvocationInfoProxy.getUserid() + ",");
            for (int i = 0; i < positionArrJson.size(); ++i) {
                positionJson = positionArrJson.getJSONObject(i);
                authIdBuff.append(positionJson.getString("id")).append(",");
            }
            param.getParams().put("targetId", new Parameter("in", (Object)authIdBuff.substring(0, authIdBuff.length() - 1)));
            ArrayList authEntities = this.service.queryList(param, false);
            if ("root_org_code".equals(corpProviderId)) {
                param.getParams().put("corpPk", new Parameter("eq", (Object)OrgVO.rootOrgId));
                param.getParams().put("corpProviderId", new Parameter("eq", (Object)"root_org_code"));
                List root = this.service.queryList(param, false);
                if (ListUtil.isEmpty((List)authEntities)) {
                    authEntities = new ArrayList();
                }
                if (ListUtil.isNotEmpty((List)root)) {
                    authEntities.addAll(root);
                }
            }
            if (ListUtil.isNotEmpty((List)authEntities)) {
                param = new QueryParam();
                param.getParams().put("pid", new Parameter("in", authEntities.stream().map(BaseEntity::getId).collect(Collectors.toList())));
                List subs = this.subService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)subs)) {
                    param = new QueryParam();
                    param.getParams().put("id", new Parameter("in", subs.stream().map(WorkAuthSubEntity::getAuthId).collect(Collectors.toList())));
                    appEntities = this.appService.queryList(param, false);
                }
            }
        }
        param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)pid));
        List subEntities = this.subService.queryList(param, false);
        ArrayList res = new ArrayList();
        appEntities.forEach(app -> {
            JSONObject object = new JSONObject();
            object.put("id", (Object)app.getId());
            object.put("manage", (Object)false);
            object.put("name", (Object)(app.getName() + "\u6d4f\u89c8\u6743\u9650"));
            object.put("pid", (Object)pid);
            if (ListUtil.isNotEmpty((List)subEntities)) {
                subEntities.forEach(s -> {
                    if (s.getAuthId().equals(app.getId())) {
                        object.put("auth", (Object)true);
                        object.put("authSubId", (Object)s.getId());
                        if (s.getManage() == 1) {
                            object.put("manage", (Object)true);
                        }
                    }
                });
                if (object.get((Object)"authSubId") == null) {
                    object.put("auth", (Object)false);
                    object.put("authSubId", null);
                }
            } else {
                object.put("auth", (Object)false);
                object.put("authSubId", null);
            }
            res.add(object);
            if (436574189119602768L == app.getId()) {
                JSONObject auth = new JSONObject();
                auth.put("id", (Object)"workAuth");
                auth.put("name", (Object)"\u5de5\u4f5c\u6388\u6743\u7ba1\u7406\u6743\u9650");
                auth.put("pid", (Object)object.getString("authSubId"));
                auth.put("auth", (Object)object.getBoolean("manage"));
                res.add(auth);
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", res);
    }

    @RequestMapping(value={"/updateAuthPositionChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateAuthPositionChange() {
        this.logger.info("start to updateAuthPositionChange ....");
        QueryParam param = new QueryParam();
        param.getParams().put("targetType", new Parameter("eq", (Object)1));
        List entities = this.service.queryList(param);
        ArrayList changeList = new ArrayList();
        HashMap save = new HashMap();
        if (ListUtil.isNotEmpty((List)entities)) {
            entities.forEach(e -> {
                JSONObject org;
                QueryParam p = new QueryParam();
                p.getParams().put("userId", new Parameter("eq", (Object)e.getTargetId()));
                List dbList = this.userPositionService.queryList(p);
                JSONArray pos = this.ztjApisService.getUserAllPosition(e.getProviderId(), e.getTargetId());
                if (ListUtil.isEmpty((List)dbList)) {
                    for (Object po : pos) {
                        JSONObject position = (JSONObject)po;
                        UserPositionEntity entity = new UserPositionEntity();
                        entity.setUserId(e.getTargetId());
                        entity.setPositionId(position.getString("id"));
                        entity.setProviderId(e.getProviderId());
                        entity.setUserName(this.ztjApisService.getUser(e.getProviderId(), e.getTargetId()).getString("name"));
                        entity.setPositionName(this.ztjApisService.getOrgPath(e.getProviderId(), position.getString("id"), true));
                        this.userPositionService.saveOrUpdate((Object)entity);
                    }
                } else if (pos == null || pos.size() == 0) {
                    for (UserPositionEntity userPositionEntity : dbList) {
                        PositionChangeEntity changeEntity = new PositionChangeEntity();
                        changeEntity.setCorpName(e.getCorpName());
                        changeEntity.setCorpPk(e.getCorpPk());
                        changeEntity.setCorpProviderId(e.getCorpProviderId());
                        changeEntity.setTargetId(e.getTargetId());
                        changeEntity.setTargetProviderId(e.getProviderId());
                        changeEntity.setNewPositionName("\u8c03\u79bb\u5c97\u4f4d\uff1a" + userPositionEntity.getPositionName());
                        this.positionChangeService.saveOrUpdate((Object)changeEntity, false);
                        this.userPositionService.removeById(userPositionEntity.getId());
                    }
                } else {
                    PositionChangeEntity changeEntity;
                    ArrayList<UserPositionEntity> exist = new ArrayList<UserPositionEntity>();
                    ArrayList<JSONObject> newPosition = new ArrayList<JSONObject>();
                    for (Object po : pos) {
                        JSONObject position = (JSONObject)po;
                        Boolean isNew = true;
                        for (UserPositionEntity db : dbList) {
                            if (!position.getString("id").equals(db.getPositionId())) continue;
                            exist.add(db);
                            isNew = false;
                        }
                        if (!isNew.booleanValue()) continue;
                        newPosition.add(position);
                    }
                    dbList.removeAll(exist);
                    if (ListUtil.isNotEmpty((List)dbList)) {
                        for (UserPositionEntity userPositionEntity : dbList) {
                            changeEntity = new PositionChangeEntity();
                            changeEntity.setCorpName(e.getCorpName());
                            changeEntity.setCorpPk(e.getCorpPk());
                            changeEntity.setTargetId(e.getTargetId());
                            changeEntity.setCorpProviderId(e.getCorpProviderId());
                            changeEntity.setTargetProviderId(e.getProviderId());
                            changeEntity.setNewPositionName("\u8c03\u79bb\u5c97\u4f4d\uff1a" + userPositionEntity.getPositionName());
                            this.positionChangeService.saveOrUpdate((Object)changeEntity, false);
                            this.userPositionService.removeById(userPositionEntity.getId());
                        }
                    }
                    if (ListUtil.isNotEmpty(newPosition)) {
                        for (JSONObject userPosition : newPosition) {
                            changeEntity = new PositionChangeEntity();
                            changeEntity.setCorpPk(e.getCorpPk());
                            changeEntity.setCorpName(e.getCorpName());
                            changeEntity.setCorpProviderId(e.getCorpProviderId());
                            changeEntity.setTargetId(e.getTargetId());
                            changeEntity.setTargetProviderId(e.getProviderId());
                            String positionName = this.ztjApisService.getOrgPath(e.getProviderId(), userPosition.getString("id"), true);
                            changeEntity.setNewPositionName("\u6dfb\u52a0\u5c97\u4f4d\uff1a" + positionName);
                            this.positionChangeService.saveOrUpdate((Object)changeEntity, false);
                            UserPositionEntity entity = new UserPositionEntity();
                            entity.setUserId(e.getTargetId());
                            entity.setPositionId(userPosition.getString("id"));
                            entity.setProviderId(e.getProviderId());
                            entity.setPositionName(positionName);
                            entity.setUserName(this.ztjApisService.getUser(e.getProviderId(), e.getTargetId()).getString("name"));
                            this.userPositionService.saveOrUpdate((Object)entity);
                        }
                    }
                }
                if (((org = this.ztjApisService.getSureOrg(e.getCorpProviderId(), e.getCorpPk())) == null || org.size() == 0) && StringUtils.isEmpty((CharSequence)((CharSequence)save.get(e.getCorpProviderId() + e.getCorpPk())))) {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("corpPk", new Parameter("eq", (Object)e.getCorpPk()));
                    queryParam.getParams().put("corpProviderId", new Parameter("eq", (Object)e.getCorpProviderId()));
                    List list = this.positionChangeService.queryList(queryParam);
                    if (ListUtil.isNotEmpty((List)list)) {
                        for (PositionChangeEntity en : list) {
                            en.setCorpProviderId(e.getCorpParentProviderId());
                            en.setCorpPk(e.getCorpParentPk());
                        }
                        changeList.addAll(list);
                    }
                    save.put(e.getCorpProviderId() + e.getCorpPk(), e.getCorpProviderId() + e.getCorpPk());
                }
            });
            if (ListUtil.isNotEmpty(changeList)) {
                this.positionChangeService.saveOrUpdateBatch(changeList);
            }
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryAuthPositionChangeList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PositionChangeVO>> queryAuthPositionChangeList(@RequestBody QueryParam param) {
        this.updateAuthPositionChange();
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.positionChangeService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), PositionChangeVO.class);
        if (ListUtil.isNotEmpty((List)page.getRecords())) {
            List pageRecords = page.getRecords();
            int pageRecordsSize = pageRecords.size();
            for (int i = 0; i < pageRecordsSize; ++i) {
                PositionChangeEntity e = (PositionChangeEntity)((Object)pageRecords.get(i));
                PositionChangeVO change = (PositionChangeVO)records.get(i);
                JSONObject user = this.ztjApisService.getUser(e.getTargetProviderId(), e.getTargetId());
                change.setTargetName(user.getString("name"));
                JSONArray array = this.ztjApisService.getOrgPath(e.getCorpProviderId(), e.getCorpPk());
                StringBuffer path = new StringBuffer("");
                for (int j = array.size() - 1; j > -1; --j) {
                    JSONObject p = array.getJSONObject(j);
                    path.append(p.getString("name")).append(" ");
                }
                change.setCorpName(path.toString());
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUserCanAuth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> queryUserCanAuth(@RequestParam String corpCode) {
        Boolean canAuth = false;
        if (StringUtils.isEmpty((CharSequence)corpCode)) {
            return CommonResponse.success((Object)false);
        }
        if (!corpCode.startsWith("root_org_code")) {
            corpCode = "root_org_code" + corpCode;
        }
        Long userId = this.sessionManager.getUserContext().getUserId();
        JSONArray positionArrJson = this.ztjApisService.getUserAllPosition(this.sessionManager.getUserContext().getProviderId(), userId + "");
        JSONObject positionJson = null;
        StringBuffer authIdBuff = new StringBuffer(userId + ",");
        for (int i = 0; i < positionArrJson.size(); ++i) {
            positionJson = positionArrJson.getJSONObject(i);
            authIdBuff.append(positionJson.getString("id")).append(",");
        }
        String targetIds = authIdBuff.substring(0, authIdBuff.length() - 1);
        List<WorkAuthEntity> list = this.service.queryUserAuthList(corpCode, targetIds);
        if (ListUtil.isNotEmpty(list)) {
            canAuth = true;
        }
        return CommonResponse.success((Object)canAuth);
    }
}

